/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.project;

import com.atlassian.jira.functest.framework.assertions.TextAssertionsImpl;
import com.atlassian.jira.functest.framework.locator.AbstractLocator;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.webtests.JIRAWebTest;

public class TestViewProject
extends JIRAWebTest {
    public TestViewProject(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
    }

    public void testViewProject() {
        this.restoreData("TestViewProject.xml");
        this._testViewProjectFieldConfigurationSchemeLinkVisibilityEnterpriseOnly();
    }

    public void testViewProjectUrlEncoding() {
        this.restoreData("TestViewProject.xml");
        this.setUnsafeUrl("http://<b>hi</b>\">");
        this.assertUrlEncoded();
        this.tester.clickLink("view_projects");
        this.assertUrlEncoded();
        this.tester.gotoPage("secure/BrowseProjects.jspa");
        this.assertUrlEncoded();
        this.tester.gotoPage("browse/HSP");
        this.assertUrlEncoded();
        this.tester.gotoPage("browse/HSP#selectedTab=com.atlassian.jira.plugin.system.project%3Asummary-panel");
        this.assertUrlEncoded();
    }

    private void setUnsafeUrl(String url) {
        this.gotoAdmin();
        this.tester.clickLink("view_projects");
        this.tester.clickLinkWithText("homosapien");
        this.tester.clickLink("edit_project");
        this.tester.setFormElement("name", "homosapien");
        this.tester.setFormElement("url", url);
        this.tester.submit("Update");
    }

    private void assertUrlEncoded() {
        this.assertTextPresent("href=\"http://&lt;b&gt;hi&lt;/b&gt;&quot;&gt;\"");
        this.assertTextPresent("http://&lt;b&gt;hi&lt;/b&gt;&quot;&gt;");
    }

    public void testNonExistantProjectLeadShownInRed() {
        this.restoreData("TestNonExistantLead.xml");
        this._testNonExistantProjectLeadShownInRedInAdmin();
        this._testNonExistantProjectLeadShownInRedInBrowse();
    }

    private void _testNonExistantProjectLeadShownInRedInAdmin() {
        TextAssertionsImpl textAssert = new TextAssertionsImpl();
        this.login("admin");
        this.goToProject("homosapien");
        XPathLocator loc = new XPathLocator(this.tester, "//td[@class='jiraformbody']");
        textAssert.assertTextSequence(loc, new String[]{"Project Lead:", "adminXXX"});
        loc = new XPathLocator(loc.getNode(), "//span[@class='errLabel']");
        textAssert.assertTextPresent(loc, "adminXXX");
    }

    private void _testNonExistantProjectLeadShownInRedInBrowse() {
        TextAssertionsImpl textAssert = new TextAssertionsImpl();
        this.login("admin");
        this.gotoProjectBrowse("HSP");
        AbstractLocator loc = new WebPageLocator(this.tester);
        textAssert.assertTextSequence(loc, new String[]{"Lead:", "adminXXX"});
        loc = new XPathLocator(loc.getNode(), "//dd[@class='errLabel']");
        textAssert.assertTextPresent(loc, "adminXXX");
    }

    public void _testViewProjectFieldConfigurationSchemeLinkVisibilityEnterpriseOnly() {
        this.login("admin", "admin");
        this.goToProject("homosapien");
        this.assertTextSequence(new String[]{"Field Configuration Scheme", "System Default Field Configuration"});
        this.assertTextNotPresent("Another Field Configuration Scheme");
        this.assertLinkNotPresent("select_fieldlayoutscheme");
        this.assertLinkNotPresent("edit_fieldlayoutscheme");
        this.logout();
        this.login("projectadmin", "projectadmin");
        this.goToProject("homosapien");
        this.assertTextSequence(new String[]{"Field Configuration Scheme", "System Default Field Configuration"});
        this.assertTextNotPresent("Another Field Configuration Scheme");
        this.assertLinkNotPresent("select_fieldlayoutscheme");
        this.assertLinkNotPresent("edit_fieldlayoutscheme");
        this.logout();
        this.login("admin", "admin");
        this.clickLink("admin_link");
        this.clickLink("issue_fields");
        this.setFormElement("fieldLayoutSchemeName", "Another Field Configuration Scheme");
        this.submit("Add");
        this.goToProject("homosapien");
        this.assertTextSequence(new String[]{"Field Configuration Scheme", "System Default Field Configuration"});
        this.assertTextNotPresent("Another Field Configuration Scheme");
        this.assertLinkPresent("select_fieldlayoutscheme");
        this.assertLinkNotPresent("edit_fieldlayoutscheme");
        this.logout();
        this.login("projectadmin", "projectadmin");
        this.goToProject("homosapien");
        this.assertTextSequence(new String[]{"Field Configuration Scheme", "System Default Field Configuration"});
        this.assertTextNotPresent("Another Field Configuration Scheme");
        this.assertLinkNotPresent("select_fieldlayoutscheme");
        this.assertLinkNotPresent("edit_fieldlayoutscheme");
        this.logout();
        this.login("admin", "admin");
        this.goToProject("homosapien");
        this.clickLink("select_fieldlayoutscheme");
        this.selectOption("schemeId", "Another Field Configuration Scheme");
        this.submit("Associate");
        this.assertTextSequence(new String[]{"Field Configuration Scheme", "Another Field Configuration Scheme"});
        this.assertTextNotPresent("System Default Field Configuration");
        this.assertLinkPresent("select_fieldlayoutscheme");
        this.assertLinkPresent("edit_fieldlayoutscheme");
        this.logout();
        this.login("projectadmin", "projectadmin");
        this.goToProject("homosapien");
        this.assertTextSequence(new String[]{"Field Configuration Scheme", "Another Field Configuration Scheme"});
        this.assertTextNotPresent("System Default Field Configuration");
        this.assertLinkNotPresent("select_fieldlayoutscheme");
        this.assertLinkNotPresent("edit_fieldlayoutscheme");
        this.logout();
    }
}

