/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.project;

import com.atlassian.jira.webtests.JIRAWebTest;

public class TestBrowseVersionsAndComponentsPaging
extends JIRAWebTest {
    public TestBrowseVersionsAndComponentsPaging(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.restoreData("TestBrowseVersionsAndComponentsPaging.xml");
    }

    public void testBrowseComponentOpenIssuesOverLimit() {
        this.gotoComponentBrowse("HSP", "New Component 1");
        this.clickLinkWithText("Open Issues");
        this.assertTextSequence(new String[]{"Viewing 50 of", "58", " unresolved issue(s).", "Viewing 50 of", "58", "Issues."});
        this.assertTableCellHasText("openissues_table", 0, 2, "HSP-20");
        this.clickLink("unresolved_link");
        this.assertTextSequence(new String[]{"Displaying issues ", "1", "to", "50", "of", "58", "matching issues."});
        this.assertTableCellHasText("issuetable", 1, 1, "HSP-20");
        this.gotoComponentBrowse("HSP", "New Component 1");
        this.clickLinkWithText("Open Issues");
        this.clickLink("pager_footer_link");
        this.assertTextSequence(new String[]{"Displaying issues ", "1", "to", "50", "of", "58", "matching issues."});
        this.assertTableCellHasText("issuetable", 1, 1, "HSP-20");
    }

    public void testBrowseComponentOpenIssuesUnderLimit() {
        this.gotoComponentBrowse("HSP", "New Component 2");
        this.clickLinkWithText("Open Issues");
        this.assertTextNotPresent("Viewing ");
        this.assertTableCellHasText("openissues_table", 0, 2, "HSP-61");
        this.clickLink("unresolved_link");
        this.assertTextSequence(new String[]{"Displaying issues ", "1", "to", "1", "of", "1", "matching issues."});
        this.assertTableCellHasText("issuetable", 1, 1, "HSP-61");
        this.assertLinkNotPresent("pager_footer_link");
    }

    public void testBrowseVersionSummaryOverLimit() {
        this.gotoVersionBrowse("HSP", "New Version 1");
        this.clickLinkWithText("Summary");
        this.assertTextSequence(new String[]{"Progress:", "2", "of", "60", "issues have been resolved"});
        this.assertTextSequence(new String[]{"Viewing 50 of", "60", "Issues."});
        this.assertTableCellHasText("summary_table", 0, 2, "HSP-20");
        this.clickLink("pager_footer_link");
        this.assertTextSequence(new String[]{"Displaying issues ", "1", "to", "50", "of", "60", "matching issues."});
        this.assertTableCellHasText("issuetable", 1, 1, "HSP-20");
        this.gotoVersionBrowse("HSP", "New Version 1");
        this.clickLinkWithText("Summary");
        this.clickLink("unresolved_link");
        this.assertTextSequence(new String[]{"Progress:", "2", "of", "60", "issues have been resolved"});
        this.clickLink("pager_footer_link");
        this.assertTextSequence(new String[]{"Displaying issues ", "1", "to", "50", "of", "58", "matching issues."});
        this.assertTableCellHasText("issuetable", 1, 1, "HSP-20");
    }

    public void testBrowseVersionSummaryUnderLimit() {
        this.gotoVersionBrowse("HSP", "New Version 4");
        this.clickLinkWithText("Summary");
        this.assertTextNotPresent("Viewing ");
        this.assertTableCellHasText("summary_table", 0, 2, "HSP-61");
        this.clickLink("unresolved_link");
        this.assertTableCellHasText("summary_table", 0, 2, "HSP-61");
        this.assertLinkNotPresent("pager_footer_link");
    }
}

