/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.project;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import java.net.URLEncoder;
import org.apache.commons.lang.StringUtils;

public class TestBrowseProjectRoadMapAndChangeLogTab
extends FuncTestCase {
    private static final String SECOND_LINE = "//ul[@class='versionBannerList']/li[2]/div[1]/a[@class='versionBanner-name']";
    private static final String FIRST_LINE = "//ul[@class='versionBannerList']/li[1]/div[1]/a[@class='versionBanner-name']";

    protected void setUpTest() {
        this.administration.restoreData("TestBrowseProjectRoadmapAndChangeLogTab.xml");
    }

    public void testEmptyRoadMapAndChangelLog() {
        this.navigation.browseProjectTabPanel("NORELEASED", "roadmap");
        this.assertions.assertNodeHasText(FIRST_LINE, "Version 1");
        this.assertions.assertNodeHasText(SECOND_LINE, "Version 2");
        this.navigation.browseProjectTabPanel("NORELEASED", "changelog");
        this.assertions.assertNodeDoesNotExist(FIRST_LINE);
        this.assertions.assertNodeHasText("//ul[@class='versionBannerList']", "No Versions");
        this.navigation.browseProjectTabPanel("RELEASED", "changelog");
        this.assertions.assertNodeHasText(FIRST_LINE, "Vesion 2");
        this.assertions.assertNodeHasText(SECOND_LINE, "Version 1");
        this.navigation.browseProjectTabPanel("RELEASED", "roadmap");
        this.assertions.assertNodeDoesNotExist(FIRST_LINE);
        this.assertions.assertNodeHasText("//ul[@class='versionBannerList']", "No Versions");
        this.navigation.browseComponentTabPanel("NORELEASED", "Component 1", "roadmap");
        this.assertions.assertNodeHasText(FIRST_LINE, "Version 1");
        this.assertions.assertNodeHasText(SECOND_LINE, "Version 2");
        this.navigation.browseComponentTabPanel("NORELEASED", "Component 1", "changelog");
        this.assertions.assertNodeDoesNotExist(FIRST_LINE);
        this.assertions.assertNodeHasText("//ul[@class='versionBannerList']", "No Versions");
        this.navigation.browseComponentTabPanel("RELEASED", "Component 1", "changelog");
        this.assertions.assertNodeHasText(FIRST_LINE, "Vesion 2");
        this.assertions.assertNodeHasText(SECOND_LINE, "Version 1");
        this.navigation.browseComponentTabPanel("RELEASED", "Component 1", "roadmap");
        this.assertions.assertNodeDoesNotExist(FIRST_LINE);
        this.assertions.assertNodeHasText("//ul[@class='versionBannerList']", "No Versions");
        this.tester.gotoPage("secure/ViewProfile.jspa?selectedTab=jira.user.profile.panels:up-roadmap-panel&pid=10050");
        this.assertions.assertNodeHasText(FIRST_LINE, "Version 1");
        this.assertions.assertNodeHasText(SECOND_LINE, "Version 2");
        this.tester.gotoPage("secure/ViewProfile.jspa?selectedTab=jira.user.profile.panels:up-roadmap-panel&pid=10051");
        this.assertions.assertNodeDoesNotExist(FIRST_LINE);
        this.assertions.assertNodeHasText("//ul[@class='versionBannerList']", "No Versions");
    }

    public void testPaging() {
        this.navigation.browseProjectTabPanel("LOTS", "roadmap");
        this.assertions.getLinkAssertions().assertLinkPresentWithExactText("//ul[@class='paging']", "all versions");
        this.assertions.getLinkAssertions().assertLinkNotPresentWithExactText("//ul[@class='paging']", "upcoming 10 versions");
        XPathLocator locator = new XPathLocator(this.tester, "//ul[@class='versionBannerList']/li");
        TestBrowseProjectRoadMapAndChangeLogTab.assertEquals((int)10, (int)locator.getNodes().length);
        this.assertions.assertNodeHasText(FIRST_LINE, "Version 1");
        this.assertions.assertNodeHasText("//ul[@class='versionBannerList']/li[10]/div[1]/a[@class='versionBanner-name']", "Version Bored");
        this.tester.clickLinkWithText("all versions");
        this.assertions.getLinkAssertions().assertLinkPresentWithExactText("//ul[@class='paging']", "upcoming 10 versions");
        this.assertions.getLinkAssertions().assertLinkNotPresentWithExactText("//ul[@class='paging']", "all versions");
        locator = new XPathLocator(this.tester, "//ul[@class='versionBannerList']/li");
        TestBrowseProjectRoadMapAndChangeLogTab.assertEquals((int)11, (int)locator.getNodes().length);
        this.assertions.assertNodeHasText(FIRST_LINE, "Version 1");
        this.assertions.assertNodeHasText("//ul[@class='versionBannerList']/li[11]/div[1]/a[@class='versionBanner-name']", "Version still Bored");
        this.navigation.browseProject("LOTS");
        this.assertions.getLinkAssertions().assertLinkPresentWithExactText("//ul[@class='paging']", "upcoming 10 versions");
        this.assertions.getLinkAssertions().assertLinkNotPresentWithExactText("//ul[@class='paging']", "all versions");
        locator = new XPathLocator(this.tester, "//ul[@class='versionBannerList']/li");
        TestBrowseProjectRoadMapAndChangeLogTab.assertEquals((int)11, (int)locator.getNodes().length);
        this.assertions.assertNodeHasText(FIRST_LINE, "Version 1");
        this.assertions.assertNodeHasText("//ul[@class='versionBannerList']/li[11]/div[1]/a[@class='versionBanner-name']", "Version still Bored");
        this.tester.clickLinkWithText("upcoming 10 versions");
        this.assertions.getLinkAssertions().assertLinkPresentWithExactText("//ul[@class='paging']", "all versions");
        this.assertions.getLinkAssertions().assertLinkNotPresentWithExactText("//ul[@class='paging']", "upcoming 10 versions");
        locator = new XPathLocator(this.tester, "//ul[@class='versionBannerList']/li");
        TestBrowseProjectRoadMapAndChangeLogTab.assertEquals((int)10, (int)locator.getNodes().length);
        this.assertions.assertNodeHasText(FIRST_LINE, "Version 1");
        this.assertions.assertNodeHasText("//ul[@class='versionBannerList']/li[10]/div[1]/a[@class='versionBanner-name']", "Version Bored");
        this.tester.clickLinkWithText("all versions");
        this.navigation.browseProjectTabPanel("LOTS", "changelog");
        this.assertions.getLinkAssertions().assertLinkPresentWithExactText("//ul[@class='paging']", "all versions");
        this.assertions.getLinkAssertions().assertLinkNotPresentWithExactText("//ul[@class='paging']", "previous 10 versions");
        locator = new XPathLocator(this.tester, "//ul[@class='versionBannerList']/li");
        TestBrowseProjectRoadMapAndChangeLogTab.assertEquals((int)10, (int)locator.getNodes().length);
        this.assertions.assertNodeHasText(FIRST_LINE, "<b>CSS</b>");
        this.assertions.assertNodeHasText("//ul[@class='versionBannerList']/li[10]/div[1]/a[@class='versionBanner-name']", "Version Dylan");
        this.tester.clickLinkWithText("all versions");
        this.assertions.getLinkAssertions().assertLinkPresentWithExactText("//ul[@class='paging']", "previous 10 versions");
        this.assertions.getLinkAssertions().assertLinkNotPresentWithExactText("//ul[@class='paging']", "all versions");
        locator = new XPathLocator(this.tester, "//ul[@class='versionBannerList']/li");
        TestBrowseProjectRoadMapAndChangeLogTab.assertEquals((int)11, (int)locator.getNodes().length);
        this.assertions.assertNodeHasText(FIRST_LINE, "<b>CSS</b>");
        this.assertions.assertNodeHasText("//ul[@class='versionBannerList']/li[11]/div[1]/a[@class='versionBanner-name']", "Version Andreas");
        this.navigation.browseProject("LOTS");
        this.assertions.getLinkAssertions().assertLinkPresentWithExactText("//ul[@class='paging']", "previous 10 versions");
        this.assertions.getLinkAssertions().assertLinkNotPresentWithExactText("//ul[@class='paging']", "all versions");
        locator = new XPathLocator(this.tester, "//ul[@class='versionBannerList']/li");
        TestBrowseProjectRoadMapAndChangeLogTab.assertEquals((int)11, (int)locator.getNodes().length);
        this.assertions.assertNodeHasText(FIRST_LINE, "<b>CSS</b>");
        this.assertions.assertNodeHasText("//ul[@class='versionBannerList']/li[11]/div[1]/a[@class='versionBanner-name']", "Version Andreas");
        this.tester.clickLinkWithText("previous 10 versions");
        this.assertions.getLinkAssertions().assertLinkPresentWithExactText("//ul[@class='paging']", "all versions");
        this.assertions.getLinkAssertions().assertLinkNotPresentWithExactText("//ul[@class='paging']", "previous 10 versions");
        locator = new XPathLocator(this.tester, "//ul[@class='versionBannerList']/li");
        TestBrowseProjectRoadMapAndChangeLogTab.assertEquals((int)10, (int)locator.getNodes().length);
        this.assertions.assertNodeHasText(FIRST_LINE, "<b>CSS</b>");
        this.assertions.assertNodeHasText("//ul[@class='versionBannerList']/li[10]/div[1]/a[@class='versionBanner-name']", "Version Dylan");
        this.navigation.browseComponentTabPanel("LOTS", "Component 1", "roadmap");
        this.assertions.getLinkAssertions().assertLinkPresentWithExactText("//ul[@class='paging']", "all versions");
        this.assertions.getLinkAssertions().assertLinkNotPresentWithExactText("//ul[@class='paging']", "upcoming 10 versions");
        locator = new XPathLocator(this.tester, "//ul[@class='versionBannerList']/li");
        TestBrowseProjectRoadMapAndChangeLogTab.assertEquals((int)10, (int)locator.getNodes().length);
        this.assertions.assertNodeHasText(FIRST_LINE, "Version 1");
        this.assertions.assertNodeHasText("//ul[@class='versionBannerList']/li[10]/div[1]/a[@class='versionBanner-name']", "Version Bored");
        this.tester.clickLinkWithText("all versions");
        this.assertions.getLinkAssertions().assertLinkPresentWithExactText("//ul[@class='paging']", "upcoming 10 versions");
        this.assertions.getLinkAssertions().assertLinkNotPresentWithExactText("//ul[@class='paging']", "all versions");
        locator = new XPathLocator(this.tester, "//ul[@class='versionBannerList']/li");
        TestBrowseProjectRoadMapAndChangeLogTab.assertEquals((int)11, (int)locator.getNodes().length);
        this.assertions.assertNodeHasText(FIRST_LINE, "Version 1");
        this.assertions.assertNodeHasText("//ul[@class='versionBannerList']/li[11]/div[1]/a[@class='versionBanner-name']", "Version still Bored");
        this.navigation.browseComponentTabPanel("LOTS", "Component 1");
        this.assertions.getLinkAssertions().assertLinkPresentWithExactText("//ul[@class='paging']", "upcoming 10 versions");
        this.assertions.getLinkAssertions().assertLinkNotPresentWithExactText("//ul[@class='paging']", "all versions");
        locator = new XPathLocator(this.tester, "//ul[@class='versionBannerList']/li");
        TestBrowseProjectRoadMapAndChangeLogTab.assertEquals((int)11, (int)locator.getNodes().length);
        this.assertions.assertNodeHasText(FIRST_LINE, "Version 1");
        this.assertions.assertNodeHasText("//ul[@class='versionBannerList']/li[11]/div[1]/a[@class='versionBanner-name']", "Version still Bored");
        this.tester.clickLinkWithText("upcoming 10 versions");
        this.assertions.getLinkAssertions().assertLinkPresentWithExactText("//ul[@class='paging']", "all versions");
        this.assertions.getLinkAssertions().assertLinkNotPresentWithExactText("//ul[@class='paging']", "upcoming 10 versions");
        locator = new XPathLocator(this.tester, "//ul[@class='versionBannerList']/li");
        TestBrowseProjectRoadMapAndChangeLogTab.assertEquals((int)10, (int)locator.getNodes().length);
        this.assertions.assertNodeHasText(FIRST_LINE, "Version 1");
        this.assertions.assertNodeHasText("//ul[@class='versionBannerList']/li[10]/div[1]/a[@class='versionBanner-name']", "Version Bored");
        this.tester.clickLinkWithText("all versions");
        this.navigation.browseComponentTabPanel("LOTS", "Component 1", "changelog");
        this.assertions.getLinkAssertions().assertLinkPresentWithExactText("//ul[@class='paging']", "all versions");
        this.assertions.getLinkAssertions().assertLinkNotPresentWithExactText("//ul[@class='paging']", "previous 10 versions");
        locator = new XPathLocator(this.tester, "//ul[@class='versionBannerList']/li");
        TestBrowseProjectRoadMapAndChangeLogTab.assertEquals((int)10, (int)locator.getNodes().length);
        this.assertions.assertNodeHasText(FIRST_LINE, "<b>CSS</b>");
        this.assertions.assertNodeHasText("//ul[@class='versionBannerList']/li[10]/div[1]/a[@class='versionBanner-name']", "Version Dylan");
        this.tester.clickLinkWithText("all versions");
        this.assertions.getLinkAssertions().assertLinkPresentWithExactText("//ul[@class='paging']", "previous 10 versions");
        this.assertions.getLinkAssertions().assertLinkNotPresentWithExactText("//ul[@class='paging']", "all versions");
        locator = new XPathLocator(this.tester, "//ul[@class='versionBannerList']/li");
        TestBrowseProjectRoadMapAndChangeLogTab.assertEquals((int)11, (int)locator.getNodes().length);
        this.assertions.assertNodeHasText(FIRST_LINE, "<b>CSS</b>");
        this.assertions.assertNodeHasText("//ul[@class='versionBannerList']/li[11]/div[1]/a[@class='versionBanner-name']", "Version Andreas");
        this.navigation.browseComponentTabPanel("LOTS", "Component 1");
        this.assertions.getLinkAssertions().assertLinkPresentWithExactText("//ul[@class='paging']", "previous 10 versions");
        this.assertions.getLinkAssertions().assertLinkNotPresentWithExactText("//ul[@class='paging']", "all versions");
        locator = new XPathLocator(this.tester, "//ul[@class='versionBannerList']/li");
        TestBrowseProjectRoadMapAndChangeLogTab.assertEquals((int)11, (int)locator.getNodes().length);
        this.assertions.assertNodeHasText(FIRST_LINE, "<b>CSS</b>");
        this.assertions.assertNodeHasText("//ul[@class='versionBannerList']/li[11]/div[1]/a[@class='versionBanner-name']", "Version Andreas");
        this.tester.clickLinkWithText("previous 10 versions");
        this.assertions.getLinkAssertions().assertLinkPresentWithExactText("//ul[@class='paging']", "all versions");
        this.assertions.getLinkAssertions().assertLinkNotPresentWithExactText("//ul[@class='paging']", "previous 10 versions");
        locator = new XPathLocator(this.tester, "//ul[@class='versionBannerList']/li");
        TestBrowseProjectRoadMapAndChangeLogTab.assertEquals((int)10, (int)locator.getNodes().length);
        this.assertions.assertNodeHasText(FIRST_LINE, "<b>CSS</b>");
        this.assertions.assertNodeHasText("//ul[@class='versionBannerList']/li[10]/div[1]/a[@class='versionBanner-name']", "Version Dylan");
        this.navigation.browseProjectTabPanel("LOTS", "versions");
        this.assertions.getLinkAssertions().assertLinkPresentWithExactText("//ul[@class='paging']", "all versions");
        this.assertions.getLinkAssertions().assertLinkNotPresentWithExactText("//ul[@class='paging']", "next 20 versions");
        locator = new XPathLocator(this.tester, "//table[@id='versions_panel']/tbody/tr");
        TestBrowseProjectRoadMapAndChangeLogTab.assertEquals((int)20, (int)locator.getNodes().length);
        this.assertions.assertNodeHasText("//table[@id='versions_panel']/tbody/tr[1]/td[2]", "<b>CSS</b>");
        this.assertions.assertNodeHasText("//table[@id='versions_panel']/tbody/tr[20]/td[2]", "Version A");
        this.tester.clickLinkWithText("all versions");
        this.assertions.getLinkAssertions().assertLinkPresentWithExactText("//ul[@class='paging']", "next 20 versions");
        this.assertions.getLinkAssertions().assertLinkNotPresentWithExactText("//ul[@class='paging']", "all versions");
        locator = new XPathLocator(this.tester, "//table[@id='versions_panel']/tbody/tr");
        TestBrowseProjectRoadMapAndChangeLogTab.assertEquals((int)22, (int)locator.getNodes().length);
        this.assertions.assertNodeHasText("//table[@id='versions_panel']/tbody/tr[1]/td[2]", "<b>CSS</b>");
        this.assertions.assertNodeHasText("//table[@id='versions_panel']/tbody/tr[22]/td[2]", "Version 1");
        this.navigation.browseProject("LOTS");
        this.assertions.getLinkAssertions().assertLinkPresentWithExactText("//ul[@class='paging']", "next 20 versions");
        this.assertions.getLinkAssertions().assertLinkNotPresentWithExactText("//ul[@class='paging']", "all versions");
        locator = new XPathLocator(this.tester, "//table[@id='versions_panel']/tbody/tr");
        TestBrowseProjectRoadMapAndChangeLogTab.assertEquals((int)22, (int)locator.getNodes().length);
        this.assertions.assertNodeHasText("//table[@id='versions_panel']/tbody/tr[1]/td[2]", "<b>CSS</b>");
        this.assertions.assertNodeHasText("//table[@id='versions_panel']/tbody/tr[22]/td[2]", "Version 1");
        this.tester.clickLinkWithText("next 20 versions");
        this.assertions.getLinkAssertions().assertLinkPresentWithExactText("//ul[@class='paging']", "all versions");
        this.assertions.getLinkAssertions().assertLinkNotPresentWithExactText("//ul[@class='paging']", "next 20 versions");
        locator = new XPathLocator(this.tester, "//table[@id='versions_panel']/tbody/tr");
        TestBrowseProjectRoadMapAndChangeLogTab.assertEquals((int)20, (int)locator.getNodes().length);
        this.assertions.assertNodeHasText("//table[@id='versions_panel']/tbody/tr[1]/td[2]", "<b>CSS</b>");
        this.assertions.assertNodeHasText("//table[@id='versions_panel']/tbody/tr[20]/td[2]", "Version A");
        this.tester.gotoPage("secure/ViewProfile.jspa?selectedTab=jira.user.profile.panels:up-roadmap-panel&pid=10040");
        this.assertions.getLinkAssertions().assertLinkPresentWithExactText("//ul[@class='paging']", "all versions");
        this.assertions.getLinkAssertions().assertLinkNotPresentWithExactText("//ul[@class='paging']", "upcoming 10 versions");
        locator = new XPathLocator(this.tester, "//ul[@class='versionBannerList']/li");
        TestBrowseProjectRoadMapAndChangeLogTab.assertEquals((int)10, (int)locator.getNodes().length);
        this.assertions.assertNodeHasText(FIRST_LINE, "Version 1");
        this.assertions.assertNodeHasText("//ul[@class='versionBannerList']/li[10]/div[1]/a[@class='versionBanner-name']", "Version Bored");
        this.tester.clickLinkWithText("all versions");
        this.assertions.getLinkAssertions().assertLinkPresentWithExactText("//ul[@class='paging']", "upcoming 10 versions");
        this.assertions.getLinkAssertions().assertLinkNotPresentWithExactText("//ul[@class='paging']", "all versions");
        locator = new XPathLocator(this.tester, "//ul[@class='versionBannerList']/li");
        TestBrowseProjectRoadMapAndChangeLogTab.assertEquals((int)11, (int)locator.getNodes().length);
        this.assertions.assertNodeHasText(FIRST_LINE, "Version 1");
        this.assertions.assertNodeHasText("//ul[@class='versionBannerList']/li[11]/div[1]/a[@class='versionBanner-name']", "Version still Bored");
        this.tester.clickLinkWithText("upcoming 10 versions");
        this.assertions.getLinkAssertions().assertLinkPresentWithExactText("//ul[@class='paging']", "all versions");
        this.assertions.getLinkAssertions().assertLinkNotPresentWithExactText("//ul[@class='paging']", "upcoming 10 versions");
        locator = new XPathLocator(this.tester, "//ul[@class='versionBannerList']/li");
        TestBrowseProjectRoadMapAndChangeLogTab.assertEquals((int)10, (int)locator.getNodes().length);
        this.assertions.assertNodeHasText(FIRST_LINE, "Version 1");
        this.assertions.assertNodeHasText("//ul[@class='versionBannerList']/li[10]/div[1]/a[@class='versionBanner-name']", "Version Bored");
        this.tester.clickLinkWithText("all versions");
    }

    public void testVersionsHeaderContent() {
        this.navigation.browseProjectTabPanel("LOTS", "roadmap");
        this.tester.clickLinkWithText("all versions");
        this.assertUnreleasedVersion("Version 1", 10040, "", "", 2, 4, -1, null);
        this.assertUnreleasedVersion("Version 2", 10041, "", "", 2, 3, -1, null);
        this.assertUnreleasedVersion("Version A", 10042, "", "This is version A", 1, 3, -1, null);
        this.assertUnreleasedVersion("Version <b>B</b>", 10043, "", "This is version B - Version <b>B</b>", 1, 2, -1, null);
        this.assertUnreleasedVersion("Version 3", 10044, "19/Feb/09", "", 0, 1, -1, null);
        this.assertUnreleasedVersion("Version Version", 10045, "", "VVVVVVVVVVVVVVVVV", 0, 1, -1, null);
        this.assertUnreleasedVersion("Version 6", 10046, "", "", 0, 1, -1, null);
        this.assertUnreleasedVersion("Version 8", 10047, "", "", 0, 1, -1, null);
        this.assertUnreleasedVersion("Version Nick", 10048, "", "", 0, 1, -1, null);
        this.assertUnreleasedVersion("Version Bored", 10049, "", "", 0, 1, -1, null);
        this.assertUnreleasedVersion("Version still Bored", 10050, "", "", 0, 0, -1, null);
        this.navigation.browseProjectTabPanel("LOTS", "changelog");
        this.tester.clickLinkWithText("all versions");
        this.assertReleasedVersion("<b>CSS</b>", 10061, "21/Feb/09", "<b>CSS</b><b>CSS</b><b>CSS</b><b>CSS</b>", 0, -1, null);
        this.assertReleasedVersion("This is getting silly", 10060, "16/Feb/09", "", 1, -1, null);
        this.assertReleasedVersion("V2", 10059, "16/Feb/09", "V2V2V2V2", 2, -1, null);
        this.assertReleasedVersion("Lets throw in a Date", 10058, "27/Feb/09", "", 2, -1, null);
        this.assertReleasedVersion("Still going", 10057, "16/Feb/09", "", 1, -1, null);
        this.assertReleasedVersion("Going Again Version", 10056, "16/Feb/09", "", 1, -1, null);
        this.assertReleasedVersion("Version Anton", 10055, "16/Feb/09", "", 0, -1, null);
        this.assertReleasedVersion("Version Justus", 10054, "16/Feb/09", "", 1, -1, null);
        this.assertReleasedVersion("Version Brenden", 10053, "", "", 2, -1, null);
        this.assertReleasedVersion("Version Dylan", 10052, "01/Feb/09", "", 1, -1, null);
        this.assertReleasedVersion("Version Andreas", 10051, "16/Feb/09", "", 1, -1, null);
        this.navigation.browseComponentTabPanel("LOTS", "Component 1", "roadmap");
        this.tester.clickLinkWithText("all versions");
        this.assertUnreleasedVersion("Version 1", 10040, "", "", 0, 1, 10030, "Component 1");
        this.assertUnreleasedVersion("Version 2", 10041, "", "", 0, 1, 10030, "Component 1");
        this.assertUnreleasedVersion("Version A", 10042, "18/Feb/09", "This is version A", 0, 1, 10030, "Component 1");
        this.assertUnreleasedVersion("Version <b>B</b>", 10043, "", "This is version B - Version <b>B</b>", 0, 1, 10030, "Component 1");
        this.assertUnreleasedVersion("Version 3", 10044, "19/Feb/09", "", 0, 1, 10030, "Component 1");
        this.assertUnreleasedVersion("Version Version", 10045, "", "VVVVVVVVVVVVVVVVV", 0, 1, 10030, "Component 1");
        this.assertUnreleasedVersion("Version 6", 10046, "", "", 0, 1, 10030, "Component 1");
        this.assertUnreleasedVersion("Version 8", 10047, "", "", 0, 1, 10030, "Component 1");
        this.assertUnreleasedVersion("Version Nick", 10048, "", "", 0, 1, 10030, "Component 1");
        this.assertUnreleasedVersion("Version Bored", 10049, "", "", 0, 0, 10030, "Component 1");
        this.assertUnreleasedVersion("Version still Bored", 10050, "", "", 0, 0, 10030, "Component 1");
        this.navigation.browseComponentTabPanel("LOTS", "Component 1", "changelog");
        this.tester.clickLinkWithText("all versions");
        this.assertReleasedVersion("<b>CSS</b>", 10061, "21/Feb/09", "<b>CSS</b><b>CSS</b><b>CSS</b><b>CSS</b>", 0, 10030, "Component 1");
        this.assertReleasedVersion("This is getting silly", 10060, "16/Feb/09", "", 1, 10030, "Component 1");
        this.assertReleasedVersion("V2", 10059, "16/Feb/09", "V2V2V2V2", 1, 10030, "Component 1");
        this.assertReleasedVersion("Lets throw in a Date", 10058, "27/Feb/09", "", 1, 10030, "Component 1");
        this.assertReleasedVersion("Still going", 10057, "16/Feb/09", "", 1, 10030, "Component 1");
        this.assertReleasedVersion("Going Again Version", 10056, "16/Feb/09", "", 0, 10030, "Component 1");
        this.assertReleasedVersion("Version Anton", 10055, "16/Feb/09", "", 0, 10030, "Component 1");
        this.assertReleasedVersion("Version Justus", 10054, "16/Feb/09", "", 1, 10030, "Component 1");
        this.assertReleasedVersion("Version Brenden", 10053, "", "", 1, 10030, "Component 1");
        this.assertReleasedVersion("Version Dylan", 10052, "01/Feb/09", "", 0, 10030, "Component 1");
        this.assertReleasedVersion("Version Andreas", 10051, "16/Feb/09", "", 0, 10030, "Component 1");
        this.tester.gotoPage("secure/ViewProfile.jspa?selectedTab=jira.user.profile.panels:up-roadmap-panel&pid=10040");
        this.tester.clickLinkWithText("all versions");
        this.assertPersonalUnreleasedVersion("Version 1", 10040, "", "", 2, 4);
        this.assertPersonalUnreleasedVersion("Version 2", 10041, "", "", 2, 3);
        this.assertPersonalUnreleasedVersion("Version A", 10042, "18/Feb/09", "This is version A", 1, 3);
        this.assertPersonalUnreleasedVersion("Version <b>B</b>", 10043, "", "This is version B - Version <b>B</b>", 1, 2);
        this.assertPersonalUnreleasedVersion("Version 3", 10044, "19/Feb/09", "", 0, 1);
        this.assertPersonalUnreleasedVersion("Version Version", 10045, "", "VVVVVVVVVVVVVVVVV", 0, 1);
        this.assertPersonalUnreleasedVersion("Version 6", 10046, "", "", 0, 1);
        this.assertPersonalUnreleasedVersion("Version 8", 10047, "", "", 0, 1);
        this.assertPersonalUnreleasedVersion("Version Nick", 10048, "", "", 0, 1);
        this.assertPersonalUnreleasedVersion("Version Bored", 10049, "", "", 0, 1);
        this.assertPersonalUnreleasedVersion("Version still Bored", 10050, "", "", 0, 0);
    }

    public void testVersionIssuesContent() {
        this.navigation.browseProjectTabPanel("LOTS", "roadmap");
        this.tester.clickLinkWithText("all versions");
        this.tester.clickLink("version-expando-10040");
        this.assertRowCount(10040, 4);
        this.assertIssueRow(1, 10040, "LOTS-1", "LOTS 1");
        this.assertIssueRow(2, 10040, "LOTS-3", "Lots 3");
        this.assertIssueRow(3, 10040, "LOTS-4", "Lots 4");
        this.assertIssueRow(4, 10040, "LOTS-2", "Lots 2");
        this.tester.clickLink("version-expando-10041");
        this.assertRowCount(10040, 4);
        this.assertIssueRow(1, 10040, "LOTS-1", "LOTS 1");
        this.assertIssueRow(2, 10040, "LOTS-3", "Lots 3");
        this.assertIssueRow(3, 10040, "LOTS-4", "Lots 4");
        this.assertIssueRow(4, 10040, "LOTS-2", "Lots 2");
        this.assertRowCount(10041, 3);
        this.assertIssueRow(1, 10041, "LOTS-1", "LOTS 1");
        this.assertIssueRow(2, 10041, "LOTS-4", "Lots 4");
        this.assertIssueRow(3, 10041, "LOTS-2", "Lots 2");
        this.tester.clickLink("version-expando-10042");
        this.assertRowCount(10040, 4);
        this.assertIssueRow(1, 10040, "LOTS-1", "LOTS 1");
        this.assertIssueRow(2, 10040, "LOTS-3", "Lots 3");
        this.assertIssueRow(3, 10040, "LOTS-4", "Lots 4");
        this.assertIssueRow(4, 10040, "LOTS-2", "Lots 2");
        this.assertRowCount(10041, 3);
        this.assertIssueRow(1, 10041, "LOTS-1", "LOTS 1");
        this.assertIssueRow(2, 10041, "LOTS-4", "Lots 4");
        this.assertIssueRow(3, 10041, "LOTS-2", "Lots 2");
        this.assertRowCount(10042, 3);
        this.assertIssueRow(1, 10042, "LOTS-1", "LOTS 1");
        this.assertIssueRow(2, 10042, "LOTS-3", "Lots 3");
        this.assertIssueRow(3, 10042, "LOTS-2", "Lots 2");
        this.navigation.browseProject("LOTS");
        this.assertRowCount(10040, 4);
        this.assertIssueRow(1, 10040, "LOTS-1", "LOTS 1");
        this.assertIssueRow(2, 10040, "LOTS-3", "Lots 3");
        this.assertIssueRow(3, 10040, "LOTS-4", "Lots 4");
        this.assertIssueRow(4, 10040, "LOTS-2", "Lots 2");
        this.assertRowCount(10041, 3);
        this.assertIssueRow(1, 10041, "LOTS-1", "LOTS 1");
        this.assertIssueRow(2, 10041, "LOTS-4", "Lots 4");
        this.assertIssueRow(3, 10041, "LOTS-2", "Lots 2");
        this.assertRowCount(10042, 3);
        this.assertIssueRow(1, 10042, "LOTS-1", "LOTS 1");
        this.assertIssueRow(2, 10042, "LOTS-3", "Lots 3");
        this.assertIssueRow(3, 10042, "LOTS-2", "Lots 2");
        this.tester.clickLink("version-expando-10050");
        this.assertions.assertNodeHasText("//li[@id='version-10050']/div[2]", "No issues");
        this.navigation.browseProjectTabPanel("LOTS", "changelog");
        this.tester.clickLinkWithText("all versions");
        this.tester.clickLink("version-expando-10061");
        this.assertions.assertNodeHasText("//li[@id='version-10061']/div[2]", "No issues");
        this.tester.clickLink("version-expando-10060");
        this.assertions.assertNodeHasText("//li[@id='version-10061']/div[2]", "No issues");
        this.assertRowCount(10060, 1);
        this.assertIssueRow(1, 10060, "LOTS-1", "LOTS 1");
        this.tester.clickLink("version-expando-10059");
        this.assertions.assertNodeHasText("//li[@id='version-10061']/div[2]", "No issues");
        this.assertRowCount(10060, 1);
        this.assertIssueRow(1, 10060, "LOTS-1", "LOTS 1");
        this.assertRowCount(10059, 2);
        this.assertIssueRow(1, 10059, "LOTS-1", "LOTS 1");
        this.assertIssueRow(2, 10059, "LOTS-3", "Lots 3");
        this.tester.clickLink("version-expando-10053");
        this.assertions.assertNodeHasText("//li[@id='version-10061']/div[2]", "No issues");
        this.assertRowCount(10060, 1);
        this.assertIssueRow(1, 10060, "LOTS-1", "LOTS 1");
        this.assertRowCount(10059, 2);
        this.assertIssueRow(1, 10059, "LOTS-1", "LOTS 1");
        this.assertIssueRow(2, 10059, "LOTS-3", "Lots 3");
        this.assertRowCount(10053, 2);
        this.assertIssueRow(1, 10053, "LOTS-1", "LOTS 1");
        this.assertIssueRow(2, 10053, "LOTS-4", "Lots 4");
        this.navigation.browseProject("LOTS");
        this.assertions.assertNodeHasText("//li[@id='version-10061']/div[2]", "No issues");
        this.assertRowCount(10060, 1);
        this.assertIssueRow(1, 10060, "LOTS-1", "LOTS 1");
        this.assertRowCount(10059, 2);
        this.assertIssueRow(1, 10059, "LOTS-1", "LOTS 1");
        this.assertIssueRow(2, 10059, "LOTS-3", "Lots 3");
        this.assertRowCount(10053, 2);
        this.assertIssueRow(1, 10053, "LOTS-1", "LOTS 1");
        this.assertIssueRow(2, 10053, "LOTS-4", "Lots 4");
        this.navigation.browseComponentTabPanel("LOTS", "Component 1", "roadmap");
        this.tester.clickLinkWithText("all versions");
        this.tester.clickLink("version-expando-10040");
        this.assertRowCount(10040, 1);
        this.assertIssueRow(1, 10040, "LOTS-1", "LOTS 1");
        this.tester.clickLink("version-expando-10041");
        this.assertRowCount(10040, 1);
        this.assertIssueRow(1, 10040, "LOTS-1", "LOTS 1");
        this.assertRowCount(10041, 1);
        this.assertIssueRow(1, 10041, "LOTS-1", "LOTS 1");
        this.tester.clickLink("version-expando-10042");
        this.assertRowCount(10040, 1);
        this.assertIssueRow(1, 10040, "LOTS-1", "LOTS 1");
        this.assertRowCount(10041, 1);
        this.assertIssueRow(1, 10041, "LOTS-1", "LOTS 1");
        this.assertRowCount(10042, 1);
        this.assertIssueRow(1, 10042, "LOTS-1", "LOTS 1");
        this.navigation.browseComponentTabPanel("LOTS", "Component 1");
        this.assertRowCount(10040, 1);
        this.assertIssueRow(1, 10040, "LOTS-1", "LOTS 1");
        this.assertRowCount(10041, 1);
        this.assertIssueRow(1, 10041, "LOTS-1", "LOTS 1");
        this.assertRowCount(10042, 1);
        this.assertIssueRow(1, 10042, "LOTS-1", "LOTS 1");
        this.tester.clickLink("version-expando-10050");
        this.assertions.assertNodeHasText("//li[@id='version-10050']/div[2]", "No issues");
        this.navigation.browseComponentTabPanel("LOTS", "Component 1", "changelog");
        this.tester.clickLinkWithText("all versions");
        this.tester.clickLink("version-expando-10061");
        this.assertions.assertNodeHasText("//li[@id='version-10061']/div[2]", "No issues");
        this.tester.clickLink("version-expando-10060");
        this.assertions.assertNodeHasText("//li[@id='version-10061']/div[2]", "No issues");
        this.assertRowCount(10060, 1);
        this.assertIssueRow(1, 10060, "LOTS-1", "LOTS 1");
        this.tester.clickLink("version-expando-10059");
        this.assertions.assertNodeHasText("//li[@id='version-10061']/div[2]", "No issues");
        this.assertRowCount(10060, 1);
        this.assertIssueRow(1, 10060, "LOTS-1", "LOTS 1");
        this.assertRowCount(10059, 1);
        this.assertIssueRow(1, 10059, "LOTS-1", "LOTS 1");
        this.tester.clickLink("version-expando-10053");
        this.assertions.assertNodeHasText("//li[@id='version-10061']/div[2]", "No issues");
        this.assertRowCount(10060, 1);
        this.assertIssueRow(1, 10060, "LOTS-1", "LOTS 1");
        this.assertRowCount(10059, 1);
        this.assertIssueRow(1, 10059, "LOTS-1", "LOTS 1");
        this.assertRowCount(10053, 1);
        this.assertIssueRow(1, 10053, "LOTS-1", "LOTS 1");
        this.navigation.browseComponentTabPanel("LOTS", "Component 1");
        this.assertions.assertNodeHasText("//li[@id='version-10061']/div[2]", "No issues");
        this.assertRowCount(10060, 1);
        this.assertIssueRow(1, 10060, "LOTS-1", "LOTS 1");
        this.assertRowCount(10059, 1);
        this.assertIssueRow(1, 10059, "LOTS-1", "LOTS 1");
        this.assertRowCount(10053, 1);
        this.assertIssueRow(1, 10053, "LOTS-1", "LOTS 1");
        this.tester.gotoPage("secure/ViewProfile.jspa?selectedTab=jira.user.profile.panels:up-roadmap-panel&pid=10040");
        this.tester.clickLinkWithText("all versions");
        this.tester.clickLink("version-expando-10040");
        this.assertRowCount(10040, 4);
        this.assertIssueRow(1, 10040, "LOTS-1", "LOTS 1");
        this.assertIssueRow(2, 10040, "LOTS-3", "Lots 3");
        this.assertIssueRow(3, 10040, "LOTS-4", "Lots 4");
        this.assertIssueRow(4, 10040, "LOTS-2", "Lots 2");
        this.tester.clickLink("version-expando-10041");
        this.assertRowCount(10040, 4);
        this.assertIssueRow(1, 10040, "LOTS-1", "LOTS 1");
        this.assertIssueRow(2, 10040, "LOTS-3", "Lots 3");
        this.assertIssueRow(3, 10040, "LOTS-4", "Lots 4");
        this.assertIssueRow(4, 10040, "LOTS-2", "Lots 2");
        this.assertRowCount(10041, 3);
        this.assertIssueRow(1, 10041, "LOTS-1", "LOTS 1");
        this.assertIssueRow(2, 10041, "LOTS-4", "Lots 4");
        this.assertIssueRow(3, 10041, "LOTS-2", "Lots 2");
        this.tester.clickLink("version-expando-10042");
        this.assertRowCount(10040, 4);
        this.assertIssueRow(1, 10040, "LOTS-1", "LOTS 1");
        this.assertIssueRow(2, 10040, "LOTS-3", "Lots 3");
        this.assertIssueRow(3, 10040, "LOTS-4", "Lots 4");
        this.assertIssueRow(4, 10040, "LOTS-2", "Lots 2");
        this.assertRowCount(10041, 3);
        this.assertIssueRow(1, 10041, "LOTS-1", "LOTS 1");
        this.assertIssueRow(2, 10041, "LOTS-4", "Lots 4");
        this.assertIssueRow(3, 10041, "LOTS-2", "Lots 2");
        this.assertRowCount(10042, 3);
        this.assertIssueRow(1, 10042, "LOTS-1", "LOTS 1");
        this.assertIssueRow(2, 10042, "LOTS-3", "Lots 3");
        this.assertIssueRow(3, 10042, "LOTS-2", "Lots 2");
        this.tester.gotoPage("secure/ViewProfile.jspa?selectedTab=jira.user.profile.panels:up-roadmap-panel&pid=10040");
        this.assertRowCount(10040, 4);
        this.assertIssueRow(1, 10040, "LOTS-1", "LOTS 1");
        this.assertIssueRow(2, 10040, "LOTS-3", "Lots 3");
        this.assertIssueRow(3, 10040, "LOTS-4", "Lots 4");
        this.assertIssueRow(4, 10040, "LOTS-2", "Lots 2");
        this.assertRowCount(10041, 3);
        this.assertIssueRow(1, 10041, "LOTS-1", "LOTS 1");
        this.assertIssueRow(2, 10041, "LOTS-4", "Lots 4");
        this.assertIssueRow(3, 10041, "LOTS-2", "Lots 2");
        this.assertRowCount(10042, 3);
        this.assertIssueRow(1, 10042, "LOTS-1", "LOTS 1");
        this.assertIssueRow(2, 10042, "LOTS-3", "Lots 3");
        this.assertIssueRow(3, 10042, "LOTS-2", "Lots 2");
        this.tester.clickLink("version-expando-10050");
        this.assertions.assertNodeHasText("//li[@id='version-10050']/div[2]", "No issues");
    }

    private void assertRowCount(int versionId, int count) {
        XPathLocator locator = new XPathLocator(this.tester, "//li[@id='version-" + versionId + "']/div[2]/table/tr");
        TestBrowseProjectRoadMapAndChangeLogTab.assertEquals((int)count, (int)locator.getNodes().length);
    }

    private void assertIssueRow(int row, int versionId, String issueKey, String issueSummary) {
        this.assertions.assertNodeHasText("//li[@id='version-" + versionId + "']/div[2]/table/tr[" + row + "]/td[2]", issueKey);
        this.assertions.getLinkAssertions().assertLinkAtNodeEndsWith("//li[@id='version-" + versionId + "']/div[2]/table/tr[" + row + "]/td[2]/a", "browse/" + issueKey);
        this.assertions.assertNodeHasText("//li[@id='version-" + versionId + "']/div[2]/table/tr[" + row + "]/td[4]", issueSummary);
        this.assertions.getLinkAssertions().assertLinkAtNodeEndsWith("//li[@id='version-" + versionId + "']/div[2]/table/tr[" + row + "]/td[4]/a", "browse/" + issueKey);
    }

    private void assertUnreleasedVersion(String versionName, int versionId, String releaseDate, String description, int unresolved, int total, int componentId, String componentName) {
        this.assertions.assertNodeHasText("//li[@id='version-" + versionId + "']/div[1]/a[@class='versionBanner-name']", versionName);
        this.assertions.getLinkAssertions().assertLinkLocationEndsWith(versionName, "browse/LOTS/fixforversion/" + versionId);
        if (componentId == -1) {
            this.assertions.getLinkAssertions().assertLinkAtNodeEndsWith("//li[@id='version-" + versionId + "']/div[1]/a[1]", "browse/LOTS?selectedTab=com.atlassian.jira.plugin.system.project:roadmap-panel&expandVersion=" + versionId);
            this.assertions.assertNodeHasText("//a[@id='release-notes-" + versionId + "']", "Release Notes");
            this.assertions.getLinkAssertions().assertLinkIdLocationEndsWith("release-notes-" + versionId, "secure/ReleaseNote.jspa?projectId=10040&version=" + versionId);
        } else {
            this.assertions.getLinkAssertions().assertLinkAtNodeEndsWith("//li[@id='version-" + versionId + "']/div[1]/a[1]", "browse/LOTS/component/" + componentId + "?selectedTab=com.atlassian.jira.plugin.system.project:component-roadmap-panel&expandVersion=" + versionId);
            this.assertions.assertNodeDoesNotExist("//a[@id='release-notes-" + versionId + "']");
        }
        if (StringUtils.isNotBlank((String)releaseDate)) {
            this.assertions.assertNodeHasText("//li[@id='version-" + versionId + "']/div[1]/span[2]", releaseDate);
        } else if (componentId != -1) {
            this.assertions.assertNodeHasText("//li[@id='version-" + versionId + "']/div[1]/span[2]", "Release Date: N/A");
        }
        this.assertions.assertNodeHasText("//li[@id='version-" + versionId + "']/div[1]/span[1]", description);
        if (total != 0) {
            this.assertions.assertNodeHasText("//li[@id='version-" + versionId + "']/div[1]/div[1]/table/tr[2]", unresolved + " of " + total + " issues have been resolved");
            if (componentId == -1) {
                this.assertions.getLinkAssertions().assertLinkAtNodeEndsWith("//li[@id='version-" + versionId + "']/div[1]/div[1]/table/tr[2]/td[1]/span/a[1]", "secure/IssueNavigator.jspa?reset=true&mode=hide&jqlQuery=project+%3D+LOTS+AND+fixVersion+%3D+%22" + URLEncoder.encode(versionName) + "%22+AND+resolution+in+%28Fixed%2C+%22Won%27t+Fix%22%2C+Duplicate%2C+Incomplete%2C+%22Cannot+Reproduce%22%29");
                this.assertions.getLinkAssertions().assertLinkAtNodeEndsWith("//li[@id='version-" + versionId + "']/div[1]/div[1]/table/tr[2]/td[1]/span/a[2]", "secure/IssueNavigator.jspa?reset=true&mode=hide&jqlQuery=project+%3D+LOTS+AND+fixVersion+%3D+%22" + URLEncoder.encode(versionName) + "%22");
            } else {
                this.assertions.getLinkAssertions().assertLinkAtNodeEndsWith("//li[@id='version-" + versionId + "']/div[1]/div[1]/table/tr[2]/td[1]/span/a[1]", "secure/IssueNavigator.jspa?reset=true&mode=hide&jqlQuery=project+%3D+LOTS+AND+fixVersion+%3D+%22" + URLEncoder.encode(versionName) + "%22+AND+component+%3D+%22" + URLEncoder.encode(componentName) + "%22+AND+resolution+in+%28Fixed%2C+%22Won%27t+Fix%22%2C+Duplicate%2C+Incomplete%2C+%22Cannot+Reproduce%22%29");
                this.assertions.getLinkAssertions().assertLinkAtNodeEndsWith("//li[@id='version-" + versionId + "']/div[1]/div[1]/table/tr[2]/td[1]/span/a[2]", "secure/IssueNavigator.jspa?reset=true&mode=hide&jqlQuery=project+%3D+LOTS+AND+fixVersion+%3D+%22" + URLEncoder.encode(versionName) + "%22+AND+component+%3D+%22" + URLEncoder.encode(componentName) + "%22");
            }
        } else {
            this.assertions.assertNodeHasText("//li[@id='version-" + versionId + "']/div[1]/div[1]", "No issues");
        }
    }

    private void assertPersonalUnreleasedVersion(String versionName, int versionId, String releaseDate, String description, int unresolved, int total) {
        this.assertions.assertNodeHasText("//li[@id='version-" + versionId + "']/div[1]/a[@class='versionBanner-name']", versionName);
        this.assertions.getLinkAssertions().assertLinkLocationEndsWith(versionName, "browse/LOTS/fixforversion/" + versionId);
        this.assertions.getLinkAssertions().assertLinkAtNodeEndsWith("//li[@id='version-" + versionId + "']/div[1]/a[1]", "secure/ViewProfile.jspa?selectedTab=jira.user.profile.panels:up-roadmap-panel&pid=10040&expandVersion=" + versionId);
        this.assertions.assertNodeDoesNotExist("//a[@id='release-notes-" + versionId + "']");
        if (StringUtils.isNotBlank((String)releaseDate)) {
            this.assertions.assertNodeHasText("//li[@id='version-" + versionId + "']/div[1]/span[2]", releaseDate);
        } else {
            this.assertions.assertNodeHasText("//li[@id='version-" + versionId + "']/div[1]/span[2]", "Release Date: N/A");
        }
        this.assertions.assertNodeHasText("//li[@id='version-" + versionId + "']/div[1]/span[1]", description);
        if (total != 0) {
            this.assertions.assertNodeHasText("//li[@id='version-" + versionId + "']/div[1]/div[1]/table/tr[2]", unresolved + " of " + total + " issues have been resolved");
            this.assertions.getLinkAssertions().assertLinkAtNodeEndsWith("//li[@id='version-" + versionId + "']/div[1]/div[1]/table/tr[2]/td[1]/span/a[1]", "secure/IssueNavigator.jspa?reset=true&mode=hide&jqlQuery=project+%3D+LOTS+AND+fixVersion+%3D+%22" + URLEncoder.encode(versionName) + "%22+AND+assignee+%3D+currentUser%28%29+AND+resolution+in+%28Fixed%2C+%22Won%27t+Fix%22%2C+Duplicate%2C+Incomplete%2C+%22Cannot+Reproduce%22%29");
            this.assertions.getLinkAssertions().assertLinkAtNodeEndsWith("//li[@id='version-" + versionId + "']/div[1]/div[1]/table/tr[2]/td[1]/span/a[2]", "secure/IssueNavigator.jspa?reset=true&mode=hide&jqlQuery=project+%3D+LOTS+AND+fixVersion+%3D+%22" + URLEncoder.encode(versionName) + "%22+AND+assignee+%3D+currentUser%28%29");
        } else {
            this.assertions.assertNodeHasText("//li[@id='version-" + versionId + "']/div[1]/div[1]", "No issues");
        }
    }

    private void assertReleasedVersion(String versionName, int versionId, String releaseDate, String description, int total, int componentId, String componentName) {
        this.assertions.assertNodeHasText("//li[@id='version-" + versionId + "']/div[1]/a[@class='versionBanner-name']", versionName);
        this.assertions.getLinkAssertions().assertLinkLocationEndsWith(versionName, "browse/LOTS/fixforversion/" + versionId);
        if (componentId == -1) {
            this.assertions.getLinkAssertions().assertLinkAtNodeEndsWith("//li[@id='version-" + versionId + "']/div[1]/a[1]", "browse/LOTS?selectedTab=com.atlassian.jira.plugin.system.project:changelog-panel&expandVersion=" + versionId);
            this.assertions.assertNodeHasText("//a[@id='release-notes-" + versionId + "']", "Release Notes");
            this.assertions.getLinkAssertions().assertLinkIdLocationEndsWith("release-notes-" + versionId, "secure/ReleaseNote.jspa?projectId=10040&version=" + versionId);
        } else {
            this.assertions.getLinkAssertions().assertLinkAtNodeEndsWith("//li[@id='version-" + versionId + "']/div[1]/a[1]", "browse/LOTS/component/" + componentId + "?selectedTab=com.atlassian.jira.plugin.system.project:component-changelog-panel&expandVersion=" + versionId);
            this.assertions.assertNodeDoesNotExist("//a[@id='release-notes-" + versionId + "']");
        }
        if (StringUtils.isNotBlank((String)releaseDate)) {
            this.assertions.assertNodeHasText("//li[@id='version-" + versionId + "']/div[1]/span[2]", releaseDate);
        } else if (componentId != -1) {
            this.assertions.assertNodeHasText("//li[@id='version-" + versionId + "']/div[1]/span[2]", "Release Date: N/A");
        }
        this.assertions.assertNodeHasText("//li[@id='version-" + versionId + "']/div[1]/span[1]", description);
        if (total != 0) {
            boolean versionRequiresQuotes = versionName.contains(" ");
            String jqlVersionString = versionRequiresQuotes ? URLEncoder.encode("\"" + versionName + "\"") : URLEncoder.encode(versionName);
            this.assertions.assertNodeHasText("//li[@id='version-" + versionId + "']/div[1]/div[1]/a", total + " issues");
            if (componentId == -1) {
                this.assertions.getLinkAssertions().assertLinkAtNodeEndsWith("//li[@id='version-" + versionId + "']/div[1]/div[1]/a", "secure/IssueNavigator.jspa?reset=true&mode=hide&jqlQuery=project+%3D+LOTS+AND+fixVersion+%3D+" + jqlVersionString + "");
            } else {
                this.assertions.getLinkAssertions().assertLinkAtNodeEndsWith("//li[@id='version-" + versionId + "']/div[1]/div[1]/a", "secure/IssueNavigator.jspa?reset=true&mode=hide&jqlQuery=project+%3D+LOTS+AND+fixVersion+%3D+" + jqlVersionString + "+AND+component+%3D+%22" + URLEncoder.encode(componentName) + "%22");
            }
        } else {
            this.assertions.assertNodeHasText("//li[@id='version-" + versionId + "']/div[1]/div[1]", "No issues");
        }
    }
}

