/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;

public class TestVisibleOperations
extends FuncTestCase {
    public void testLoadedNotModifiedOwned() throws Exception {
        this.administration.restoreData("TestFilterOperations.xml");
        this.navigation.issueNavigator().loadFilter(10000L, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.assertOperationsPresent("filtereditshares", "filterviewsubscriptions", "filtersaveas");
        this.assertOperationsNotPresent("reload", "filtersave", "filtersavenew");
    }

    public void testInvalid() {
        this.administration.restoreData("TestFilterOperations.xml");
        this.navigation.issueNavigator().createSearch("type = bogus");
        this.assertOperationsNotPresent("filtersavenew", "filtereditshares", "filterviewsubscriptions", "filtersaveas", "reload", "filtersave", "editinvalid");
    }

    public void testLoadedInvalid() {
        this.administration.restoreData("TestFilterOperations.xml");
        this.navigation.issueNavigator().loadFilter(10010L, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.assertOperationsNotPresent("filtersavenew", "filtersaveas", "reload", "filtersave", "editinvalid");
        this.assertOperationsPresent("filtereditshares", "filterviewsubscriptions");
    }

    public void testLoadedModifiedInvalid() {
        this.administration.restoreData("TestFilterOperations.xml");
        this.navigation.issueNavigator().loadFilter(10000L, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.tester.setWorkingForm("jqlform");
        this.tester.setFormElement("jqlQuery", "type = bogus");
        this.tester.submit();
        this.assertOperationsNotPresent("filtersavenew", "filtersaveas", "filtersave", "editinvalid");
        this.assertOperationsPresent("filtereditshares", "filterviewsubscriptions", "reload");
    }

    public void testLoadedModifiedInvalidNotOwned() {
        this.administration.restoreData("TestFilterOperations.xml");
        this.navigation.login("fred", "fred");
        this.navigation.issueNavigator().loadFilter(10000L, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.tester.setWorkingForm("jqlform");
        this.tester.setFormElement("jqlQuery", "type = bogus");
        this.tester.submit();
        this.assertOperationsNotPresent("filtersavenew", "filtersaveas", "filtersave", "editinvalid", "filtereditshares", "filterviewsubscriptions");
        this.assertOperationsPresent("reload");
    }

    public void testLoadedInvalidNotOwned() {
        this.administration.restoreData("TestFilterOperations.xml");
        this.navigation.login("fred", "fred");
        this.navigation.issueNavigator().loadFilter(10010L, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.assertOperationsNotPresent("filtersavenew", "filtersaveas", "filtersave", "editinvalid", "filtereditshares", "filterviewsubscriptions", "reload");
    }

    public void testLoadedModifiedOwned() throws Exception {
        this.administration.restoreData("TestFilterOperations.xml");
        this.navigation.issueNavigator().loadFilter(10000L, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.tester.setWorkingForm("jqlform");
        this.tester.setFormElement("jqlQuery", "type = 2");
        this.tester.submit();
        this.assertOperationsPresent("filtereditshares", "filterviewsubscriptions", "filtersaveas", "reload", "filtersave");
        this.assertOperationsNotPresent("filtersavenew", "editinvalid");
    }

    public void testLoadedNotModifiedNotOwned() throws Exception {
        this.administration.restoreData("TestFilterOperations.xml");
        this.navigation.login("fred", "fred");
        this.navigation.issueNavigator().loadFilter(10000L, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        TestVisibleOperations.assertTrue((String)"Asserting 'create new' link present", (boolean)new XPathLocator(this.tester, "//a[@id='copyasnewfilter']").exists());
        this.assertOperationsNotPresent("reload", "filtersave", "filtersavenew", "filtereditshares", "filterviewsubscriptions", "filtersaveas", "editinvalid");
    }

    public void testLoadedModifiedNotOwned() throws Exception {
        this.administration.restoreData("TestFilterOperations.xml");
        this.navigation.login("fred", "fred");
        this.navigation.issueNavigator().loadFilter(10000L, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.tester.setWorkingForm("jqlform");
        this.tester.setFormElement("jqlQuery", "type = 2");
        this.tester.submit();
        TestVisibleOperations.assertTrue((String)"Asserting 'create new' link present", (boolean)new XPathLocator(this.tester, "//a[@id='copyasnewfilter']").exists());
        this.assertOperationsPresent("reload");
        this.assertOperationsNotPresent("filtersave", "filtersavenew", "filtereditshares", "filterviewsubscriptions", "filtersaveas", "editinvalid");
    }

    public void testNotLoaded() throws Exception {
        this.administration.restoreData("TestFilterOperations.xml");
        this.navigation.issueNavigator().createSearch("bug = type");
        this.navigation.issueNavigator().gotoEditMode(IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.tester.submit();
        this.assertOperationsPresent("filtersavenew");
        this.assertOperationsNotPresent("filtereditshares", "filterviewsubscriptions", "filtersaveas", "reload", "editinvalid");
    }

    private void assertOperationsPresent(String ... operationIds) {
        for (String operationId : operationIds) {
            TestVisibleOperations.assertTrue((String)("Checking operation with link ID: '" + operationId + "' is present."), (boolean)new XPathLocator(this.tester, "//div[@id='filteroperations']//a[@id='" + operationId + "']").exists());
        }
    }

    private void assertOperationsNotPresent(String ... operationIds) {
        for (String operationId : operationIds) {
            TestVisibleOperations.assertFalse((String)("Checking operation with link ID: '" + operationId + "' is NOT present."), (boolean)new XPathLocator(this.tester, "//div[@id='filteroperations']//a[@id='" + operationId + "']").exists());
        }
    }
}

