/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.jira.functest.framework.FuncTestCase;

public class TestJqlParsing
extends FuncTestCase {
    private static final String[] reservedWords = new String[]{"abort", "access", "add", "after", "alias", "all", "alter", "any", "as", "audit", "avg", "before", "begin", "between", "boolean", "break", "byte", "catch", "char", "character", "check", "checkpoint", "collate", "collation", "column", "commit", "connect", "continue", "count", "create", "current", "date", "decimal", "declare", "decrement", "default", "defaults", "define", "delete", "delimiter", "difference", "distinct", "divide", "do", "double", "drop", "else", "encoding", "end", "equals", "escape", "exclusive", "exec", "execute", "exists", "explain", "false", "fetch", "file", "field", "first", "float", "for", "from", "function", "go", "goto", "grant", "greater", "group", "having", "identified", "if", "immediate", "increment", "index", "initial", "inner", "inout", "input", "insert", "int", "integer", "intersect", "intersection", "into", "isempty", "isnull", "join", "last", "left", "less", "like", "limit", "lock", "long", "max", "min", "minus", "mode", "modify", "modulo", "more", "multiply", "next", "noaudit", "notin", "nowait", "number", "object", "of", "on", "option", "outer", "output", "power", "previous", "prior", "privileges", "public", "raise", "raw", "remainder", "rename", "resource", "return", "returns", "revoke", "right", "row", "rowid", "rownum", "rows", "select", "session", "set", "share", "size", "sqrt", "start", "strict", "string", "subtract", "sum", "synonym", "table", "then", "to", "trans", "transaction", "trigger", "true", "uid", "union", "unique", "update", "user", "validate", "values", "view", "when", "whenever", "where", "while", "with"};

    public void testJqlParserErrors() throws Exception {
        this.administration.restoreBlankInstance();
        this.assertErrorMessage("comment ~ 'test", "The quoted string 'test' has not been completed. (line 1, character 11)");
        this.assertErrorMessage("comment ~ 'test\n", "The quoted string 'test' has not been completed. (line 1, character 11)");
        this.assertErrorMessage("priority=\"test\nword", "Error in the JQL Query: The quoted string 'test word' has not been completed. (line 1, character 10)");
        this.assertErrorMessage("comment ~ '", "Error in the JQL Query: The quoted string has not been completed. (line 1, character 11)");
        this.assertErrorMessage("comme\\unt ~ 'test", "'\\un' is an illegal JQL escape sequence. The valid escape sequences are \\', \\\", \\t, \\n, \\r, \\\\, '\\ ' and \\uXXXX. (line 1, character 6)");
        this.assertErrorMessage("status =\n\n\n\n\n\n \\c", "'\\c' is an illegal JQL escape sequence. The valid escape sequences are \\', \\\", \\t, \\n, \\r, \\\\, '\\ ' and \\uXXXX. (line 7, character 2)");
        this.assertErrorMessage("status =\n\n\n\n \\csss", "'\\c' is an illegal JQL escape sequence. The valid escape sequences are \\', \\\", \\t, \\n, \\r, \\\\, '\\ ' and \\uXXXX. (line 5, character 2)");
        this.assertErrorMessage("status =\n\n\n\n\\", "The escape sequence has not been completed. The valid escape sequences are \\', \\\", \\t, \\n, \\r, \\\\, '\\ ' and \\uXXXX. (line 5, character 1)");
        this.assertErrorMessage("status =\n\n\n\n\\u", "'\\u' is an illegal JQL escape sequence. The valid escape sequences are \\', \\\", \\t, \\n, \\r, \\\\, '\\ ' and \\uXXXX. (line 5, character 1)");
        this.assertErrorMessage("status =\n\n\n\n'\\u'", "'\\u'' is an illegal JQL escape sequence. The valid escape sequences are \\', \\\", \\t, \\n, \\r, \\\\, '\\ ' and \\uXXXX. (line 5, character 2)");
        this.assertErrorMessage("mine{www = qwwr", "The character '{' is a reserved JQL character. You must enclose it in a string or use the escape '\\u007b' instead. (line 1, character 5)");
        this.assertErrorMessage("minewww# = qwwr", "The character '#' is a reserved JQL character. You must enclose it in a string or use the escape '\\u0023' instead. (line 1, character 8)");
        this.assertErrorMessage("minewww = qwwr}", "The character '}' is a reserved JQL character. You must enclose it in a string or use the escape '\\u007d' instead. (line 1, character 15)");
        this.assertErrorMessage("minewww =\u007fqwwr", "The character 'U+007F' on line 1 at position 10 must be escaped. Use the escape '\\u007f' instead. (line 1, character 10)");
        this.assertErrorMessage("mqwwr\u007f", "The character 'U+007F' on line 1 at position 6 must be escaped. Use the escape '\\u007f' instead. (line 1, character 6)");
        this.assertErrorMessage("mqwwr=\"\u007f this is broken\"", "Error in the JQL Query: The character 'U+007F' on line 1 at position 8 must be escaped. Use the escape '\\u007f' instead. (line 1, character 8)");
        this.assertErrorMessage("aaaaa=-3482094382084092840932809482", "'-3482094382084092840932809482' is not a valid number. Numbers must be between -9,223,372,036,854,775,808 and 9,223,372,036,854,775,807. (line 1, character 7)");
        this.assertErrorMessage("cf[1002020202002020202020202020020202822]=a", "'1002020202002020202020202020020202822' is not a valid number. Numbers must be between -9,223,372,036,854,775,808 and 9,223,372,036,854,775,807. (line 1, character 4)");
        this.assertErrorMessage("a =b order", "Expecting 'by' before the end of the query.");
        this.assertErrorMessage("a =b order summary", "Expecting 'by' but got 'summary'. (line 1, character 12)");
        this.assertErrorMessage("a =b order by", "Expecting a field name at the end of the query.");
        this.assertErrorMessage("a =b order by asc", "Expecting a field name but got 'asc'. You must surround 'asc' in quotation marks to use it as a field name. (line 1, character 15)");
        this.assertErrorMessage("a =b order by ajsks blah", "Expecting either 'ASC' or 'DESC' but got 'blah'. (line 1, character 21)");
        this.assertErrorMessage("a =b order by \"\" desc", "A field name cannot be empty. (line 1, character 15)");
        this.assertErrorMessage("'' = c", "A field name cannot be empty. (line 1, character 1)");
        this.assertErrorMessage("summary ~ bad and \n\\ ~ cool", "A field name cannot be empty. (line 2, character 1)");
        this.assertErrorMessage("a = ''()", "A function name cannot be empty. (line 1, character 5)");
        this.assertErrorMessage("a = \"\"()", "A function name cannot be empty. (line 1, character 5)");
        this.assertErrorMessage("a = \\ \n()", "A function name cannot be empty. (line 1, character 5)");
        this.assertErrorMessage("a", "Expecting operator before the end of the query. The valid operators are '=', '!=', '<', '>', '<=', '>=', '~', '!~', 'IN', 'NOT IN', 'IS' and 'IS NOT'.");
        this.assertErrorMessage("a blah >", "Expecting operator but got 'blah'. The valid operators are '=', '!=', '<', '>', '<=', '>=', '~', '!~', 'IN', 'NOT IN', 'IS' and 'IS NOT'. (line 1, character 3)");
        this.assertErrorMessage("a blah >", "Expecting operator but got 'blah'. The valid operators are '=', '!=', '<', '>', '<=', '>=', '~', '!~', 'IN', 'NOT IN', 'IS' and 'IS NOT'. (line 1, character 3)");
        this.assertErrorMessage("a =a and j not is empty", "Expecting 'IN' but got 'is'. (line 1, character 16)");
        this.assertErrorMessage("a =a and j is ! empty", "Expecting 'NOT' but got '!'. (line 1, character 15)");
        this.assertErrorMessage("cf", "Expecting '[' before the end of the query.");
        this.assertErrorMessage("a = b and not (cf = 6)", "Expecting '[' but got '='. (line 1, character 19)");
        this.assertErrorMessage("cf[", "Expecting a custom field id (a positive number) before the end of the query.");
        this.assertErrorMessage("cf[ = 9", "Expecting a custom field id (a positive number) but got '='. (line 1, character 5)");
        this.assertErrorMessage("cf[] = 1", "Expecting a custom field id (a positive number) but got ']'. (line 1, character 4)");
        this.assertErrorMessage("cf[29829k] = ", "Expecting a custom field id (a positive number) but got '29829k'. (line 1, character 4)");
        this.assertErrorMessage("cf[-29829] = ", "Expecting a custom field id (a positive number) but got '-29829'. (line 1, character 4)");
        this.assertErrorMessage("cf[29829 = world", "Expecting ']' but got '='. (line 1, character 10)");
        this.assertErrorMessage("cf[29829", "Expecting ']' before the end of the query.");
        this.assertErrorMessage("a = func(", "Expecting ')' before the end of the query.");
        this.assertErrorMessage("a = func(, and not (a = x)", "Expecting ')' but got ','. (line 1, character 10)");
        this.assertErrorMessage("b=func(bad", "Expecting ')' before the end of the query.");
        this.assertErrorMessage("bas=func(bad,)", "Function argument must be specified. (line 1, character 14)");
        this.assertErrorMessage("bas=func(bad,", "Expecting a function argument at the end of the query.");
        this.assertErrorMessage("k = func(!", "Expecting a function argument but got '!'. You must surround '!' in quotation marks to use it as an argument. (line 1, character 10)");
        this.assertErrorMessage("k = func(abc, jk!)", "Expecting ')' or ',' but got '!'. (line 1, character 17)");
        this.assertErrorMessage("(a=b and c = d", "Expecting ')' before the end of the query.");
        this.assertErrorMessage("a=b or (c=d and not l ~ kate", "Expecting ')' before the end of the query.");
        this.assertErrorMessage("b in ((12, (288)", "Expecting ')' before the end of the query.");
        this.assertErrorMessage("abc IN ((foo) abc = a", "Expecting ')' but got 'abc'. (line 1, character 15)");
        this.assertErrorMessage("a=", "Expecting either a value, list or function before the end of the query.");
        this.assertErrorMessage("a=!", "Expecting either a value, list or function but got '!'. You must surround '!' in quotation marks to use it as a value. (line 1, character 3)");
        this.assertErrorMessage("a=b c=d", "Expecting either 'OR' or 'AND' but got 'c'. (line 1, character 5)");
        this.assertErrorMessage("a=b !c=d", "Expecting either 'OR' or 'AND' but got '!'. (line 1, character 5)");
        this.assertErrorMessage("a=(a,", "Expecting either a value, list or function before the end of the query.");
        this.assertErrorMessage("a=(a,", "Expecting either a value, list or function before the end of the query.");
        this.assertErrorMessage("a=(a,(,bad))", "Expecting either a value, list or function but got ','. You must surround ',' in quotation marks to use it as a value. (line 1, character 7)");
        this.assertErrorMessage("a = ((c,d), d, e, f, yyy) and", "Expecting a field name at the end of the query.");
        this.assertErrorMessage("comment !~ \"brenden\" and", "Expecting a field name at the end of the query.");
        this.assertErrorMessage("comment !~ \"brenden\" jack = jill", "Expecting either 'OR' or 'AND' but got 'jack'. (line 1, character 22)");
        this.assertErrorMessage("comment !~ \"brenden\" and cf[1000] = jill order by a desc b", "Error in the JQL Query: Expecting ',' but got 'b'. (line 1, character 58)");
        this.assertErrorMessage(", a = b", "Expecting a field name but got ','. You must surround ',' in quotation marks to use it as a field name. (line 1, character 1)");
        this.assertErrorMessage("order by a desc d", "Error in the JQL Query: Expecting ',' but got 'd'. (line 1, character 17)");
        this.assertErrorMessage("[brenden] = a", "Expecting a field name but got '['. Did you mean 'cf['? (line 1, character 1)");
        this.assertErrorMessage("a = brenden and [78] = q", "Expecting a field name but got '['. Did you mean 'cf['? (line 1, character 17)");
        for (String reservedWord : reservedWords) {
            String jqlQuery = String.format("summary ~ %s", reservedWord);
            String errorMsg = String.format("Error in the JQL Query: '%s' is a reserved JQL word. You must surround it in quotation marks to use it in a query. (line 1, character 11)", reservedWord);
            this.assertErrorMessage(jqlQuery, errorMsg);
        }
    }

    private void assertErrorMessage(String query, String errorMessage) {
        this.navigation.issueNavigator().createSearch(query);
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors(errorMessage);
    }
}

