/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.jira.functest.framework.assertions.HTMLAssertionsImpl;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.webtests.ztests.navigator.jql.AbstractJqlFuncTest;
import com.meterware.httpunit.WebResponse;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class TestIssueNavigatorUrlParameter
extends AbstractJqlFuncTest {
    private static final String JQL_NOT_PARSEABLE = "()&#)$&#(*$prject =&^$(&# homosapien";
    private static final String JQL_IN_VALID_DOESNOT_FIT = "component = \"New Component 5\" AND project = homosapien";
    private static final String JQL_IN_VALID_FITS = "reporter in membersOf(\"blub\")";
    private static final String JQL_VALID_DOESNOT_FIT = "component = \"New Component 2\"";
    private static final String JQL_VALID_AND_FITS = "component = \"New Component 2\" AND project = homosapien";

    protected void setUpTest() {
        this.administration.restoreData("TestIssueNavigatorUrlParameter.xml");
    }

    public void testIssueNavigatorRetainSimpleSearch() throws Exception {
        this.executeIssueNavigatorURL(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED, true, "jqlQuery=()&#)$&#(*$prject =&^$(&# homosapien");
        this.executeIssueNavigatorURL(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED, true, "jqlQuery=component = \"New Component 5\" AND project = homosapien");
        this.executeIssueNavigatorURL(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE, IssueNavigatorNavigation.NavigatorEditMode.SIMPLE, true, "jqlQuery=reporter in membersOf(\"blub\")");
        this.executeIssueNavigatorURL(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED, true, "jqlQuery=component = \"New Component 2\"");
        this.assertIssues("HSP-1");
        this.executeIssueNavigatorURL(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE, IssueNavigatorNavigation.NavigatorEditMode.SIMPLE, true, "jqlQuery=component = \"New Component 2\" AND project = homosapien");
        this.assertIssues("HSP-1");
        this.executeIssueNavigatorURL(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED, true, "jqlQuery=()&#)$&#(*$prject =&^$(&# homosapien", "pid=123123");
        this.executeIssueNavigatorURL(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED, true, "jqlQuery=component = \"New Component 5\" AND project = homosapien", "pid=123123");
        this.executeIssueNavigatorURL(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE, IssueNavigatorNavigation.NavigatorEditMode.SIMPLE, true, "jqlQuery=reporter in membersOf(\"blub\")", "pid=123123");
        this.executeIssueNavigatorURL(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED, true, "jqlQuery=component = \"New Component 2\"", "pid=123123");
        this.assertIssues("HSP-1");
        this.executeIssueNavigatorURL(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE, IssueNavigatorNavigation.NavigatorEditMode.SIMPLE, true, "jqlQuery=component = \"New Component 2\" AND project = homosapien", "pid=123123");
        this.assertIssues("HSP-1");
        this.executeIssueNavigatorURL(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE, IssueNavigatorNavigation.NavigatorEditMode.SIMPLE, true, "pid=10000");
        this.assertIssues("HSP-1");
        this.executeIssueNavigatorURL(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED, true, "pid=123123");
        this.executeIssueNavigatorURL(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED, true, "version=10002");
    }

    public void testIssueNavigatorRetainAdvancedSearch() throws Exception {
        this.executeIssueNavigatorURL(IssueNavigatorNavigation.NavigatorEditMode.ADVANCED, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED, true, "jqlQuery=()&#)$&#(*$prject =&^$(&# homosapien");
        this.executeIssueNavigatorURL(IssueNavigatorNavigation.NavigatorEditMode.ADVANCED, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED, true, "jqlQuery=component = \"New Component 5\" AND project = homosapien");
        this.executeIssueNavigatorURL(IssueNavigatorNavigation.NavigatorEditMode.ADVANCED, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED, true, "jqlQuery=reporter in membersOf(\"blub\")");
        this.executeIssueNavigatorURL(IssueNavigatorNavigation.NavigatorEditMode.ADVANCED, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED, true, "jqlQuery=component = \"New Component 2\"");
        this.assertIssues("HSP-1");
        this.executeIssueNavigatorURL(IssueNavigatorNavigation.NavigatorEditMode.ADVANCED, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED, true, "jqlQuery=component = \"New Component 2\" AND project = homosapien");
        this.assertIssues("HSP-1");
        this.executeIssueNavigatorURL(IssueNavigatorNavigation.NavigatorEditMode.ADVANCED, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED, true, "jqlQuery=()&#)$&#(*$prject =&^$(&# homosapien", "pid=123123");
        this.executeIssueNavigatorURL(IssueNavigatorNavigation.NavigatorEditMode.ADVANCED, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED, true, "jqlQuery=component = \"New Component 5\" AND project = homosapien", "pid=123123");
        this.executeIssueNavigatorURL(IssueNavigatorNavigation.NavigatorEditMode.ADVANCED, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED, true, "jqlQuery=reporter in membersOf(\"blub\")", "pid=123123");
        this.executeIssueNavigatorURL(IssueNavigatorNavigation.NavigatorEditMode.ADVANCED, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED, true, "jqlQuery=component = \"New Component 2\"", "pid=123123");
        this.assertIssues("HSP-1");
        this.executeIssueNavigatorURL(IssueNavigatorNavigation.NavigatorEditMode.ADVANCED, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED, true, "jqlQuery=component = \"New Component 2\" AND project = homosapien", "pid=123123");
        this.assertIssues("HSP-1");
        this.executeIssueNavigatorURL(IssueNavigatorNavigation.NavigatorEditMode.ADVANCED, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED, true, "pid=10000");
        this.assertIssues("HSP-1");
        this.executeIssueNavigatorURL(IssueNavigatorNavigation.NavigatorEditMode.ADVANCED, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED, true, "pid=123123");
        this.executeIssueNavigatorURL(IssueNavigatorNavigation.NavigatorEditMode.ADVANCED, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED, true, "version=10002");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIssueNavigatorSearchRequestViews() throws Exception {
        try {
            this.tester.getDialog().getWebClient().setExceptionsThrownOnErrorStatus(false);
            this.executeIssueNavigatorSearchRequestView(400, "Error in the JQL Query: The character '#' is a reserved JQL character. You must enclose it in a string or use the escape '\\u0023' instead. (line 1, character 4)", "jqlQuery=()&#)$&#(*$prject =&^$(&# homosapien", "pid=123123");
            this.executeIssueNavigatorSearchRequestView(400, "The value 'New Component 5' does not exist for the field 'component'.", "jqlQuery=component = \"New Component 5\" AND project = homosapien", "pid=123123");
            this.executeIssueNavigatorSearchRequestView(400, "Function 'membersOf' can not generate a list of usernames for group 'blub'; the group does not exist.", "jqlQuery=reporter in membersOf(\"blub\")", "pid=123123");
            this.executeIssueNavigatorSearchRequestView(200, "", "jqlQuery=component = \"New Component 2\"", "pid=123123");
            Document doc = XMLUnit.buildControlDocument((String)this.tester.getDialog().getResponse().getText());
            XMLAssert.assertXpathExists((String)"/rss/channel/item[key = 'HSP-1']", (Document)doc);
            this.executeIssueNavigatorSearchRequestView(200, "", "jqlQuery=component = \"New Component 2\" AND project = homosapien", "pid=10001");
            doc = XMLUnit.buildControlDocument((String)this.tester.getDialog().getResponse().getText());
            XMLAssert.assertXpathExists((String)"/rss/channel/item[key = 'HSP-1']", (Document)doc);
        }
        finally {
            this.tester.getDialog().getWebClient().setExceptionsThrownOnErrorStatus(true);
        }
    }

    public void testIssueNavigatorSearchFilter() throws Exception {
        this.executeSearchFilter(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED, 10001);
        this.executeSearchFilter(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE, IssueNavigatorNavigation.NavigatorEditMode.SIMPLE, 10002);
        this.executeSearchFilter(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED, 10003);
        this.assertIssues("HSP-1");
        this.executeSearchFilter(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE, IssueNavigatorNavigation.NavigatorEditMode.SIMPLE, 10004);
        this.assertIssues("HSP-1");
    }

    private void executeSearchFilter(IssueNavigatorNavigation.NavigatorEditMode startEditMode, IssueNavigatorNavigation.NavigatorEditMode expectedEditMode, int filterId) {
        if (this.navigation.issueNavigator().getCurrentEditMode() != startEditMode) {
            this.navigation.issueNavigator().displayAllIssues();
            this.navigation.issueNavigator().gotoEditMode(startEditMode);
            TestIssueNavigatorUrlParameter.assertEquals((Object)((Object)startEditMode), (Object)((Object)this.navigation.issueNavigator().getCurrentEditMode()));
        }
        this.tester.gotoPage("secure/IssueNavigator.jspa?mode=hide&requestId=" + filterId);
        if (this.navigation.issueNavigator().getCurrentEditMode() == null) {
            this.tester.clickLink("editfilter");
        }
        TestIssueNavigatorUrlParameter.assertEquals((Object)((Object)expectedEditMode), (Object)((Object)this.navigation.issueNavigator().getCurrentEditMode()));
    }

    private void executeIssueNavigatorSearchRequestView(int expectedResponseCode, String expectedErrorMessage, String ... urlParameter) throws IOException, SAXException, ParserConfigurationException {
        String encodedQueryString = this.encodeQueryString(urlParameter);
        this.tester.gotoPage("sr/jira.issueviews:searchrequest-xml/temp/SearchRequest.xml?" + encodedQueryString);
        WebResponse response = this.tester.getDialog().getResponse();
        int actualResponseCode = response.getResponseCode();
        TestIssueNavigatorUrlParameter.assertEquals((int)expectedResponseCode, (int)actualResponseCode);
        new HTMLAssertionsImpl().assertResponseContains(this.tester, expectedErrorMessage);
    }

    public void testIssueNavigatorAddParamsParameter() throws Exception {
        this.executeIssueNavigatorURL(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE, IssueNavigatorNavigation.NavigatorEditMode.SIMPLE, false, "pid=10000");
        this.assertIssues("HSP-1");
        this.executeIssueNavigatorURL(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED, false, "pid=123123");
        this.executeIssueNavigatorURL(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED, false, "version=10002");
        this.executeIssueNavigatorURL(IssueNavigatorNavigation.NavigatorEditMode.ADVANCED, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED, false, "pid=10000");
        this.assertIssues("HSP-1");
        this.executeIssueNavigatorURL(IssueNavigatorNavigation.NavigatorEditMode.ADVANCED, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED, false, "pid=123123");
        this.executeIssueNavigatorURL(IssueNavigatorNavigation.NavigatorEditMode.ADVANCED, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED, false, "version=10002");
    }
}

