/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.jira.functest.framework.FuncTestCase;

public class TestCustomFieldsDisabled
extends FuncTestCase {
    protected void tearDownTest() {
        this.administration.enablePlugin("Custom Field Types & Searchers", "JIRA's system custom field types.");
        super.tearDownTest();
    }

    public void testDisable() throws Exception {
        String[] customFields;
        this.administration.restoreData("TestCustomFieldOperators.xml");
        for (String cf : customFields = new String[]{"CSF", "DP", "DT", "FTF", "GP", "II", "MC", "MGP", "MS", "MUP", "NF", "PP", "RB", "ROTF", "SL", "SVP", "TF", "UP", "URL", "VP"}) {
            this.navigation.issueNavigator().createSearch(String.format("%s is not empty", cf));
            this.assertions.getIssueNavigatorAssertions().assertNoJqlErrors();
        }
        this.administration.disablePlugin("Custom Field Types & Searchers", "JIRA's system custom field types.");
        for (String cf : customFields) {
            this.navigation.issueNavigator().createSearch(String.format("%s is not empty", cf));
            this.assertions.getIssueNavigatorAssertions().assertJqlErrors(String.format("Field '%s' does not exist or you do not have permission to view it.", cf));
        }
    }
}

