/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.jira.functest.framework.Splitable;
import com.atlassian.jira.functest.framework.assertions.IssueNavigatorAssertions;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.webtests.ztests.navigator.jql.AbstractJqlFuncTest;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Splitable
public class TestCustomFieldDoesItFitSingle
extends AbstractJqlFuncTest {
    private static final AtomicBoolean dataSetUp = new AtomicBoolean(false);

    @Override
    protected void setUpTest() {
        super.setUpTest();
        if (!dataSetUp.getAndSet(true)) {
            this.administration.restoreData("TestCustomFieldDoesItFitSingle.xml");
        }
    }

    public void testCascadingSelect() throws Exception {
        String customFieldId = "10000";
        String fieldName = "CSF";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("= parent", new Result(new IssueNavigatorAssertions.FilterFormParam[]{TestCustomFieldDoesItFitSingle.createFilterFormParam("customfield_10000", "10000"), TestCustomFieldDoesItFitSingle.createFilterFormParam("customfield_10000:1", "")}));
        matrix.put("= 10000", new Result(new IssueNavigatorAssertions.FilterFormParam[]{TestCustomFieldDoesItFitSingle.createFilterFormParam("customfield_10000", "10000"), TestCustomFieldDoesItFitSingle.createFilterFormParam("customfield_10000:1", "")}));
        matrix.put("= child2", new Result(new IssueNavigatorAssertions.FilterFormParam[]{TestCustomFieldDoesItFitSingle.createFilterFormParam("customfield_10000", "10000"), TestCustomFieldDoesItFitSingle.createFilterFormParam("customfield_10000:1", "10010")}));
        matrix.put("= 10010", new Result(new IssueNavigatorAssertions.FilterFormParam[]{TestCustomFieldDoesItFitSingle.createFilterFormParam("customfield_10000", "10000"), TestCustomFieldDoesItFitSingle.createFilterFormParam("customfield_10000:1", "10010")}));
        matrix.put("= child", Result.tooComplex());
        matrix.put("= 10001", new Result(new IssueNavigatorAssertions.FilterFormParam[]{TestCustomFieldDoesItFitSingle.createFilterFormParam("customfield_10000", "10000"), TestCustomFieldDoesItFitSingle.createFilterFormParam("customfield_10000:1", "10001")}));
        matrix.put("!= parent", Result.tooComplex());
        this.addComplexEmpty(matrix);
        matrix.put("in (parent, child2)", Result.tooComplex());
        matrix.put("not in (parent, child2)", Result.tooComplex());
        LinkedHashMap<String, Result> functionMatrix = new LinkedHashMap<String, Result>();
        functionMatrix.put("in cascadeOption(parent)", new Result(false));
        functionMatrix.put("in cascadeOption(10000)", new Result(new IssueNavigatorAssertions.FilterFormParam[]{TestCustomFieldDoesItFitSingle.createFilterFormParam("customfield_10000", "10000"), TestCustomFieldDoesItFitSingle.createFilterFormParam("customfield_10000:1", "")}));
        functionMatrix.put("in cascadeOption(parent, child2)", new Result(false));
        functionMatrix.put("in cascadeOption(10000, child2)", new Result(new IssueNavigatorAssertions.FilterFormParam[]{TestCustomFieldDoesItFitSingle.createFilterFormParam("customfield_10000", "10000"), TestCustomFieldDoesItFitSingle.createFilterFormParam("customfield_10000:1", "10010")}));
        functionMatrix.put("in cascadeOption(parent, 10010)", new Result(new IssueNavigatorAssertions.FilterFormParam[]{TestCustomFieldDoesItFitSingle.createFilterFormParam("customfield_10000", "10000"), TestCustomFieldDoesItFitSingle.createFilterFormParam("customfield_10000:1", "10010")}));
        functionMatrix.put("in cascadeOption(parent, child)", new Result(false));
        functionMatrix.put("in cascadeOption(parent, 10001)", new Result(new IssueNavigatorAssertions.FilterFormParam[]{TestCustomFieldDoesItFitSingle.createFilterFormParam("customfield_10000", "10000"), TestCustomFieldDoesItFitSingle.createFilterFormParam("customfield_10000:1", "10001")}));
        functionMatrix.put("in cascadeOption(parent, none)", new Result(false));
        functionMatrix.put("in cascadeOption(10000, none)", new Result(false));
        this._testFitnessMatrix("CSF", matrix);
        this._testFitnessMatrix("CSF", functionMatrix);
        this._testFieldDoesntExistWhenNoSearcher("10000", "CSF", matrix);
        this.administration.customFields().removeGlobalContext("10000");
        matrix = new LinkedHashMap();
        matrix.put("= parent", Result.tooComplex());
        matrix.put("= 10030", Result.tooComplex());
        matrix.put("= child2", Result.tooComplex());
        matrix.put("= 10040", Result.tooComplex());
        matrix.put("in cascadeOption(parent)", Result.tooComplex());
        matrix.put("in cascadeOption(10030)", Result.tooComplex());
        matrix.put("in cascadeOption(10030, child2)", Result.tooComplex());
        matrix.put("in cascadeOption(parent, 10039)", Result.tooComplex());
        matrix.put("in cascadeOption(parent, 10040)", Result.tooComplex());
        this._testFitnessMatrix("CSF", matrix);
    }

    public void testDatePicker() throws Exception {
        String customFieldId = "10001";
        String fieldName = "DP";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("= '2009-05-11'", Result.tooComplex());
        matrix.put("!= '2009-05-11'", Result.tooComplex());
        matrix.put("<= '2009-05-11'", new Result(new IssueNavigatorAssertions.FilterFormParam[]{TestCustomFieldDoesItFitSingle.createFilterFormParam("customfield_10001:before", "11/May/09")}));
        matrix.put(">= '2009-05-11'", new Result(new IssueNavigatorAssertions.FilterFormParam[]{TestCustomFieldDoesItFitSingle.createFilterFormParam("customfield_10001:after", "11/May/09")}));
        matrix.put("< '2009-05-11'", Result.tooComplex());
        matrix.put("> '2009-05-11'", Result.tooComplex());
        matrix.put("<= '1d'", new Result(new IssueNavigatorAssertions.FilterFormParam[]{TestCustomFieldDoesItFitSingle.createFilterFormParam("customfield_10001:next", "1d")}));
        matrix.put(">= '1d'", new Result(new IssueNavigatorAssertions.FilterFormParam[]{TestCustomFieldDoesItFitSingle.createFilterFormParam("customfield_10001:previous", "1d")}));
        matrix.put("< '1d'", Result.tooComplex());
        matrix.put("> '1d'", Result.tooComplex());
        matrix.put("in ('2009-05-11', '2009-05-12')", Result.tooComplex());
        matrix.put("not in ('2009-05-11', '2009-05-12')", Result.tooComplex());
        this.addComplexEmpty(matrix);
        this._testFitnessMatrix("DP", matrix);
        this._testFieldDoesntExistWhenNoSearcher("10001", "DP", matrix);
        this._testTooComplexWhenNoGlobalContext("10001", "DP", matrix);
    }

    public void testDateTime() throws Exception {
        String customFieldId = "10002";
        String fieldName = "DT";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("= '2009-05-11 12:00'", Result.tooComplex());
        matrix.put("!= '2009-05-11 12:00'", Result.tooComplex());
        matrix.put("<= '2009-05-11 12:00'", new Result(new IssueNavigatorAssertions.FilterFormParam[]{TestCustomFieldDoesItFitSingle.createFilterFormParam("customfield_10002:before", "11/May/09 12:00 PM")}));
        matrix.put("<= '2009-05-11'", new Result(new IssueNavigatorAssertions.FilterFormParam[]{TestCustomFieldDoesItFitSingle.createFilterFormParam("customfield_10002:before", "11/May/09 12:00 AM")}));
        matrix.put(">= '2009-05-11 12:00'", new Result(new IssueNavigatorAssertions.FilterFormParam[]{TestCustomFieldDoesItFitSingle.createFilterFormParam("customfield_10002:after", "11/May/09 12:00 PM")}));
        matrix.put(">= '2009-05-11'", new Result(new IssueNavigatorAssertions.FilterFormParam[]{TestCustomFieldDoesItFitSingle.createFilterFormParam("customfield_10002:after", "11/May/09 12:00 AM")}));
        matrix.put("< '2009-05-11 12:00'", Result.tooComplex());
        matrix.put("> '2009-05-11 12:00'", Result.tooComplex());
        matrix.put("<= '1d'", new Result(new IssueNavigatorAssertions.FilterFormParam[]{TestCustomFieldDoesItFitSingle.createFilterFormParam("customfield_10002:next", "1d")}));
        matrix.put(">= '1d'", new Result(new IssueNavigatorAssertions.FilterFormParam[]{TestCustomFieldDoesItFitSingle.createFilterFormParam("customfield_10002:previous", "1d")}));
        matrix.put("< '1d'", Result.tooComplex());
        matrix.put("> '1d'", Result.tooComplex());
        matrix.put("in ('2009-05-11', '2009-05-12')", Result.tooComplex());
        matrix.put("not in ('2009-05-11', '2009-05-12')", Result.tooComplex());
        this.addComplexEmpty(matrix);
        this._testFitnessMatrix("DT", matrix);
        this._testFieldDoesntExistWhenNoSearcher("10002", "DT", matrix);
        this._testTooComplexWhenNoGlobalContext("10002", "DT", matrix);
    }

    public void testFreeTextField() throws Exception {
        String customFieldId = "10003";
        String fieldName = "FTF";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("~ something", new Result(new IssueNavigatorAssertions.FilterFormParam[]{TestCustomFieldDoesItFitSingle.createFilterFormParam("customfield_10003", "something")}));
        matrix.put("!~ something", Result.tooComplex());
        this.addComplexEmpty(matrix);
        this._testFitnessMatrix("FTF", matrix);
        this._testFieldDoesntExistWhenNoSearcher("10003", "FTF", matrix);
        this._testTooComplexWhenNoGlobalContext("10003", "FTF", matrix);
    }

    public void testGroupPicker() throws Exception {
        String customFieldId = "10004";
        String fieldName = "GP";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("= 'jira-users'", new Result(new IssueNavigatorAssertions.FilterFormParam[]{TestCustomFieldDoesItFitSingle.createFilterFormParam("customfield_10004", "jira-users")}));
        matrix.put("!= 'jira-users'", Result.tooComplex());
        matrix.put("in ('jira-users', 'jira-administrators')", Result.tooComplex());
        matrix.put("not in ('jira-users', 'jira-administrators')", Result.tooComplex());
        this.addComplexEmpty(matrix);
        this._testFitnessMatrix("GP", matrix);
        this._testFieldDoesntExistWhenNoSearcher("10004", "GP", matrix);
        this._testTooComplexWhenNoGlobalContext("10004", "GP", matrix);
    }

    public void testImportId() throws Exception {
        String customFieldId = "10005";
        String fieldName = "II";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("= 2", new Result(new IssueNavigatorAssertions.FilterFormParam[]{TestCustomFieldDoesItFitSingle.createFilterFormParam("customfield_10005", "2")}));
        matrix.put("!= 2", Result.tooComplex());
        matrix.put("in (2, 4)", Result.tooComplex());
        matrix.put("not in (2, 4)", Result.tooComplex());
        this.addComplexEmpty(matrix);
        matrix.put("< 2", Result.tooComplex());
        matrix.put("<= 2", Result.tooComplex());
        matrix.put("> 2", Result.tooComplex());
        matrix.put(">= 2", Result.tooComplex());
        this._testFitnessMatrix("II", matrix);
        this.administration.customFields().setCustomFieldSearcher("10005", "com.atlassian.jira.plugin.system.customfieldtypes:numberrange");
        matrix = new LinkedHashMap();
        matrix.put("= 2", Result.tooComplex());
        matrix.put("!= 2", Result.tooComplex());
        matrix.put("in (2, 4)", Result.tooComplex());
        matrix.put("not in (2, 4)", Result.tooComplex());
        this.addComplexEmpty(matrix);
        matrix.put("< 2", Result.tooComplex());
        matrix.put("<= 2", new Result(new IssueNavigatorAssertions.FilterFormParam[]{TestCustomFieldDoesItFitSingle.createFilterFormParam("customfield_10005:lessThan", "2")}));
        matrix.put("> 2", Result.tooComplex());
        matrix.put(">= 2", new Result(new IssueNavigatorAssertions.FilterFormParam[]{TestCustomFieldDoesItFitSingle.createFilterFormParam("customfield_10005:greaterThan", "2")}));
        this._testFitnessMatrix("II", matrix);
        this._testFieldDoesntExistWhenNoSearcher("10005", "II", matrix);
        this._testTooComplexWhenNoGlobalContext("10005", "II", matrix);
    }

    public void testMultiCheckbox() throws Exception {
        String customFieldId = "10006";
        String fieldName = "MC";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("= opt1", new Result(new IssueNavigatorAssertions.FilterFormParam[]{TestCustomFieldDoesItFitSingle.createFilterFormParam("customfield_10006", "opt1")}));
        matrix.put("!= opt1", Result.tooComplex());
        matrix.put("in (opt1, opt2)", new Result(new IssueNavigatorAssertions.FilterFormParam[]{TestCustomFieldDoesItFitSingle.createFilterFormParam("customfield_10006", "opt1", "opt2")}));
        matrix.put("not in (opt1, opt2)", Result.tooComplex());
        this.addComplexEmpty(matrix);
        this._testFitnessMatrix("MC", matrix);
        this._testFieldDoesntExistWhenNoSearcher("10006", "MC", matrix);
        this.administration.customFields().removeGlobalContext("10006");
        matrix = new LinkedHashMap();
        matrix.put("= opt3", Result.tooComplex());
        matrix.put("in (opt3, opt4)", Result.tooComplex());
        this.addComplexEmpty(matrix);
        this._testFitnessMatrix("MC", matrix);
    }

    public void testMultiGroupPicker() throws Exception {
        String customFieldId = "10007";
        String fieldName = "MGP";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("= 'jira-users'", new Result(new IssueNavigatorAssertions.FilterFormParam[]{TestCustomFieldDoesItFitSingle.createFilterFormParam("customfield_10007", "jira-users")}));
        matrix.put("!= 'jira-users'", Result.tooComplex());
        matrix.put("in ('jira-users', 'jira-administrators')", Result.tooComplex());
        matrix.put("not in ('jira-users', 'jira-administrators')", Result.tooComplex());
        this.addComplexEmpty(matrix);
        this._testFitnessMatrix("MGP", matrix);
        this._testFieldDoesntExistWhenNoSearcher("10007", "MGP", matrix);
        this._testTooComplexWhenNoGlobalContext("10007", "MGP", matrix);
    }

    public void testMultiSelect() throws Exception {
        String customFieldId = "10008";
        String fieldName = "MS";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("= select1", new Result(new IssueNavigatorAssertions.FilterFormParam[]{TestCustomFieldDoesItFitSingle.createFilterFormParam("customfield_10008", "select1")}));
        matrix.put("!= select1", Result.tooComplex());
        matrix.put("in (select1, select2)", new Result(new IssueNavigatorAssertions.FilterFormParam[]{TestCustomFieldDoesItFitSingle.createFilterFormParam("customfield_10008", "select1", "select2")}));
        matrix.put("not in (select1, select2)", Result.tooComplex());
        this.addComplexEmpty(matrix);
        this._testFitnessMatrix("MS", matrix);
        this._testFieldDoesntExistWhenNoSearcher("10008", "MS", matrix);
        this.administration.customFields().removeGlobalContext("10008");
        matrix = new LinkedHashMap();
        matrix.put("= select3", Result.tooComplex());
        matrix.put("in (select3, select4)", Result.tooComplex());
        this.addComplexEmpty(matrix);
        this._testFitnessMatrix("MS", matrix);
    }

    public void testMultiUserPicker() throws Exception {
        String customFieldId = "10009";
        String fieldName = "MUP";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("= fred", new Result(new IssueNavigatorAssertions.FilterFormParam[]{TestCustomFieldDoesItFitSingle.createFilterFormParam("customfield_10009", "fred")}));
        matrix.put("!= fred", Result.tooComplex());
        this.addComplexEmpty(matrix);
        matrix.put("in (fred, admin)", Result.tooComplex());
        matrix.put("not in (fred, admin)", Result.tooComplex());
        matrix.put("in membersOf('jira-users')", Result.tooComplex());
        matrix.put("= currentUser()", Result.tooComplex());
        this._testFitnessMatrix("MUP", matrix);
        this.administration.customFields().setCustomFieldSearcher("10009", "com.atlassian.jira.plugin.system.customfieldtypes:userpickergroupsearcher");
        matrix = new LinkedHashMap();
        matrix.put("= fred", new Result(new IssueNavigatorAssertions.FilterFormParam[]{TestCustomFieldDoesItFitSingle.createFilterFormParam("customfield_10009", "fred"), TestCustomFieldDoesItFitSingle.createFilterFormParam("customfield_10009Select", "specificuser")}));
        matrix.put("!= fred", Result.tooComplex());
        this.addComplexEmpty(matrix);
        matrix.put("in (fred, admin)", Result.tooComplex());
        matrix.put("not in (fred, admin)", Result.tooComplex());
        matrix.put("in membersOf('jira-users')", new Result(new IssueNavigatorAssertions.FilterFormParam[]{TestCustomFieldDoesItFitSingle.createFilterFormParam("customfield_10009", "jira-users"), TestCustomFieldDoesItFitSingle.createFilterFormParam("customfield_10009Select", "specificgroup")}));
        matrix.put("= currentUser()", new Result(new IssueNavigatorAssertions.FilterFormParam[]{TestCustomFieldDoesItFitSingle.createFilterFormParam("customfield_10009Select", "issue_current_user")}));
        this._testFitnessMatrix("MUP", matrix);
        this._testFieldDoesntExistWhenNoSearcher("10009", "MUP", matrix);
        this._testTooComplexWhenNoGlobalContext("10009", "MUP", matrix);
    }

    public void testNumberField() throws Exception {
        String customFieldId = "10010";
        String fieldName = "NF";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("= 10", new Result(new IssueNavigatorAssertions.FilterFormParam[]{TestCustomFieldDoesItFitSingle.createFilterFormParam("customfield_10010", "10")}));
        matrix.put("!= 10", Result.tooComplex());
        matrix.put("in (10, 20)", Result.tooComplex());
        matrix.put("not in (10, 20)", Result.tooComplex());
        this.addComplexEmpty(matrix);
        matrix.put("< 10", Result.tooComplex());
        matrix.put("<= 10", Result.tooComplex());
        matrix.put("> 10", Result.tooComplex());
        matrix.put(">= 10", Result.tooComplex());
        this._testFitnessMatrix("NF", matrix);
        this.administration.customFields().setCustomFieldSearcher("10010", "com.atlassian.jira.plugin.system.customfieldtypes:numberrange");
        matrix = new LinkedHashMap();
        matrix.put("= 10", Result.tooComplex());
        matrix.put("!= 10", Result.tooComplex());
        matrix.put("in (10, 20)", Result.tooComplex());
        matrix.put("not in (10, 20)", Result.tooComplex());
        this.addComplexEmpty(matrix);
        matrix.put("< 10", Result.tooComplex());
        matrix.put("<= 10", new Result(new IssueNavigatorAssertions.FilterFormParam[]{TestCustomFieldDoesItFitSingle.createFilterFormParam("customfield_10010:lessThan", "10")}));
        matrix.put("> 10", Result.tooComplex());
        matrix.put(">= 10", new Result(new IssueNavigatorAssertions.FilterFormParam[]{TestCustomFieldDoesItFitSingle.createFilterFormParam("customfield_10010:greaterThan", "10")}));
        this._testFitnessMatrix("NF", matrix);
        this._testFieldDoesntExistWhenNoSearcher("10010", "NF", matrix);
        this._testTooComplexWhenNoGlobalContext("10010", "NF", matrix);
    }

    public void testProjectPicker() throws Exception {
        String customFieldId = "10011";
        String fieldName = "PP";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("= three", new Result(new IssueNavigatorAssertions.FilterFormParam[]{TestCustomFieldDoesItFitSingle.createFilterFormParam("customfield_10011", "10012")}));
        matrix.put("!= three", Result.tooComplex());
        matrix.put("in (three, four)", Result.tooComplex());
        matrix.put("not in (three, four)", Result.tooComplex());
        this.addComplexEmpty(matrix);
        this._testFitnessMatrix("PP", matrix);
        this._testFieldDoesntExistWhenNoSearcher("10011", "PP", matrix);
        this._testTooComplexWhenNoGlobalContext("10011", "PP", matrix);
    }

    public void testRadioButton() throws Exception {
        String customFieldId = "10012";
        String fieldName = "RB";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("= rad1", new Result(new IssueNavigatorAssertions.FilterFormParam[]{TestCustomFieldDoesItFitSingle.createFilterFormParam("customfield_10012", "rad1")}));
        matrix.put("!= rad1", Result.tooComplex());
        matrix.put("in (rad1, rad2)", Result.tooComplex());
        matrix.put("not in (rad1, rad2)", Result.tooComplex());
        this.addComplexEmpty(matrix);
        this._testFitnessMatrix("RB", matrix);
        this._testFieldDoesntExistWhenNoSearcher("10012", "RB", matrix);
        this.administration.customFields().removeGlobalContext("10012");
        matrix = new LinkedHashMap();
        matrix.put("= rad3", Result.tooComplex());
        matrix.put("in (rad3, rad4)", Result.tooComplex());
        this.addComplexEmpty(matrix);
        this._testFitnessMatrix("RB", matrix);
    }

    public void testReadOnlyTextField() throws Exception {
        String customFieldId = "10013";
        String fieldName = "ROTF";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("~ something", new Result(new IssueNavigatorAssertions.FilterFormParam[]{TestCustomFieldDoesItFitSingle.createFilterFormParam("customfield_10013", "something")}));
        matrix.put("!~ something", Result.tooComplex());
        this.addComplexEmpty(matrix);
        this._testFitnessMatrix("ROTF", matrix);
        this._testFieldDoesntExistWhenNoSearcher("10013", "ROTF", matrix);
        this._testTooComplexWhenNoGlobalContext("10013", "ROTF", matrix);
    }

    public void testSelectList() throws Exception {
        String customFieldId = "10014";
        String fieldName = "SL";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("= select1", new Result(new IssueNavigatorAssertions.FilterFormParam[]{TestCustomFieldDoesItFitSingle.createFilterFormParam("customfield_10014", "select1")}));
        matrix.put("!= select1", Result.tooComplex());
        matrix.put("in (select1, select2)", Result.tooComplex());
        matrix.put("not in (select1, select2)", Result.tooComplex());
        this.addComplexEmpty(matrix);
        this._testFitnessMatrix("SL", matrix);
        this._testFieldDoesntExistWhenNoSearcher("10014", "SL", matrix);
        this.administration.customFields().removeGlobalContext("10014");
        matrix = new LinkedHashMap();
        matrix.put("= select3", Result.tooComplex());
        matrix.put("in (select3, select4)", Result.tooComplex());
        this.addComplexEmpty(matrix);
        this._testFitnessMatrix("SL", matrix);
    }

    public void testSingleVersionPicker() throws Exception {
        String fieldName = "SVP";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("= v1", Result.tooComplex());
        matrix.put("!= v1", Result.tooComplex());
        this.addComplexRelational(matrix, "v1");
        this.addComplexEmpty(matrix);
        matrix.put("in (v1, v2)", Result.tooComplex());
        matrix.put("not in (v1, v2)", Result.tooComplex());
        matrix.put("in releasedVersions(SIXTEEN)", Result.tooComplex());
        matrix.put("not in releasedVersions(SIXTEEN)", Result.tooComplex());
        matrix.put("in unreleasedVersions(SIXTEEN)", Result.tooComplex());
        matrix.put("not in unreleasedVersions(SIXTEEN)", Result.tooComplex());
        matrix.put("= 10020 and project = HSP", Result.tooComplex());
        this._testFitnessMatrix("SVP", matrix);
    }

    public void testTextField() throws Exception {
        String customFieldId = "10016";
        String fieldName = "TF";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("~ something", new Result(new IssueNavigatorAssertions.FilterFormParam[]{TestCustomFieldDoesItFitSingle.createFilterFormParam("customfield_10016", "something")}));
        matrix.put("!~ something", Result.tooComplex());
        this.addComplexEmpty(matrix);
        this._testFitnessMatrix("TF", matrix);
        this._testFieldDoesntExistWhenNoSearcher("10016", "TF", matrix);
        this._testTooComplexWhenNoGlobalContext("10016", "TF", matrix);
    }

    public void testUrlField() throws Exception {
        String customFieldId = "10017";
        String fieldName = "URL";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("= 'http://www.atlassian.com'", new Result(new IssueNavigatorAssertions.FilterFormParam[]{TestCustomFieldDoesItFitSingle.createFilterFormParam("customfield_10017", "http://www.atlassian.com")}));
        matrix.put("!= 'http://www.atlassian.com'", Result.tooComplex());
        matrix.put("in ('http://www.atlassian.com', 'http://www.jira.com')", Result.tooComplex());
        matrix.put("not in ('http://www.atlassian.com', 'http://www.jira.com')", Result.tooComplex());
        this.addComplexEmpty(matrix);
        this._testFitnessMatrix("URL", matrix);
        this._testFieldDoesntExistWhenNoSearcher("10017", "URL", matrix);
        this._testTooComplexWhenNoGlobalContext("10017", "URL", matrix);
    }

    public void testUserPicker() throws Exception {
        String customFieldId = "10018";
        String fieldName = "UP";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("= fred", new Result(new IssueNavigatorAssertions.FilterFormParam[]{TestCustomFieldDoesItFitSingle.createFilterFormParam("customfield_10018", "fred")}));
        matrix.put("!= fred", Result.tooComplex());
        this.addComplexEmpty(matrix);
        matrix.put("in (fred, admin)", Result.tooComplex());
        matrix.put("not in (fred, admin)", Result.tooComplex());
        matrix.put("in membersOf('jira-users')", Result.tooComplex());
        matrix.put("= currentUser()", Result.tooComplex());
        this._testFitnessMatrix("UP", matrix);
        this.administration.customFields().setCustomFieldSearcher("10018", "com.atlassian.jira.plugin.system.customfieldtypes:userpickergroupsearcher");
        matrix = new LinkedHashMap();
        matrix.put("= fred", new Result(new IssueNavigatorAssertions.FilterFormParam[]{TestCustomFieldDoesItFitSingle.createFilterFormParam("customfield_10018", "fred"), TestCustomFieldDoesItFitSingle.createFilterFormParam("customfield_10018Select", "specificuser")}));
        matrix.put("!= fred", Result.tooComplex());
        this.addComplexEmpty(matrix);
        matrix.put("in (fred, admin)", Result.tooComplex());
        matrix.put("not in (fred, admin)", Result.tooComplex());
        matrix.put("in membersOf('jira-users')", new Result(new IssueNavigatorAssertions.FilterFormParam[]{TestCustomFieldDoesItFitSingle.createFilterFormParam("customfield_10018", "jira-users"), TestCustomFieldDoesItFitSingle.createFilterFormParam("customfield_10018Select", "specificgroup")}));
        matrix.put("= currentUser()", new Result(new IssueNavigatorAssertions.FilterFormParam[]{TestCustomFieldDoesItFitSingle.createFilterFormParam("customfield_10018Select", "issue_current_user")}));
        this._testFitnessMatrix("UP", matrix);
        this._testFieldDoesntExistWhenNoSearcher("10018", "UP", matrix);
        this._testTooComplexWhenNoGlobalContext("10018", "UP", matrix);
    }

    public void testVersionPicker() throws Exception {
        String fieldName = "VP";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("= v1", Result.tooComplex());
        matrix.put("!= v1", Result.tooComplex());
        this.addComplexRelational(matrix, "v1");
        this.addComplexEmpty(matrix);
        matrix.put("in (v1, v2)", Result.tooComplex());
        matrix.put("not in (v1, v2)", Result.tooComplex());
        matrix.put("in releasedVersions(SIXTEEN)", Result.tooComplex());
        matrix.put("not in releasedVersions(SIXTEEN)", Result.tooComplex());
        matrix.put("in unreleasedVersions(SIXTEEN)", Result.tooComplex());
        matrix.put("not in unreleasedVersions(SIXTEEN)", Result.tooComplex());
        this._testFitnessMatrix("VP", matrix);
    }

    private void _testFitnessMatrix(String fieldName, Map<String, Result> matrix) {
        for (Map.Entry<String, Result> entry : matrix.entrySet()) {
            String jqlQuery = String.format("%s %s", fieldName, entry.getKey());
            Result result = entry.getValue();
            if (result.isTooComplex) {
                this.assertTooComplex(jqlQuery);
                continue;
            }
            if (result.expectedFormData != null) {
                this.assertFitsFilterForm(jqlQuery, result.expectedFormData);
                continue;
            }
            this.assertFitsFilterForm(jqlQuery, new IssueNavigatorAssertions.FilterFormParam[0]);
        }
    }

    private void _testTooComplexWhenNoGlobalContext(String customFieldId, String fieldName, Map<String, Result> matrix) {
        this.administration.customFields().removeGlobalContext(customFieldId);
        for (Map.Entry<String, Result> entry : matrix.entrySet()) {
            String jqlQuery = String.format("%s %s", fieldName, entry.getKey());
            Result result = entry.getValue();
            if (result.isTooComplex) continue;
            this.assertTooComplex(jqlQuery);
        }
    }

    private void _testFieldDoesntExistWhenNoSearcher(String customFieldId, String fieldName, Map<String, Result> matrix) {
        String searcherId = this.administration.customFields().setCustomFieldSearcher(customFieldId, null);
        for (Map.Entry<String, Result> entry : matrix.entrySet()) {
            String jqlQuery = String.format("%s %s", fieldName, entry.getKey());
            Result result = entry.getValue();
            if (result.isTooComplex) continue;
            this.assertFieldDoesntExist(jqlQuery, fieldName);
        }
        this.administration.customFields().setCustomFieldSearcher(customFieldId, searcherId);
    }

    private void assertFieldDoesntExist(String jqlQuery, String fieldName) {
        this.navigation.issueNavigator().createSearch(jqlQuery);
        String errorMsg = String.format("Field '%s' is not searchable, it is only sortable.", fieldName);
        this.assertions.getTextAssertions().assertTextPresent(new WebPageLocator(this.tester), errorMsg);
    }

    private void addComplexRelational(Map<String, Result> matrix, String lit) {
        matrix.put("< " + lit, Result.tooComplex());
        matrix.put("<= " + lit, Result.tooComplex());
        matrix.put("> " + lit, Result.tooComplex());
        matrix.put(">= " + lit, Result.tooComplex());
    }

    private void addComplexEmpty(Map<String, Result> matrix) {
        matrix.put("is EMPTY", Result.tooComplex());
        matrix.put("is not EMPTY", Result.tooComplex());
    }

    private static class Result {
        private IssueNavigatorAssertions.FilterFormParam[] expectedFormData;
        private boolean isTooComplex;

        private static Result tooComplex() {
            Result result = new Result();
            result.isTooComplex = true;
            return result;
        }

        private Result() {
            this.expectedFormData = null;
            this.isTooComplex = true;
        }

        private Result(boolean tooComplex) {
            this.expectedFormData = null;
            this.isTooComplex = false;
        }

        private Result(IssueNavigatorAssertions.FilterFormParam ... expectedFormData) {
            this.expectedFormData = expectedFormData;
            this.isTooComplex = false;
        }
    }
}

