/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestContextFieldValues
extends FuncTestCase {
    private static final String FIELD_FIXFOR = "fixfor";
    private static final String FIELD_AFFECTS = "version";
    private static final String FIELD_COMPONENT = "component";
    private static final String FIELD_STATUS = "status";
    private static final String CF_CASCADINGSELECT = "customfield_10022";
    private static final String CF_SINGLEVERSION = "customfield_10039";
    private static final String CF_MULTIPLEVERSION = "customfield_10021";
    private static final String CF_DATE = "customfield_10032:after";
    private static final String CF_DATE_TIME = "customfield_10023:after";
    private static final String CF_FREE_TEXT = "customfield_10033";
    private static final String CF_GROUP_PICKER = "customfield_10024";
    private static final String CF_IMPORT_ID = "customfield_10034";
    private static final String CF_MULTI_GROUP = "customfield_10035";
    private static final String CF_MULTI_USER = "customfield_10036";
    private static final String CF_NUMBER = "customfield_10027";
    private static final String CF_READ_TEXT = "customfield_10038";
    private static final String CF_TEXT = "customfield_10030";
    private static final String CF_URL = "customfield_10040";
    private static final String CF_USER_SELECT = "customfield_10031";
    private static final String CF_MULTI_CHECK = "customfield_10025";
    private static final String CF_MULTI_SELECT = "customfield_10026";
    private static final String CF_PROJECT_PICKER = "customfield_10037";
    private static final String CF_SELECT_LIST = "customfield_10029";
    private static final String CF_RADIO = "customfield_10028";

    @Override
    protected void setUpTest() {
        this.administration.restoreData("TestJqlContextValues.xml");
    }

    public void testFieldValues() throws Exception {
        AssertionOptions options = new AssertionOptions();
        options.addStatuses(new String[]{"Open", "In Progress", "Reopened", "Resolved", "Closed", "OneStatus", "TwoStatus"});
        options.addDefaultProjectPickerOptions();
        options.addOptions("Global").setVisibility(true);
        this.assertNavigatorState("", options);
        AssertionOptions template = new AssertionOptions();
        template.addUnreleasedVersions(new String[]{"Version11"});
        template.addComponents(new String[]{"Component11", "Component12", "Component13"});
        options = new AssertionOptions(template);
        options.addStatuses(new String[]{"Open", "In Progress", "Reopened", "Resolved", "Closed", "OneStatus"});
        this.assertNavigatorState("project = one", options);
        this.assertNavigatorState("project = one and type in (task, onetype)", options);
        options = new AssertionOptions(template).addStatuses(new String[]{"Open", "In Progress", "Reopened", "Resolved", "Closed"});
        this.assertNavigatorState("project = one and issuetype = task", options);
        options = new AssertionOptions(template).addStatuses(new String[]{"Open", "OneStatus"});
        options.setVisibility(true).addOptions("One");
        options.addDefaultProjectPickerOptions();
        this.assertNavigatorState("project = one and issuetype = oneTYPE", options);
        options = new AssertionOptions();
        options.addComponents(new String[]{"Component21"});
        options.addReleasedVersions(new String[]{"Version21"}).addUnreleasedVersions(new String[]{"Version23", "Version22"});
        options.addStatuses(new String[]{"Open", "TwoStatus"});
        options.addDefaultProjectPickerOptions();
        options.addOptions("Two").setVisibility(true);
        this.assertNavigatorState("project = two", options);
        this.assertNavigatorState("project = two and issuetype = twotype", options);
        this.assertNavigatorState("project = two and issuetype = task", options);
        this.assertNavigatorState("project = two and issuetype in (twotype, task)", options);
        options = new AssertionOptions();
        options.addUnreleasedVersions(new String[]{"Version31"});
        options.addComponents(new String[]{"Component31"});
        options.addStatuses(new String[]{"Open", "In Progress", "Reopened", "Resolved", "Closed"});
        options.addDefaultProjectPickerOptions();
        options.setVisibility(true).addOptions("Global");
        this.assertNavigatorState("project = three", options);
        this.assertNavigatorState("project = three and type = bug", options);
        this.assertNavigatorState("project = three and type in (bug, task, improvement)", options);
        options = new AssertionOptions().addStatuses(new String[]{"Open", "In Progress", "Reopened", "Resolved", "Closed", "OneStatus", "TwoStatus"});
        this.assertNavigatorState("project in (one, two)", options);
        this.assertNavigatorState("issuetype in (onetype, twotype) and project in (one, two)", options);
        this.assertNavigatorState("issuetype in (onetype, twotype, task) and project in (one, two)", options);
        this.assertNavigatorState("project in (one, two) and issuetype = onetype", new AssertionOptions().addStatuses(new String[]{"Open", "OneStatus", "TwoStatus"}));
        options = new AssertionOptions().addStatuses(new String[]{"Open", "In Progress", "Reopened", "Resolved", "Closed", "TwoStatus"});
        this.assertNavigatorState("project in (one, two) and issuetype = twotype", options);
        this.assertNavigatorState("project in (one, two) and issuetype = task", options);
        options = new AssertionOptions().addStatuses(new String[]{"Open", "In Progress", "Reopened", "Resolved", "Closed", "OneStatus"});
        this.assertNavigatorState("project in (one, three)", options);
        this.assertNavigatorState("issuetype in (onetype, twotype) and project in (one, three)", options);
        this.assertNavigatorState("issuetype in (onetype, twotype, task) and project in (one, three)", options);
        this.assertNavigatorState("project in (three, one) and issuetype in (onetype, twotype, task)", options);
        this.assertNavigatorState("project in (one, three) and issuetype = task", new AssertionOptions().addStatuses(new String[]{"Open", "In Progress", "Reopened", "Resolved", "Closed"}));
        options = new AssertionOptions().addStatuses(new String[]{"Open", "In Progress", "Reopened", "Resolved", "Closed", "TwoStatus"});
        this.assertNavigatorState("project in (two, three)", options);
        this.assertNavigatorState("issuetype in (onetype, twotype) and project in (two, three)", options);
        this.assertNavigatorState("issuetype in (onetype, twotype, task) and project in (two, three)", options);
        this.assertNavigatorState("project in (three, two) and issuetype in (onetype, twotype, task)", options);
        this.assertNavigatorState("project in (two, three) and issuetype = task", options);
        options = new AssertionOptions().addStatuses(new String[]{"Open", "In Progress", "Reopened", "Resolved", "Closed", "OneStatus", "TwoStatus"});
        this.assertNavigatorState("project in (one, two, three)", options);
        this.assertNavigatorState("project in (one, two, three) and issuetype = onetype", options);
        this.assertNavigatorState("project in (one, two, three) and issuetype in (onetype, twotype)", options);
        options = new AssertionOptions().addStatuses(new String[]{"Open", "In Progress", "Reopened", "Resolved", "Closed", "TwoStatus"});
        this.assertNavigatorState("project in (one, two, three) and issuetype = twotype", options);
        this.assertNavigatorState("project in (one, two, three) and issuetype in (improvement, 'new feature', twotype)", options);
        options = new AssertionOptions().addStatuses(new String[]{"Open", "In Progress", "Reopened", "Resolved", "Closed", "TwoStatus"});
        this.assertNavigatorState("project in (one, two, three) and issuetype = twotype", options);
        this.assertNavigatorState("project in (one, two, three) and issuetype in (improvement, 'new feature', twotype)", options);
        options = new AssertionOptions();
        options.addDefaultProjectPickerOptions();
        options.addOptions("Global").setVisibility(true);
        options.addStatuses(new String[]{"Open", "In Progress", "Reopened", "Resolved", "Closed", "OneStatus", "TwoStatus"});
        this.assertNavigatorState("issuetype = onetype", options);
        this.assertNavigatorState("issuetype = twotype", options);
        this.assertNavigatorState("issuetype in (twotype, onetype)", options);
        this.assertNavigatorState("issuetype in (twotype, onetype, task)", options);
    }

    private void assertNavigatorState(String jqlQuery, AssertionOptions options) {
        this.log("Asserting naviagator state for: '" + jqlQuery + "'.");
        this.navigation.issueNavigator().createSearch(jqlQuery);
        this.navigation.issueNavigator().gotoEditMode(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        TestContextFieldValues.assertEquals((Object)((Object)IssueNavigatorNavigation.NavigatorEditMode.SIMPLE), (Object)((Object)this.navigation.issueNavigator().getCurrentEditMode()));
        this.assertNavigatorState(options);
    }

    private void assertNavigatorState(AssertionOptions options) {
        this.assertOptions(FIELD_FIXFOR, options.getFixForVersionsOptions());
        this.assertOptions(FIELD_AFFECTS, options.getAffectsVersionsOptions());
        this.assertOptions(FIELD_COMPONENT, options.getComponentOptions());
        this.assertOptions(FIELD_STATUS, options.getStatusOptions());
        List customFieldOptions = options.getCustomFieldOptions();
        this.assertOptions(CF_SINGLEVERSION, customFieldOptions);
        this.assertOptions(CF_MULTIPLEVERSION, customFieldOptions);
        this.assertOptions(CF_CASCADINGSELECT, options.getCascadingSelectOptions());
        this.assertValues(CF_MULTI_CHECK, options.getMultiCheckOptions());
        this.assertOptions(CF_MULTI_SELECT, options.getMultiSelectOptions());
        this.assertOptions(CF_PROJECT_PICKER, options.getProjectPickerOptions());
        this.assertOptions(CF_SELECT_LIST, options.getSelectListOptions());
        this.assertValues(CF_RADIO, options.getRadioOptions());
        this.assertVisibility(CF_DATE, options.isDateCfVisible());
        this.assertVisibility(CF_DATE_TIME, options.isDateTimeCfVisible());
        this.assertVisibility(CF_FREE_TEXT, options.isFreeTextCfVisible());
        this.assertVisibility(CF_IMPORT_ID, options.isImportIdCfVisible());
        this.assertVisibility(CF_GROUP_PICKER, options.isGoupCfVisible());
        this.assertVisibility(CF_MULTI_GROUP, options.isMultiGroupCfVisible());
        this.assertVisibility(CF_MULTI_USER, options.isMultiUserPickerCfVisible());
        this.assertVisibility(CF_NUMBER, options.isNumberCfVisible());
        this.assertVisibility(CF_READ_TEXT, options.isReadCfVisible());
        this.assertVisibility(CF_TEXT, options.isTextCfVisible());
        this.assertVisibility(CF_URL, options.isUrlCfVisible());
        this.assertVisibility(CF_USER_SELECT, options.isUserSelectCfVisible());
    }

    private void assertVisibility(String fieldName, boolean visible) {
        if (visible) {
            this.tester.assertFormElementPresent(fieldName);
        } else {
            this.tester.assertFormElementNotPresent(fieldName);
        }
    }

    private void assertOptions(String fieldName, List<String> options) {
        this.log("Checking that field '" + fieldName + "' has options: " + options);
        if (options.isEmpty()) {
            this.tester.assertFormElementNotPresent(fieldName);
        } else {
            this.tester.assertFormElementPresent(fieldName);
            this.tester.assertOptionsEqual(fieldName, options.toArray(new String[options.size()]));
        }
    }

    private void assertValues(String fieldName, List<String> values) {
        this.log("Checking that field '" + fieldName + "' has values: " + values);
        if (values.isEmpty()) {
            this.tester.assertFormElementNotPresent(fieldName);
        } else {
            this.tester.assertFormElementPresent(fieldName);
            this.tester.assertOptionValuesEqual(fieldName, values.toArray(new String[values.size()]));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AssertionOptions {
        private List<String> releasedVersions;
        private List<String> unlreasedVersions;
        private List<String> components;
        private List<String> status;
        private List<String> cascaingSelect;
        private List<String> multiCheck;
        private List<String> multiSelect;
        private List<String> projectPicker;
        private List<String> selectList;
        private List<String> radioList;
        private boolean dateCf;
        private boolean dateTimeCf;
        private boolean freeTextCf;
        private boolean importIdCf;
        private boolean groupPickerCf;
        private boolean multiGroupPickerCf;
        private boolean multiUserPickerCf;
        private boolean numberCf;
        private boolean readCf;
        private boolean textCf;
        private boolean urlCf;
        private boolean userSelectCf;

        private AssertionOptions(AssertionOptions copy) {
            this.releasedVersions = new ArrayList<String>(copy.releasedVersions);
            this.unlreasedVersions = new ArrayList<String>(copy.unlreasedVersions);
            this.components = new ArrayList<String>(copy.components);
            this.status = new ArrayList<String>(copy.status);
            this.cascaingSelect = new ArrayList<String>(copy.status);
            this.multiCheck = new ArrayList<String>(copy.multiCheck);
            this.multiSelect = new ArrayList<String>(copy.multiSelect);
            this.projectPicker = new ArrayList<String>(copy.projectPicker);
            this.selectList = new ArrayList<String>(copy.selectList);
            this.radioList = new ArrayList<String>(copy.radioList);
            this.dateTimeCf = copy.dateTimeCf;
            this.dateCf = copy.dateCf;
            this.freeTextCf = copy.dateCf;
            this.importIdCf = copy.importIdCf;
            this.groupPickerCf = copy.groupPickerCf;
            this.multiGroupPickerCf = copy.multiGroupPickerCf;
            this.multiUserPickerCf = copy.multiUserPickerCf;
            this.numberCf = copy.numberCf;
            this.readCf = copy.readCf;
            this.textCf = copy.textCf;
            this.urlCf = copy.urlCf;
            this.userSelectCf = copy.userSelectCf;
        }

        private AssertionOptions() {
            this.releasedVersions = new ArrayList<String>();
            this.unlreasedVersions = new ArrayList<String>();
            this.components = new ArrayList<String>();
            this.status = new ArrayList<String>();
            this.cascaingSelect = new ArrayList<String>();
            this.multiCheck = new ArrayList<String>();
            this.multiSelect = new ArrayList<String>();
            this.projectPicker = new ArrayList<String>();
            this.selectList = new ArrayList<String>();
            this.radioList = new ArrayList<String>();
            this.dateTimeCf = false;
            this.dateCf = false;
            this.freeTextCf = false;
            this.importIdCf = true;
            this.groupPickerCf = false;
            this.multiGroupPickerCf = false;
            this.multiUserPickerCf = false;
            this.numberCf = false;
            this.readCf = true;
            this.textCf = false;
            this.urlCf = false;
            this.userSelectCf = false;
        }

        public AssertionOptions setVisibility(boolean visible) {
            this.setDateCfVisible(visible);
            this.setDateTimeCfVisible(visible);
            this.setFreeTextCfVisible(visible);
            this.setGroupCfVisible(visible);
            this.setMultiUserCfVisible(visible);
            this.setMultiGroupCfVisible(visible);
            this.setNumberCfVisible(visible);
            this.setTextCf(visible);
            this.setUrlCfVisible(visible);
            this.setUserSelectCfVisible(visible);
            return this;
        }

        public AssertionOptions addOptions(String ... options) {
            this.addCascaingSelectOptions(options);
            this.addMultiCheckOptions(options);
            this.addMultiSelectOptions(options);
            this.addSelectListOptions(options);
            this.addRadioOptions(options);
            return this;
        }

        public boolean isUrlCfVisible() {
            return this.urlCf;
        }

        public AssertionOptions setUrlCfVisible(boolean urlCf) {
            this.urlCf = urlCf;
            return this;
        }

        public boolean isUserSelectCfVisible() {
            return this.userSelectCf;
        }

        public AssertionOptions setUserSelectCfVisible(boolean userSelectCf) {
            this.userSelectCf = userSelectCf;
            return this;
        }

        public boolean isTextCfVisible() {
            return this.textCf;
        }

        public AssertionOptions setTextCf(boolean textCf) {
            this.textCf = textCf;
            return this;
        }

        public boolean isReadCfVisible() {
            return this.readCf;
        }

        private AssertionOptions addRadioOptions(String ... options) {
            this.radioList.addAll(Arrays.asList(options));
            return this;
        }

        private List<String> getRadioOptions() {
            return this.createOptionsList(this.radioList, "-1");
        }

        private AssertionOptions addSelectListOptions(String ... options) {
            this.selectList.addAll(Arrays.asList(options));
            return this;
        }

        private List<String> getSelectListOptions() {
            return this.createOptionsList(this.selectList, "Any");
        }

        private AssertionOptions addDefaultProjectPickerOptions() {
            return this.addProjectPickerOptions("One", "Three", "Two");
        }

        private AssertionOptions addProjectPickerOptions(String ... options) {
            this.projectPicker.addAll(Arrays.asList(options));
            return this;
        }

        private List<String> getProjectPickerOptions() {
            return this.createOptionsList(this.projectPicker, "None");
        }

        private AssertionOptions addMultiSelectOptions(String ... options) {
            this.multiSelect.addAll(Arrays.asList(options));
            return this;
        }

        private List<String> getMultiSelectOptions() {
            return this.createOptionsList(this.multiSelect, "Any");
        }

        private AssertionOptions addMultiCheckOptions(String ... options) {
            this.multiCheck.addAll(Arrays.asList(options));
            return this;
        }

        private List<String> getMultiCheckOptions() {
            return this.multiCheck;
        }

        private AssertionOptions addCascaingSelectOptions(String ... options) {
            this.cascaingSelect.addAll(Arrays.asList(options));
            return this;
        }

        private List<String> getCascadingSelectOptions() {
            return this.createOptionsList(this.cascaingSelect, "Please select...", "Any");
        }

        private List<String> createOptionsList(List<String> options, String ... extras) {
            if (options.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<String> newOptions = new ArrayList<String>();
            newOptions.addAll(Arrays.asList(extras));
            newOptions.addAll(options);
            return newOptions;
        }

        private boolean isDateCfVisible() {
            return this.dateCf;
        }

        private AssertionOptions setDateCfVisible(boolean visible) {
            this.dateCf = visible;
            return this;
        }

        private boolean isFreeTextCfVisible() {
            return this.freeTextCf;
        }

        private AssertionOptions setFreeTextCfVisible(boolean visible) {
            this.freeTextCf = visible;
            return this;
        }

        private boolean isDateTimeCfVisible() {
            return this.dateTimeCf;
        }

        private AssertionOptions setDateTimeCfVisible(boolean visible) {
            this.dateTimeCf = visible;
            return this;
        }

        private boolean isGoupCfVisible() {
            return this.groupPickerCf;
        }

        private AssertionOptions setGroupCfVisible(boolean visible) {
            this.groupPickerCf = visible;
            return this;
        }

        private boolean isMultiGroupCfVisible() {
            return this.multiGroupPickerCf;
        }

        private AssertionOptions setMultiGroupCfVisible(boolean visible) {
            this.multiGroupPickerCf = visible;
            return this;
        }

        private AssertionOptions setMultiUserCfVisible(boolean visible) {
            this.multiUserPickerCf = visible;
            return this;
        }

        private boolean isMultiUserPickerCfVisible() {
            return this.multiUserPickerCf;
        }

        private boolean isImportIdCfVisible() {
            return this.importIdCf;
        }

        private boolean isNumberCfVisible() {
            return this.numberCf;
        }

        private AssertionOptions setNumberCfVisible(boolean visible) {
            this.numberCf = visible;
            return this;
        }

        private AssertionOptions addStatuses(String ... statuses) {
            this.status.addAll(Arrays.asList(statuses));
            return this;
        }

        private List<String> getStatusOptions() {
            if (this.status.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<String> statusOptions = new ArrayList<String>();
            statusOptions.add("Any");
            statusOptions.addAll(this.status);
            return statusOptions;
        }

        private AssertionOptions addComponents(String ... components) {
            this.components.addAll(Arrays.asList(components));
            return this;
        }

        private List<String> getComponentOptions() {
            if (this.components.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<String> customFieldOptions = new ArrayList<String>();
            customFieldOptions.add("Any");
            customFieldOptions.add("No Component");
            customFieldOptions.addAll(this.components);
            return customFieldOptions;
        }

        private AssertionOptions addReleasedVersions(String ... versions) {
            this.releasedVersions.addAll(Arrays.asList(versions));
            return this;
        }

        private AssertionOptions addUnreleasedVersions(String ... versions) {
            this.unlreasedVersions.addAll(Arrays.asList(versions));
            return this;
        }

        private List<String> getCustomFieldOptions() {
            if (this.releasedVersions.isEmpty() && this.unlreasedVersions.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<String> customFieldOptions = new ArrayList<String>();
            customFieldOptions.add("Unknown");
            customFieldOptions.addAll(this.releasedVersions);
            customFieldOptions.addAll(this.unlreasedVersions);
            return customFieldOptions;
        }

        private List<String> getFixForVersionsOptions() {
            if (this.releasedVersions.isEmpty() && this.unlreasedVersions.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<String> fixFor = new ArrayList<String>();
            fixFor.add("Any");
            fixFor.add("No Version");
            if (!this.unlreasedVersions.isEmpty()) {
                fixFor.add("Unreleased Versions");
                fixFor.addAll(this.unlreasedVersions);
            }
            if (!this.releasedVersions.isEmpty()) {
                fixFor.add("Released Versions");
                fixFor.addAll(this.releasedVersions);
            }
            return fixFor;
        }

        private List<String> getAffectsVersionsOptions() {
            if (this.releasedVersions.isEmpty() && this.unlreasedVersions.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<String> affects = new ArrayList<String>();
            affects.add("Any");
            affects.add("No Version");
            if (!this.releasedVersions.isEmpty()) {
                affects.add("Released Versions");
                affects.addAll(this.releasedVersions);
            }
            if (!this.unlreasedVersions.isEmpty()) {
                affects.add("Unreleased Versions");
                affects.addAll(this.unlreasedVersions);
            }
            return affects;
        }
    }
}

