/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator;

import com.atlassian.jira.webtests.JIRAWebTest;
import com.meterware.httpunit.WebResponse;

public class TestSearchXmlViewErrors
extends JIRAWebTest {
    private static final String SAMPLE_PATH_MESSAGE_1 = "Invalid path format.";
    private static final String SAMPLE_PATH_MESSAGE_2 = "Path should be of format";
    private static final String SAMPLE_PATH_MESSAGE_3 = "/sr/jira.issueviews:searchrequest-xml/10010/SearchRequest-10010.xml";
    private static final String SAMPLE_PATH_MESSAGE_4 = "/sr/jira.issueviews:searchrequest-xml/temp/SearchRequest.xml?param1=abc";
    private static final String BAD_PLUGIN_MESSAGE = "Could not find any enabled plugin with key";

    public TestSearchXmlViewErrors(String name) {
        super(name);
    }

    public void testMalformedUrls() throws Exception {
        this.assert400SamplePathMessage("/sr");
        this.assert400SamplePathMessage("/sr/");
        this.assert400SamplePathMessage("/sr/unknownplugin");
        this.assert400SamplePathMessage("/sr/unknownplugin/");
        this.assert400SamplePathMessage("/sr/unknownplugin/blah");
        this.assert400BadPlugin("/sr/unknownplugin/blah/", "unknownplugin");
    }

    private void assert400SamplePathMessage(String url) {
        this.assert400(url);
        this.assertTextSequence(new String[]{SAMPLE_PATH_MESSAGE_1, SAMPLE_PATH_MESSAGE_2, SAMPLE_PATH_MESSAGE_3, SAMPLE_PATH_MESSAGE_4});
    }

    private void assert400BadPlugin(String url, String message) {
        this.assert400(url);
        this.assertTextSequence(new String[]{BAD_PLUGIN_MESSAGE, message});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assert400(String url) {
        this.tester.getDialog().getWebClient().setExceptionsThrownOnErrorStatus(false);
        try {
            this.tester.gotoPage(url);
            WebResponse webResponse = this.tester.getDialog().getResponse();
            TestSearchXmlViewErrors.assertEquals((int)400, (int)webResponse.getResponseCode());
        }
        finally {
            this.tester.getDialog().getWebClient().setExceptionsThrownOnErrorStatus(true);
        }
    }
}

