/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator;

import com.atlassian.jira.webtests.JIRAWebTest;
import org.apache.log4j.Logger;

public class TestNavigationBarWebFragment
extends JIRAWebTest {
    public static final Logger log = Logger.getLogger(TestNavigationBarWebFragment.class);

    public TestNavigationBarWebFragment(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.restoreData("TestNavigationBarWebFragment.xml");
    }

    public void tearDown() {
        this.login("admin", "admin");
        this.restoreBlankInstance();
        super.tearDown();
    }

    public void testNavigationBarWebFragment() {
        this.login("admin", "admin");
        this.assertLinkPresent("home_link");
        this._checkBrowseAndFindIssueLinksVisiblity();
        this._checkCreateIssueLinkVisiblity();
        this._checkAdminLinkVisiblityToProjectAdmin();
        this._checkAdminLinkVisiblityToSystemAdmin();
    }

    public void _checkBrowseAndFindIssueLinksVisiblity() {
        this.assertLinkPresent("browse_link");
        this.assertLinkPresent("find_link");
        this.removeBrowsePermission();
        this.assertLinkNotPresent("browse_link");
        this.assertLinkNotPresent("find_link");
        this.addBrowsePermission();
        this.assertLinkPresent("find_link");
        this.assertLinkPresent("browse_link");
        this.assertLinkPresentWithText("Projects");
        this.goToProject("homosapien");
        this.assertLinkPresent("browse_link");
        this.assertLinkPresentWithText("Projects");
    }

    public void _checkCreateIssueLinkVisiblity() {
        this.assertLinkPresent("create_link");
        this.removeCreatePermission();
        this.assertLinkNotPresent("create_link");
        this.addCreatePermission();
        this.assertLinkPresent("create_link");
    }

    public void _checkAdminLinkVisiblityToProjectAdmin() {
        this.login("project_admin", "project_admin");
        this.assertLinkPresent("admin_link");
        this.login("admin", "admin");
        this.removeProjectAdminPermission();
        this.assertLinkPresent("admin_link");
        this.logout();
        this.login("project_admin", "project_admin");
        this.assertLinkNotPresent("admin_link");
        this.logout();
        this.login("admin", "admin");
        this.addProjectAdminPermission();
        this.assertLinkPresent("admin_link");
        this.logout();
        this.login("project_admin", "project_admin");
        this.assertLinkPresent("admin_link");
    }

    public void _checkAdminLinkVisiblityToSystemAdmin() {
        this.login("system_admin", "system_admin");
        this.assertLinkPresent("admin_link");
        this.login("admin", "admin");
        this.removeUserFromGroup("system_admin", "jira-administrators");
        this.assertLinkPresent("admin_link");
        this.logout();
        this.login("system_admin", "system_admin");
        this.assertLinkNotPresent("admin_link");
        this.login("admin", "admin");
        this.addUserToGroup("system_admin", "jira-administrators");
        this.assertLinkPresent("admin_link");
        this.login("system_admin", "system_admin");
        this.assertLinkPresent("admin_link");
    }

    public void removeBrowsePermission() {
        this.gotoAdmin();
        this.clickLink("permission_schemes");
        this.clickLink("0_edit");
        this.clickLink("del_perm_10_10000");
        this.submit("Delete");
    }

    public void removeCreatePermission() {
        this.gotoAdmin();
        this.clickLink("permission_schemes");
        this.clickLink("0_edit");
        this.clickLink("del_perm_11_10000");
        this.submit("Delete");
    }

    public void removeProjectAdminPermission() {
        this.clickLink("admin_link");
        this.clickLink("permission_schemes");
        this.clickLink("0_edit");
        this.clickLink("del_perm_23_jira-developers");
        this.submit("Delete");
    }

    public void addBrowsePermission() {
        this.gotoAdmin();
        this.clickLink("permission_schemes");
        this.clickLink("0_edit");
        this.clickLink("add_perm_10");
        this.checkCheckbox("type", "group");
        this.selectOption("group", "jira-users");
        this.submit(" Add ");
    }

    public void addCreatePermission() {
        this.gotoAdmin();
        this.clickLink("permission_schemes");
        this.clickLink("0_edit");
        this.clickLink("add_perm_11");
        this.checkCheckbox("type", "group");
        this.selectOption("group", "jira-users");
        this.submit(" Add ");
    }

    public void addProjectAdminPermission() {
        this.clickLink("admin_link");
        this.clickLink("permission_schemes");
        this.clickLink("0_edit");
        this.clickLink("add_perm_23");
        this.checkCheckbox("type", "group");
        this.selectOption("group", "jira-developers");
        this.submit(" Add ");
    }
}

