/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.assertions.TextAssertionsImpl;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.functest.framework.navigator.IssueTypeCondition;
import com.atlassian.jira.webtests.CustomFieldValue;
import com.meterware.httpunit.WebLink;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class TestIssueNavigator
extends FuncTestCase {
    private static final String FIELD_FIX_FOR = "Fix For";
    private static final String FIELD_AFFECTS_VERSION = "Affects Versions";
    private static final String FIELD_COMPONENTS = "Components";
    private static final String CUSTOM_FIELD_GLOBAL = "global custom field";
    private static final String CUSTOM_FIELD_ISSUETYPE = "issueType only custom field";
    private static final String CUSTOM_FIELD_PROJECT = "project only custom field";
    private static final String CUSTOM_FIELD_ISSUETYPE_AND_PROJECT = "issue type &amp; project custom field";
    private static final String PROJECT_DOG = "dog";
    private static final String PROJECT_HOMOSAP = "homosapien";
    private static final String homosapId = "10000";
    private static final Long homosapIdLong = 1000L;
    private static final Long hspUnresolvedFilterId = 10010L;
    private static final String GROUP_NAME = "test group";
    private static final List<CustomFieldValue>[] cfValuesPerIssue = new ArrayList[]{new ArrayList(), new ArrayList(), new ArrayList()};
    private static final String issueKey = "HSP-1";
    private static final String issueKey2 = "HSP-2";
    private static final String issueKey3 = "HSP-3";
    private static final String issueKey4 = "HSP-4";
    private static final String customFieldIdSelectList = "10000";
    private static final String customFieldIdRadioButton = "10001";
    private static final String customFieldIdMultiSelect = "10002";
    private static final String customFieldIdCheckBox = "10003";
    private static final String customFieldIdTextField = "10004";
    private static final String customFieldIdUserPicker = "10005";
    private static final String customFieldIdDatePicker = "10006";
    private static final String CUSTOM_FIELD_SELECT = "Custom Field Select";
    private static final String CUSTOM_FIELD_RADIO = "Custom Field Radio";
    private static final String CUSTOM_FIELD_MULTI_SELECT = "Custom Field Multi Select";
    private static final String CUSTOM_FIELD_TEXTFIELD = "Custom Field Text Field";
    private static final String CUSTOM_FIELD_CHECKBOX = "Custom Field Check Box";
    private static final String CUSTOM_FIELD_USERPICKER = "Custom Field User Picker";
    private static final String CUSTOM_FIELD_DATEPICKER = "Custom Field Date Picker";
    private static final String ABC_USERNAME = "abcuser";
    private static final String DEF_USERNAME = "defuser";
    private static final String GHI_USERNAME = "ghiuser";
    private static final String RESULTS_COUNT_CLASS = "results-count";
    private static final String[] defaultOptions = new String[]{"abc", "def", "ghi"};
    private static final String[] dateOptions = new String[]{"01/Jan/05", "01/Feb/05", "01/Mar/05"};
    private static final String[] userOptions = new String[]{"abcuser", "defuser", "ghiuser"};
    private static final String[] customFieldNames = new String[]{"Custom Field Select", "Custom Field Radio", "Custom Field Text Field", "Custom Field Multi Select", "Custom Field Check Box", "Custom Field User Picker", "Custom Field Date Picker"};
    private static final String[] customFieldIds = new String[]{"10000", "10001", "10004", "10002", "10003", "10005", "10006"};

    public void testSubtaskIssueNavigatorColumn() {
        this.administration.restoreData("TestIssueNavigatorSubtaskColumnView.xml");
        this.navigation.login("admin", "admin");
        this.navigation.issue().gotoIssue("");
        this.text.assertTextPresent("HSP-5");
        this.text.assertTextPresent("HSP-6");
        this.log("Successfully found subtask issue keys in the subtask issue navigator column");
    }

    protected void removeColumnFromIssueNavigatorByPosition(int pos) {
        this.tester.clickLink("Profile");
        this.tester.clickLink("view_nav_columns");
        this.tester.clickLink("del_col_" + pos);
    }

    public void testNavigatorColumnVisibilityForCustomFields() {
        this.administration.restoreData("TestIssueNavigatorColumnVisibilityForCustomFields.xml");
        String dogProjectId = "10010";
        this.tester.clickLink("find_link");
        this.tester.submit("show");
        this.text.assertTextNotPresent("homosapien cf");
        this.text.assertTextNotPresent("homosapien bug cf");
        this.text.assertTextNotPresent("dog cf");
        this.text.assertTextNotPresent("dog bug cf");
        this.tester.clickLink("new_filter");
        this.tester.selectOption("pid", PROJECT_HOMOSAP);
        this.tester.submit("show");
        this.text.assertTextPresent("homosapien cf");
        this.text.assertTextNotPresent("homosapien bug cf");
        this.text.assertTextNotPresent("dog cf");
        this.text.assertTextNotPresent("dog bug cf");
        this.tester.clickLink("new_filter");
        this.tester.selectOption("pid", PROJECT_HOMOSAP);
        this.tester.selectOption("type", "Bug");
        this.tester.submit("show");
        this.text.assertTextPresent("homosapien cf");
        this.text.assertTextPresent("homosapien bug cf");
        this.text.assertTextNotPresent("dog cf");
        this.text.assertTextNotPresent("dog bug cf");
        this.tester.clickLink("new_filter");
        this.tester.selectOption("pid", PROJECT_DOG);
        this.tester.submit("show");
        this.text.assertTextNotPresent("homosapien cf");
        this.text.assertTextNotPresent("homosapien bug cf");
        this.text.assertTextPresent("dog cf");
        this.text.assertTextNotPresent("dog bug cf");
        this.tester.clickLink("new_filter");
        this.tester.selectOption("pid", PROJECT_DOG);
        this.tester.selectOption("type", "Bug");
        this.tester.submit("show");
        this.text.assertTextNotPresent("homosapien cf");
        this.text.assertTextNotPresent("homosapien bug cf");
        this.text.assertTextPresent("dog cf");
        this.text.assertTextPresent("dog bug cf");
        this.tester.clickLink("new_filter");
        this.tester.checkCheckbox("pid", "10000");
        this.tester.checkCheckbox("pid", "10010");
        this.tester.submit("show");
        this.text.assertTextPresent("homosapien cf");
        this.text.assertTextNotPresent("homosapien bug cf");
        this.text.assertTextPresent("dog cf");
        this.text.assertTextNotPresent("dog bug cf");
        this.tester.clickLink("new_filter");
        this.tester.checkCheckbox("pid", "10000");
        this.tester.checkCheckbox("pid", "10010");
        this.tester.selectOption("type", "Bug");
        this.tester.submit("show");
        this.text.assertTextPresent("homosapien cf");
        this.text.assertTextPresent("homosapien bug cf");
        this.text.assertTextPresent("dog cf");
        this.text.assertTextPresent("dog bug cf");
    }

    public void testProjectDropDownVisibility() {
        this.log("Issue Navigator: Test Issue navigator with only one project");
        this.administration.restoreData("TestIssueNavigatorProjectDropDownVisibility.xml");
        this.tester.clickLink("find_link");
        IdLocator issueFilterForm = new IdLocator(this.tester, "issue-filter");
        this.text.assertTextPresent(issueFilterForm, "Project");
        this.text.assertTextNotPresent(issueFilterForm, FIELD_FIX_FOR);
        this.text.assertTextNotPresent(issueFilterForm, FIELD_COMPONENTS);
        this.text.assertTextNotPresent(issueFilterForm, FIELD_AFFECTS_VERSION);
        this.tester.submit("show");
        this.tester.clickLink("viewfilter");
        this.tester.assertLinkPresentWithText(PROJECT_HOMOSAP);
        this.tester.assertLinkPresentWithText(issueKey);
        this.tester.assertLinkPresentWithText("This issue is in the project homosapien");
        this.navigation.issue().deleteIssue(issueKey);
    }

    public void testProjectCustomFieldsFixForAffectsComponetsVisibilityOneProject() {
        this.log("Issue Navigator: Test Issue navigator with only one project for visible related fields");
        this.administration.restoreData("TestIssueNavigatorComponentsVisibilityOneProject.xml");
        this.tester.clickLink("find_link");
        IdLocator issueFilterForm = new IdLocator(this.tester, "issue-filter");
        this.text.assertTextNotPresent(issueFilterForm, FIELD_FIX_FOR);
        this.text.assertTextNotPresent(issueFilterForm, FIELD_COMPONENTS);
        this.text.assertTextNotPresent(issueFilterForm, FIELD_AFFECTS_VERSION);
        this.text.assertTextNotPresent(issueFilterForm, CUSTOM_FIELD_PROJECT);
        this.navigation.logout();
        this.navigation.login("bob", "bob_password");
        this.tester.clickLink("find_link");
        this.text.assertTextPresent(FIELD_FIX_FOR);
        this.text.assertTextPresent(FIELD_COMPONENTS);
        this.text.assertTextPresent(FIELD_AFFECTS_VERSION);
        this.text.assertTextPresent(CUSTOM_FIELD_PROJECT);
    }

    public void testSearchAfterProjectRemoval() {
        this.log("Issue Navigator: Searching right after removal of the last searched project");
        this.administration.restoreData("TestIssueNavigatorSearchAfterProjectRemoval.xml");
        this.tester.clickLink("find_link");
        this.form.selectOptionsByValue("pid", new String[]{"10000"});
        this.tester.submit("show");
        this.tester.clickLink("viewfilter");
        this.administration.project().deleteProject(homosapIdLong);
        this.administration.project().addProject(PROJECT_HOMOSAP, "HSP", "", "admin", "project to delete");
        this.tester.clickLink("find_link");
        this.text.assertTextNotPresent("A system error has occurred");
    }

    public void testProjectComponentsVisibility() {
        this.log("Issue Navigator: Test project componenets visibility");
        this.administration.restoreData("TestIssueNavigatorProjectComponentsVisibility.xml");
        String projectIdOne = "10010";
        String projectIdTwo = "10011";
        String projectIdThree = "10012";
        String projectIdFour = "10013";
        String issueKeyOne = issueKey;
        String issueKeyTwo = "MKY-1";
        String issueKeyThree = "NDT-1";
        String issueKeyFour = "DOG-1";
        this.log("  Search all projects ie. there should be no project components section");
        this.tester.clickLink("find_link");
        this.form.selectOptionsByValue("pid", new String[]{"-1"});
        this.tester.submit("show");
        XPathLocator labelLocator = new XPathLocator(this.tester, "//*[@id=\"common.concepts.projectcomponents-group\"]//label");
        this.tester.assertLinkPresentWithText(issueKey);
        this.tester.assertLinkPresentWithText("MKY-1");
        this.tester.assertLinkPresentWithText("NDT-1");
        this.tester.assertLinkPresentWithText("DOG-1");
        this.text.assertTextNotPresent(labelLocator, FIELD_FIX_FOR);
        this.text.assertTextNotPresent(labelLocator, FIELD_COMPONENTS);
        this.text.assertTextNotPresent(labelLocator, FIELD_AFFECTS_VERSION);
        this.log("  Search Project 1 that has NO components and versions field");
        this.tester.clickLink("find_link");
        this.form.selectOptionsByValue("pid", new String[]{"10010"});
        this.tester.submit("show");
        labelLocator = new XPathLocator(this.tester, "//*[@id=\"common.concepts.projectcomponents-group\"]//label");
        this.tester.assertLinkPresentWithText(issueKey);
        this.tester.assertLinkNotPresentWithText("MKY-1");
        this.tester.assertLinkNotPresentWithText("NDT-1");
        this.tester.assertLinkNotPresentWithText("DOG-1");
        this.text.assertTextNotPresent(labelLocator, FIELD_FIX_FOR);
        this.text.assertTextNotPresent(labelLocator, FIELD_COMPONENTS);
        this.text.assertTextNotPresent(labelLocator, FIELD_AFFECTS_VERSION);
        this.log("  Search Project 2 that has components field");
        this.tester.clickLink("find_link");
        this.form.selectOptionsByValue("pid", new String[]{"10011"});
        this.tester.submit("show");
        labelLocator = new XPathLocator(this.tester, "//*[@id=\"common-concepts-projectcomponents-group\"]//label");
        this.tester.assertLinkNotPresentWithText(issueKey);
        this.tester.assertLinkPresentWithText("MKY-1");
        this.tester.assertLinkNotPresentWithText("NDT-1");
        this.tester.assertLinkNotPresentWithText("DOG-1");
        this.text.assertTextNotPresent(labelLocator, FIELD_FIX_FOR);
        this.text.assertTextPresent(labelLocator, FIELD_COMPONENTS);
        this.text.assertTextNotPresent(labelLocator, FIELD_AFFECTS_VERSION);
        this.log("  Search Project 3 that has versions field");
        this.tester.clickLink("find_link");
        this.form.selectOptionsByValue("pid", new String[]{"10012"});
        this.tester.submit("show");
        labelLocator = new XPathLocator(this.tester, "//*[@id=\"common-concepts-projectcomponents-group\"]//label");
        this.tester.assertLinkNotPresentWithText(issueKey);
        this.tester.assertLinkNotPresentWithText("MKY-1");
        this.tester.assertLinkPresentWithText("NDT-1");
        this.tester.assertLinkNotPresentWithText("DOG-1");
        this.text.assertTextPresent(labelLocator, FIELD_FIX_FOR);
        this.text.assertTextNotPresent(labelLocator, FIELD_COMPONENTS);
        this.text.assertTextPresent(labelLocator, FIELD_AFFECTS_VERSION);
        this.log("  Search Project 4 that has a component and a version field");
        this.tester.clickLink("find_link");
        this.form.selectOptionsByValue("pid", new String[]{"10013"});
        this.tester.submit("show");
        labelLocator = new XPathLocator(this.tester, "//*[@id=\"common-concepts-projectcomponents-group\"]//label");
        this.tester.assertLinkNotPresentWithText(issueKey);
        this.tester.assertLinkNotPresentWithText("MKY-1");
        this.tester.assertLinkNotPresentWithText("NDT-1");
        this.tester.assertLinkPresentWithText("DOG-1");
        this.text.assertTextPresent(labelLocator, FIELD_FIX_FOR);
        this.text.assertTextPresent(labelLocator, FIELD_COMPONENTS);
        this.text.assertTextPresent(labelLocator, FIELD_AFFECTS_VERSION);
        this.administration.project().deleteProject(PROJECT_DOG);
    }

    public void testJQLQueryBoxShownWhenInvalidProjectIdsSetInUrl() {
        this.log("Issue Navigator: Test project componenets visibility");
        this.administration.restoreData("TestIssueNavigatorProjectComponentsVisibility.xml");
        this.tester.gotoPage("/secure/IssueNavigator.jspa?reset=true&pid=99999");
        this.text.assertTextPresent("A value with ID &#39;99999&#39; does not exist for the field &#39;project&#39;.");
        this.assertions.getIssueNavigatorAssertions().assertJqlTooComplex();
        this.tester.gotoPage("/secure/IssueNavigator.jspa?reset=true&pid=99999&pid=88888");
        this.text.assertTextPresent("A value with ID &#39;88888&#39; does not exist for the field &#39;project&#39;.");
        this.text.assertTextPresent("A value with ID &#39;99999&#39; does not exist for the field &#39;project&#39;.");
        this.assertions.getIssueNavigatorAssertions().assertJqlTooComplex();
        this.tester.gotoPage("/secure/IssueNavigator.jspa?reset=true&pid=99999&pid=88888&pid=10010");
        this.text.assertTextPresent("A value with ID &#39;88888&#39; does not exist for the field &#39;project&#39;.");
        this.text.assertTextPresent("A value with ID &#39;99999&#39; does not exist for the field &#39;project&#39;.");
        this.text.assertTextNotPresent("A value with ID &#39;10010&#39; does not exist for the field &#39;project&#39;.");
        this.assertions.getIssueNavigatorAssertions().assertJqlTooComplex();
    }

    public void testCustomfieldVisibility() {
        this.administration.restoreData("TestIssueNavigatorCustomfieldVisibility.xml");
        this.tester.clickLink("find_link");
        this.form.selectOptionsByValue("type", new String[]{""});
        this.form.selectOptionsByValue("pid", new String[]{"-1"});
        this.tester.submit("show");
        this.text.assertTextPresent(CUSTOM_FIELD_GLOBAL);
        this.text.assertTextNotPresent(CUSTOM_FIELD_ISSUETYPE);
        this.text.assertTextNotPresent(CUSTOM_FIELD_PROJECT);
        this.text.assertTextNotPresent(CUSTOM_FIELD_ISSUETYPE_AND_PROJECT);
        this.tester.clickLink("find_link");
        this.form.selectOptionsByDisplayName("type", new String[]{IssueTypeCondition.IssueType.BUG.getName()});
        this.form.selectOptionsByValue("pid", new String[]{"-1"});
        this.tester.submit("show");
        this.text.assertTextPresent(CUSTOM_FIELD_GLOBAL);
        this.text.assertTextPresent(CUSTOM_FIELD_ISSUETYPE);
        this.text.assertTextNotPresent(CUSTOM_FIELD_PROJECT);
        this.text.assertTextNotPresent(CUSTOM_FIELD_ISSUETYPE_AND_PROJECT);
        this.tester.clickLink("find_link");
        this.form.selectOptionsByValue("type", new String[]{""});
        this.form.selectOptionsByValue("pid", new String[]{"10000"});
        this.tester.submit("show");
        this.text.assertTextPresent(CUSTOM_FIELD_GLOBAL);
        this.text.assertTextNotPresent(CUSTOM_FIELD_ISSUETYPE);
        this.text.assertTextPresent(CUSTOM_FIELD_PROJECT);
        this.text.assertTextNotPresent(CUSTOM_FIELD_ISSUETYPE_AND_PROJECT);
        this.tester.clickLink("find_link");
        this.form.selectOptionsByDisplayName("type", new String[]{IssueTypeCondition.IssueType.BUG.getName()});
        this.form.selectOptionsByValue("pid", new String[]{"10000"});
        this.tester.submit("show");
        this.text.assertTextPresent(CUSTOM_FIELD_GLOBAL);
        this.text.assertTextPresent(CUSTOM_FIELD_ISSUETYPE);
        this.text.assertTextPresent(CUSTOM_FIELD_PROJECT);
        this.text.assertTextPresent(CUSTOM_FIELD_ISSUETYPE_AND_PROJECT);
    }

    public void testSearchParametersDisplayed() {
        this.administration.restoreData("TestIssueNavigatorCommon.xml");
        String componentId = "10000";
        String versionFourId = "10000";
        String versionFiveId = customFieldIdRadioButton;
        String customFieldId = this.administration.customFields().addCustomField("com.atlassian.jira.plugin.system.customfieldtypes:textfield", CUSTOM_FIELD_GLOBAL);
        this.tester.clickLink("find_link");
        this.form.selectOptionsByValue("pid", new String[]{"10000"});
        this.tester.submit("show");
        this.form.selectOptionsByDisplayName("type", new String[]{IssueTypeCondition.IssueType.BUG.getName()});
        this.form.selectOptionsByValue("fixfor", new String[]{"10000"});
        this.form.selectOptionsByValue("component", new String[]{"10000"});
        this.form.selectOptionsByValue("version", new String[]{customFieldIdRadioButton});
        this.tester.setFormElement("query", "this is the query field");
        this.tester.setFormElement("reporterSelect", "specificuser");
        this.tester.setFormElement("reporter", "admin");
        this.tester.setFormElement("assigneeSelect", "issue_current_user");
        this.tester.setFormElement("status", "1");
        this.tester.setFormElement("resolution", "1");
        this.tester.setFormElement("priority", "3");
        this.tester.setFormElement("created:after", "15/Jul/05");
        this.tester.setFormElement("created:before", "16/Jul/05");
        this.tester.setFormElement("created:previous", "-1d");
        this.tester.setFormElement("created:next", "2d");
        this.tester.setFormElement("updated:after", "17/Jul/05");
        this.tester.setFormElement("updated:before", "18/Jul/05");
        this.tester.setFormElement("updated:previous", "-3d");
        this.tester.setFormElement("updated:next", "4d");
        this.tester.setFormElement("duedate:after", "19/Jul/05");
        this.tester.setFormElement("duedate:before", "20/Jul/05");
        this.tester.setFormElement("duedate:previous", "-5d");
        this.tester.setFormElement("duedate:next", "6d");
        this.tester.setFormElement("workratio:min", "12");
        this.tester.setFormElement("workratio:max", "13");
        this.tester.setFormElement(customFieldId, "custom value");
        this.tester.submit("show");
        this.tester.clickLink("viewfilter");
        this.text.assertTextSequence(new IdLocator(this.tester, "filter-summary"), new String[]{"Project:", PROJECT_HOMOSAP});
        this.text.assertTextSequence(new IdLocator(this.tester, "filter-summary"), new String[]{"Issue Type:", "Bug"});
        this.text.assertTextSequence(new IdLocator(this.tester, "filter-summary"), new String[]{"Fix For:", "New Version 4"});
        this.text.assertTextSequence(new IdLocator(this.tester, "filter-summary"), new String[]{"Components:", "New Component 1"});
        this.text.assertTextSequence(new IdLocator(this.tester, "filter-summary"), new String[]{"Affects Versions:", "New Version 5"});
        this.text.assertTextSequence(new IdLocator(this.tester, "filter-summary"), new String[]{"Query", "this is the query field"});
        this.text.assertTextSequence(new IdLocator(this.tester, "filter-summary"), new String[]{"Reporter:", "admin"});
        this.text.assertTextSequence(new IdLocator(this.tester, "filter-summary"), new String[]{"Assignee:", "Current User"});
        this.text.assertTextSequence(new IdLocator(this.tester, "filter-summary"), new String[]{"Status:", "Open"});
        this.text.assertTextSequence(new IdLocator(this.tester, "filter-summary"), new String[]{"Resolutions:", "Fixed"});
        this.text.assertTextSequence(new IdLocator(this.tester, "filter-summary"), new String[]{"Priorities:", "Major"});
        this.text.assertTextSequence(new IdLocator(this.tester, "filter-summary"), new String[]{"Created After:", "15/Jul/05"});
        this.text.assertTextSequence(new IdLocator(this.tester, "filter-summary"), new String[]{"Created Before:", "16/Jul/05"});
        this.text.assertTextSequence(new IdLocator(this.tester, "filter-summary"), new String[]{"Created:", "From 1 day ago"});
        this.text.assertTextSequence(new IdLocator(this.tester, "filter-summary"), new String[]{"From 1 day ago", "2 days from now"});
        this.text.assertTextSequence(new IdLocator(this.tester, "filter-summary"), new String[]{"Updated After:", "17/Jul/05"});
        this.text.assertTextSequence(new IdLocator(this.tester, "filter-summary"), new String[]{"Updated Before:", "18/Jul/05"});
        this.text.assertTextSequence(new IdLocator(this.tester, "filter-summary"), new String[]{"Updated:", "From 3 days ago"});
        this.text.assertTextSequence(new IdLocator(this.tester, "filter-summary"), new String[]{"From 3 days ago", "4 days from now"});
        this.text.assertTextSequence(new IdLocator(this.tester, "filter-summary"), new String[]{"Due After:", "19/Jul/05"});
        this.text.assertTextSequence(new IdLocator(this.tester, "filter-summary"), new String[]{"Due Before:", "20/Jul/05"});
        this.text.assertTextSequence(new IdLocator(this.tester, "filter-summary"), new String[]{"Due Date:", "From 5 days ago"});
        this.text.assertTextSequence(new IdLocator(this.tester, "filter-summary"), new String[]{"From 5 days ago", "6 days from now"});
        this.text.assertTextSequence(new IdLocator(this.tester, "filter-summary"), new String[]{"Work Ratio Min:", "12%"});
        this.text.assertTextSequence(new IdLocator(this.tester, "filter-summary"), new String[]{"Work Ratio Max:", "13%"});
        this.text.assertTextSequence(new IdLocator(this.tester, "filter-summary"), new String[]{CUSTOM_FIELD_GLOBAL, "custom value"});
    }

    public void testIssueNavigatorSortByComponent() {
        this.log("Issue Navigator: Test that the filter correctly orders issues for components.");
        this.administration.restoreData("TestIssueNavigatorCommon.xml");
        this.tester.clickLink("find_link");
        this.tester.submit("show");
        this.tester.clickLink("viewfilter");
        this.tester.clickLinkWithText("Configure");
        try {
            this.form.selectOption("fieldId", "Component/s");
            this.tester.submit("add");
        }
        catch (Throwable t) {
            this.log("Component field already added");
        }
        this.tester.clickLinkWithText("Issue Navigator");
        this.navigation.issueNavigator().sortIssues("issuekey", "ASC");
        this.navigation.issueNavigator().sortIssues("components", "ASC");
        this.text.assertTextSequence(new IdLocator(this.tester, "issuetable"), new String[]{issueKey4, issueKey2, issueKey, issueKey3});
        this.navigation.issueNavigator().sortIssues("components", "DESC");
        this.text.assertTextSequence(new IdLocator(this.tester, "issuetable"), new String[]{issueKey, issueKey3, issueKey2, issueKey4});
        this.tester.clickLinkWithText("Configure");
        this.tester.clickLinkWithText("Restore Defaults");
    }

    public void testIssueNavigatorSortByCustomField() {
        this.log("Issue Navigator: Test that the filter correctly orders issues for custom fields.");
        this.administration.restoreData("TestIssueNavigatorCommon.xml");
        this.navigation.issueNavigator().addColumnToIssueNavigator(customFieldNames);
        this.navigation.issueNavigator().displayAllIssues();
        for (int i = 0; i < customFieldIds.length; ++i) {
            this.log("Sorting by " + customFieldNames[i]);
            this.navigation.issueNavigator().sortIssues("customfield_" + customFieldIds[i], "ASC");
            this.text.assertTextSequence(new IdLocator(this.tester, "issuetable"), new String[]{issueKey, issueKey2, issueKey3, issueKey4});
            this.navigation.issueNavigator().sortIssues("customfield_" + customFieldIds[i], "DESC");
            this.text.assertTextSequence(new IdLocator(this.tester, "issuetable"), new String[]{issueKey4, issueKey3, issueKey2, issueKey});
        }
        this.navigation.issueNavigator().restoreColumnDefaults();
    }

    public void testIssueNavigatorHideReporter() {
        this.log("Issue Navigator: Test that the filter correctly hides the reporter field with full content view.");
        this.administration.restoreData("TestIssueNavigatorCommon.xml");
        this.administration.fieldConfigurations().defaultFieldConfiguration().hideFields("Reporter");
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.clickLink("fullContent");
        this.text.assertTextNotPresent("Reporter");
        this.tester.clickLinkWithText("test issue 1");
        this.administration.fieldConfigurations().defaultFieldConfiguration().showFields("Reporter");
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.clickLink("fullContent");
        this.text.assertTextPresent("Reporter");
        this.tester.clickLinkWithText("test issue 1");
    }

    public void testIssueNavigatorManyFields() {
        this.administration.restoreData("TestIssueNavigatorCommon.xml");
        this.administration.addGlobalPermission(33, "jira-users");
        String testIssueKey = this.navigation.issue().createIssue(PROJECT_HOMOSAP, "Bug", "test issue 6");
        this.navigation.issue().assignIssue(testIssueKey, "assign to admin", "Administrator");
        this.navigation.issue().setPriority(testIssueKey, "Trivial");
        this.navigation.issue().setComponents(testIssueKey, "New Component 1");
        this.navigation.issue().setAffectsVersions(testIssueKey, "New Version 5");
        this.navigation.issue().setFixVersions(testIssueKey, "New Version 5");
        this.navigation.issue().setEnvironment(testIssueKey, "test environment 5");
        this.navigation.issue().setDueDate(testIssueKey, dateOptions[1]);
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.clickLink("new_filter");
        this.tester.selectOption("type", "Bug");
        this.tester.setFormElement("query", "issue 6");
        this.tester.selectOption("reporterSelect", "Current User");
        this.tester.selectOption("assigneeSelect", "Specify User");
        this.tester.setFormElement("assignee", "admin");
        this.tester.selectOption("status", "Open");
        this.tester.selectOption("resolution", "Unresolved");
        this.tester.selectOption("priority", "Trivial");
        this.tester.setFormElement("created:after", dateOptions[0]);
        this.tester.setFormElement("created:previous", "-1h");
        this.tester.setFormElement("updated:after", dateOptions[0]);
        this.tester.setFormElement("updated:previous", "-1h");
        this.tester.setFormElement("duedate:after", dateOptions[0]);
        this.tester.setFormElement("duedate:before", dateOptions[2]);
        this.tester.submit("show");
        this.text.assertTextPresent("all 1 issue");
        this.tester.selectOption("type", "Task");
        this.tester.submit("show");
        this.text.assertTextPresent("No matching issues found");
        this.administration.removeGlobalPermission(33, "jira-users");
    }

    public void testIssueNavigatorSelectGroup() {
        this.log("Issue Navigator: Test that all issues are filtered for a specific group");
        this.administration.restoreData("TestIssueNavigatorCommon.xml");
        this.administration.usersAndGroups().addGroup(GROUP_NAME);
        this.administration.usersAndGroups().addUserToGroup("bob", GROUP_NAME);
        String testIssueKey = this.navigation.issue().createIssue(PROJECT_HOMOSAP, "Bug", "test issue 5");
        this.navigation.issue().assignIssue(testIssueKey, "Assign to Bob", "Bob The Builder");
        this.tester.clickLink("find_link");
        try {
            this.tester.clickLink("new_filter");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.tester.selectOption("assigneeSelect", "Specify Group");
        this.tester.setFormElement("assignee", GROUP_NAME);
        this.tester.submit("show");
        this.tester.clickLink("viewfilter");
        this.tester.assertLinkPresentWithText(issueKey);
        this.tester.assertLinkPresentWithText(issueKey3);
        this.tester.assertLinkPresentWithText(testIssueKey);
        this.navigation.issue().deleteIssue(testIssueKey);
        this.administration.usersAndGroups().deleteGroup(GROUP_NAME);
    }

    public void testIssueNavigatorXMLViewWithCustomFields() throws Exception {
        this.log("Issue Navigator: Test that the RSS page correctly shows the custom field information.");
        this.administration.restoreData("TestIssueNavigatorCommon.xml");
        this.navigation.issueNavigator().addColumnToIssueNavigator(customFieldNames);
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.clickLinkWithText("XML");
        this.text.assertTextPresent("An XML representation of a search request");
        this.text.assertTextPresent("[HSP-1] test issue 1");
        Document doc = XMLUnit.buildControlDocument((String)this.tester.getDialog().getResponse().getText());
        for (List<CustomFieldValue> values : cfValuesPerIssue) {
            for (CustomFieldValue customFieldValue : values) {
                if (customFieldValue.getCfType().equals("datepicker")) continue;
                this.log("Searching for existence of xpath //item/customfields/customfield[@id='customfield_" + customFieldValue.getCfId() + "'][customfieldname='" + this.getCustomFieldNameFromType(customFieldValue.getCfType()) + "'][customfieldvalues[customfieldvalue='" + customFieldValue.getCfValue() + "']]");
                XMLAssert.assertXpathExists((String)("//item/customfields/customfield[@id='customfield_" + customFieldValue.getCfId() + "'][customfieldname='" + this.getCustomFieldNameFromType(customFieldValue.getCfType()) + "'][customfieldvalues[customfieldvalue='" + customFieldValue.getCfValue() + "']]"), (Document)doc);
            }
        }
    }

    private String getCustomFieldNameFromType(String type) {
        if (type.equals("select")) {
            return CUSTOM_FIELD_SELECT;
        }
        if (type.equals("radiobuttons")) {
            return CUSTOM_FIELD_RADIO;
        }
        if (type.equals("multiselect")) {
            return CUSTOM_FIELD_MULTI_SELECT;
        }
        if (type.equals("multicheckboxes")) {
            return CUSTOM_FIELD_CHECKBOX;
        }
        if (type.equals("textfield")) {
            return CUSTOM_FIELD_TEXTFIELD;
        }
        if (type.equals("userpicker")) {
            return CUSTOM_FIELD_USERPICKER;
        }
        if (type.equals("datepicker")) {
            return CUSTOM_FIELD_DATEPICKER;
        }
        return null;
    }

    public void testSearchPermLink() throws SAXException {
        this.administration.restoreData("TestNavigatorSearchPermLink.xml");
        this.navigation.login("admin", "admin");
        this.navigation.issueNavigator().loadFilter(hspUnresolvedFilterId, IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.confirmSearchResults();
        WebLink permLink = this.tester.getDialog().getResponse().getLinkWithID("permlink");
        String permlinkURLString = permLink.getURLString();
        this.navigation.gotoAdmin();
        this.tester.beginAt(permlinkURLString);
        this.confirmSearchResults();
        this.navigation.logout();
        this.tester.beginAt(permlinkURLString);
        this.confirmSearchResults();
    }

    public void testIssueNavigatorWithInvalidFilterId() {
        String invalidFilterId = "14a";
        this.administration.restoreData("TestIssueNavigatorCommon.xml");
        this.tester.gotoPage("/secure/IssueNavigator.jspa?mode=hide&requestId=14a");
        this.text.assertTextPresent("You do not currently have a search or filter selected.");
        this.text.assertTextPresent("Invalid filter id &#39;14a&#39;. Filter id must be a number.");
        this.text.assertTextPresent("The selected filter with id '14a' does not exist.");
    }

    public void testBackToPreviousViewLinks() {
        this.administration.restoreData("TestIssueNavigatorCommon.xml");
        this.tester.gotoPage("secure/IssueNavigator.jspa?reset=true&jqlQuery=resolution+%3D+Unresolved+AND+assignee+%3D+currentUser%28%29+ORDER+BY+created+ASC%2C+priority+DESC");
        long filterId = this.navigation.issueNavigator().saveCurrentAsNewFilter("my issues", "", true, null);
        this.navigation.issueNavigator().displayAllIssues();
        this.assertions.getIssueNavigatorAssertions().assertIssueNavigatorDisplaying(new XPathLocator(this.tester, "//*[@class='results-count']"), "1", "4", "4");
        this.tester.gotoPage("secure/IssueNavigator.jspa?reset=true&jqlQuery=resolution+%3D+Unresolved+AND+assignee+%3D+currentUser%28%29+ORDER+BY+created+ASC%2C+priority+DESC");
        this.assertPrintableViewsBackToPreviousViewLink();
        this.navigation.issueNavigator().loadFilter(filterId, IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.assertPrintableViewsBackToPreviousViewLink();
        this.tester.gotoPage("secure/IssueNavigator.jspa?reset=true&jqlQuery=resolution+%3D+Unresolved+AND+assignee+%3D+currentUser%28%29+ORDER+BY+created+ASC%2C+priority+DESC");
        this.assertFullContentViewsBackToPreviousViewLink();
        this.navigation.issueNavigator().loadFilter(filterId, IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.assertFullContentViewsBackToPreviousViewLink();
    }

    private void assertPrintableViewsBackToPreviousViewLink() {
        String fromIssueCount = "1";
        String toIssueCount = "2";
        String totalIssueCount = "2";
        this.assertExpectedIssueLinksPresent();
        this.assertions.getIssueNavigatorAssertions().assertIssueNavigatorDisplaying(new XPathLocator(this.tester, "//*[@class='results-count']"), "1", "2", "2");
        this.tester.clickLink("printable");
        this.assertExpectedIssueLinksPresent();
        this.assertions.getIssueNavigatorAssertions().assertIssueNavigatorDisplaying(new XPathLocator(this.tester, "//*[@class='borderedHeader']"), "1", "2", "2");
        this.tester.clickLinkWithText("<< Back to previous view");
        this.assertExpectedIssueLinksPresent();
        this.assertions.getIssueNavigatorAssertions().assertIssueNavigatorDisplaying(new XPathLocator(this.tester, "//*[@class='results-count']"), "1", "2", "2");
    }

    private void assertFullContentViewsBackToPreviousViewLink() {
        String fromIssueCount = "1";
        String toIssueCount = "2";
        String totalIssueCount = "2";
        this.assertExpectedIssueLinksPresent();
        this.assertions.getIssueNavigatorAssertions().assertIssueNavigatorDisplaying(new XPathLocator(this.tester, "//*[@class='results-count']"), "1", "2", "2");
        this.tester.clickLink("fullContent");
        this.assertExpectedIssueLinksPresent();
        this.tester.clickLinkWithText("<< Back to previous view");
        this.assertExpectedIssueLinksPresent();
        this.assertions.getIssueNavigatorAssertions().assertIssueNavigatorDisplaying(new XPathLocator(this.tester, "//*[@class='results-count']"), "1", "2", "2");
    }

    private void assertExpectedIssueLinksPresent() {
        this.tester.assertLinkNotPresentWithText("test issue 1");
        this.tester.assertLinkNotPresentWithText("test issue 3");
        this.tester.assertLinkPresentWithText("test issue 2");
        this.tester.assertLinkPresentWithText("test issue 4");
    }

    public void testSearchAbsoluteDateRangeDueDate() {
        this.administration.restoreData("TestIssueNavigatorSearchParams.xml");
        this.tester.clickLink("find_link");
        this.tester.setFormElement("duedate:after", "12/Sep/06");
        this.tester.submit("show");
        this.text.assertTextPresent(issueKey2);
        this.text.assertTextNotPresent(issueKey);
        this.tester.setFormElement("duedate:after", "11/Sep/06");
        this.tester.submit("show");
        this.text.assertTextPresent(issueKey2);
        this.text.assertTextPresent(issueKey);
        this.tester.setFormElement("duedate:before", "13/Sep/06");
        this.tester.submit("show");
        this.text.assertTextPresent(issueKey2);
        this.text.assertTextPresent(issueKey);
        this.tester.setFormElement("duedate:before", "12/Sep/06");
        this.tester.submit("show");
        this.text.assertTextPresent(issueKey);
        this.text.assertTextNotPresent(issueKey2);
        this.tester.setFormElement("duedate:before", "13/Sep/06");
        this.tester.setFormElement("duedate:after", "11/Sep/06");
        this.tester.submit("show");
        this.text.assertTextPresent(issueKey2);
        this.text.assertTextPresent(issueKey);
        this.tester.setFormElement("duedate:before", "17/Sep/06");
        this.tester.setFormElement("duedate:after", "15/Sep/06");
        this.tester.submit("show");
        this.text.assertTextNotPresent(issueKey2);
        this.text.assertTextNotPresent(issueKey);
    }

    public void testSearchRelativeDateRangeDueDate() {
        this.administration.restoreData("TestIssueNavigatorSearchParams.xml");
        this.navigation.issue().viewIssue(issueKey);
        this.tester.clickLinkWithText("Edit");
        Date today = new Date();
        String todayString = new SimpleDateFormat("dd/MMM/yy").format(today);
        this.tester.setFormElement("duedate", todayString);
        this.tester.submit("Update");
        this.tester.clickLink("find_link");
        this.tester.setFormElement("duedate:previous", "-1d");
        this.tester.setFormElement("duedate:next", "1d");
        this.tester.submit("show");
        this.text.assertTextPresent(issueKey);
        this.text.assertTextNotPresent(issueKey2);
        this.tester.setFormElement("duedate:previous", "2d");
        this.tester.setFormElement("duedate:next", "4d");
        this.tester.submit("show");
        this.text.assertTextNotPresent(issueKey);
        this.text.assertTextNotPresent(issueKey2);
        this.tester.setFormElement("duedate:previous", "-1d");
        this.tester.setFormElement("duedate:next", "");
        this.tester.submit("show");
        this.text.assertTextPresent(issueKey);
        this.text.assertTextNotPresent(issueKey2);
        this.tester.setFormElement("duedate:previous", "");
        this.tester.setFormElement("duedate:next", "1d");
        this.tester.submit("show");
        this.text.assertTextPresent(issueKey);
        this.text.assertTextPresent(issueKey2);
    }

    public void testSearchWorkRatioParam() {
        this.administration.restoreData("TestIssueNavigatorSearchParams.xml");
        this.tester.clickLink("find_link");
        this.tester.setFormElement("workratio:min", "2");
        this.tester.setFormElement("workratio:max", "5");
        this.tester.submit("show");
        this.text.assertTextPresent(issueKey2);
        this.text.assertTextNotPresent(issueKey);
        this.tester.setFormElement("workratio:min", "4");
        this.tester.setFormElement("workratio:max", "5");
        this.tester.submit("show");
        this.text.assertTextPresent(issueKey2);
        this.text.assertTextNotPresent(issueKey);
        this.tester.setFormElement("workratio:min", "3");
        this.tester.setFormElement("workratio:max", "4");
        this.tester.submit("show");
        this.text.assertTextPresent(issueKey2);
        this.text.assertTextNotPresent(issueKey);
        this.tester.setFormElement("workratio:min", "5");
        this.tester.setFormElement("workratio:max", "9");
        this.tester.submit("show");
        this.text.assertTextNotPresent(issueKey2);
        this.text.assertTextNotPresent(issueKey);
        this.tester.setFormElement("workratio:min", "3");
        this.tester.setFormElement("workratio:max", "");
        this.tester.submit("show");
        this.text.assertTextPresent(issueKey2);
        this.text.assertTextNotPresent(issueKey);
        this.tester.setFormElement("workratio:min", "");
        this.tester.setFormElement("workratio:max", "5");
        this.tester.submit("show");
        this.text.assertTextPresent(issueKey2);
        this.text.assertTextNotPresent(issueKey);
    }

    public void testSearchNumberCustomFieldParam() {
        this.administration.restoreData("TestIssueNavigatorSearchParams.xml");
        this.tester.clickLink("find_link");
        this.tester.setFormElement("customfield_10000:greaterThan", "0");
        this.tester.setFormElement("customfield_10000:lessThan", "3");
        this.tester.submit("show");
        this.text.assertTextPresent(issueKey2);
        this.text.assertTextPresent(issueKey);
        this.tester.setFormElement("customfield_10000:greaterThan", "1");
        this.tester.setFormElement("customfield_10000:lessThan", "3");
        this.tester.submit("show");
        this.text.assertTextPresent(issueKey2);
        this.text.assertTextPresent(issueKey);
        this.tester.setFormElement("customfield_10000:greaterThan", "0");
        this.tester.setFormElement("customfield_10000:lessThan", "2");
        this.tester.submit("show");
        this.text.assertTextPresent(issueKey2);
        this.text.assertTextPresent(issueKey);
        this.tester.setFormElement("customfield_10000:greaterThan", "5");
        this.tester.setFormElement("customfield_10000:lessThan", "9");
        this.tester.submit("show");
        this.text.assertTextNotPresent(issueKey2);
        this.text.assertTextNotPresent(issueKey);
        this.tester.setFormElement("customfield_10000:greaterThan", "2");
        this.tester.setFormElement("customfield_10000:lessThan", "");
        this.tester.submit("show");
        this.text.assertTextPresent(issueKey2);
        this.text.assertTextNotPresent(issueKey);
        this.tester.setFormElement("customfield_10000:greaterThan", "");
        this.tester.setFormElement("customfield_10000:lessThan", "1");
        this.tester.submit("show");
        this.text.assertTextNotPresent(issueKey2);
        this.text.assertTextPresent(issueKey);
    }

    public void testNavigatorOrdering() {
        this.administration.restoreData("TestIssueNavigatorCommon.xml");
        this.tester.clickLink("find_link");
        this.tester.submit("show");
        this.tester.gotoPage("secure/IssueNavigator.jspa?sorter/field=summary&sorter/order=ASC");
        this.text.assertTextSequence(new IdLocator(this.tester, "issuetable"), new String[]{"test issue 1", "test issue 2", "test issue 3", "test issue 4"});
        this.tester.gotoPage("secure/IssueNavigator.jspa?sorter/field=assignee&sorter/order=ASC");
        this.text.assertTextSequence(new IdLocator(this.tester, "issuetable"), new String[]{"Administrator", "Administrator", "Bob The Builder", "Bob The Builder"});
        this.tester.gotoPage("secure/IssueNavigator.jspa?sorter/field=summary&sorter/order=ASC");
        this.tester.gotoPage("secure/IssueNavigator.jspa?sorter/field=duedate&sorter/order=ASC");
        this.text.assertTextSequence(new IdLocator(this.tester, "issuetable"), new String[]{"test issue 1", "test issue 2", "test issue 3", "test issue 4"});
        this.tester.clickLink("find_link");
        this.tester.clickLinkWithText("Configure");
        this.tester.selectOption("fieldId", "Work Ratio");
        this.tester.submit("add");
        this.tester.clickLink("find_link");
        this.tester.gotoPage("secure/IssueNavigator.jspa?sorter/field=summary&sorter/order=ASC");
        this.tester.gotoPage("secure/IssueNavigator.jspa?sorter/field=workratio&sorter/order=ASC");
        this.text.assertTextSequence(new IdLocator(this.tester, "issuetable"), new String[]{"test issue 1", "test issue 2", "test issue 3", "test issue 4"});
    }

    public void testNavigatorTabs() {
        this.administration.restoreData("TestIssueNavigatorCommon.xml");
        this.navigation.logout();
        this.tester.gotoPage("secure/IssueNavigator.jspa");
        String[] loggedTabs = new String[]{"Summary", "New", "Manage"};
        this.text.assertTextSequence(new IdLocator(this.tester, "filterFormHeader"), loggedTabs);
        this.tester.clickLink("viewfilter");
        this.text.assertTextSequence(new IdLocator(this.tester, "filterFormHeader"), loggedTabs);
        this.tester.clickLink("new_filter");
        this.text.assertTextSequence(new IdLocator(this.tester, "filterFormHeader"), loggedTabs);
        this.navigation.login("admin", "admin");
        this.navigation.issueNavigator().displayAllIssues();
        this.text.assertTextSequence(new IdLocator(this.tester, "filterFormHeader"), loggedTabs);
        this.tester.clickLink("viewfilter");
        this.text.assertTextSequence(new IdLocator(this.tester, "filterFormHeader"), loggedTabs);
        this.tester.clickLink("new_filter");
        this.text.assertTextSequence(new IdLocator(this.tester, "filterFormHeader"), loggedTabs);
        this.tester.submit("show");
        this.tester.clickLink("viewfilter");
        loggedTabs = new String[]{"Summary", "Edit", "New", "Manage"};
        this.text.assertTextSequence(new IdLocator(this.tester, "filterFormHeader"), loggedTabs);
        this.tester.clickLink("editfilter");
        this.text.assertTextSequence(new IdLocator(this.tester, "filterFormHeader"), loggedTabs);
        this.tester.clickLink("new_filter");
        loggedTabs = new String[]{"Summary", "New", "Manage"};
        this.text.assertTextSequence(new IdLocator(this.tester, "filterFormHeader"), loggedTabs);
        this.tester.assertLinkNotPresent("new_filter");
        this.tester.clickLink("find_link");
        this.text.assertTextSequence(new IdLocator(this.tester, "filterFormHeader"), loggedTabs);
        this.tester.assertLinkNotPresent("new_filter");
    }

    public void testSearchSortDescriptionForInvalidField() throws Exception {
        this.administration.restoreData("TestIssueNavigatorCommon.xml");
        this.tester.clickLink("find_link");
        this.tester.submit("show");
        this.tester.clickLinkWithText("Save");
        this.tester.setFormElement("filterName", "My Test Filter");
        this.tester.submit("saveasfilter_submit");
        this.tester.gotoPage("/secure/IssueNavigator.jspa?sorter/field=customfield_10006&sorter/order=ASC");
        this.text.assertTextSequence(new IdLocator(this.tester, "filter-summary"), new String[]{"Sorted by:", "Custom Field Date Picker ascending, then", "Key descending"});
        this.tester.clickLinkWithText("Save");
        this.tester.submit("Save");
        this.tester.clickLink("admin_link");
        this.tester.clickLink("view_custom_fields");
        this.tester.clickLink("del_customfield_10006");
        this.tester.submit("Delete");
        this.tester.clickLink("find_link");
        this.tester.assertTextNotPresent("Custom Field Date Picker ascending, then");
        this.text.assertTextSequence(new IdLocator(this.tester, "filter-summary"), new String[]{"Sorted by:", "Key descending"});
    }

    public void testNoColumnsDialog() throws Exception {
        this.administration.restoreData("TestIssueNavigatorNoColumns.xml");
        this.tester.clickLink("find_link");
        this.tester.submit("show");
        new TextAssertionsImpl().assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"No columns selected", "/secure/ViewUserIssueColumns!default.jspa", "Configure"});
    }

    public void testCanSearchForTextWithDotAndColon() throws Exception {
        this.administration.restoreData("TestIssueNavigatorTextWithDotAndColon.xml");
        this.navigation.issueNavigator().createSearch("description ~ \"d.dude:123\" order by key desc");
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults("TST-1");
        this.navigation.issueNavigator().createSearch("description ~ \"dude\" order by key asc");
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults("TST-1", "TST-2");
    }

    public void testXssInImageUrls() throws Exception {
        this.administration.restoreData("TestImageUrlXss.xml");
        this.navigation.issueNavigator().createSearch("");
        this.tester.assertTextNotPresent("\"'/><script>alert('statuzz');</script>");
        this.tester.assertTextPresent("&quot;'/&gt;&lt;script&gt;alert('statuzz');&lt;/script&gt;");
        this.tester.assertTextNotPresent("\"'/><script>alert('prioritiezz');</script>");
        this.tester.assertTextPresent("&quot;'/&gt;&lt;script&gt;alert('prioritiezz');&lt;/script&gt;");
        this.tester.assertTextNotPresent("\"'/><script>alert('issue typezz');</script>");
        this.tester.assertTextPresent("&quot;'/&gt;&lt;script&gt;alert('issue typezz');&lt;/script&gt;");
    }

    private void confirmSearchResults() {
        this.assertions.getIssueNavigatorAssertions().assertIssueNavigatorDisplaying(new XPathLocator(this.tester, "//*[@class='results-count']"), "1", "4", "4");
        this.tester.assertLinkNotPresentWithText("this is a NDT bug - should not be shown on the HSP filter");
        this.tester.assertLinkPresentWithText("unresolved issue 1");
        this.tester.assertLinkPresentWithText("unresolved issue 2");
        this.tester.assertLinkPresentWithText("unresolved issue 3");
        this.tester.assertLinkPresentWithText("unresolved issue 4");
    }
}

