/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.jira.functest.framework.FuncTestCase;

public class TestXSS
extends FuncTestCase {
    private static final String XSS_ALERT_CONTENTS = "xss exploit";
    private static final String XSS_ALERT_RAW = "\"><script>alert('xss exploit')</script>";
    private static final String XSS_TAG = "<script>";
    private static final String XSS_ATTACK = "%22%3E%3Cscript%3Ealert%28%27xss+exploit%27%29%3C/script%3E";
    private static final String XSS_ALERT_ENCODED = "%22&gt;&lt;script&gt;alert(%27xss exploit%27)&lt;/script&gt;";
    private static final String XSS_RETURN_ATTACK_ENCODED = "javascript%3Aalert(%22owned%22)%3B";
    private static final String XSS_RETURN_ATTACK_RAW = "javascript:alert(\"owned\");";

    protected void setUpTest() {
        this.administration.restoreBlankInstance();
    }

    public void testXSSReturnUrl() {
        String issueKey = this.navigation.issue().createIssue("homosapien", null, "Test issue");
        this.navigation.issue().viewIssue(issueKey);
        this.tester.gotoPage("/secure/AddComment!default.jspa?id=10000&returnUrl=javascript%3Aalert(%22owned%22)%3B");
        String responseHtml = this.tester.getDialog().getResponseText();
        TestXSS.assertTrue((responseHtml.indexOf(XSS_RETURN_ATTACK_ENCODED) == -1 ? 1 : 0) != 0);
        TestXSS.assertTrue((responseHtml.indexOf(XSS_RETURN_ATTACK_RAW) == -1 ? 1 : 0) != 0);
    }

    public void testXSSReturnUrlInViewUserProfiles() {
        this.tester.gotoPage("/secure/admin/user/ViewUserProjectRoles!default.jspa?atl_token=AKJmt_DiLV&name=admin&returnUrl=javascript%3Aalert(%22owned%22)%3B");
        String responseHtml = this.tester.getDialog().getResponseText();
        this.assertReturnUrlEscaped(responseHtml);
    }

    public void testXSSFieldTypeInCreateCustomField() {
        this.tester.gotoPage("http://localhost:8090/jira/secure/admin/CreateCustomField.jspa?currentStep=1&global=true&&issuetypes=-1&fieldType=INJECT&searcher=&description=&fieldName=&nextBtn=Next+%3e%3e");
        this.assertions.getTextAssertions().assertTextNotPresent("INJECT");
    }

    public void testXSSPickers() {
        this.tester.gotoPage("/secure/popups/colorpicker.jsp?element=name;}catch%28e%29{}%0D%0A--%3E%3C/script%3E%3Cscript%3Ealert%28%27woot%27%29%3C/script%3E%3Cscript%3E%3C!--&defaultColor=%27;try{//");
        this.tester.assertTextPresent("&gt;&lt;/script&gt;&lt;script&gt;alert(&#39;woot&#39;)&lt;/script&gt;&lt;script&gt;&lt;!");
        this.tester.assertTextNotPresent("<script>alert('woot')</script>");
        this.tester.gotoPage("/secure/popups/colorpicker.jsp?defaultColor=<script>alert('boo');</script>");
        this.tester.assertTextPresent("&lt;script&gt;alert(&#39;boo&#39;);&lt;/script&gt;");
        this.tester.assertTextNotPresent("<script>alert('boo');</script>");
        this.tester.gotoPage("/secure/popups/UserPickerBrowser.jspa?formName=startform&multiSelect=true&element=<script>alert('doo');</script>");
        this.tester.assertTextPresent("&lt;script&gt;alert(&#39;doo&#39;);&lt;/script&gt;");
        this.tester.assertTextNotPresent("<script>alert('doo');</script>");
        this.tester.gotoPage("/secure/popups/GroupPickerBrowser.jspa?formName=startform&multiSelect=true&element=<script>alert('foo');</script>");
        this.tester.assertTextPresent("&lt;script&gt;alert(&#39;foo&#39;);&lt;/script&gt;");
        this.tester.assertTextNotPresent("<script>alert('foo');</script>");
        this.tester.gotoPage("/secure/Dashboard.jspa?announcement_preview_banner_st=<script>alert('foobar');</script>");
        this.tester.assertTextNotPresent("<script>alert('foobar');</script>");
        this.tester.gotoPage("/secure/views/runportleterror.jsp?portletKey=%3Cscript%3Ealert%28%27moosies%27%29%3C/script%3E");
        this.tester.assertTextNotPresent("&lt;script&gt;alert(&#39;moosies&#39;);&lt;/script&gt;");
        this.tester.assertTextNotPresent("<script>alert('moosies');</script>");
    }

    public void testXSSIconPicker() {
        this.tester.gotoPage("/secure/popups/IconPicker.jspa?fieldType=<script>alert('XSS');</script>&formName=jiraform");
        this.tester.assertTextPresent("&lt;script&gt;alert(&#39;XSS&#39;);&lt;/script&gt;");
        this.tester.assertTextNotPresent("<script>alert('XSS');</script>");
    }

    private String addXss(String url) {
        return url + XSS_ATTACK;
    }

    private void assertXssEscaped(String responseHtml) {
        TestXSS.assertTrue((boolean)responseHtml.contains(XSS_ALERT_ENCODED));
        TestXSS.assertFalse((boolean)responseHtml.contains(XSS_ALERT_RAW));
        TestXSS.assertFalse((boolean)responseHtml.contains(XSS_TAG));
    }

    private void assertReturnUrlEscaped(String responseHtml) {
        TestXSS.assertFalse((boolean)responseHtml.contains(XSS_RETURN_ATTACK_ENCODED));
        TestXSS.assertFalse((boolean)responseHtml.contains(XSS_RETURN_ATTACK_RAW));
    }
}

