/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.TableCellLocator;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import java.io.IOException;
import java.util.Calendar;
import java.util.Map;
import junit.framework.Assert;

public class TestUpgradeTask401
extends FuncTestCase {
    protected void setUpTest() {
        Calendar cal = Calendar.getInstance();
        cal.set(2008, 9, 29, 0, 0, 0);
        String fromDate = Long.toString(cal.getTimeInMillis());
        cal.set(2008, 9, 30, 0, 0, 0);
        String toDate = Long.toString(cal.getTimeInMillis());
        Map replacements = EasyMap.build((Object)"DATE_PARAM_FROM", (Object)fromDate, (Object)"DATE_PARAM_TO", (Object)toDate);
        try {
            this.administration.restoreDataWithReplacedTokens("TestUpgradeTask401.xml", replacements);
        }
        catch (IOException e) {
            Assert.fail((String)("Could not restore backup with replacement data: " + e.getMessage()));
        }
    }

    public void testUpgrade() {
        this.navigation.gotoAdminSection("view_custom_fields");
        this.tester.assertTextPresent("View Custom Fields");
        this.tester.assertTextNotPresent("Daffodil");
        this.tester.assertTextNotPresent("Cancer");
        this.tester.assertTextNotPresent("Council");
        this.navigation.gotoAdminSection("issue_field_columns");
        this.tester.assertTextPresent("Issue Navigator Default Columns");
        TableCellLocator locator = new TableCellLocator(this.tester, "issuetable", 0, 11);
        this.text.assertTextPresent(locator, "Resolved");
        this.text.assertTextNotPresent(locator, "Daffodil");
        this.text.assertTextNotPresent(locator, "Cancer");
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.assertTextPresent("Issue Navigator");
        this.tester.clickLinkWithText("Configure");
        this.tester.assertTextPresent("Issue Navigator Columns");
        this.text.assertTextSequence(new WebPageLocator(this.tester), "The table below shows issue fields in order of appearance in", "your", "Issue Navigator.");
        TableCellLocator locator2 = new TableCellLocator(this.tester, "issuetable", 0, 11);
        this.text.assertTextPresent(locator2, "Resolved");
        this.text.assertTextNotPresent(locator2, "Daffodil");
        this.text.assertTextNotPresent(locator2, "Cancer");
        this.navigation.logout();
        this.navigation.login("fred");
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.clickLink("managefilters");
        this.tester.clickLink("filterlink_10000");
        this.tester.assertTextPresent("Issue Navigator");
        this.tester.assertTextPresent("All homosapien issues");
        TableCellLocator locator3 = new TableCellLocator(this.tester, "issuetable", 0, 11);
        this.text.assertTextPresent(locator3, "Resolved");
        this.text.assertTextNotPresent(locator3, "Daffodil");
        this.text.assertTextNotPresent(locator3, "Cancer");
        this.navigation.logout();
        this.navigation.login("admin");
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.clickLink("managefilters");
        this.tester.clickLink("filterlink_10010");
        this.tester.assertTextPresent("All issues");
        this.tester.assertTextPresent("Issue Navigator");
        WebPageLocator locator4 = new WebPageLocator(this.tester);
        this.text.assertTextSequence(locator4, "Summary", "Resolved After", "Resolved Before", "Resolved", "From 1 week ago to 2 weeks from now", "Sorted by", "Key descending", "Operations");
        this.text.assertTextNotPresent(locator4, "Daffodil");
        this.text.assertTextNotPresent(locator4, "Cancer");
    }
}

