/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.util.env.EnvironmentUtils;
import com.opensymphony.util.FileUtils;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class TestEmptyStringDataRestore
extends FuncTestCase {
    public void testEmtpyStringRestore() throws IOException, ParserConfigurationException, SAXException, TransformerException {
        this.log("we must do something");
        this.log("this is something");
        this.log("therefore we must do this");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEmptyStringRestore() throws IOException, ParserConfigurationException, SAXException, TransformerException {
        boolean isOracle = new EnvironmentUtils(this.tester, this.getEnvironmentData(), this.navigation).isOracle();
        String importFileName = "TestEmptyStringDataRestore";
        String inFile = "TestEmptyStringDataRestore.xml";
        this.administration.restoreData("TestEmptyStringDataRestore.xml");
        File outFile = null;
        try {
            outFile = this.administration.exportDataToFile("TestEmptyStringDataRestore.xml_out.xml");
            outFile.deleteOnExit();
            String exportedFileString = FileUtils.readFile((File)outFile);
            Document doc = XMLUnit.buildControlDocument((String)exportedFileString);
            this.checkXpath("10002", "10000", "admin", "comment", "Comment3", doc);
            if (isOracle) {
                this.checkXpath("10001", "10000", "admin", "comment", null, doc);
            } else {
                this.checkXpath("10001", "10000", "admin", "comment", "", doc);
            }
            this.checkXpath("10000", "10000", "admin", "comment", null, doc);
        }
        finally {
            if (outFile != null) {
                outFile.delete();
            }
        }
    }

    private void checkXpath(String id, String issue, String author, String type, String body, Document doc) throws TransformerException {
        if (body == null) {
            String xpath = "//entity-engine-xml/Action[@id='" + id + "'][@issue='" + issue + "'][@author='" + author + "'][@type='" + type + "'][@body]";
            this.log("Searching for non-existence of xpath " + xpath);
            XMLAssert.assertXpathNotExists((String)xpath, (Document)doc);
            xpath = "//entity-engine-xml/Action[@id='" + id + "'][@issue='" + issue + "'][@author='" + author + "'][@type='" + type + "']";
            this.log("Searching for existence of xpath " + xpath);
            XMLAssert.assertXpathExists((String)xpath, (Document)doc);
        } else if (body.length() == 0) {
            String xpath = "//entity-engine-xml/Action[@id='" + id + "'][@issue='" + issue + "'][@author='" + author + "'][@type='" + type + "'][@body='']";
            this.log("Searching for existence of xpath " + xpath);
            XMLAssert.assertXpathExists((String)xpath, (Document)doc);
        } else {
            String xpath = "//entity-engine-xml/Action[@id='" + id + "'][@issue='" + issue + "'][@author='" + author + "'][@type='" + type + "'][@body='" + body + "']";
            this.log("Searching for existence of xpath " + xpath);
            XMLAssert.assertXpathExists((String)xpath, (Document)doc);
        }
    }
}

