/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.jira.webtests.JIRAWebTest;
import java.io.UnsupportedEncodingException;

public class TestDifferentEncodings
extends JIRAWebTest {
    public TestDifferentEncodings(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.restoreBlankInstance();
    }

    public void testNonASCIIGroupName() throws UnsupportedEncodingException {
        this.setJIRAEncoding("ISO-8859-1");
        this.assertCreateGroupEncodesCorrectly("J%FCrgen");
        this.setJIRAEncoding("UTF-8");
        this.assertCreateGroupEncodesCorrectly("J%C3%BCrgen");
    }

    private void assertCreateGroupEncodesCorrectly(String groupName) {
        this.gotoPage(this.page.addXsrfToken("/secure/admin/jira/GroupBrowser!add.jspa?addName=" + groupName));
        this.assertTextPresent("ViewGroup.jspa?atl_token=" + this.page.getXsrfToken() + "&amp;name=" + groupName);
    }

    private void setJIRAEncoding(String encoding) {
        this.gotoPage("/secure/admin/jira/EditApplicationProperties!default.jspa");
        this.setFormElement("encoding", encoding);
        this.submit();
    }
}

