/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.jira.webtests.JIRAWebTest;
import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.WebClient;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import net.sourceforge.jwebunit.TestContext;

public class Test500Page
extends JIRAWebTest {
    private boolean isBeforeJdk = false;

    public Test500Page(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.restoreData("Test500Page.xml");
        this.isBeforeJdk = this.isBeforeJdk15();
        this.gotoDashboard();
    }

    public void test500PageServiceParamVisibility() {
        this.login("admin", "admin");
        this.gotoPage("/500page.jsp");
        this.assertTextPresentBeforeText("ParamListeners", "com.atlassian.jira.event.listeners.DebugParamListener");
        this.assertTextPresentBeforeText("Param1:", "paramKey");
        this.assertTextPresentBeforeText("Param2:", "paramValue");
        this.assertServiceHeaderPresent("Pop Service", "com.atlassian.jira.service.services.pop.PopService", "123");
        this.assertTextPresentBeforeText("handler:", "Create Or Comment Handler");
        this.assertTextPresentBeforeText("popserver:", "fake server");
        this.assertTextPresentBeforeText("handler.params:", "project=hsp, issuetype=1, catchemail=sam@atlassian.com");
        this.assertTextPresentBeforeText("usessl:", "No SSL");
        this.assertTextPresentBeforeText("forwardEmail:", "fake@example.com");
        this.logout();
        this.gotoPage("/500page.jsp");
        this.assertTextPresentBeforeText("ParamListeners", "com.atlassian.jira.event.listeners.DebugParamListener");
        this.assertTextNotPresent("Param1:");
        this.assertTextNotPresent("paramKey");
        this.assertTextNotPresent("Param2:");
        this.assertTextNotPresent("paramValue");
        this.assertServiceHeaderPresent("Pop Service", "com.atlassian.jira.service.services.pop.PopService", "123");
        this.assertserviceParamsNotVisible();
        this.login("bob", "bob_password");
        this.gotoPage("/500page.jsp");
        this.assertTextPresentBeforeText("ParamListeners", "com.atlassian.jira.event.listeners.DebugParamListener");
        this.assertTextNotPresent("Param1:");
        this.assertTextNotPresent("paramKey");
        this.assertTextNotPresent("Param2:");
        this.assertTextNotPresent("paramValue");
        this.assertServiceHeaderPresent("Pop Service", "com.atlassian.jira.service.services.pop.PopService", "123");
        this.assertserviceParamsNotVisible();
    }

    public void test500PageContainsMemoryAndInputArgsInfo() {
        this.gotoPage("/500page.jsp");
        this.assertTextPresent("Used PermGen Memory");
        this.assertTextPresent("Free PermGen Memory");
        this.assertTextPresent("JVM Input Arguments");
        if (this.isBeforeJdk) {
            this.assertTextPresent("Unable to determine, this requires running JDK 1.5 and higher.");
        } else {
            this.assertTextNotPresent("Unable to determine, this requires running JDK 1.5 and higher.");
        }
    }

    public void testExternalUsermanagement() {
        this.gotoPage("/500page.jsp");
        this.assertTextPresent("External user management");
    }

    public void testHtmlEscapingOfErrors() throws Exception {
        String badHtml = "<body onload=alert('XSSATTACK')>";
        String badHtmlEscaped = "%3Cbody%20onload=alert('XSSATTACK')%3E";
        GetMethodWebRequest request = new GetMethodWebRequest(this.getEnvironmentData().getBaseUrl() + "/secure/Dashboard!default" + badHtmlEscaped + ".jspa");
        TestContext testContext = this.tester.getTestContext();
        WebClient webClient = testContext.getWebClient();
        webClient.setExceptionsThrownOnErrorStatus(false);
        WebResponse response = webClient.sendRequest((WebRequest)request);
        String responseText = response.getText();
        Test500Page.assertFalse((String)"Found bad HTML in the response", (responseText.indexOf(badHtml) >= 0 ? 1 : 0) != 0);
    }

    public void testAdministratorDoesntSeeContactYourAdmin() {
        this.gotoPage("/500page.jsp");
        this.assertTextNotPresent("If this problem persists - please notify your JIRA administrator of this problem.");
        this.assertTextSequence(new String[]{"try submitting this problem via the", "Support Request Page"});
    }

    public void testNonAdministratorSeesContactYourAdmin() {
        this.login("bob", "bob_password");
        this.gotoPage("/500page.jsp");
        this.assertTextPresent("If this problem persists - please notify your JIRA administrator of this problem.");
        this.assertTextNotPresent("try submitting this problem via the");
        this.assertTextNotPresent("Support Request Page");
    }

    public void testSystemAdministratorCanSeeSysAdminOnlyProperties() {
        this.gotoPage("/500page.jsp");
        this.assertTextNotPresent("Contact your System Administrator to discover file path information.");
        this.assertTextNotPresent("Contact your System Administrator to discover this property value.");
        this.assertTextSequence(new String[]{"Server ID", "ABN9-RZYJ-WI2T-37UF"});
        this.assertTextSequence(new String[]{"attach the application server log file (", "atlassian-jira.log", ")"});
        this.assertTextSequence(new String[]{"File Paths:", "entityengine.xml", "atlassian-jira.log"});
        this.assertTextPresent("JVM Input Arguments");
        if (!this.isBeforeJdk) {
            this.assertTextPresent("-D");
        }
        this.assertTextPresent("Current Working Directory");
    }

    public void testNonSystemAdministratorDoesntSeeFilePaths() {
        this.login("bob", "bob_password");
        this.gotoPage("/500page.jsp");
        this.assertTextNotPresent("attach the application server log file");
        this.assertTextNotPresent("atlassian-jira.log");
        this.assertTextSequence(new String[]{"Server ID", "Contact your Administrator to discover this property value.", "File Paths:", "Contact your System Administrator to discover file path information.", "Current Working Directory", "Contact your System Administrator to discover this property value.", "JVM Input Arguments", "Contact your System Administrator to discover this property value."});
        this.assertTextNotPresent("-Xmx");
        this.login("admin_non_sysadmin", "admin_non_sysadmin");
        this.gotoPage("/500page.jsp");
        this.assertTextSequence(new String[]{"Server ID", "ABN9-RZYJ-WI2T-37UF", "File Paths:", "Contact your System Administrator to discover file path information.", "Current Working Directory", "Contact your System Administrator to discover this property value.", "JVM Input Arguments", "Contact your System Administrator to discover this property value."});
        this.assertTextNotPresent("-Xmx");
    }

    private void assertServiceHeaderPresent(String serviceName, String serviceClass, String delay) {
        this.assertTextSequence(new String[]{"Services", serviceName, serviceClass, "Delay:", delay, "minutes"});
    }

    private void assertserviceParamsNotVisible() {
        this.assertTextNotPresent("handler:");
        this.assertTextNotPresent("Create Or Comment Handler");
        this.assertTextNotPresent("popserver:");
        this.assertTextNotPresent("fake server");
        this.assertTextNotPresent("handler.params:");
        this.assertTextNotPresent("project=hsp, issuetype=1, catchemail=sam@atlassian.com");
        this.assertTextNotPresent("usessl:");
        this.assertTextNotPresent("No SSL");
        this.assertTextNotPresent("forwardEmail:");
        this.assertTextNotPresent("fake@example.com");
    }
}

