/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.license;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.TableCellLocator;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;

public class TestPersonalLicense
extends FuncTestCase {
    protected void setUpTest() {
        this.administration.restoreBlankInstance();
    }

    public void testCreateIssueOverLicenseLimit() {
        this.administration.switchToPersonalLicense();
        this.tester.clickLink("create_link");
        this.tester.submit("Next");
        this.tester.setFormElement("summary", "A little bug");
        this.tester.submit("Create");
        this.tester.assertTextPresent("A little bug");
        this.tester.assertTextPresent("Details");
        this.administration.usersAndGroups().addUser("bob");
        this.tester.clickLink("create_link");
        this.tester.submit("Next");
        this.tester.setFormElement("summary", "This is a big one!");
        this.tester.submit("Create");
        this.tester.assertTextPresent("This is a big one!");
        this.tester.assertTextPresent("Details");
        this.administration.restoreData("TestPersonalLicenseTooManyUsers.xml");
        this.administration.switchToPersonalLicense();
        this.tester.clickLink("create_link");
        this.tester.assertTextPresent("You cannot create new issues at this time, as the user limit for JIRA has been exceeded. Please contact your JIRA administrators for further assistance.");
        String atlToken = this.page.getXsrfToken();
        this.tester.gotoPage("/secure/CreateIssueDetails.jspa?atl_token=" + atlToken);
        this.tester.assertTextPresent("You cannot create new issues at this time, as the user limit for JIRA has been exceeded. Please contact your JIRA administrators for further assistance.");
        this.tester.assertElementNotPresent("details-module");
        this.navigation.gotoAdmin();
        this.tester.clickLink("user_browser");
        this.tester.clickLink("editgroups_michael");
        this.tester.selectOption("groupsToLeave", "jira-users");
        this.tester.submit("leave");
        this.tester.clickLink("create_link");
        this.tester.submit("Next");
        this.tester.setFormElement("summary", "Let's create another bug!");
        this.tester.submit("Create");
        this.assertions.getTextAssertions().assertTextPresentHtmlEncoded("Let's create another bug!");
        this.tester.assertTextPresent("Details");
    }

    public void testAddUserOverLimitShowsWarning() {
        this.administration.switchToPersonalLicense();
        this.navigation.gotoAdminSection("user_browser");
        this.tester.clickLink("add_user");
        this.text.assertTextNotPresent(new WebPageLocator(this.tester), "Creating a new user will exceed the number of users allowed to use JIRA under your license.");
        this.tester.setFormElement("username", "devman");
        this.tester.setFormElement("password", "devman");
        this.tester.setFormElement("confirm", "devman");
        this.tester.setFormElement("fullname", "Devman");
        this.tester.setFormElement("email", "devman@example.com");
        this.tester.submit("Create");
        this.text.assertTextSequence(new WebPageLocator(this.tester), new String[]{"Groups:", "jira-users"});
        this.navigation.gotoAdminSection("user_browser");
        this.tester.clickLink("add_user");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "Creating a new user will exceed the number of users allowed to use JIRA under your license.");
        this.tester.setFormElement("username", "barney");
        this.tester.setFormElement("password", "barney");
        this.tester.setFormElement("confirm", "barney");
        this.tester.setFormElement("fullname", "Barney");
        this.tester.setFormElement("email", "barney@example.com");
        this.tester.submit("Create");
        this.text.assertTextNotPresent(new WebPageLocator(this.tester), "jira-users");
        this.navigation.logout();
        this.navigation.gotoDashboard();
        this.navigation.login("barney", "barney");
        this.tester.assertTextPresent("You do not have a permission to log in");
    }

    public void testDeleteUserClearsActiveUserCount() {
        this.administration.switchToPersonalLicense();
        this.navigation.gotoAdminSection("license_details");
        this.tester.assertTextPresent("2 currently active");
        this.administration.usersAndGroups().deleteUser("fred");
        this.navigation.gotoAdminSection("license_details");
        this.tester.assertTextPresent("1 currently active");
    }

    public void testModifyGlobalPermissionsShowsWarning() {
        this.administration.restoreData("TestPersonalLicenseGlobalPermissions.xml");
        this.administration.switchToPersonalLicense();
        this.navigation.gotoAdminSection("global_permissions");
        this.tester.assertTextPresent("Global Permissions");
        this.tester.assertTextPresent("These permissions apply to all projects. They are independent of project specific permissions.");
        this.tester.assertTextNotPresent("You have exceeded the number of users allowed to use JIRA under");
        this.administration.addGlobalPermission(1, "jira-developers");
        this.tester.assertTextPresent("You have exceeded the number of users allowed to use JIRA under");
        this.administration.removeGlobalPermission(1, "jira-developers");
        this.tester.assertTextNotPresent("You have exceeded the number of users allowed to use JIRA under");
    }

    public void testViewLicenseScreen() {
        String edition = this.administration.getEdition();
        this.navigation.gotoAdminSection("license_details");
        this.tester.assertTextPresent("License Information");
        this.tester.assertTextPresent("This page shows your current licensing information.");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "license_table", 0, 0), "Organisation");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "license_table", 0, 1), "Atlassian");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "license_table", 1, 0), "Date Purchased");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "license_table", 2, 0), "License Type");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "license_table", 2, 1), "JIRA " + edition + ": Commercial Server");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "license_table", 2, 1), "Support and updates available until");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "license_table", 3, 0), "Server ID");
        this.administration.switchToPersonalLicense();
        this.navigation.gotoAdminSection("license_details");
        this.tester.assertTextPresent("License Information");
        this.tester.assertTextPresent("This page shows your current licensing information.");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "license_table", 0, 0), "Organisation");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "license_table", 0, 1), "Atlassian");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "license_table", 1, 0), "Date Purchased");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "license_table", 2, 0), "License Type");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "license_table", 2, 1), "JIRA " + edition + ": Personal");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "license_table", 2, 1), "Updates available until");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "license_table", 3, 0), "Server ID");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "license_table", 4, 0), "Support Entitlement Number (SEN)");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "license_table", 5, 0), "User Limit");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "license_table", 5, 1), "3 (2 currently active)");
        this.tester.submit("Refresh");
        this.tester.assertTextPresent("License Information");
        this.tester.assertTextPresent("This page shows your current licensing information.");
    }

    public void testPersonalLicenseCannotSubmitSupportRequest() {
        String edition = this.administration.getEdition();
        this.administration.switchToPersonalLicense();
        this.navigation.gotoAdminSection("support_request");
        this.tester.assertTextPresent("Your license does not entitle you to support");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "Please note that your license (JIRA " + edition + ": Personal) does not entitle you to support.");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "If you are experiencing problems, please see the JIRA documentation, try our forums or consider purchasing a full license.");
        this.tester.gotoPage("/secure/admin/jira/JiraSupportRequest.jspa");
        this.tester.assertTextPresent("Support Request");
        this.tester.assertTextPresent("You can send a support request email here.");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "Please note that your license (JIRA " + edition + ": Personal) does not entitle you to support. If you are experiencing problems, please see the JIRA documentation, try our forums or consider purchasing a full license.");
    }

    public void testSignupOverLicenseLimit() {
        this.administration.switchToPersonalLicense();
        this.navigation.logout();
        this.tester.gotoPage("login.jsp");
        this.tester.clickLink("signup");
        this.tester.setFormElement("username", "devman");
        this.tester.setFormElement("password", "devman");
        this.tester.setFormElement("confirm", "devman");
        this.tester.setFormElement("fullname", "Devman");
        this.tester.setFormElement("email", "devman@example.com");
        this.tester.submit();
        this.tester.assertTextPresent("You have successfully signed up. If you forget your password, you can have it emailed to you.");
        this.tester.clickLinkWithText("Click here to log in");
        this.navigation.login("devman", "devman");
        XPathLocator anchorLocator = new XPathLocator(this.tester, "//div[@id='header-details-user']/a");
        this.text.assertTextPresent(anchorLocator, "Devman");
        this.navigation.logout();
        this.tester.gotoPage("login.jsp");
        this.tester.clickLink("signup");
        this.tester.assertTextPresent("You cannot sign up at this time, as the user limit for JIRA has been exceeded.");
        this.tester.gotoPage("/secure/Signup.jspa");
        this.tester.assertTextPresent("You cannot sign up at this time, as the user limit for JIRA has been exceeded.");
    }
}

