/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue.security.xsrf;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import org.apache.commons.lang.StringUtils;

public class TestXsrfSpecificLinks
extends FuncTestCase {
    protected void setUpTest() {
        this.administration.restoreData("TestXsrfSpecificLinks.xml");
    }

    public void testLinksThatShouldNOTHaveAtlTokens() {
        this.navigation.issue().gotoIssue("HSP-1");
        this.assertAnchorsDoNotHaveToken("//table[@id='outwardLinks_table']//a/@href");
        this.assertAnchorsDoNotHaveToken("//table[@id='inwardLinks_table']//a/@href");
        this.assertAnchorsDoNotHaveToken("//ul[@id='issue-tabs']//a/@href");
        this.navigation.browseProject("HSP");
        this.assertAnchorsDoNotHaveToken("//div[@id='main-content']//ul/li/a/@href");
        this.navigation.issueNavigator().createSearch("project=HSP");
        this.navigation.issueNavigator().createSearch("project=HSP and summary ~ fred");
        this.navigation.issueNavigator().createSearch("project=HSP and summary ~ bill");
        this.navigation.issueNavigator().gotoEditMode(IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.assertAnchorsDoNotHaveToken("//div[@id='jqlHistory']//ul/li/a/@href");
    }

    private void assertAnchorsDoNotHaveToken(String xPath) {
        String allHrefs = new XPathLocator(this.tester, xPath).getText();
        TestXsrfSpecificLinks.assertTrue((boolean)StringUtils.isNotBlank((String)allHrefs));
        this.text.assertTextNotPresent(allHrefs, "atl_token");
    }
}

