/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue.move;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.FuncTestHelperFactory;
import com.atlassian.jira.functest.framework.Navigation;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import net.sourceforge.jwebunit.WebTester;

public class TestMoveIssueAttachment
extends FuncTestCase {
    private String attachmentPath;

    protected void setUpTest() {
        this.administration.restoreData("TestMoveIssueAttachment.xml");
        this.administration.attachments().enable();
        this.attachmentPath = this.administration.getCurrentAttachmentPath();
    }

    public void testMoveSingleIssueSameWorkflow() throws Exception {
        this.installAttachedFile("AAAAAA");
        this.navigation.issue().viewIssue("RAT-1");
        this.tester.clickLinkWithText("info.txt");
        this.tester.assertTextPresent("AAAAAA");
        this.navigation.issue().viewIssue("RAT-1");
        this.tester.clickLink("move-issue");
        this.tester.selectOption("pid", "Bovine");
        this.tester.submit("Next >>");
        this.tester.submit("Next >>");
        this.tester.submit("Move");
        this.tester.clickLinkWithText("info.txt");
        this.tester.assertTextPresent("AAAAAA");
        File movedFile = new File(this.attachmentPath + "/COW/COW-15", "10010_info.txt");
        TestMoveIssueAttachment.assertTrue((boolean)movedFile.exists());
        this.deleteAttachment("COW-15");
        TestMoveIssueAttachment.assertFalse((boolean)movedFile.exists());
    }

    public void testMoveSingleIssueDifferentWorkflow() throws Exception {
        this.installAttachedFile("testMo");
        this.navigation.issue().viewIssue("RAT-1");
        this.tester.clickLink("move-issue");
        this.tester.assertTextPresent("Step 1 of 4");
        this.tester.selectOption("pid", "Canine");
        this.tester.submit("Next >>");
        this.tester.assertTextPresent("Step 3 of 4");
        this.tester.submit("Next >>");
        this.tester.assertTextPresent("Move Issue: Confirm");
        this.tester.submit("Move");
        this.tester.assertTextPresent("DOG-1");
        this.navigation.issue().viewIssue("DOG-1");
        this.tester.clickLinkWithText("info.txt");
        this.tester.assertTextPresent("testMo");
        File movedFile = new File(this.attachmentPath + "/DOG/DOG-1", "10010_info.txt");
        TestMoveIssueAttachment.assertTrue((boolean)movedFile.exists());
        this.deleteAttachment("DOG-1");
        TestMoveIssueAttachment.assertFalse((boolean)movedFile.exists());
    }

    public void testBulkMoveIssueSameWorkflow() throws Exception {
        this.installAttachedFile("testBu");
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.clickLink("bulkedit_all");
        this.tester.checkCheckbox("bulkedit_10000", "on");
        this.tester.submit("Next");
        this.tester.checkCheckbox("operation", "bulk.move.operation.name");
        this.tester.submit("Next");
        this.tester.selectOption("10000_1_pid", "Bovine");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.navigation.issue().viewIssue("COW-15");
        this.tester.clickLinkWithText("info.txt");
        this.tester.assertTextPresent("testBu");
        File movedFile = new File(this.attachmentPath + "/COW/COW-15", "10010_info.txt");
        TestMoveIssueAttachment.assertTrue((boolean)movedFile.exists());
        this.deleteAttachment("COW-15");
        TestMoveIssueAttachment.assertFalse((boolean)movedFile.exists());
    }

    public void testBulkMoveIssueDifferentWorkflow() throws Exception {
        this.installAttachedFile("testBu");
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.clickLink("bulkedit_all");
        this.tester.checkCheckbox("bulkedit_10000", "on");
        this.tester.submit("Next");
        this.tester.checkCheckbox("operation", "bulk.move.operation.name");
        this.tester.submit("Next");
        this.tester.selectOption("10000_1_pid", "Canine");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.navigation.issue().viewIssue("DOG-1");
        this.tester.clickLinkWithText("info.txt");
        this.tester.assertTextPresent("testBu");
        File movedFile = new File(this.attachmentPath + "/DOG/DOG-1", "10010_info.txt");
        TestMoveIssueAttachment.assertTrue((boolean)movedFile.exists());
        this.deleteAttachment("DOG-1");
        TestMoveIssueAttachment.assertFalse((boolean)movedFile.exists());
    }

    public void testMoveSingleIssueTwoUsers() throws Exception {
        this.installAttachedFile("WWWWww");
        FuncTestHelperFactory funcTestHelperFactory2 = new FuncTestHelperFactory(this, this.getEnvironmentData());
        WebTester tester2 = funcTestHelperFactory2.getTester();
        Navigation navigation2 = funcTestHelperFactory2.getNavigation();
        this.navigation.issue().viewIssue("RAT-1");
        this.tester.clickLink("move-issue");
        navigation2.issue().viewIssue("RAT-1");
        tester2.clickLink("move-issue");
        this.tester.selectOption("pid", "Bovine");
        this.tester.submit("Next >>");
        this.tester.assertTextPresent("Step 3 of 4");
        this.tester.submit("Next >>");
        tester2.selectOption("pid", "Canine");
        tester2.submit("Next >>");
        tester2.assertTextPresent("Step 3 of 4");
        tester2.submit("Next >>");
        tester2.assertTextPresent("Move Issue: Confirm");
        tester2.submit("Move");
        tester2.assertTextPresent("DOG-1");
        tester2.clickLinkWithText("info.txt");
        tester2.assertTextPresent("WWWWww");
        this.tester.assertTextPresent("Move Issue: Confirm");
        this.tester.submit("Move");
        this.tester.assertTextPresent("Move Issue: Confirm");
        this.tester.assertTextPresent("Cannot move Issue RAT-1 because it has already been moved to DOG-1.");
        File movedFile = new File(this.attachmentPath + "/DOG/DOG-1", "10010_info.txt");
        TestMoveIssueAttachment.assertTrue((boolean)movedFile.exists());
        this.deleteAttachment("DOG-1");
        TestMoveIssueAttachment.assertFalse((boolean)movedFile.exists());
    }

    public void testBulkMoveIssueTwoUsers() throws Exception {
        this.installAttachedFile("JJJJJJ");
        FuncTestHelperFactory funcTestHelperFactory2 = new FuncTestHelperFactory(this, this.getEnvironmentData());
        WebTester tester2 = funcTestHelperFactory2.getTester();
        Navigation navigation2 = funcTestHelperFactory2.getNavigation();
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.clickLink("bulkedit_all");
        this.tester.assertTextPresent("Bulk Operation: Choose Issues");
        this.tester.checkCheckbox("bulkedit_10000", "on");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Bulk Operation: Choose Operation");
        this.tester.checkCheckbox("operation", "bulk.move.operation.name");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Move Issues: Select Projects and Issue Types");
        this.tester.selectOption("10000_1_pid", "Canine");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Update Fields for Target Project 'Canine' - Issue Type 'Bug'");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Move Issues: Confirmation");
        navigation2.issueNavigator().displayAllIssues();
        tester2.clickLink("bulkedit_all");
        tester2.assertTextPresent("Bulk Operation: Choose Issues");
        tester2.checkCheckbox("bulkedit_10000", "on");
        tester2.submit("Next");
        tester2.assertTextPresent("Bulk Operation: Choose Operation");
        tester2.checkCheckbox("operation", "bulk.move.operation.name");
        tester2.submit("Next");
        tester2.assertTextPresent("Move Issues: Select Projects and Issue Types");
        tester2.selectOption("10000_1_pid", "Bovine");
        tester2.submit("Next");
        tester2.assertTextPresent("Update Fields for Target Project 'Bovine' - Issue Type 'Bug'");
        tester2.submit("Next");
        tester2.assertTextPresent("Move Issues: Confirmation");
        tester2.submit("Next");
        tester2.assertTextPresent("Issue Navigator");
        navigation2.issue().viewIssue("COW-15");
        tester2.clickLinkWithText("info.txt");
        tester2.assertTextPresent("JJJJJJ");
        File movedFile = new File(this.attachmentPath + "/COW/COW-15", "10010_info.txt");
        TestMoveIssueAttachment.assertTrue((boolean)movedFile.exists());
        this.tester.submit("Next");
        this.tester.assertTextPresent("Move Issues: Confirmation");
        this.tester.assertTextPresent("At least one of the issues you are trying to move has been recently moved by another user (RAT-1). Please cancel and start again.");
        movedFile = new File(this.attachmentPath + "/COW/COW-15", "10010_info.txt");
        TestMoveIssueAttachment.assertTrue((boolean)movedFile.exists());
        this.deleteAttachment("COW-15");
        TestMoveIssueAttachment.assertFalse((boolean)movedFile.exists());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String installAttachedFile(String contents) throws IOException {
        File attachedFile = new File(this.attachmentPath + "/RAT/RAT-1", "10010_info.txt");
        attachedFile.getParentFile().mkdirs();
        PrintWriter out = new PrintWriter(new FileWriter(attachedFile));
        try {
            out.println(contents);
        }
        finally {
            out.close();
        }
        return this.attachmentPath;
    }

    private void deleteAttachment(String issueKey) {
        this.navigation.issue().viewIssue(issueKey);
        this.tester.clickLink("manage-attachment-link");
        this.tester.clickLink("del_10010");
        this.tester.submit("Delete");
    }
}

