/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.locator.Locator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.webtests.JIRAWebTest;
import com.meterware.httpunit.TableCell;
import com.meterware.httpunit.WebTable;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Node;

public class TestViewIssue
extends JIRAWebTest {
    private static final String IMAGE_ATTACHMENT_NAME = "picture-attachment.jpg";
    private static final String CLASSNAME_SUBTASK_PERCENTAGE_CELL = "nav progress";

    public TestViewIssue(String name) {
        super(name);
    }

    public void testSpeed() {
        this.administration.restoreBlankInstance();
    }

    public void testViewIssuePageWithInvalidAssigneeAndReporters() {
        this.restoreData("TestViewIssueWithInvalidUsersProEnt.xml");
        this.administration.attachments().enable();
        this._testViewIssuePageWithInvalidAssigneeAndReportersStandard();
        this._testViewIssuePageWithInvalidAssigneeAndReportersProEnt();
    }

    public void testEditedCommentVisibleWithDoubleQuotesInDateFormat() {
        this.restoreData("TestEditedCommentAndWorklogWithMalformedDateFormat.xml");
        this.gotoIssueTabPanel("HSP-1", "Comments");
        this.assertTextPresentBeforeText("this comment is edited", "this comment will not be edited");
        this.assertTextPresent("title=\"Administrator - 24/Jul/07 09:47 AM&quot; \"");
        this.assertTextNotPresent("25/Jul/07 09:48 AM&quot; ");
        this.gotoIssueTabPanel("HSP-1", "Work Log");
        this.assertTextPresentBeforeText("this work log is edited", "this work log will not be edited");
        this.assertTextPresent("title=\"Administrator - 18/Jul/07 09:42 AM&quot; \"");
        this.assertTextNotPresent("18/Jul/07 09:43 AM&quot; ");
    }

    private void _testViewIssuePageWithInvalidAssigneeAndReportersStandard() {
        this.gotoIssue("HSP-1");
        this.assertTextPresent("Issue with valid user");
        IdLocator locator = new IdLocator(this.tester, "assignee-val");
        this.text.assertTextPresent(locator, "Administrator");
        locator = new IdLocator(this.tester, "reporter-val");
        this.text.assertTextPresent(locator, "Administrator");
        this.text.assertTextPresent(new XPathLocator(this.tester, "//dd[@id='customfield_10000-val']/preceding-sibling::dt[1]"), "Custom User Picker");
        this.assertions.getLinkAssertions().assertLinkAtNodeEndsWith("//dd[@id='customfield_10000-val']//a", "/secure/ViewProfile.jspa?name=admin");
        this.text.assertTextPresent(new XPathLocator(this.tester, "//dd[@id='customfield_10000-val']"), "Administrator");
        this.text.assertTextPresent(new XPathLocator(this.tester, "//dd[@id='customfield_10001-val']/preceding-sibling::dt[1]"), "Custom Multi User Picker");
        this.assertions.getLinkAssertions().assertLinkAtNodeEndsWith("//dd[@id='customfield_10001-val']//a", "/secure/ViewProfile.jspa?name=admin");
        this.text.assertTextPresent(new XPathLocator(this.tester, "//dd[@id='customfield_10001-val']"), "Administrator");
        this.assertLinkPresentWithText("Stop Progress");
        this.assertLinkPresentWithText("Resolve Issue");
        this.assertLinkPresentWithText("Close Issue");
        this.assertLinkPresentWithText("Assign");
        this.assertLinkPresentWithText("Attach file");
        this.assertLinkPresentWithText("Clone");
        this.assertLinkPresentWithText("Comment");
        this.assertLinkPresentWithText("Delete");
        this.assertLinkPresentWithText("Edit");
        this.assertLinkPresent("view-voters");
        this.assertLinkPresent("manage-watchers");
        this.assertLinkPresentWithText("Log work");
        this.gotoIssue("HSP-2");
        this.assertTextPresent("Issue with invalid users");
        this.text.assertTextPresent(new IdLocator(this.tester, "assignee-val"), "deletedassignee");
        this.text.assertTextPresent(new IdLocator(this.tester, "reporter-val"), "deletedreporter");
        this.assertElementNotPresent("customfield_10000-val");
        this.assertElementPresent("customfield_10001-val");
        this.assertions.assertNodeDoesNotExist("//dd[@id='customfield_10001-val']//a");
        this.assertLinkNotPresentWithText("Stop Progress");
        this.assertLinkPresentWithText("Resolve Issue");
        this.assertLinkPresentWithText("Close Issue");
        this.assertLinkPresentWithText("Assign");
        this.assertLinkPresentWithText("Attach file");
        this.assertLinkPresentWithText("Clone");
        this.assertLinkPresentWithText("Comment");
        this.assertLinkPresentWithText("Delete");
        this.assertLinkPresentWithText("Edit");
        this.assertLinkPresent("view-voters");
        this.assertLinkPresent("manage-watchers");
        this.assertLinkPresentWithText("Log work");
    }

    private void _testViewIssuePageWithInvalidAssigneeAndReportersProEnt() {
        this.gotoIssue("HSP-2");
        this.assertLinkPresentWithText("sub-task");
        this.assertLinkPresentWithText("Sub task with invalid user");
        this.gotoIssue("HSP-3");
        this.assertTextPresent("Sub task with invalid user");
        this.text.assertTextPresent(new IdLocator(this.tester, "assignee-val"), "deletedsubtaskuser");
        this.text.assertTextPresent(new IdLocator(this.tester, "reporter-val"), "deletedsubtaskuser");
        this.assertElementNotPresent("customfield_10000-val");
        this.assertElementPresent("customfield_10001-val");
        this.assertions.assertNodeDoesNotExist("//dd[@id='customfield_10001-val']//a");
        this.assertLinkNotPresentWithText("Stop Progress");
        this.assertLinkPresentWithText("Resolve Issue");
        this.assertLinkPresentWithText("Close Issue");
        this.assertLinkPresentWithText("Assign");
        this.assertLinkPresentWithText("Attach file");
        this.assertLinkPresentWithText("Clone");
        this.assertLinkPresentWithText("Comment");
        this.assertLinkPresentWithText("Delete");
        this.assertLinkPresentWithText("Edit");
        this.assertLinkPresent("view-voters");
        this.assertLinkPresent("manage-watchers");
        this.assertLinkPresentWithText("Log work");
    }

    public void testSubtaskPercentageGraphPresence() {
        this.restoreBlankInstance();
        this.activateSubTasks();
        this.activateTimeTracking();
        String parentKey = this.addIssue("monkey", "MKY", "Bug", "bonobo");
        String sub1Key = this.addSubTaskToIssue(parentKey, "Sub-task", "sub1", "subdesc1");
        this.gotoIssue(parentKey);
        TestViewIssue.assertFalse((boolean)this.isSubtaskPercentageGraphPresent());
        this.addSubTaskToIssue(parentKey, "Sub-task", "sub2", "subdesc2");
        this.gotoIssue(parentKey);
        TestViewIssue.assertFalse((boolean)this.isSubtaskPercentageGraphPresent());
        this.gotoIssue(sub1Key);
        this.setEstimate("1m");
        this.gotoIssue(parentKey);
        TestViewIssue.assertTrue((boolean)this.isSubtaskPercentageGraphPresent());
        this.logWork(sub1Key, "1m", "1m");
        this.clickLink("parent_issue_summary");
        TestViewIssue.assertTrue((boolean)this.isSubtaskPercentageGraphPresent());
        this.assertTextPresent("50%");
        this.enableDeleteAllWorklogInDefaultPermissionScheme("jira-administrators");
        this.gotoIssue(sub1Key);
        if (this.getDialog().isLinkPresentWithText("Work Log")) {
            this.clickLinkWithText("Work Log");
        }
        this.clickLink("delete_worklog_10000");
        this.submit("Delete");
        this.gotoIssue(parentKey);
        TestViewIssue.assertTrue((String)"Expected to still see graph after worklog deletion, original estimate remains", (boolean)this.isSubtaskPercentageGraphPresent());
    }

    public void testProjectCFNotLinkedWithNoPermission() {
        this.restoreData("TestProjectCFWithNoPermission.xml");
        this.login("fred");
        this.gotoIssue("HSP-2");
        this.assertLinkWithTextExists("homosapien");
        this.gotoIssue("HSP-1");
        this.assertLinkWithTextNotPresent("monkey");
        this.assertTextPresent("monkey");
        this.login("admin");
        this.gotoIssue("HSP-1");
        this.assertLinkWithTextExists("monkey");
    }

    public void testComponentOrdering() {
        this.restoreBlankInstance();
        TestViewIssue.log("Testing ordering for components field");
        this.tester.clickLink("create_link");
        this.tester.submit("Next");
        this.tester.setFormElement("summary", "Test issue");
        this.selectMultiOption("components", "New Component 1");
        this.selectMultiOption("components", "New Component 3");
        this.tester.submit("Create");
        this.assertTextSequence(new String[]{"Component/s", "New Component 1", "New Component 3"});
        this.tester.clickLink("editIssue");
        this.tester.setWorkingForm("issue-edit");
        this.selectMultiOption("components", "New Component 2");
        this.selectMultiOption("components", "New Component 3");
        this.tester.submit("Update");
        this.assertTextSequence(new String[]{"Component/s", "New Component 2", "New Component 3"});
        this.tester.clickLink("editIssue");
        this.tester.setWorkingForm("issue-edit");
        this.selectMultiOption("components", "New Component 1");
        this.selectMultiOption("components", "New Component 2");
        this.tester.submit("Update");
        this.assertTextSequence(new String[]{"Component/s", "New Component 1", "New Component 2"});
        this.tester.clickLink("editIssue");
        this.tester.setWorkingForm("issue-edit");
        this.selectMultiOption("components", "New Component 1");
        this.selectMultiOption("components", "New Component 2");
        this.selectMultiOption("components", "New Component 3");
        this.tester.submit("Update");
        this.assertTextSequence(new String[]{"Component/s", "New Component 1", "New Component 2", "New Component 3"});
    }

    public void testVersionOrdering() {
        this.restoreBlankInstance();
        String[] versionFields = new String[]{"versions", "fixVersions"};
        String[] versionFieldNames = new String[]{"Affects Version/s", "Fix Version/s"};
        for (int i = 0; i < versionFields.length; ++i) {
            String versionField = versionFields[i];
            String versionFieldName = versionFieldNames[i];
            TestViewIssue.log("Testing ordering for versions field '" + versionField + "'");
            this.tester.clickLink("create_link");
            this.tester.submit("Next");
            this.tester.setFormElement("summary", "Test issue");
            this.selectMultiOption(versionField, "New Version 1");
            this.selectMultiOption(versionField, "New Version 5");
            this.tester.submit("Create");
            this.assertTextSequence(new String[]{versionFieldName, "New Version 1", "New Version 5"});
            this.tester.clickLink("editIssue");
            this.tester.setWorkingForm("issue-edit");
            this.selectMultiOption(versionField, "New Version 4");
            this.selectMultiOption(versionField, "New Version 5");
            this.tester.submit("Update");
            this.assertTextSequence(new String[]{versionFieldName, "New Version 4", "New Version 5"});
            this.tester.clickLink("editIssue");
            this.tester.setWorkingForm("issue-edit");
            this.selectMultiOption(versionField, "New Version 1");
            this.selectMultiOption(versionField, "New Version 4");
            this.tester.submit("Update");
            this.assertTextSequence(new String[]{versionFieldName, "New Version 1", "New Version 4"});
            this.tester.clickLink("editIssue");
            this.tester.setWorkingForm("issue-edit");
            this.selectMultiOption(versionField, "New Version 1");
            this.selectMultiOption(versionField, "New Version 4");
            this.selectMultiOption(versionField, "New Version 5");
            this.tester.submit("Update");
            this.assertTextSequence(new String[]{versionFieldName, "New Version 1", "New Version 4", "New Version 5"});
        }
    }

    public void testFieldTabs() throws Exception {
        this.restoreData("TestIssueFields.xml");
        this.gotoIssue("HSP-1");
        this.assertElementNotPresent("customfieldmodule");
        this.gotoIssue("HSP-2");
        this.assertElementPresent("customfieldmodule");
        this.assertElementNotPresent("tabCell1");
        this.text.assertTextPresent(new IdLocator(this.tester, "customfield_10001-val"), "Tab2CF");
        this.gotoIssue("HSP-3");
        this.assertElementPresent("customfieldmodule");
        this.text.assertTextPresent(new IdLocator(this.tester, "tabCell1"), "Tab1");
        this.text.assertTextPresent(this.createCFValueLocator("tabCellPane1", 10000), "Tab1CF");
        this.text.assertTextPresent(new IdLocator(this.tester, "tabCell2"), "Tab2");
        this.text.assertTextPresent(this.createCFValueLocator("tabCellPane2", 10001), "Tab2CF");
    }

    public void testDateCustomFieldTabs() throws Exception {
        this.restoreData("TestIssueFields.xml");
        this.gotoIssue("HSP-3");
        this.assertions.assertNodeDoesNotExist("//*[@id='datesmodule']//*[contains(@id, 'customfield')]");
        this.gotoIssue("HSP-4");
        this.assertElementNotPresent("customfieldmodule");
        this.text.assertTextSequence(new IdLocator(this.tester, "datesmodule"), "DateCFTab2", "26/Jan/10");
        this.gotoIssue("HSP-5");
        this.assertElementNotPresent("customfieldmodule");
        this.text.assertTextSequence(new IdLocator(this.tester, "datesmodule"), "DateTimeCFTab1", "03/Jan/10", "DateTimeCFTab2", "29/Jan/10");
        this.gotoIssue("HSP-6");
        this.assertElementPresent("customfieldmodule");
        this.text.assertTextPresent(new IdLocator(this.tester, "tabCell1"), "Tab1");
        this.text.assertTextPresent(this.createCFValueLocator("tabCellPane1", 10000), "Tab1CF");
        this.text.assertTextPresent(new IdLocator(this.tester, "tabCell2"), "Tab2");
        this.text.assertTextPresent(this.createCFValueLocator("tabCellPane2", 10001), "Tab2CF");
        this.text.assertTextSequence(new IdLocator(this.tester, "datesmodule"), "DateTimeCFTab1", "04/Jan/10", "DateTimeCFTab2", "12/Jan/10", "DateCFTab2", "19/Jan/10");
    }

    public void testUserCustomFieldTabs() throws Exception {
        this.restoreData("TestIssueFields.xml");
        this.gotoIssue("HSP-3");
        this.assertions.assertNodeDoesNotExist("//*[@id='peopledetails']//*[contains(@id, 'customfield')]");
        this.gotoIssue("HSP-7");
        this.assertElementNotPresent("customfieldmodule");
        this.text.assertTextSequence(new IdLocator(this.tester, "peopledetails"), "UserPickerCF", "Administrator");
        this.assertLinks("//*[@id='customfield_10020-val']//a/@href", "secure/ViewProfile.jspa?name=admin");
        this.gotoIssue("HSP-8");
        this.assertElementPresent("customfieldmodule");
        this.text.assertTextPresent(new IdLocator(this.tester, "tabCell1"), "Tab1");
        this.text.assertTextPresent(this.createCFValueLocator("tabCellPane1", 10000), "Tab1CF");
        this.text.assertTextPresent(new IdLocator(this.tester, "tabCell2"), "Tab2");
        this.text.assertTextPresent(this.createCFValueLocator("tabCellPane2", 10001), "Tab2CF");
        this.text.assertTextSequence(new IdLocator(this.tester, "peopledetails"), "UserPickerCF", "Administrator", "MultiGroupPickerCF", "jira-developers", "jira-users", "GroupPickerCF", "jira-administrators", "MultiUserPickerCF", "Administrator", "Fred Normal");
        this.assertLinks("//*[@id='customfield_10020-val']//a/@href", "secure/ViewProfile.jspa?name=admin");
        this.assertLinks("//*[@id='customfield_10022-val']//a/@href", "secure/admin/user/ViewGroup.jspa?name=jira-developers", "secure/admin/user/ViewGroup.jspa?name=jira-users");
        this.assertLinks("//*[@id='customfield_10021-val']//a/@href", "secure/admin/user/ViewGroup.jspa?name=jira-administrators");
        this.assertLinks("//*[@id='customfield_10023-val']//a/@href", "secure/ViewProfile.jspa?name=admin", "secure/ViewProfile.jspa?name=fred");
    }

    public void testXssInImageUrls() throws Exception {
        this.administration.restoreData("TestImageUrlXss.xml");
        this.navigation.issue().gotoIssue("HSP-1");
        this.tester.assertTextNotPresent("\"'/><script>alert('statuzz');</script>");
        this.tester.assertTextPresent("&quot;'/&gt;&lt;script&gt;alert('statuzz');&lt;/script&gt;");
        this.tester.assertTextNotPresent("\"'/><script>alert('prioritiezz');</script>");
        this.tester.assertTextPresent("&quot;'/&gt;&lt;script&gt;alert('prioritiezz');&lt;/script&gt;");
        this.tester.assertTextNotPresent("\"'/><script>alert('issue typezz');</script>");
        this.tester.assertTextPresent("&quot;'/&gt;&lt;script&gt;alert('issue typezz');&lt;/script&gt;");
    }

    private void assertLinks(String xPath, String ... urls) {
        XPathLocator locator = new XPathLocator(this.tester, xPath);
        Node[] nodes = locator.getNodes();
        TestViewIssue.assertEquals((String)String.format("Expected number of links %d but there where %d links.", urls.length, nodes.length), (int)urls.length, (int)nodes.length);
        for (int i = 0; i < urls.length; ++i) {
            String url = nodes[i].getNodeValue();
            TestViewIssue.assertFalse((String)String.format("URL[%d] is blank.", i), (boolean)StringUtils.isBlank((String)url));
            TestViewIssue.assertTrue((String)String.format("The actual URL '%s' does not contain '%s'.", url, urls[i]), (boolean)url.contains(urls[i]));
        }
    }

    private Locator createCFValueLocator(String tab, int id) {
        return new XPathLocator(this.tester, String.format("//*[@id='%s']//*[@id='customfield_%d-val']", tab, id));
    }

    private void enableDeleteAllWorklogInDefaultPermissionScheme(String groupName) {
        TestViewIssue.log("enabling delete all worklog deletion in default permission scheme for group " + groupName);
        this.gotoAdmin();
        this.clickLink("permission_schemes");
        this.clickLink("0_edit");
        this.clickLink("add_perm_43");
        this.checkCheckbox("type", "group");
        this.selectOption("group", groupName);
        this.submit(" Add ");
    }

    private boolean isSubtaskPercentageGraphPresent() {
        WebTable issueSummary = this.getDialog().getWebTableBySummaryOrId("issuetable");
        TableCell percentageCell = issueSummary.getTableCell(0, 5);
        return CLASSNAME_SUBTASK_PERCENTAGE_CELL.equals(percentageCell.getClassName());
    }
}

