/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.changehistory.ChangeHistoryList;
import com.atlassian.jira.functest.framework.changehistory.ChangeHistoryParser;
import com.atlassian.jira.functest.framework.labels.Labels;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.locator.TableLocator;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.functest.framework.util.form.FormParameterUtil;
import com.atlassian.jira.util.collect.MapBuilder;
import java.io.IOException;
import java.util.Map;
import org.xml.sax.SAXException;

public class TestLabels
extends FuncTestCase {
    public void testSearching() {
        this.administration.restoreData("TestLabels.xml");
        this._testSearching("labels", "labels", "Labels");
    }

    public void testCustomFieldSearching() {
        this.administration.restoreData("TestLabels.xml");
        this._testSearching("customfield_10000", "Epic", "Epic");
    }

    public void testNoEditWhenClosed() throws Exception {
        this.administration.restoreData("TestLabels.xml");
        this.navigation.issue().closeIssue("HSP-1", "Fixed", "closing for testing purposes");
        this.navigation.issue().gotoIssue("HSP-1");
        this.assertions.assertNodeDoesNotExist("//*[contains(@class, 'edit-labels')]");
        this.navigation.issueNavigator().createSearch("key = \"HSP-1\"");
        this.assertions.assertNodeDoesNotExist("id('labels-10001-value')//*[contains(@class, 'edit-labels')]");
        this.assertions.assertNodeDoesNotExist("id('customfield_10000-10001-value')//*[contains(@class, 'edit-labels')]");
    }

    public void testProjectTabPanel() {
        this.administration.restoreData("TestLabelsProjectTabPanel.xml");
        this.navigation.gotoPage("/browse/HSP?selectedTab=com.atlassian.jira.plugin.system.project%3Alabels-heatmap-panel");
        this.tester.assertLinkNotPresentWithText("Popular Labels");
        this.tester.assertLinkNotPresentWithText("alphabetically");
        this.tester.assertLinkPresentWithText("All Labels");
        this.tester.assertLinkPresentWithText("Epic");
        this.tester.assertLinkPresentWithText("Stuff");
        this.tester.assertLinkPresentWithText("popularity");
        WebPageLocator locator = new WebPageLocator(this.tester);
        this.text.assertTextPresent(locator, "Popular Labels");
        this.text.assertTextPresent(locator, "Labels");
        this.text.assertTextPresent(locator, "alphabetically");
        this.text.assertTextPresent(locator, "Below are the 8 most popular labels. The bigger the text, the more popular the label. Click on a label to see its associated content.");
        this.text.assertTextSequence(locator, "aa", "bb", "cc", "dd", "duck", "duffy", "mickey", "mouse");
        this.navigation.gotoPage("/browse/HSP?selectedTab=com.atlassian.jira.plugin.system.project:labels-heatmap-panel&labels.order=pop&selected.field=labels");
        this.tester.assertLinkNotPresentWithText("Popular Labels");
        this.tester.assertLinkNotPresentWithText("popularity");
        this.tester.assertLinkPresentWithText("All Labels");
        this.tester.assertLinkPresentWithText("Epic");
        this.tester.assertLinkPresentWithText("Stuff");
        this.tester.assertLinkPresentWithText("alphabetically");
        locator = new WebPageLocator(this.tester);
        this.text.assertTextPresent(locator, "Popular Labels");
        this.text.assertTextPresent(locator, "Labels");
        this.text.assertTextPresent(locator, "popularity");
        this.text.assertTextPresent(locator, "Below are the 8 most popular labels. The bigger the text, the more popular the label. Click on a label to see its associated content.");
        this.text.assertTextSequence(locator, "mouse", "mickey", "duffy", "duck", "dd", "cc", "bb", "aa");
        this.navigation.gotoPage("/browse/HSP?selectedTab=com.atlassian.jira.plugin.system.project:labels-heatmap-panel&labels.view=popular&selected.field=customfield_10031&labels.order=pop");
        this.tester.assertLinkNotPresentWithText("Popular Labels");
        this.tester.assertLinkNotPresentWithText("popularity");
        this.tester.assertLinkNotPresentWithText("Epic");
        this.tester.assertLinkPresentWithText("All Labels");
        this.tester.assertLinkPresentWithText("Stuff");
        this.tester.assertLinkPresentWithText("alphabetically");
        locator = new WebPageLocator(this.tester);
        this.text.assertTextPresent(locator, "Popular Labels");
        this.text.assertTextPresent(locator, "Labels");
        this.text.assertTextPresent(locator, "Epic");
        this.text.assertTextPresent(locator, "popularity");
        this.text.assertTextPresent(locator, "Below are the 4 most popular labels. The bigger the text, the more popular the label. Click on a label to see its associated content.");
        this.text.assertTextSequence(locator, "monroe", "marylyn", "lewis", "john");
        this.navigation.gotoPage("/browse/HSP?selectedTab=com.atlassian.jira.plugin.system.project:labels-heatmap-panel&labels.view=popular&selected.field=customfield_10033&labels.order=pop");
        this.tester.assertLinkNotPresentWithText("Popular Labels");
        this.tester.assertLinkNotPresentWithText("Stuff");
        this.tester.assertLinkPresentWithText("All Labels");
        this.tester.assertLinkPresentWithText("Epic");
        locator = new WebPageLocator(this.tester);
        this.text.assertTextPresent(locator, "Popular Labels");
        this.text.assertTextPresent(locator, "Stuff");
        this.text.assertTextPresent(locator, "No Labels Found.");
        this.navigation.gotoPage("/browse/HSP?selectedTab=com.atlassian.jira.plugin.system.project:labels-heatmap-panel&labels.view=all&selected.field=customfield_10031");
        this.tester.assertLinkNotPresentWithText("All Labels");
        this.tester.assertLinkNotPresentWithText("Epic");
        this.tester.assertLinkPresentWithText("Popular Labels");
        this.tester.assertLinkPresentWithText("Stuff");
        this.tester.assertLinkPresentWithText("Labels");
        locator = new WebPageLocator(this.tester);
        this.text.assertTextPresent(locator, "All Labels");
        this.text.assertTextPresent(locator, "Labels");
        this.text.assertTextPresent(locator, "Below are the 4 most recently used labels, listed alphabetically. Click on a label to see its associated content.");
        this.text.assertTextSequence(locator, "A-Z", "john", "lewis", "marylyn", "monroe");
        this.navigation.gotoPage("/browse/HSP?selectedTab=com.atlassian.jira.plugin.system.project:labels-heatmap-panel&labels.view=all&selected.field=customfield_10033");
        locator = new WebPageLocator(this.tester);
        this.text.assertTextPresent(locator, "No Labels Found.");
    }

    private void _testSearching(String fieldId, String field, String fieldName) {
        this.navigation.issueNavigator().createSearch(field + " in (aa, TeSt)");
        TableLocator locator = new TableLocator(this.tester, "issuetable");
        this.text.assertTextPresent(locator, "HSP-2");
        this.text.assertTextPresent(locator, "HSP-1");
        this.tester.clickLinkWithText("simple");
        TestLabels.assertEquals((String)"aa TeSt", (String)this.tester.getDialog().getFormParameterValue(fieldId));
        this.navigation.issueNavigator().createSearch(field + " = \"fIRst\"");
        locator = new TableLocator(this.tester, "issuetable");
        this.text.assertTextPresent(locator, "HSP-1");
        this.text.assertTextNotPresent(locator, "HSP-2");
        this.tester.clickLinkWithText("simple");
        TestLabels.assertEquals((String)"fIRst", (String)this.tester.getDialog().getFormParameterValue(fieldId));
        this.tester.clickLinkWithText("advanced");
        this.tester.setWorkingForm("jqlform");
        TestLabels.assertEquals((String)(field + " = \"fIRst\""), (String)this.tester.getDialog().getForm().getParameterValue("jqlQuery"));
        locator = new TableLocator(this.tester, "issuetable");
        this.text.assertTextPresent(locator, "HSP-1");
        this.text.assertTextNotPresent(locator, "HSP-2");
        this.navigation.issueNavigator().createSearch(field + " is empty");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "No matching issues found. ");
        String issueKey = this.navigation.issue().createIssue("homosapien", "Bug", "Another test issue!!!!");
        this.navigation.issueNavigator().createSearch(field + " is empty");
        this.text.assertTextNotPresent(new WebPageLocator(this.tester), "No matching issues found. ");
        locator = new TableLocator(this.tester, "issuetable");
        this.text.assertTextPresent(locator, issueKey);
        this.navigation.issueNavigator().createSearch(field + " in (TeST, aa)");
        long filterId = this.navigation.issueNavigator().saveCurrentAsNewFilter("labelsearch", "in search", true, null);
        this.navigation.issueNavigator().loadFilter(filterId, IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        locator = new TableLocator(this.tester, "issuetable");
        this.text.assertTextPresent(locator, "HSP-1");
        this.text.assertTextPresent(locator, "HSP-2");
        this.tester.clickLink("viewfilter");
        this.text.assertTextSequence(new IdLocator(this.tester, "filter-summary"), fieldName + ":", "TeST aa");
        this.navigation.issueNavigator().createSearch(field + " != couple");
        locator = new TableLocator(this.tester, "issuetable");
        this.text.assertTextPresent(locator, "HSP-2");
        this.text.assertTextNotPresent(locator, "HSP-1");
        this.text.assertTextNotPresent(locator, "HSP-3");
        this.navigation.issueNavigator().createSearch(field + " not in (aa, bb)");
        locator = new TableLocator(this.tester, "issuetable");
        this.text.assertTextNotPresent(locator, "HSP-2");
        this.text.assertTextPresent(locator, "HSP-1");
        this.text.assertTextNotPresent(locator, "HSP-3");
    }

    public void testEditIssueLabelsDoesCreateChangeItem() throws Exception {
        this.administration.restoreData("TestLabelsHistory.xml");
        this.navigation.issue().gotoEditIssue("HSP-3");
        FormParameterUtil formParameterUtil = new FormParameterUtil(this.tester, "issue-edit", "Update");
        formParameterUtil.addOptionToHtmlSelect("labels", new String[]{"Label"});
        formParameterUtil.submitForm();
        this.navigation.issue().gotoIssueChangeHistory("HSP-3");
        this.assertHistoryContains("Administrator", "Labels", "", "Label");
    }

    public void testCreateIssueLabelsDoesNotCreateChangeItem() throws Exception {
        this.administration.restoreData("TestLabelsHistory.xml");
        Map<String, String[]> params = new MapBuilder<String, String[]>().add("labels", new String[]{"label"}).toMap();
        String issueKey = this.navigation.issue().createIssue("homosapien", "Bug", "Bug With Labels", params);
        this.navigation.issue().gotoIssueChangeHistory(issueKey);
        this.assertNoHistory();
    }

    public void testSimpleToAdvanced() {
        this.administration.restoreData("TestLabels.xml");
        IssueNavigatorNavigation issueNav = this.navigation.issueNavigator();
        issueNav.gotoNewMode(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.tester.setWorkingForm("issue-filter");
        this.tester.setFormElement("customfield_10000", "whatever");
        issueNav.runSearch();
        issueNav.gotoEditMode(IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.assertions.getIssueNavigatorAssertions().assertAdvancedSearch(this.tester, "Epic", "=", "whatever");
        issueNav.gotoEditMode(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.tester.assertFormElementEquals("customfield_10000", "whatever");
    }

    public void testEditIssueLabelsStandaloneDoesNotSuck() {
        Labels expectedLabels = new Labels(true, true, true, "TEST", "aaafirst", "couple", "first", "labels", "of", "test");
        this.administration.restoreData("TestLabelsHistory.xml");
        this.navigation.issue().gotoIssue("HSP-1");
        String labelsDomId = "labels-10000-labels";
        this.assertions.getLabelAssertions().assertLabels("10000", "labels", expectedLabels);
        this.navigation.issue().editLabels(10000);
        this.assertions.assertNodeExists("//input[@type='hidden'][@name='id']");
        this.assertions.assertNodeExists("//select[@id='labels']");
        this.tester.submit("edit-labels-submit");
        this.assertions.getLabelAssertions().assertLabels("10000", "labels", expectedLabels);
    }

    public void testEditCustomIssueLabelsStandaloneDoesNotSuck() {
        String customFieldName = "customfield_10000";
        String labelsDomId = "labels-10000-customfield_10000";
        Labels expectedLabels = new Labels(true, true, true, "TEST", "aaafirst", "couple", "first", "labels", "of", "test");
        this.administration.restoreData("TestLabelsHistory.xml");
        this.navigation.issue().gotoIssue("HSP-1");
        this.assertions.getLabelAssertions().assertLabels("10000", "labels", expectedLabels);
        this.navigation.issue().editCustomLabels(10000, 10000);
        this.assertions.assertNodeExists("//input[@type='hidden'][@name='id']");
        this.assertions.assertNodeExists("//input[@type='hidden'][@name='customFieldId']");
        this.assertions.assertNodeExists("//select[@id='customfield_10000']");
        this.tester.submit("edit-labels-submit");
        this.assertions.getLabelAssertions().assertLabels("10000", "labels", expectedLabels);
    }

    public void testCancelOnEditLabelsStandaloneNavigatesToIssue() {
        this.administration.restoreData("TestLabelsHistory.xml");
        this.navigation.issue().gotoIssue("HSP-1");
        this.navigation.issue().editLabels(10000);
        this.tester.clickLink("cancel");
        this.assertions.getViewIssueAssertions().assertOnViewIssuePage("HSP-1");
    }

    public void testEditSystemLabelsValidation() throws Exception {
        this.administration.restoreData("TestLabelsHistory.xml");
        this.navigation.issue().gotoIssue("HSP-1");
        this.navigation.issue().editLabels(10000);
        FormParameterUtil parameterUtil = new FormParameterUtil(this.tester, "edit-labels-form", "edit-labels-submit");
        this._addInvalidLabel(parameterUtil);
        this._assertLabelValidation("labels", parameterUtil);
    }

    public void testEditCustomLabelsValidation() throws Exception {
        this.administration.restoreData("TestLabelsHistory.xml");
        this.navigation.issue().gotoIssue("HSP-1");
        this.navigation.issue().editCustomLabels(10000, 10000);
        FormParameterUtil parameterUtil = new FormParameterUtil(this.tester, "edit-labels-form", "edit-labels-submit");
        this._addInvalidLabel(parameterUtil);
        this._assertLabelValidation("customfield_10000", parameterUtil);
    }

    public void testLabelsJqlLinks() {
        int i;
        this.administration.restoreData("TestLabels.xml");
        int issueId = 10000;
        int customFieldId = 10000;
        String[] indexToLabel = new String[]{"TEST", "aaafirst", "couple", "first", "labels", "of", "test"};
        for (i = 0; i < indexToLabel.length; ++i) {
            this.navigation.issue().gotoIssue("HSP-1");
            this.assertJqlLinkForSystemLabel(10000, i, indexToLabel[i]);
            this.navigation.issue().gotoIssue("HSP-1");
            this.assertJqlLinkForLabel(10000, 10000, i, indexToLabel[i]);
        }
        this.navigation.issueNavigator().createSearch("");
        for (i = 0; i < indexToLabel.length; ++i) {
            this.navigation.issueNavigator().gotoNavigator();
            this.assertJqlLinkForSystemLabel(10000, i, indexToLabel[i]);
            this.navigation.issueNavigator().gotoNavigator();
            this.assertJqlLinkForLabel(10000, 10000, i, indexToLabel[i]);
        }
    }

    private void assertJqlLinkForSystemLabel(int issueId, int labelIndex, String labelText) {
        this.assertJqlLinkForLabel(issueId, null, labelIndex, labelText);
    }

    private void assertJqlLinkForLabel(int issueId, Integer customFieldId, int labelIndex, String labelText) {
        String fieldId = customFieldId == null ? "labels" : "customfield_" + customFieldId;
        String jqlHref = this.xpath("//ul[@id='" + fieldId + "-" + issueId + "-value']//a").getNodes()[labelIndex].getAttributes().getNamedItem("href").getNodeValue();
        this.navigation.gotoPage(jqlHref);
        this.navigation.issueNavigator().gotoEditMode(IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        String jqlFieldName = customFieldId == null ? "labels" : "cf[" + customFieldId + "]";
        try {
            this.assertions.getIssueNavigatorAssertions().assertAdvancedSearch(this.tester, jqlFieldName + " = " + labelText);
        }
        catch (Throwable ignore) {
            this.assertions.getIssueNavigatorAssertions().assertAdvancedSearch(this.tester, jqlFieldName + " = \"" + labelText + "\"");
        }
    }

    private void _addInvalidLabel(FormParameterUtil formParameterUtil) {
        formParameterUtil.addOptionToHtmlSelect("labels", new String[]{"A B"});
    }

    private void _assertLabelValidation(String fieldName, FormParameterUtil formParameterUtil) throws IOException, SAXException {
        String domId = fieldName + "-error";
        XPathLocator locator = new XPathLocator(formParameterUtil.submitForm(), String.format("//*[@id='%s']", domId));
        TestLabels.assertNotNull((String)String.format("%s-error should exist", domId), (Object)locator.getNode());
    }

    private void assertNoHistory() throws Exception {
        ChangeHistoryList actualList = ChangeHistoryParser.getChangeHistory(this.tester);
        TestLabels.assertTrue((boolean)actualList.isEmpty());
    }

    private void assertHistoryContains(String changedBy, String fieldName, String oldValue, String newValue) throws Exception {
        ChangeHistoryList expectedList = new ChangeHistoryList();
        expectedList.addChangeSet(changedBy).add(fieldName, oldValue, newValue);
        ChangeHistoryList actualList = ChangeHistoryParser.getChangeHistory(this.tester);
        actualList.assertContainsChangeHistory(expectedList);
    }
}

