/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.util.env.EnvironmentUtils;
import com.atlassian.jira.webtests.JIRAWebTest;

public class TestIssueTabPanels
extends JIRAWebTest {
    private final String commentLorem = "Nulla pulvinar leo et eros. Vestibulum tortor. Aenean aliquam odio a neque.";

    public TestIssueTabPanels(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.restoreData("TestIssueTabPanels.xml");
    }

    public void testViewDefaultPanelWhenRequestedPanelDoesNotExist() {
        this.gotoPage("browse/MKY-1?page=unknown");
        this.assertTextPresent("Nulla pulvinar leo et eros. Vestibulum tortor. Aenean aliquam odio a neque.");
        this.assertTextNotPresent("An unknown error occurred - actions == null. Please see logs for more details.");
    }

    public void testViewDefaultPanelWhenPanelPermissionsChange() {
        this.gotoIssue("MKY-1");
        this.clickLinkWithText("Version Control");
        this.gotoIssue("HSP-1");
        this.assertTextPresent("There are no comments yet on this issue.");
    }

    public void testSortOrdering() throws Exception {
        boolean isOracle = new EnvironmentUtils(this.tester, this.getEnvironmentData(), this.navigation).isOracle();
        String comment1 = "This is the first comment.";
        String comment2 = "This is the second comment.";
        String comment3 = "This is the third comment.";
        String[] ascComments = new String[]{"This is the first comment.", "This is the second comment.", "This is the third comment."};
        String[] descComments = new String[]{"This is the third comment.", "This is the second comment.", "This is the first comment."};
        String status = "Status";
        String open = "Open";
        String inProgress = "In Progress";
        String[] ascChangeItems = new String[]{"Status", "Open", "In Progress", "Status", "In Progress", "Open"};
        String[] descChangeItems = new String[]{"Status", "In Progress", "Open", "Status", "Open", "In Progress"};
        this.gotoIssue("HSP-1");
        for (String comment : ascComments) {
            this.addCommentOnCurrentIssue(comment);
            if (!isOracle) continue;
            Thread.sleep(2000L);
        }
        this.clickLinkWithText("Start Progress");
        if (isOracle) {
            Thread.sleep(2000L);
        }
        this.clickLinkWithText("Stop Progress");
        this.assertTextSequence(ascComments);
        this.clickLinkWithText("History");
        this.assertTextSequence(ascChangeItems);
        this.gotoIssue("HSP-1");
        this.clickLinkWithText("Ascending order");
        this.assertTextSequence(descChangeItems);
        this.clickLinkWithText("Comments");
        this.assertTextSequence(descComments);
        this.gotoIssue("HSP-1");
        this.clickLinkWithText("Descending order");
        this.assertTextSequence(ascComments);
        this.clickLinkWithText("History");
        this.assertTextSequence(ascChangeItems);
    }

    public void testSortOrderShownForTabs() {
        this.gotoPage("browse/HSP-1?page=com.atlassian.jira.plugin.system.issuetabpanels%3Aall-tabpanel");
        this.assertTextPresent("Ascending order");
        this.gotoPage("browse/HSP-1?page=com.atlassian.jira.plugin.system.issuetabpanels%3Achangehistory-tabpanel");
        this.assertTextPresent("Ascending order");
        this.gotoPage("browse/HSP-1?page=com.atlassian.jira.plugin.system.issuetabpanels%3Aworklog-tabpanel");
        this.assertTextPresent("Ascending order");
        this.gotoPage("browse/HSP-1?page=com.atlassian.jira.plugin.system.issuetabpanels%3Acomment-tabpanel");
        this.assertTextPresent("Ascending order");
    }

    public void testPermalinking() throws Exception {
        this.gotoDashboard();
        this.logout();
        String worklogPermalink = "/browse/MKY-1?page=com.atlassian.jira.plugin.system.issuetabpanels%3Aworklog-tabpanel#worklog-10001";
        String worklogLorem = "Cras hendrerit porta tortor. Ut varius";
        String commentPermalink = "/browse/MKY-1?focusedCommentId=10001&page=com.atlassian.jira.plugin.system.issuetabpanels%3Acomment-tabpanel#comment-10001";
        this.gotoPage("/browse/MKY-1?page=com.atlassian.jira.plugin.system.issuetabpanels%3Aworklog-tabpanel#worklog-10001");
        this.assertTextPresent("Cras hendrerit porta tortor. Ut varius");
        this.gotoDashboard();
        this.gotoPage("/browse/MKY-1?focusedCommentId=10001&page=com.atlassian.jira.plugin.system.issuetabpanels%3Acomment-tabpanel#comment-10001");
        this.assertTextPresent("Nulla pulvinar leo et eros. Vestibulum tortor. Aenean aliquam odio a neque.");
    }
}

