/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.webtests.JIRAWebTest;

public class TestIssueSecurityActions
extends JIRAWebTest {
    private static final String DEFAULT_FIELD_CONFIG = "Default Field Configuration";

    public TestIssueSecurityActions(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.restoreBlankInstance();
        if (this.projectExists("homosapien")) {
            TestIssueSecurityActions.log("Project 'homospaien' exists");
            if (!this.componentExists("New Component 1", "homosapien")) {
                this.addComponent("homosapien", "New Component 1");
            }
            if (!this.versionExists("New Version 1", "homosapien")) {
                this.addVersion("homosapien", "New Version 1", "Version 1");
            }
        } else {
            this.addProject("homosapien", "HSP", "", "admin", "project for homosapiens");
            this.addComponent("homosapien", "New Component 1");
            this.addVersion("homosapien", "New Version 1", "Version 1");
        }
        if (this.projectExists("neanderthal")) {
            TestIssueSecurityActions.log("Project 'neanderthal' exists");
        } else {
            this.addProject("neanderthal", "NDT", "", "admin", "project for neanderthals");
        }
        if (this.securtiySchemeExists("New Security Scheme")) {
            this.associateSecuritySchemeToProject("homosapien", "None");
            this.associateSecuritySchemeToProject("neanderthal", "None");
            this.deleteSecurityScheme("New Security Scheme");
        }
        this.clickOnAdminPanel("admin.usersgroups", "user_browser");
        try {
            this.assertLinkPresentWithText("bob");
        }
        catch (Throwable t) {
            this.addUser("bob", "bob_password", "Bob The Builder", "bob@stuff.com.com");
        }
        this.resetFields();
    }

    public void tearDown() {
        try {
            this.deleteAllIssuesInAllPages();
            this.resetFields();
        }
        catch (Throwable t) {
            TestIssueSecurityActions.log("Some problem in tear down of " + this.getClass().getName(), t);
        }
        super.tearDown();
    }

    public void testIssueSecurityActions() {
        String issueKeyWithoutSecurity = this.addIssue("neanderthal", "NDT", "Bug", "test without issue security", "Minor", null, null, null, "Administrator", "test environment 1", "test description without issue security", null, null, null);
        String issueKeyNormal = this.addIssue("homosapien", "HSP", "Bug", "test with components", "Minor", null, null, null, "Administrator", "test environment 1", "test description with components", null, null, null);
        this.issueSecurityCreateScheme();
        this.issueSecurityFieldSchemesAddDuplicateScheme();
        this.issueSecurityFieldSchemesAddInvalidScheme();
        this.issueSecurityAddSecurityLevel();
        this.issueSecurityAssociateSchemeToProject();
        this.issueSecurityAddGroupToSecurityLevel();
        String issueKeyWithSecurity = this.issueSecurityCreateIssueWithSecurity();
        this.issueSecurityCreateIssueWithoutIssueSecurity();
        this.issueSecurityCreateIssueWithSecurityRequired();
        this.issueSecurityEditIssueWithIssueSecurity(issueKeyWithSecurity);
        this.issueSecurityEditIssueWithoutIssueSecurity(issueKeyWithoutSecurity);
        this.issueSecurityEditIssueWithSecurityRequired(issueKeyNormal);
        this.issueSecuritySecurityViolation(issueKeyWithSecurity);
        this.issueSecurityMoveIssueAwayFromIssueSecurity(issueKeyWithSecurity);
        this.issueSecurityMoveIssueToIssueSecurity(issueKeyWithSecurity);
        this.issueSecurityMoveIssueWithDefaultSecurity(issueKeyWithoutSecurity);
        this.issueSecurityMoveIssueWithSameSecurity(issueKeyWithoutSecurity);
        this.issueSecurityCreateSubTaskWithSecurity(issueKeyWithSecurity);
        this.issueSecurityRemoveAssociationWithProject();
        this.issueSecurityRemoveGroupFromSecurityLevel();
        this.issueSecurityDeleteSecurityLevel();
        this.issueSecurityDeleteScheme();
    }

    public void testProjectRoleIssueSecurityType() {
        this.restoreData("TestIssueSecurityScheme.xml");
        this.gotoIssueSecuritySchemes();
        this.clickLink("admin_link");
        this.clickLink("security_schemes");
        this.clickLinkWithText("Security Levels");
        this.assertTextNotPresent("(Administrators)");
        this.clickLink("add_level 1");
        this.checkCheckbox("type", "projectrole");
        this.selectOption("projectrole", "Administrators");
        this.submit(" Add ");
        this.assertTextPresent("(Administrators)");
    }

    public void issueSecurityCreateScheme() {
        TestIssueSecurityActions.log("Issue Security: Creating a security scheme");
        this.createSecurityScheme("New Security Scheme", "security scheme for testing");
        this.assertTextPresent("Issue Security Schemes");
        this.assertLinkPresentWithText("New Security Scheme");
    }

    public void issueSecurityDeleteScheme() {
        TestIssueSecurityActions.log("Issue Security: Deleting a security scheme");
        this.deleteSecurityScheme("New Security Scheme");
        this.assertLinkNotPresentWithText("New Security Scheme");
        this.assertTextPresent("You do not currently have any issue security schemes configured.");
    }

    public void issueSecurityAddSecurityLevel() {
        TestIssueSecurityActions.log("Issue Secuirty: Adding a security level to a security scheme");
        this.createSecurityLevel("New Security Scheme", "Red", "Highest Level");
        this.assertTextSequence(new String[]{"Red", "Highest Level"});
        this.assertTextNotPresent("Orange");
        this.assertTextNotPresent("Middle Level");
        this.assertTextNotPresent("Green");
        this.assertTextNotPresent("Lowest Level");
        this.createSecurityLevel("New Security Scheme", "Orange", "Middle Level");
        this.assertTextSequence(new String[]{"Orange", "Middle Level", "Red", "Highest Level"});
        this.assertTextNotPresent("Green");
        this.assertTextNotPresent("Lowest Level");
        this.createSecurityLevel("New Security Scheme", "Green", "Lowest Level");
        this.assertTextSequence(new String[]{"Green", "Lowest Level", "Orange", "Middle Level", "Red", "Highest Level"});
        this.gotoIssueSecuritySchemes();
        this.clickLinkWithText("New Security Scheme");
        this.assertLinkPresent("add_Red");
        this.assertLinkPresent("add_Orange");
        this.assertLinkPresent("add_Green");
    }

    public void issueSecurityDeleteSecurityLevel() {
        TestIssueSecurityActions.log("Issue Secuirty: Deleting a security level to a security scheme");
        this.deleteSecurityLevel("New Security Scheme", "Red");
        this.gotoIssueSecuritySchemes();
        this.clickLinkWithText("New Security Scheme");
        this.assertLinkNotPresent("add_Red");
        this.assertLinkPresent("add_Orange");
        this.assertLinkPresent("add_Green");
    }

    public void issueSecurityAssociateSchemeToProject() {
        TestIssueSecurityActions.log("Issue Security: Associate a Project to a Scheme");
        this.associateSecuritySchemeToProject("homosapien", "New Security Scheme");
        this.goToProject("homosapien");
        this.assertTextPresent("homosapien");
        this.assertTextPresent("New Security Scheme");
    }

    public void issueSecurityRemoveAssociationWithProject() {
        TestIssueSecurityActions.log("Issue Security: Remove association between a Project and a Scheme");
        this.associateSecuritySchemeToProject("homosapien", "None");
        this.goToProject("homosapien");
        this.assertTextPresent("homosapien");
        this.assertTextNotPresent("New Security Scheme");
    }

    public void issueSecurityAddGroupToSecurityLevel() {
        TestIssueSecurityActions.log("Issue Security: Add groups to issue security level");
        this.addGroupToSecurityLevel("New Security Scheme", "Red", "jira-administrators");
        this.addGroupToSecurityLevel("New Security Scheme", "Orange", "jira-developers");
        this.addGroupToSecurityLevel("New Security Scheme", "Green", "jira-users");
        this.gotoIssueSecuritySchemes();
        this.clickLinkWithText("New Security Scheme");
        this.assertLinkPresent("delGroup_jira-administrators_Red");
        this.assertLinkPresent("delGroup_jira-developers_Orange");
        this.assertLinkPresent("delGroup_jira-users_Green");
    }

    public void issueSecurityRemoveGroupFromSecurityLevel() {
        TestIssueSecurityActions.log("Issue Security: Remove groups from issue security level");
        this.removeGroupFromSecurityLevel("New Security Scheme", "Red", "jira-administrators");
        this.gotoIssueSecuritySchemes();
        this.clickLinkWithText("New Security Scheme");
        this.assertLinkNotPresent("delGroup_jira-administrators_Red");
        this.assertLinkPresent("delGroup_jira-developers_Orange");
        this.assertLinkPresent("delGroup_jira-users_Green");
    }

    public void issueSecurityFieldSchemesAddDuplicateScheme() {
        TestIssueSecurityActions.log("Issue Security: Creating a duplicate security scheme");
        this.createSecurityScheme("New Security Scheme", "security scheme for testing");
        this.assertTextPresent("A Scheme with this name already exists.");
    }

    public void issueSecurityFieldSchemesAddInvalidScheme() {
        TestIssueSecurityActions.log("Issue Security: Creating a duplicate security scheme");
        this.createSecurityScheme("", "");
        this.assertTextPresent("Please specify a name for this Scheme.");
    }

    public String issueSecurityCreateIssueWithSecurity() {
        this.grantGroupPermission(26, "jira-administrators");
        String issueKey = this.addIssue("homosapien", "HSP", "Bug", "test with issue security", "Minor", new String[]{"New Component 1"}, new String[]{"New Version 1"}, new String[]{"New Version 1"}, "Administrator", "test environment 9", "test description 9", null, "Red", null);
        this.assertTextPresent("test with issue security");
        this.assertTextPresent("Minor");
        this.assertTextPresent("Bug");
        this.assertTextPresent("Security Level:");
        this.assertTextPresent("Red");
        this.removeGroupPermission(26, "jira-administrators");
        return issueKey;
    }

    public void issueSecurityCreateIssueWithoutIssueSecurity() {
        this.grantGroupPermission(26, "jira-administrators");
        TestIssueSecurityActions.log("Create Issue: Tests the availability of the 'Security Level' field");
        this.clickLink("create_link");
        this.assertTextPresent("Create Issue");
        this.selectOption("pid", "neanderthal");
        this.selectOption("issuetype", "Bug");
        this.submit();
        this.assertTextPresent("CreateIssueDetails.jspa");
        this.assertTextPresent("neanderthal");
        this.assertFormElementNotPresent("security");
        this.removeGroupPermission(26, "jira-administrators");
    }

    public void issueSecurityCreateIssueWithSecurityRequired() {
        this.grantGroupPermission(26, "jira-administrators");
        this.setSecurityLevelToRequried();
        TestIssueSecurityActions.log("Create Issue: Test the ability to create an issue with 'Security Level' required");
        this.createIssueStep1();
        this.setFormElement("summary", "This is a summary");
        this.submit("Create");
        this.assertTextPresent("CreateIssueDetails.jspa");
        this.assertTextPresent("Security Level is required.");
        this.resetFields();
        this.removeGroupPermission(26, "jira-administrators");
    }

    public void issueSecurityEditIssueWithIssueSecurity(String issueKey) {
        this.grantGroupPermission(26, "jira-administrators");
        TestIssueSecurityActions.log("Edit Issue: Test ability to change Security Level");
        this.gotoIssue(issueKey);
        this.clickLink("editIssue");
        this.selectOption("security", "Orange");
        this.submit();
        this.assertTextPresent(issueKey);
        this.assertTextPresent("Orange");
        this.removeGroupPermission(26, "jira-administrators");
    }

    public void issueSecurityEditIssueWithoutIssueSecurity(String issueKey) {
        this.grantGroupPermission(26, "jira-administrators");
        TestIssueSecurityActions.log("Edit Issue: Test availability of 'Security Level' field");
        this.gotoIssue(issueKey);
        this.clickLink("editIssue");
        this.assertFormElementNotPresent("security");
        this.removeGroupPermission(26, "jira-administrators");
    }

    public void issueSecurityEditIssueWithSecurityRequired(String issueKey) {
        this.setSecurityLevelToRequried();
        this.grantGroupPermission(26, "jira-administrators");
        TestIssueSecurityActions.log("Edit Issue: Test the ability to update an issue with 'Security Level' required");
        this.gotoIssue(issueKey);
        this.clickLink("editIssue");
        this.submit("Update");
        this.assertTextPresent("Edit Issue");
        this.assertTextPresent("Security Level is required.");
        this.removeGroupPermission(26, "jira-administrators");
        this.resetFields();
    }

    public void issueSecuritySecurityViolation(String issueKey) {
        TestIssueSecurityActions.log("Edit Issue: Test the availabilty of an issue for which a user is not permitted to view.");
        this.grantGroupPermission(26, "jira-administrators");
        this.logout();
        this.login("bob", "bob_password");
        this.gotoIssue(issueKey);
        this.assertTextPresent("Permission Violation");
        this.assertTextPresent("It seems that you have tried to perform an operation which you are not permitted to perform.");
        this.logout();
        this.login("admin", "admin");
        this.removeGroupPermission(26, "jira-administrators");
    }

    public void issueSecurityMoveIssueAwayFromIssueSecurity(String issueKey) {
        TestIssueSecurityActions.log("Move Operation: Moving an issue to a project without 'Issue Security");
        this.gotoIssue(issueKey);
        this.clickLink("move-issue");
        this.assertTextPresent("Move Issue");
        this.selectOption("pid", "neanderthal");
        this.submit();
        this.assertTextPresent("Step 3 of 4");
        this.assertTextNotPresent("All fields will be updated automatically.");
        this.getDialog().setWorkingForm("jiraform");
        this.submit();
        this.assertTextPresent("Step 4 of 4");
        this.assertTextPresent("neanderthal");
        this.assertTextPresent("homosapien");
        this.getDialog().setWorkingForm("jiraform");
        this.submit("Move");
        this.assertTextNotPresent("Security Level");
        this.assertTextNotPresent("Red");
    }

    public void issueSecurityMoveIssueToIssueSecurity(String issueKey) {
        TestIssueSecurityActions.log("Move Operation: Moving an issue to a project with 'Issue Security");
        this.grantGroupPermission(26, "jira-administrators");
        this.setRequiredFieldsOnEnterprise(DEFAULT_FIELD_CONFIG, "Security Level");
        this.gotoIssue(issueKey);
        this.clickLink("move-issue");
        this.assertTextPresent("Move Issue");
        this.selectOption("pid", "homosapien");
        this.submit();
        this.assertTextPresent("Step 3 of 4");
        this.selectOption("security", "Orange");
        this.submit();
        this.assertTextPresent("Step 4 of 4");
        this.submit("Move");
        this.assertTextPresent("Security Level:");
        this.assertTextPresent("Orange");
        this.setOptionalFieldsOnEnterprise(DEFAULT_FIELD_CONFIG, "Security Level");
        this.removeGroupPermission(26, "jira-administrators");
    }

    public void issueSecurityMoveIssueWithDefaultSecurity(String issueKey) {
        TestIssueSecurityActions.log("Move Operation: Moving an issue with default security levels");
        this.setRequiredFieldsOnEnterprise(DEFAULT_FIELD_CONFIG, "Security Level");
        this.gotoIssue(issueKey);
        this.clickLink("move-issue");
        this.assertTextPresent("Move Issue");
        this.selectOption("pid", "homosapien");
        this.submit();
        this.assertTextPresent("Move Issue: Update Fields");
        this.getDialog().setWorkingForm("jiraform");
        this.submit();
        this.assertTextPresent("Security Level: Security Level is required.");
        this.setDefaultSecurityLevel("New Security Scheme", "Red");
        this.gotoIssue(issueKey);
        this.clickLink("move-issue");
        this.assertTextPresent("Move Issue");
        this.selectOption("pid", "homosapien");
        this.submit();
        this.assertTextPresent("Move Issue: Update Fields");
        this.setWorkingForm("jiraform");
        this.submit();
        this.assertTextPresent("Move Issue: Confirm");
        this.setWorkingForm("jiraform");
        this.submit();
        this.assertTextPresent("Security Level:");
        this.assertTextPresent("Red");
        this.setDefaultSecurityLevel("New Security Scheme", null);
        this.setOptionalFieldsOnEnterprise(DEFAULT_FIELD_CONFIG, "Security Level");
    }

    public void issueSecurityMoveIssueWithSameSecurity(String issueKey) {
        TestIssueSecurityActions.log("Move Operation: Move an issue to a project with the same issue security scheme.");
        this.associateSecuritySchemeToProject("neanderthal", "New Security Scheme");
        this.gotoIssue(issueKey);
        this.clickLink("move-issue");
        this.assertTextPresent("Move Issue");
        this.selectOption("pid", "neanderthal");
        this.submit();
        this.assertTextPresent("Move Issue: Update Fields");
        this.setWorkingForm("jiraform");
        this.submit();
        this.assertTextPresent("Move Issue: Confirm");
        this.setWorkingForm("jiraform");
        this.submit();
        this.assertTextPresent("Security Level:");
        this.assertTextPresent("Red");
        this.associateSecuritySchemeToProject("neanderthal", "None");
    }

    public void issueSecurityCreateSubTaskWithSecurity(String issueKey) {
        TestIssueSecurityActions.log("Sub Task Create: Create a sub task from an issue with a security level");
        this.createSubTaskStep1(issueKey, "Sub-task");
        this.setFormElement("summary", "Sub Task of Test 5");
        this.submit();
        this.assertTextPresent("test with issue security");
        this.assertTextPresent("Sub Task of Test 5");
        this.assertTextPresent("Orange");
        this.deleteCurrentIssue();
        this.deactivateSubTasks();
    }

    private void setDefaultSecurityLevel(String scheme_name, String securityLevel) {
        this.gotoIssueSecuritySchemes();
        this.clickLinkWithText(scheme_name);
        if (securityLevel != null) {
            this.clickLink("default_" + securityLevel);
        } else {
            this.clickLinkWithText("Change default security level to \"None\"");
        }
    }
}

