/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.IdLocator;

public class TestIssueActionErrors
extends FuncTestCase {
    protected void setUpTest() {
        this.administration.restoreData("TestIssueActionErrors.xml");
    }

    public void testOperations() {
        this.assertOperationErrors("Attach Files", "secure/AttachFile!default.jspa?id=10000", "secure/AttachFile!default.jspa?id=999", "You do not have permission to create attachments for this issue.", true);
        this.assertOperationErrors("Assign", "secure/AssignIssue!default.jspa?id=10000", "secure/AssignIssue!default.jspa?id=999", "It seems that you have tried to perform an operation which you are not permitted to perform.", true);
        this.assertOperationErrors("Log Work", "secure/CreateWorklog!default.jspa?id=10000", "secure/CreateWorklog!default.jspa?id=999", "It seems that you have tried to perform an operation which you are not permitted to perform.", true);
        this.assertOperationErrors("Delete", "secure/DeleteIssue!default.jspa?id=10000", "secure/DeleteIssue!default.jspa?id=999", "It seems that you have tried to perform an operation which you are not permitted to perform.", true);
        this.assertOperationErrors("Link Issue", "secure/LinkExistingIssue!default.jspa?id=10000", "secure/LinkExistingIssue!default.jspa?id=999", "It seems that you have tried to perform an operation which you are not permitted to perform.", true);
        this.assertOperationErrors("Clone", "secure/CloneIssueDetails!default.jspa?id=10000", "secure/CloneIssueDetails!default.jspa?id=999", "It seems that you have tried to perform an operation which you are not permitted to perform.", false);
    }

    private void assertOperationErrors(String operationTitle, String goodUrl, String invalidUrl, String operationError, boolean hasTargetIssue) {
        this.log("Testing '" + operationTitle + "'");
        this.navigation.login("admin", "admin");
        this.navigation.gotoPage(goodUrl);
        IdLocator locator = new IdLocator(this.tester, "primary");
        this.text.assertTextPresent(locator, operationTitle);
        this.navigation.gotoPage(invalidUrl);
        locator = new IdLocator(this.tester, "primary");
        this.text.assertTextPresent(locator, operationTitle);
        this.text.assertTextPresent(locator, "The issue no longer exists.");
        this.navigation.logout();
        this.navigation.gotoPage(goodUrl);
        locator = new IdLocator(this.tester, "primary");
        this.text.assertTextPresent(locator, operationTitle);
        this.text.assertTextPresent(locator, "You do not have the permission to see the specified issue");
        this.tester.assertLinkPresentWithText("log in");
        if (hasTargetIssue) {
            this.tester.assertTextPresent("login.jsp?os_destination=%2Fbrowse%2FHSP-1");
        } else {
            this.tester.assertTextPresent("login.jsp?os_destination=%2Fbrowse");
        }
        this.tester.assertLinkPresentWithText("sign up");
        this.navigation.login("fred", "fred");
        this.navigation.gotoPage(goodUrl);
        locator = new IdLocator(this.tester, "primary");
        this.text.assertTextPresent(locator, operationTitle);
        this.text.assertTextPresent(locator, operationError);
        this.tester.assertLinkNotPresentWithText("log in");
        this.tester.assertLinkNotPresentWithText("sign up");
    }
}

