/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.IdLocator;

public class TestEnvironmentField
extends FuncTestCase {
    protected void setUpTest() {
        this.administration.restoreData("TestEnvironmentField.xml");
    }

    public void testEnvironmentFieldNeverHidden() throws Exception {
        this.assertEnvironmentFieldShownOnViewIssue(true);
        this.navigation.gotoAdminSection("field_screens");
        this.tester.clickLink("configure_fieldscreen_Default Screen");
        this.tester.checkCheckbox("removeField_10", "on");
        this.tester.submit("deleteFieldsFromTab");
        this.assertEnvironmentFieldShownOnViewIssue(false);
    }

    public void testHideShowToggleButton() throws Exception {
        this.navigation.issue().viewIssue("HSP-1");
        this.text.assertTextNotPresent(new IdLocator(this.tester, "environment-val"), "Hide");
        this.tester.assertElementNotPresent("field-environment");
        this.navigation.issue().viewIssue("HSP-2");
        this.text.assertTextNotPresent(new IdLocator(this.tester, "environment-val"), "Hide");
        this.navigation.issue().setEnvironment("HSP-2", "A long description that is over 255 characters that will case teh twixie to appear. A long description that is over 255 characters that will case teh twixie to appear. A long description that is over 255 characters that will case teh twixie to appear. A long description that is over 255 characters that will case teh twixie to appear.");
        this.navigation.issue().viewIssue("HSP-2");
        this.text.assertTextPresent(new IdLocator(this.tester, "environment-val"), "Hide");
        this.tester.assertElementPresent("field-environment");
    }

    private void assertEnvironmentFieldShownOnViewIssue(boolean shouldBeOnEdit) {
        this.navigation.issue().viewIssue("HSP-1");
        IdLocator locator = new IdLocator(this.tester, "environment-val");
        this.text.assertTextPresent(locator, "this is the Environment Field");
        this.tester.clickLink("editIssue");
        if (shouldBeOnEdit) {
            this.tester.assertTextPresent("Environment");
        } else {
            this.tester.assertTextNotPresent("Environment");
        }
    }
}

