/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.i18n;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.TableCellLocator;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.meterware.httpunit.HttpUnitOptions;
import java.io.IOException;
import org.xml.sax.SAXException;

public class TestI18n500Page
extends FuncTestCase {
    public static final String ADMIN_USERNAME = "admin";
    public static final String ADMIN_PASSWORD = "admin";
    public static final String USERNAME_BOB = "bob";
    public static final String PASSWORD_BOB = "bob_password";
    public static final String USERNAME_NON_SYS_ADMIN = "admin_non_sysadmin";
    public static final String PASSWORD_NON_SYS_ADMIN = "admin_non_sysadmin";

    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreI18nData("TestI18n.xml");
    }

    public void testI18nNonSystemAdministratorDoesntSeeFilePaths() {
        this.navigation.login(USERNAME_BOB, PASSWORD_BOB);
        this.tester.gotoPage("/500page.jsp");
        this.assertions.getTextAssertions().assertTextSequence(new WebPageLocator(this.tester), new String[]{"ID de serveur", "Contacter votre administrateur pour d\u00e9couvrir cette valeur de la propri\u00e9t\u00e9.", "Chemins d'acc\u00e8s de fichiers:", "R\u00e9pertoire de travail en cours", "Contacter votre administrateur de syst\u00e8me pour d\u00e9couvrir cette valeur de la propri\u00e9t\u00e9.", "Arguments d'entr\u00e9e de JVM", "Contacter votre administrateur de syst\u00e8me pour d\u00e9couvrir cette valeur de la propri\u00e9t\u00e9."});
        this.assertions.getTextAssertions().assertTextNotPresent(new WebPageLocator(this.tester), "-Xmx");
        this.navigation.login("admin_non_sysadmin", "admin_non_sysadmin");
        this.tester.gotoPage("/500page.jsp");
        this.assertions.getTextAssertions().assertTextSequence(new WebPageLocator(this.tester), new String[]{"ID de serveur", "ABN9-RZYJ-WI2T-37UF", "Chemins d'acc\u00e8s de fichiers:", "Contacter votre administrateur de syst\u00e8me pour d\u00e9couvrir les informations de chemin de fichier.", "R\u00e9pertoire de travail en cours", "Contacter votre administrateur de syst\u00e8me pour d\u00e9couvrir cette valeur de la propri\u00e9t\u00e9.", "Arguments d'entr\u00e9e de JVM", "Contacter votre administrateur de syst\u00e8me pour d\u00e9couvrir cette valeur de la propri\u00e9t\u00e9."});
        this.assertions.getTextAssertions().assertTextNotPresent(new WebPageLocator(this.tester), "-Xmx");
    }

    protected void setHttpOptions() {
        HttpUnitOptions.setExceptionsThrownOnErrorStatus((boolean)false);
        HttpUnitOptions.setLoggingHttpHeaders((boolean)true);
    }

    public void testI18nSystemAdministratorCanSeeSysAdminOnlyProperties() throws SAXException, IOException {
        this.navigation.login("admin", "admin");
        this.tester.gotoPage("/500page.jsp");
        String responseText = this.tester.getDialog().getResponseText();
        this.assertions.getTextAssertions().assertTextPresent(responseText, "\u00e9");
        this.assertions.getTextAssertions().assertTextPresent(responseText, "Chemins d'acc\u00e8s de fichiers");
        this.assertions.getTextAssertions().assertTextNotPresent(new WebPageLocator(this.tester), "Contacter votre administrateur de syst\u00e8me pour d\u00e9couvrir les informations de chemin de fichier.");
        this.assertions.getTextAssertions().assertTextNotPresent(new WebPageLocator(this.tester), "Contacter votre administrateur de syst\u00e8me pour d\u00e9couvrir cette valeur de la propri\u00e9t\u00e9.");
        this.assertions.getTextAssertions().assertTextSequence(new WebPageLocator(this.tester), new String[]{"ID de serveur", "ABN9-RZYJ-WI2T-37UF"});
        this.assertions.getTextAssertions().assertTextSequence(new WebPageLocator(this.tester), new String[]{"Chemins d'acc\u00e8s de fichiers", "entityengine.xml", "atlassian-jira.log"});
        this.assertions.getTextAssertions().assertTextPresent(new WebPageLocator(this.tester), "Arguments d'entr\u00e9e de JVM");
        this.tester.gotoPage("/500page.jsp");
        this.assertions.getTextAssertions().assertTextPresent(new WebPageLocator(this.tester), "-D");
        this.assertions.getTextAssertions().assertTextPresent(new WebPageLocator(this.tester), "R\u00e9pertoire de travail en cours");
    }

    public void testShowsLanguageListInDefaultLanguage() {
        this.administration.restoreData("TestUserProfileI18n.xml");
        this.administration.generalConfiguration().setJiraLocale("German (Germany)");
        this.tester.gotoPage("/500page.jsp");
        int lastRow = this.page.getHtmlTable("language-info").getRowCount() - 1;
        this.text.assertTextPresent(new TableCellLocator(this.tester, "language-info", lastRow, 1), "Deutsch (Deutschland)");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "language-info", lastRow - 1, 1), "Deutsch (Deutschland)");
    }

    public void testShowsLanguageListInTheUsersLanguage() {
        this.administration.restoreData("TestUserProfileI18n.xml");
        this.administration.generalConfiguration().setJiraLocale("German (Germany)");
        this.navigation.login("fred");
        this.tester.gotoPage("/500page.jsp");
        int lastRow = this.page.getHtmlTable("language-info").getRowCount() - 1;
        this.text.assertTextPresent(new TableCellLocator(this.tester, "language-info", lastRow, 1), "alem\u00e1n (Alemania)");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "language-info", lastRow - 1, 1), "espa\u00f1ol (Espa\u00f1a)");
    }
}

