/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.fields;

import com.atlassian.jira.functest.framework.FuncTestHelperFactory;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.webtests.JIRAWebTest;
import com.meterware.httpunit.HttpUnitOptions;

public class TestFieldRenderers
extends JIRAWebTest {
    private static final String CUSTOM_FIELD_NAME_TEXT_FIELD = "Custom Field Text Field";
    private static final String CUSTOM_FIELD_NAME_TEXT_AREA_FIELD = "Custom Field Text Area Field";
    private static final String DEFAULT_FIELD_CONFIGURATION = "Default Field Configuration";
    private static final String CUSTOM_FIELD_CONFIGURATION = "Renderer Custom Field Configuration";
    private static final String WIKI_STYLE_RENDERER = "Wiki Style Renderer";
    private static final String DEFAULT_TEXT_RENDERER = "Default Text Renderer";
    private static final String CUSTOM_FIELD_TYPE_AREA = "textarea";
    private static final String CUSTOM_FIELD_CONFIGURATION_SCHEME = "Renderer Custom Field Configuration Scheme";
    private static final String OTHER_PROJECT = "Renderer Test Project";
    private static final String OTHER_PROJECT_KEY = "OTH";
    private String issueKey;
    private String textAreaCustomFieldId;
    private String textCustomFieldId;
    private String projectId;
    private static final String COLOUR_MACRO_KEY = "com.atlassian.jira.plugin.system.renderers.wiki.macros:color";
    private static final String HTML_CODE = "<b>testWikiRendererBadLink</b>";
    protected Navigation navigation;
    private static final String TEXT_AREA_CF_ID = "customfield_10000";
    private static final String TEXT_FIELD_CF_ID = "customfield_10001";
    private static final String COMMENT_FIELD_ID = "comment";
    private static final String DESCRIPTION_ID = "description";
    private static final String ENVIRONMENT_ID = "environment";

    public TestFieldRenderers(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.restoreBlankInstance();
        if (this.projectExists("homosapien")) {
            this.deleteProject("homosapien");
        }
        this.projectId = this.addProject("homosapien", "HSP", "", "admin", "project for homosapiens");
        this.setFieldConfigurationFieldToRenderer(DEFAULT_FIELD_CONFIGURATION, COMMENT_FIELD_ID, WIKI_STYLE_RENDERER);
        this.setFieldConfigurationFieldToRenderer(DEFAULT_FIELD_CONFIGURATION, DESCRIPTION_ID, WIKI_STYLE_RENDERER);
        this.setFieldConfigurationFieldToRenderer(DEFAULT_FIELD_CONFIGURATION, ENVIRONMENT_ID, WIKI_STYLE_RENDERER);
        this.textAreaCustomFieldId = this.createCustomFields(CUSTOM_FIELD_TYPE_AREA, "global", CUSTOM_FIELD_NAME_TEXT_AREA_FIELD, "custom field testing for filter", null, null, null);
        this.textCustomFieldId = this.createCustomFields("textfield", "global", CUSTOM_FIELD_NAME_TEXT_FIELD, "custom field testing for filter", null, null, null);
        this.addFieldsToFieldScreen("Workflow Screen", new String[]{CUSTOM_FIELD_NAME_TEXT_AREA_FIELD, CUSTOM_FIELD_NAME_TEXT_FIELD});
        this.addFieldsToFieldScreen("Default Screen", new String[]{CUSTOM_FIELD_NAME_TEXT_AREA_FIELD, CUSTOM_FIELD_NAME_TEXT_FIELD});
        this.addFieldsToFieldScreen("Resolve Issue Screen", new String[]{CUSTOM_FIELD_NAME_TEXT_AREA_FIELD, CUSTOM_FIELD_NAME_TEXT_FIELD});
        this.setFieldConfigurationFieldToRenderer(DEFAULT_FIELD_CONFIGURATION, TEXT_AREA_CF_ID, WIKI_STYLE_RENDERER);
        this.setFieldConfigurationFieldToRenderer(DEFAULT_FIELD_CONFIGURATION, TEXT_FIELD_CF_ID, WIKI_STYLE_RENDERER);
        this.gotoFieldLayouts();
        this.clickLink("copy-Default Field Configuration");
        this.setFormElement("fieldLayoutName", CUSTOM_FIELD_CONFIGURATION);
        this.submit("Copy");
        this.issueKey = this.addIssue("homosapien", "HSP", "Bug", "This is a test issue", "Major", null, null, null, "Administrator", "test environment", "description for this is a test issue", null, null, null);
        this.administration.attachments().enable();
        this.grantGlobalPermission(33, "jira-users");
        FuncTestHelperFactory funcTestHelperFactory = new FuncTestHelperFactory(this.tester, this.getEnvironmentData());
        this.navigation = funcTestHelperFactory.getNavigation();
    }

    public void tearDown() {
        this.deleteCustomField(this.textAreaCustomFieldId);
        this.deleteCustomField(this.textCustomFieldId);
        this.setFieldConfigurationFieldToRenderer(DEFAULT_FIELD_CONFIGURATION, COMMENT_FIELD_ID, DEFAULT_TEXT_RENDERER);
        this.setFieldConfigurationFieldToRenderer(DEFAULT_FIELD_CONFIGURATION, DESCRIPTION_ID, DEFAULT_TEXT_RENDERER);
        this.setFieldConfigurationFieldToRenderer(DEFAULT_FIELD_CONFIGURATION, ENVIRONMENT_ID, DEFAULT_TEXT_RENDERER);
        this.gotoFieldLayouts();
        this.clickLink("delete-Renderer Custom Field Configuration");
        this.submit("Delete");
        this.deleteIssue(this.issueKey);
        this.deleteProject("homosapien");
        this.removeGlobalPermission(33, "jira-users");
        this.restoreBlankInstance();
        super.tearDown();
    }

    public void testFieldRenderers() {
        TestFieldRenderers.log("-- begin testFieldRenderers");
        this._testWikiRendererVisible();
        this._testRendererConfiguration();
        this._testRendererPluginConfiguration();
        this._testRendererWithBulkOperations();
        this._testRendererAlternativeViews();
        this._testWikiRendererBadLink();
        this._testWikiRendererBadMacro();
        TestFieldRenderers.log("-- end   testFieldRenderers");
    }

    public void _testRendererAlternativeViews() {
        this._testRendererExcelView();
        this._testRendererRssView();
        this._testIssueNavigatorColumnView();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _testIssueNavigatorColumnView() {
        try {
            this.gotoIssue(this.issueKey);
            this.clickLink("editIssue");
            this.setFormElement(DESCRIPTION_ID, "{color:blue}blue functional test text{color}");
            this.submit("Update");
            this.assertTextPresent("<font color=\"blue\">blue functional test text</font>");
            this.addColumnToIssueNavigator(new String[]{"Description"});
            this.displayAllIssues();
            this.assertTextPresent("<font color=\"blue\">blue functional test text</font>");
        }
        finally {
            this.restoreColumnDefaults();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _testRendererRssView() {
        TestFieldRenderers.log("--- begin testRendererRssView");
        try {
            this.gotoIssue(this.issueKey);
            this.clickLink("editIssue");
            this.setFormElement(DESCRIPTION_ID, "{color:blue}blue functional test text{color}");
            this.submit("Update");
            this.assertTextPresent("<font color=\"blue\">blue functional test text</font>");
            this.clickLinkWithText("XML");
            this.assertTextPresent("&lt;font color=&quot;blue&quot;&gt;blue functional test text&lt;/font&gt;");
        }
        finally {
            this.beginAt("/secure/Dashboard.jspa");
        }
        try {
            this.displayAllIssues();
            this.clickLinkWithText("XML");
            this.assertTextPresent("&lt;font color=&quot;blue&quot;&gt;blue functional test text&lt;/font&gt;");
        }
        finally {
            this.beginAt("/secure/Dashboard.jspa");
        }
        TestFieldRenderers.log("--- end   testRendererRssView");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _testRendererExcelView() {
        TestFieldRenderers.log("--- begin testRendererExcelView");
        try {
            this.gotoIssue(this.issueKey);
            this.clickLink("editIssue");
            this.setFormElement(DESCRIPTION_ID, "{color:blue}blue functional test text{color}");
            this.submit("Update");
            this.displayAllIssues();
            this.clickLinkWithText("All fields");
            this.assertTextPresent("{color:blue}blue functional test text{color}");
        }
        finally {
            this.beginAt("/secure/Dashboard.jspa");
        }
        TestFieldRenderers.log("--- end   testRendererExcelView");
    }

    public void _testRendererWithBulkOperations() {
        this._testBulkEditWithSameRendererType();
        this._testBulkOperationsWithDifferentRendererTypes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _testBulkOperationsWithDifferentRendererTypes() {
        block5: {
            String otherProjectIssueKey = null;
            try {
                this.addFieldLayoutScheme(CUSTOM_FIELD_CONFIGURATION_SCHEME, "random description");
                this.addProject(OTHER_PROJECT, OTHER_PROJECT_KEY, "", "admin", "project for others");
                this.associatedSchemeWithConfiguration(CUSTOM_FIELD_CONFIGURATION_SCHEME, CUSTOM_FIELD_CONFIGURATION);
                this.associateFieldLayoutScheme(OTHER_PROJECT, null, CUSTOM_FIELD_CONFIGURATION_SCHEME);
                this.setFieldConfigurationFieldToRenderer(CUSTOM_FIELD_CONFIGURATION, TEXT_AREA_CF_ID, DEFAULT_TEXT_RENDERER);
                this.setFieldConfigurationFieldToRenderer(DEFAULT_FIELD_CONFIGURATION, TEXT_AREA_CF_ID, WIKI_STYLE_RENDERER);
                this.setFieldConfigurationFieldToRenderer(CUSTOM_FIELD_CONFIGURATION, TEXT_FIELD_CF_ID, DEFAULT_TEXT_RENDERER);
                this.setFieldConfigurationFieldToRenderer(DEFAULT_FIELD_CONFIGURATION, TEXT_FIELD_CF_ID, WIKI_STYLE_RENDERER);
                otherProjectIssueKey = this.addIssue(OTHER_PROJECT, OTHER_PROJECT_KEY, "Bug", "This is a test issue", "Major", null, null, null, "Administrator", "test environment", "description for this is a test issue", null, null, null);
                this.editIssueWithCustomFields(otherProjectIssueKey, this.textAreaCustomFieldId, "test value", "textfield");
                this._testBulkEditWithDifferentRendererTypes();
                this._testBulkMoveWithDifferentRendererTypes();
                if (otherProjectIssueKey == null) break block5;
            }
            catch (Throwable throwable) {
                if (otherProjectIssueKey != null) {
                    this.deleteIssue(otherProjectIssueKey);
                }
                if (this.projectExists(OTHER_PROJECT)) {
                    this.removeAssociationWithFieldLayoutScheme(OTHER_PROJECT, null, CUSTOM_FIELD_CONFIGURATION_SCHEME);
                    this.deleteProject(OTHER_PROJECT);
                }
                this.deleteFieldLayoutScheme(CUSTOM_FIELD_CONFIGURATION_SCHEME);
                throw throwable;
            }
            this.deleteIssue(otherProjectIssueKey);
        }
        if (this.projectExists(OTHER_PROJECT)) {
            this.removeAssociationWithFieldLayoutScheme(OTHER_PROJECT, null, CUSTOM_FIELD_CONFIGURATION_SCHEME);
            this.deleteProject(OTHER_PROJECT);
        }
        this.deleteFieldLayoutScheme(CUSTOM_FIELD_CONFIGURATION_SCHEME);
    }

    private void associatedSchemeWithConfiguration(String schemeName, String fieldConfigurationName) {
        this.gotoFieldLayoutSchemes();
        this.clickLinkWithText(schemeName);
        this.clickLinkWithText("Edit");
        this.selectOption("fieldConfigurationId", fieldConfigurationName);
        this.submit("Update");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _testBulkMoveWithDifferentRendererTypes() {
        TestFieldRenderers.log("--- begin testBulkMoveWithDifferentRendererTypes");
        try {
            this.displayAllIssues();
            this.bulkChangeIncludeAllPages();
            HttpUnitOptions.setScriptingEnabled((boolean)true);
            this.bulkChangeChooseIssuesAll();
            this.isStepChooseOperation();
            this.chooseOperationBulkMove();
            this.selectOption(this.projectId + "_1_pid", "homosapien");
            this.checkCheckbox("sameAsBulkEditBean", this.projectId + "_1_");
            this.navigation.clickOnNext();
            this.assertTextPresent("warning-Custom Field Text Area Field");
            this.assertTextNotPresent("warning-Custom Field Text Field");
            this.bulkChangeCancel();
        }
        finally {
            HttpUnitOptions.setScriptingEnabled((boolean)false);
        }
        TestFieldRenderers.log("--- end   testBulkMoveWithDifferentRendererTypes");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _testBulkEditWithDifferentRendererTypes() {
        TestFieldRenderers.log("--- begin testBulkEditWithDifferentRendererTypes");
        try {
            this.displayAllIssues();
            this.bulkChangeIncludeAllPages();
            HttpUnitOptions.setScriptingEnabled((boolean)true);
            this.bulkChangeChooseIssuesAll();
            this.isStepChooseOperation();
            this.bulkChangeChooseOperationEdit();
            this.assertTextPresent("This field has inconsistent renderer types for the project(s) of the selected issues.");
            this.bulkChangeCancel();
        }
        finally {
            HttpUnitOptions.setScriptingEnabled((boolean)false);
        }
        TestFieldRenderers.log("--- end   testBulkEditWithDifferentRendererTypes");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _testBulkEditWithSameRendererType() {
        TestFieldRenderers.log("--- begin testBulkEditWithSameRendererType");
        try {
            this.displayAllIssues();
            this.bulkChangeIncludeAllPages();
            HttpUnitOptions.setScriptingEnabled((boolean)true);
            this.bulkChangeChooseIssuesAll();
            this.isStepChooseOperation();
            this.bulkChangeChooseOperationEdit();
            this.validateWikiRendererForField("customfield_" + this.textAreaCustomFieldId, CUSTOM_FIELD_NAME_TEXT_AREA_FIELD, this.issueKey);
            this.validateWikiRendererForField("customfield_" + this.textCustomFieldId, CUSTOM_FIELD_NAME_TEXT_FIELD, this.issueKey);
            this.bulkChangeCancel();
        }
        finally {
            HttpUnitOptions.setScriptingEnabled((boolean)false);
        }
        TestFieldRenderers.log("--- end   testBulkEditWithSameRendererType");
    }

    private void _testRendererPluginConfiguration() {
        this._testTextRendererDoesNotAllowDisable();
        this._testWikiRendererDisabled();
        this._testWikiRendererMacroDisabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _testWikiRendererMacroDisabled() {
        TestFieldRenderers.log("--- begin testWikiRendererMacroDisabled");
        try {
            this.gotoIssue(this.issueKey);
            this.clickLink("editIssue");
            this.setFormElement(DESCRIPTION_ID, "{color:blue}blue functional test text{color}");
            this.submit("Update");
            this.assertTextPresent("<font color=\"blue\">blue functional test text</font>");
            this.disableMacro(COLOUR_MACRO_KEY);
            this.gotoIssue(this.issueKey);
            this.assertTextPresent("{color:blue}blue functional test text{color}");
        }
        finally {
            this.enableMacro(COLOUR_MACRO_KEY);
        }
        TestFieldRenderers.log("--- end   testWikiRendererMacroDisabled");
    }

    private void enableMacro(String macroKey) {
        this.goToMacroPluginsScreen();
        this.clickLink("enable-" + macroKey);
    }

    private void disableMacro(String macroKey) {
        this.goToMacroPluginsScreen();
        this.clickLink("disable-" + macroKey);
    }

    public void _testTextRendererDoesNotAllowDisable() {
        TestFieldRenderers.log("--- begin testTextRendererDoesNotAllowDisable");
        this.gotoRendererPluginsScreen();
        this.assertTextNotPresent("disable-com.atlassian.jira.plugin.system.jirarenderers:default-text-renderer");
        TestFieldRenderers.log("--- end   testTextRendererDoesNotAllowDisable");
    }

    public void _testWikiRendererDisabled() {
        TestFieldRenderers.log("--- begin testWikiRendererDisabled");
        this.gotoRendererPluginsScreen();
        this.assertTextPresent("disable-com.atlassian.jira.plugin.system.jirarenderers:atlassian-wiki-renderer");
        this.clickLink("disable-com.atlassian.jira.plugin.system.jirarenderers:atlassian-wiki-renderer");
        this.assertTextPresent("enable-com.atlassian.jira.plugin.system.jirarenderers:atlassian-wiki-renderer");
        this.gotoIssue(this.issueKey);
        this.clickLink("editIssue");
        this.validateNoWikiRendererForField(DESCRIPTION_ID, "Description", this.issueKey);
        this.assertTextPresent("This field is configured to use the \"atlassian-wiki-renderer\" which is not currently available, using \"Default Text Renderer\" instead.");
        this.gotoRendererPluginsScreen();
        this.assertTextPresent("enable-com.atlassian.jira.plugin.system.jirarenderers:atlassian-wiki-renderer");
        this.clickLink("enable-com.atlassian.jira.plugin.system.jirarenderers:atlassian-wiki-renderer");
        this.assertTextPresent("disable-com.atlassian.jira.plugin.system.jirarenderers:atlassian-wiki-renderer");
        TestFieldRenderers.log("--- end   testWikiRendererDisabled");
    }

    public void _testRendererConfiguration() {
        this._testRendererConfigurationWarningMessage();
        this._testRendererConfigurationChangeRendererType();
        this._testCustomLayoutRendererConfiguration();
    }

    public void _testCustomLayoutRendererConfiguration() {
        TestFieldRenderers.log("--- begin testCustomLayoutRendererConfiguration");
        this.setFieldConfigurationFieldToRenderer(CUSTOM_FIELD_CONFIGURATION, DESCRIPTION_ID, WIKI_STYLE_RENDERER, true);
        this.setFieldConfigurationFieldToRenderer(CUSTOM_FIELD_CONFIGURATION, DESCRIPTION_ID, DEFAULT_TEXT_RENDERER, true);
        TestFieldRenderers.log("--- end   testCustomLayoutRendererConfiguration");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _testRendererConfigurationChangeRendererType() {
        TestFieldRenderers.log("--- begin testRendererConfigurationChangeRendererType");
        try {
            HttpUnitOptions.setScriptingEnabled((boolean)true);
            this.setFieldConfigurationFieldToRenderer(DEFAULT_FIELD_CONFIGURATION, COMMENT_FIELD_ID, DEFAULT_TEXT_RENDERER);
            this.gotoIssue(this.issueKey);
            this.validateNoWikiRendererForField(COMMENT_FIELD_ID, "Comment", this.issueKey);
            this.setFieldConfigurationFieldToRenderer(DEFAULT_FIELD_CONFIGURATION, COMMENT_FIELD_ID, WIKI_STYLE_RENDERER);
        }
        finally {
            HttpUnitOptions.setScriptingEnabled((boolean)false);
        }
        TestFieldRenderers.log("--- end   testRendererConfigurationChangeRendererType");
    }

    public void _testRendererConfigurationWarningMessage() {
        TestFieldRenderers.log("--- begin testRendererConfigurationWarningMessage");
        this.gotoFieldLayoutConfiguration(DEFAULT_FIELD_CONFIGURATION);
        this.clickLink("renderer_description");
        this.assertTextPresent("Edit Field Renderer");
        this.assertTextPresent("A renderer determines how the value of a field will be displayed within the system.");
        TestFieldRenderers.log("--- end   testRendererConfigurationWarningMessage");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _testWikiPreview() {
        TestFieldRenderers.log("--- begin testWikiPreview");
        try {
            HttpUnitOptions.setScriptingEnabled((boolean)true);
            this.gotoIssue(this.issueKey);
            this.clickLink("editIssue");
            this.setFormElement(DESCRIPTION_ID, ":)");
            this.clickLink("description-preview_link");
            this.assertTextPresent("<p><img class=\"emoticon\" src=\"http://localhost:8080/images/icons/emoticons/smile.gif\" alt=\"\" align=\"middle\" border=\"0\" height=\"20\" width=\"20\"></p>");
        }
        finally {
            HttpUnitOptions.setScriptingEnabled((boolean)false);
        }
        TestFieldRenderers.log("--- end   testWikiPreview");
    }

    public void _testWikiRendererVisible() {
        this._testWikiRendererVisibleOnViewIssue();
        this._testWikiRendererVisibleOnEditIssue();
        this._testWikiRendererVisibleOnCreateIssue();
        this._testWikiRendererVisibleOnAssignIssue();
        this._testWikiRendererVisibleOnAttachFile();
        this._testWikiRendererVisibleOnLinkIssue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _testWikiRendererVisibleOnLinkIssue() {
        TestFieldRenderers.log("--- begin testWikiRendererVisibleOnLinkIssue");
        try {
            this.createIssueLinkType();
            HttpUnitOptions.setScriptingEnabled((boolean)true);
            this.gotoIssue(this.issueKey);
            this.clickLink("link-issue");
            this.validateWikiRendererForField(COMMENT_FIELD_ID, "Comment", this.issueKey);
        }
        finally {
            HttpUnitOptions.setScriptingEnabled((boolean)false);
            this.deactivateIssueLinking();
        }
        TestFieldRenderers.log("--- end   testWikiRendererVisibleOnLinkIssue");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _testWikiRendererVisibleOnAssignIssue() {
        TestFieldRenderers.log("--- begin testWikiRendererVisibleOnAttachFile");
        try {
            HttpUnitOptions.setScriptingEnabled((boolean)true);
            this.gotoIssue(this.issueKey);
            this.clickLink("assign-issue");
            this.validateWikiRendererForField(COMMENT_FIELD_ID, "Comment", this.issueKey);
        }
        finally {
            HttpUnitOptions.setScriptingEnabled((boolean)false);
        }
        TestFieldRenderers.log("--- end   testWikiRendererVisibleOnAttachFile");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _testWikiRendererVisibleOnAttachFile() {
        TestFieldRenderers.log("--- begin testWikiRendererVisibleOnAssignIssue");
        try {
            HttpUnitOptions.setScriptingEnabled((boolean)true);
            this.gotoIssue(this.issueKey);
            this.clickLink("attach-file");
            this.validateWikiRendererForField(COMMENT_FIELD_ID, "Comment", this.issueKey);
        }
        finally {
            HttpUnitOptions.setScriptingEnabled((boolean)false);
        }
        TestFieldRenderers.log("--- end   testWikiRendererVisibleOnAssignIssue");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _testWikiRendererVisibleOnCreateIssue() {
        TestFieldRenderers.log("--- begin testWikiRendererVisibleOnCreateIssue");
        try {
            HttpUnitOptions.setScriptingEnabled((boolean)true);
            this.clickLink("create_link");
            this.assertTextPresent("Create Issue");
            this.selectOption("pid", "homosapien");
            this.selectOption("issuetype", "Bug");
            this.submit();
            this.assertTextPresent("CreateIssueDetails.jspa");
            this.validateWikiRendererForField(DESCRIPTION_ID, "Description", "");
            this.validateWikiRendererForField(ENVIRONMENT_ID, "Environment", "");
            this.validateWikiRendererForField("customfield_" + this.textAreaCustomFieldId, CUSTOM_FIELD_NAME_TEXT_AREA_FIELD, "");
            this.validateWikiRendererForField("customfield_" + this.textCustomFieldId, CUSTOM_FIELD_NAME_TEXT_FIELD, "");
        }
        finally {
            HttpUnitOptions.setScriptingEnabled((boolean)false);
        }
        TestFieldRenderers.log("--- end   testWikiRendererVisibleOnCreateIssue");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _testWikiRendererVisibleOnEditIssue() {
        TestFieldRenderers.log("--- begin testWikiRendererVisibleOnEditIssue");
        try {
            HttpUnitOptions.setScriptingEnabled((boolean)true);
            this.gotoIssue(this.issueKey);
            this.clickLink("editIssue");
            this.validateWikiRendererForField(COMMENT_FIELD_ID, "Comment", this.issueKey);
            this.validateWikiRendererForField(DESCRIPTION_ID, "Description", this.issueKey);
            this.validateWikiRendererForField(ENVIRONMENT_ID, "Environment", this.issueKey);
            this.validateWikiRendererForField("customfield_" + this.textAreaCustomFieldId, CUSTOM_FIELD_NAME_TEXT_AREA_FIELD, this.issueKey);
            this.validateWikiRendererForField("customfield_" + this.textCustomFieldId, CUSTOM_FIELD_NAME_TEXT_FIELD, this.issueKey);
        }
        finally {
            HttpUnitOptions.setScriptingEnabled((boolean)false);
        }
        TestFieldRenderers.log("--- end   testWikiRendererVisibleOnEditIssue");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _testWikiRendererVisibleOnViewIssue() {
        TestFieldRenderers.log("--- begin testWikiRendererVisibleOnViewIssue");
        try {
            HttpUnitOptions.setScriptingEnabled((boolean)true);
            this.gotoIssue(this.issueKey);
            this.validateWikiRendererForField(COMMENT_FIELD_ID, "Comment", this.issueKey);
        }
        finally {
            HttpUnitOptions.setScriptingEnabled((boolean)false);
        }
        TestFieldRenderers.log("--- end   testWikiRendererVisibleOnViewIssue");
    }

    public void _testWikiRendererBadLink() {
        this.assertValidIssueDescription("[<b>testWikiRendererBadLink</b>|http://www.google.com/]", HTML_CODE);
        this.assertValidIssueDescription("[<b>testWikiRendererBadLink</b>]", HTML_CODE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _testWikiRendererBadMacro() {
        this.assertValidIssueDescription("{code}<b>testWikiRendererBadLink</b>{code}", HTML_CODE);
        this.assertValidIssueDescription("{noSuchMacro}<b>testWikiRendererBadLink</b>{noSuchMacro}", HTML_CODE);
        try {
            this.disableMacro(COLOUR_MACRO_KEY);
            this.assertValidIssueDescription("{color:orange}<b>testWikiRendererBadLink</b>{color:orange}", HTML_CODE);
        }
        finally {
            this.enableMacro(COLOUR_MACRO_KEY);
        }
    }

    private void gotoRendererPluginsScreen() {
        this.administration.goToPluginInfo("Renderer Plugin", "JIRA's system renderers");
    }

    private void goToMacroPluginsScreen() {
        this.administration.goToPluginInfo("Wiki Renderer Macros Plugin", "JIRA's base system macros");
    }

    private void assertValidIssueDescription(String descriptionToEnter, String assertNotPresent) {
        String issueKey = this.addIssue("homosapien", "HSP", "Bug", "testing cross site scripting", "Major", null, null, null, "Administrator", "test environment", descriptionToEnter, null, null, null);
        this.gotoIssue(issueKey);
        this.assertTextNotPresent(assertNotPresent);
    }

    private void createIssueLinkType() {
        this.activateIssueLinking();
        this.setFormElement("name", "Duplicate");
        this.setFormElement("outward", "is a duplicate of");
        this.setFormElement("inward", "duplicates");
        this.submit();
    }

    private void validateNoWikiRendererForField(String field, String fieldDisplayName, String issueKey) {
        this.assertTextNotPresent("<dd>" + field + "-preview_link</dd>");
        this.assertTextNotPresent("<dd>" + fieldDisplayName + "</dd>");
        this.assertTextNotPresent("<dd>" + issueKey + "</dd>");
    }

    private void validateWikiRendererForField(String field, String fieldDisplayName, String issueKey) {
        this.assertTextPresent("<dd>" + field + "-preview_link</dd>");
        this.assertTextPresent("<dd>" + fieldDisplayName + "</dd>");
        this.assertTextPresent("<dd>" + issueKey + "</dd>");
    }
}

