/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.email;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.webtests.EmailFuncTestCase;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;

public class TestBulkWorkflowTransitionNotification
extends EmailFuncTestCase {
    private static final String COMMENT_TEXT = "This comment should appear in the email body.";
    private static final String WORKFLOW_RESOLVE = "jira_5_5";
    private static final String WORKFLOW_REOPEN = "jira_3_4";

    public void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestBulkWorkflowTransitionNotification.xml");
        this.configureAndStartSmtpServer();
    }

    public void testResolvedCommentAppearsInEmail() throws MessagingException, InterruptedException, IOException {
        this._testCommentAppearsInEmail("10000", "TST-1", WORKFLOW_RESOLVE, "Fixed", "[JIRATEST] Resolved: (TST-1) First Issue", null);
    }

    public void testReopenedCommentAppearsInEmail() throws MessagingException, InterruptedException, IOException {
        this._testCommentAppearsInEmail("10001", "TST-2", WORKFLOW_REOPEN, null, "[JIRATEST] Reopened: (TST-2) Second Issue", null);
    }

    public void testCommentVisibilityInEmailForJiraAdmins() throws MessagingException, InterruptedException, IOException {
        String commentLevel = "jira-administrators";
        this._performBulkOperation("10000", WORKFLOW_RESOLVE, "Fixed", "jira-administrators");
        this.assertCommentVisibility(EasyMap.build((Object)"admin@example.com", (Object)Boolean.TRUE, (Object)"devman@example.com", (Object)Boolean.FALSE, (Object)"fred@example.com", (Object)Boolean.FALSE));
    }

    public void testCommentVisibilityInEmailForJiraDevs() throws MessagingException, InterruptedException, IOException {
        String commentLevel = "jira-developers";
        this._performBulkOperation("10000", WORKFLOW_RESOLVE, "Fixed", "jira-developers");
        this.assertCommentVisibility(EasyMap.build((Object)"admin@example.com", (Object)Boolean.TRUE, (Object)"devman@example.com", (Object)Boolean.TRUE, (Object)"fred@example.com", (Object)Boolean.FALSE));
    }

    public void testCommentVisibilityInEmailForJiraUsers() throws MessagingException, InterruptedException, IOException {
        String commentLevel = "jira-users";
        this._performBulkOperation("10000", WORKFLOW_RESOLVE, "Fixed", "jira-users");
        this.assertCommentVisibility(EasyMap.build((Object)"admin@example.com", (Object)Boolean.TRUE, (Object)"devman@example.com", (Object)Boolean.TRUE, (Object)"fred@example.com", (Object)Boolean.TRUE));
    }

    public void testCommentVisibilityInEmailForProjectAdmins() throws MessagingException, InterruptedException, IOException {
        String commentLevel = "Administrators";
        this._performBulkOperation("10000", WORKFLOW_RESOLVE, "Fixed", "Administrators");
        this.assertCommentVisibility(EasyMap.build((Object)"admin@example.com", (Object)Boolean.TRUE, (Object)"devman@example.com", (Object)Boolean.TRUE, (Object)"fred@example.com", (Object)Boolean.FALSE));
    }

    public void testCommentVisibilityInEmailForProjectDevs() throws MessagingException, InterruptedException, IOException {
        String commentLevel = "Developers";
        this._performBulkOperation("10000", WORKFLOW_RESOLVE, "Fixed", "Developers");
        this.assertCommentVisibility(EasyMap.build((Object)"admin@example.com", (Object)Boolean.TRUE, (Object)"devman@example.com", (Object)Boolean.TRUE, (Object)"fred@example.com", (Object)Boolean.TRUE));
    }

    public void testCommentVisibilityInEmailForProjectUsers() throws MessagingException, InterruptedException, IOException {
        String commentLevel = "Users";
        this._performBulkOperation("10000", WORKFLOW_RESOLVE, "Fixed", "Users");
        this.assertCommentVisibility(EasyMap.build((Object)"admin@example.com", (Object)Boolean.TRUE, (Object)"devman@example.com", (Object)Boolean.FALSE, (Object)"fred@example.com", (Object)Boolean.FALSE));
    }

    private void _testCommentAppearsInEmail(String chkId, String issueId, String workflow, String resolution, String subject, String commentLevel) throws InterruptedException, MessagingException, IOException {
        this._performBulkOperation(chkId, workflow, resolution, commentLevel);
        List<MimeMessage> messagesForAdmin = this.getMessagesForRecipient("admin@example.com");
        TestBulkWorkflowTransitionNotification.assertTrue((messagesForAdmin.size() == 1 ? 1 : 0) != 0);
        this.assertMailProperties(messagesForAdmin.get(0), subject, COMMENT_TEXT);
        this.assertCommentVisibility(EasyMap.build((Object)"admin@example.com", (Object)Boolean.TRUE, (Object)"devman@example.com", (Object)Boolean.TRUE, (Object)"fred@example.com", (Object)Boolean.TRUE));
        this.navigation.issue().viewIssue(issueId);
        this.assertions.getTextAssertions().assertTextPresentNumOccurences(new WebPageLocator(this.tester), COMMENT_TEXT, 2);
    }

    private void assertMailProperties(MimeMessage message, String subject, String comment) throws MessagingException, IOException {
        this.assertEmailSubjectEquals(message, subject);
        this.assertEmailFromEquals(message, "\"Administrator (JIRA)\" <jiratest@atlassian.com>");
        this.assertEmailBodyContains(message, comment);
    }

    private void assertCommentVisibility(Map visibility) throws MessagingException, InterruptedException, IOException {
        for (String recipient : visibility.keySet()) {
            Boolean isCommentVisible = (Boolean)visibility.get(recipient);
            List<MimeMessage> messages = this.getMessagesForRecipient(recipient);
            TestBulkWorkflowTransitionNotification.assertTrue((messages.size() == 1 ? 1 : 0) != 0);
            if (isCommentVisible.booleanValue()) {
                this.assertEmailBodyContains(messages.get(0), COMMENT_TEXT);
                continue;
            }
            this.assertEmailBodyDoesntContain(messages.get(0), COMMENT_TEXT);
        }
    }

    private void _performBulkOperation(String chkId, String workflow, String resolution, String commentLevel) throws InterruptedException, MessagingException {
        this.navigation.issueNavigator().gotoNavigator();
        this.tester.submit("show");
        this.tester.clickLink("bulkedit_all");
        this.tester.checkCheckbox("bulkedit_" + chkId);
        this.navigation.clickOnNext();
        this.tester.setFormElement("operation", "bulk.workflowtransition.operation.name");
        this.navigation.clickOnNext();
        this.navigation.workflows().chooseWorkflowAction(workflow);
        if (resolution != null) {
            this.tester.selectOption("resolution", resolution);
        }
        this.tester.checkCheckbox("commentaction", "comment");
        this.tester.setFormElement("comment", COMMENT_TEXT);
        if (commentLevel != null) {
            this.tester.selectOption("commentLevel", commentLevel);
        }
        this.navigation.clickOnNext();
        this.navigation.clickOnNext();
        this.flushMailQueueAndWait(3);
        MimeMessage[] mimeMessages = this.getGreenMail().getReceivedMessages();
        TestBulkWorkflowTransitionNotification.assertEquals((int)3, (int)mimeMessages.length);
        this.assertRecipientsHaveMessages(EasyList.build((Object)"admin@example.com", (Object)"devman@example.com", (Object)"fred@example.com"));
    }
}

