/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.dashboard;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.jira.functest.framework.Dashboard;
import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.sharing.SharedEntityInfo;
import com.atlassian.jira.functest.framework.sharing.TestSharingPermissionUtils;
import java.util.List;

public class TestEditPortalPage
extends FuncTestCase {
    private static final SharedEntityInfo PAGE_FRED_PRIVATE = new SharedEntityInfo(10010L, "PrivateFredDashboard", "This is private to fred and should not be visible to anyone else.", true, TestSharingPermissionUtils.createPrivatePermissions());
    private static final SharedEntityInfo PAGE_FRED_PUBLIC = new SharedEntityInfo(10011L, "PublicFredDashboard", "This is a dashboard page that can be seen by everyone.", true, TestSharingPermissionUtils.createPublicPermissions());
    private static final SharedEntityInfo PAGE_EXISTS = new SharedEntityInfo(10012L, "Exists", null, true, TestSharingPermissionUtils.createPrivatePermissions());
    private static final SharedEntityInfo PAGE_ADMINNOTFAVOURITE = new SharedEntityInfo(10013L, "AdminNotFavourite", null, false, TestSharingPermissionUtils.createPublicPermissions());
    private static final SharedEntityInfo PAGE_ADMINFAVOURITE = new SharedEntityInfo(10014L, "AdminFavourite", null, true, TestSharingPermissionUtils.createPublicPermissions());
    private static final Long SYSTEM_DEFAULT_PAGE_ID = 10000L;
    private static final String FRED_USER_NAME = "fred";

    protected void setUpTest() {
        this.administration.restoreData("BaseProfessionalPortalPage.xml");
    }

    public void testMissingPageId() {
        SharedEntityInfo page = new SharedEntityInfo(null, "testMissingPageId", null, true, null);
        this._testCantEditPageWithFormError(page, "You must select a dashboard to edit.");
    }

    public void testEditNameAlreadyExists() {
        SharedEntityInfo page = new SharedEntityInfo(PAGE_ADMINFAVOURITE.getId(), "Exists", null, true, null);
        this._testPageNotEdited(page, PAGE_ADMINFAVOURITE, "Dashboard with same name already exists.");
    }

    public void testEditBlankName() {
        SharedEntityInfo page = new SharedEntityInfo(PAGE_EXISTS.getId(), "", null, true, null);
        this._testPageNotEdited(page, PAGE_EXISTS, "You must specify a name to save the dashboard as.");
    }

    public void testEditSystemDefaultPage() {
        SharedEntityInfo page = new SharedEntityInfo(SYSTEM_DEFAULT_PAGE_ID, "testEditSystemDefaultPage", null, true, null);
        this._testCantEditPageWithFormError(page, "You cannot edit the system dashboard.");
    }

    public void testNoPermissionToEdit() {
        this.navigation.login(FRED_USER_NAME);
        SharedEntityInfo page = new SharedEntityInfo(PAGE_EXISTS.getId(), "", null, true, null);
        this._testCantEditPageWithFormError(page, "You must select a dashboard to edit.");
    }

    public void testNoPermissionToEditButPageIsShared() {
        this.navigation.login(FRED_USER_NAME);
        SharedEntityInfo page = new SharedEntityInfo(PAGE_ADMINFAVOURITE.getId(), "testNoPermissionToEditButPageIsShared", null, true, null);
        this._testCantEditPageWithFormError(page, "You may only create, modify or delete dashboards that you own.");
    }

    public void testNoPageExists() {
        SharedEntityInfo page = new SharedEntityInfo(666L, "testNoPageExists", null, true, null);
        this._testCantEditPageWithFormError(page, "You must select a dashboard to edit.");
    }

    public void testEditViewReflectsData() {
        this.validateInitialState(PAGE_ADMINFAVOURITE);
        this.validateInitialState(PAGE_ADMINNOTFAVOURITE);
        this.navigation.login(FRED_USER_NAME);
        this.validateInitialState(PAGE_FRED_PRIVATE);
        this.validateInitialState(PAGE_FRED_PUBLIC);
    }

    public void testXSSNameAdnDescription() {
        SharedEntityInfo page = new SharedEntityInfo(PAGE_EXISTS.getId(), "<script>alert('IName')</script>", "<script>alert('IDescription')</script>", true, TestSharingPermissionUtils.createPrivatePermissions());
        this._testPageEditedCorrectly(page, EasyList.build((Object)page, (Object)PAGE_ADMINFAVOURITE));
    }

    public void testEditCanSaveItself() {
        SharedEntityInfo page = new SharedEntityInfo(PAGE_EXISTS);
        page.setDescription("A new description");
        this._testPageEditedCorrectly(page, EasyList.build((Object)page, (Object)PAGE_ADMINFAVOURITE));
    }

    public void testChangeFavouriteToFalse() {
        SharedEntityInfo page = new SharedEntityInfo(PAGE_ADMINFAVOURITE);
        page.setFavourite(false);
        this._testPageEditedCorrectly(page, EasyList.build((Object)PAGE_EXISTS));
        this.navigation.dashboard().navigateToMy();
        this.assertions.getDashboardAssertions().assertDashboardPages(EasyList.build((Object)page, (Object)PAGE_ADMINNOTFAVOURITE, (Object)PAGE_EXISTS), Dashboard.Table.OWNED);
    }

    public void testChangeFavouriteToTrue() {
        SharedEntityInfo page = new SharedEntityInfo(PAGE_ADMINNOTFAVOURITE);
        page.setFavourite(true);
        this._testPageEditedCorrectly(page, EasyList.build((Object)PAGE_EXISTS, (Object)PAGE_ADMINFAVOURITE, (Object)page));
        this.navigation.dashboard().navigateToMy();
        this.assertions.getDashboardAssertions().assertDashboardPages(EasyList.build((Object)PAGE_ADMINFAVOURITE, (Object)page, (Object)PAGE_EXISTS), Dashboard.Table.OWNED);
    }

    private void _testPageEditedCorrectly(SharedEntityInfo page, List expectedPageList) {
        this.navigation.dashboard().editPage(page);
        this.assertions.getDashboardAssertions().assertDashboardPages(expectedPageList, Dashboard.Table.FAVOURITE);
    }

    private void _testPageNotEdited(SharedEntityInfo page, String expectedText) {
        this.navigation.dashboard().editPage(page);
        this.assertions.getJiraFormAssertions().assertFieldErrMsg(expectedText);
    }

    private void _testPageNotEdited(SharedEntityInfo page, SharedEntityInfo oldPage, String expectedText) {
        this._testPageNotEdited(page, expectedText);
        this.validateInitialState(oldPage);
    }

    private void _testCantEditPageWithFormError(SharedEntityInfo page, String expectedText) {
        this.navigation.dashboard().editPage(page);
        this.assertions.getJiraFormAssertions().assertFormErrMsg(expectedText);
    }

    private void validateInitialState(SharedEntityInfo page) {
        this.tester.gotoPage("secure/EditPortalPage!default.jspa?pageId=" + page.getId());
        this.tester.assertFormElementEquals("portalPageName", page.getName());
        this.tester.assertFormElementEquals("portalPageDescription", page.getDescription());
        this.tester.assertFormElementEquals("favourite", String.valueOf(page.isFavourite()));
        this.tester.assertFormElementEquals("pageId", String.valueOf(page.getId()));
    }

    private void assertFredCanEditHisPortlets() {
        this.navigation.logout();
        this.navigation.login(FRED_USER_NAME, FRED_USER_NAME);
        this.tester.clickLink("home_link");
        this.tester.clickLink("configure_on");
        this.tester.clickLink("config_10040");
        this.tester.assertTextPresent("Edit Portlet: Project");
        this.tester.selectOption("projectinfo", "Brief");
        this.tester.submit("Save");
    }

    private void hideHomosapientFromFred() {
        this.navigation.logout();
        this.navigation.login("admin", "admin");
        this.tester.clickLink("admin_link");
        this.tester.clickLinkWithText("homosapien");
        this.tester.clickLink("select_permission_scheme");
        this.tester.selectOption("schemeIds", "hidden_from_fred");
        this.tester.submit("Associate");
    }
}

