/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.customfield;

import com.atlassian.jira.webtests.JIRAWebTest;

public class TestCustomFieldsNoSearcherPermissions
extends JIRAWebTest {
    public TestCustomFieldsNoSearcherPermissions(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.restoreData("TestCustomFieldsNoSearcherPermissions.xml");
    }

    public void testEditCustomFieldSetSearcherToNone() {
        this.gotoAdmin();
        this.clickLink("view_custom_fields");
        this.clickLink("edit_User picker");
        this.setFormElement("name", "User picker");
        this.selectOption("searcher", "None");
        this.submit("Update");
        this.assertTextPresent("Search Template cannot be set to &#39;None&#39; because this custom field is used in the following Permission Scheme(s): Default Permission Scheme");
        this.assertTextPresent("Search Template cannot be set to &#39;None&#39; because this custom field is used in the following Issue Level Security Scheme(s): TestScheme");
        this.gotoAdmin();
        this.clickLink("view_custom_fields");
        this.clickLink("edit_multigrouppicker");
        this.setFormElement("name", "multigrouppicker");
        this.selectOption("searcher", "None");
        this.submit("Update");
        this.assertTextPresent("Search Template cannot be set to &#39;None&#39; because this custom field is used in the following Permission Scheme(s): Default Permission Scheme");
        this.assertTextPresent("Search Template cannot be set to &#39;None&#39; because this custom field is used in the following Issue Level Security Scheme(s): TestScheme");
    }

    public void testDeleteCustomField() {
        this.gotoAdmin();
        this.clickLink("view_custom_fields");
        this.clickLink("del_customfield_10000");
        this.submit("Delete");
        this.assertTextPresent("Custom field cannot be deleted because it is used in the following Permission Scheme(s): Default Permission Scheme");
        this.assertTextPresent("Custom field cannot be deleted because it is used in the following Issue Level Security Scheme(s): TestScheme");
        this.gotoAdmin();
        this.clickLink("view_custom_fields");
        this.clickLink("del_customfield_10001");
        this.submit("Delete");
        this.assertTextPresent("Custom field cannot be deleted because it is used in the following Permission Scheme(s): Default Permission Scheme");
        this.assertTextPresent("Custom field cannot be deleted because it is used in the following Issue Level Security Scheme(s): TestScheme");
    }

    public void testAddCustomFieldWithoutSearcherToPermission() {
        this.gotoAdmin();
        this.clickLink("permission_schemes");
        this.clickLinkWithText("Default Permission Scheme");
        this.clickLink("add_perm_11");
        this.checkCheckbox("type", "userCF");
        this.selectOption("userCF", "nosearchercf");
        this.submit(" Add ");
        this.assertTextPresent("Custom field &#39;nosearchercf&#39; is not indexed for searching - please add a Search Template to this Custom Field.");
    }

    public void testAddCustomFieldWithoutSearcherToIssueLevelPermission() {
        this.gotoAdmin();
        this.clickLink("security_schemes");
        this.clickLinkWithText("Security Levels");
        this.clickLink("add_TestLevel");
        this.checkCheckbox("type", "userCF");
        this.selectOption("userCF", "nosearchercf");
        this.submit(" Add ");
        this.assertTextPresent("Custom field &#39;nosearchercf&#39; is not indexed for searching - please add a Search Template to this Custom Field.");
    }

    public void testAddingSearcherToCustomField() {
        this.gotoAdmin();
        this.clickLink("view_custom_fields");
        this.clickLink("edit_nosearchercf");
        this.selectOption("searcher", "User Picker Searcher");
        this.submit("Update");
        this.clickLink("permission_schemes");
        this.clickLink("0_edit");
        this.clickLink("add_perm_25");
        this.checkCheckbox("type", "userCF");
        this.selectOption("userCF", "nosearchercf");
        this.submit(" Add ");
        this.assertTextPresent("Default Permission Scheme");
        this.assertTextSequence(new String[]{"Move Issues", "nosearchercf"});
    }

    public void testRemovingCustomField() {
        this.gotoAdmin();
        this.clickLink("permission_schemes");
        this.clickLink("0_edit");
        this.clickLink("del_perm_12_customfield_10000");
        this.submit("Delete");
        this.clickLink("security_schemes");
        this.clickLinkWithText("Security Levels");
        this.clickLink("delGroup_customfield_10000_TestLevel");
        this.submit("Delete");
        this.clickLink("view_custom_fields");
        this.clickLink("del_customfield_10000");
        this.submit("Delete");
        this.assertTextPresent("View Custom Fields");
        this.assertTextNotPresent("User picker");
    }

    public void testDeleteIssueSecurityLevelFlushesCache() {
        this.grantPermissionToUserInEnterprise(26, "admin");
        this.associateIssueLevelSecuritySchemeToProject("homosapien", "TestScheme");
        this.gotoAdmin();
        this.clickLink("security_schemes");
        this.clickLinkWithText("Security Levels");
        this.clickLink("add_TestLevel");
        this.checkCheckbox("type", "user");
        this.setFormElement("user", "admin");
        this.submit(" Add ");
        this.gotoIssue("HSP-1");
        this.clickLink("editIssue");
        this.assertTextPresent("TestLevel");
        this.setFormElement("customfield_10000", "admin");
        this.submit("Update");
        this.gotoAdmin();
        this.clickLink("security_schemes");
        this.clickLinkWithText("Security Levels");
        this.clickLink("delGroup_admin_TestLevel");
        this.submit("Delete");
        this.gotoIssue("HSP-1");
        this.clickLink("editIssue");
        this.assertTextPresent("TestLevel");
        this.gotoAdmin();
        this.clickLink("security_schemes");
        this.clickLinkWithText("Security Levels");
        this.clickLink("delGroup_customfield_10000_TestLevel");
        this.submit("Delete");
        this.clickLink("security_schemes");
        this.clickLinkWithText("Security Levels");
        this.clickLink("delGroup_customfield_10001_TestLevel");
        this.submit("Delete");
        this.gotoIssue("HSP-1");
        this.clickLink("editIssue");
        this.assertTextNotPresent("TestLevel");
    }
}

