/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.charts;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.TableCellLocator;
import com.atlassian.jira.functest.framework.locator.TableLocator;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;

public class TestCharting
extends FuncTestCase {
    protected void setUpTest() {
        this.administration.restoreBlankInstance();
    }

    public void testCreatedVsResolvedReport() {
        this.tester.gotoPage("/secure/ConfigureReport!default.jspa?selectedProjectId=10000&reportKey=com.atlassian.jira.plugin.system.reports:createdvsresolved-report");
        this.tester.assertTextPresent("Report: Created vs Resolved Issues Report");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Please specify a project or filter");
        this.tester.setFormElement("daysprevious", "aaa");
        this.tester.submit("Next");
        this.tester.assertTextPresent("You must specify a whole number of days.");
        this.tester.setFormElement("projectOrFilterId", "project-10000");
        this.tester.setFormElement("daysprevious", "30");
        this.tester.submit("Next");
        WebPageLocator locator = new WebPageLocator(this.tester);
        this.text.assertTextPresent(locator, "There are no matching issues to report on.");
        this.navigation.issue().createIssue("homosapien", "Bug", "My first bug");
        this.tester.gotoPage("/secure/ConfigureReport!default.jspa?selectedProjectId=10000&reportKey=com.atlassian.jira.plugin.system.reports:createdvsresolved-report");
        this.tester.setFormElement("projectOrFilterId", "project-10000");
        this.tester.setFormElement("daysprevious", "30");
        this.tester.submit("Next");
        locator = new WebPageLocator(this.tester);
        this.text.assertTextSequence(locator, "Report:", "Created vs Resolved Issues Report");
        this.text.assertTextSequence(locator, "Project:", "homosapien");
        this.text.assertTextSequence(locator, "This chart shows the number of issues", "created", "vs the number of issues", "resolved", "in the last", "30", "days.");
        this.tester.assertTextPresent("Data Table");
        TableLocator tableLocator = new TableLocator(this.tester, "createdvsresolved-report-datatable");
        this.text.assertTextPresent(tableLocator, "Period");
        this.text.assertTextPresent(tableLocator, "Created");
        this.text.assertTextPresent(tableLocator, "Resolved");
    }

    public void testResolutionTimeReport() {
        this.tester.gotoPage("/secure/ConfigureReport!default.jspa?selectedProjectId=10000&reportKey=com.atlassian.jira.plugin.system.reports:resolutiontime-report");
        this.tester.assertTextPresent("Report: Resolution Time Report");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Please specify a project or filter");
        this.tester.setFormElement("daysprevious", "aaa");
        this.tester.submit("Next");
        this.tester.assertTextPresent("You must specify a whole number of days.");
        this.tester.setFormElement("projectOrFilterId", "project-10000");
        this.tester.setFormElement("daysprevious", "30");
        this.tester.submit("Next");
        WebPageLocator locator = new WebPageLocator(this.tester);
        this.text.assertTextPresent(locator, "There are no matching issues to report on.");
    }

    public void testPieReport() {
        this.tester.gotoPage("/secure/ConfigureReport!default.jspa?selectedProjectId=10000&reportKey=com.atlassian.jira.plugin.system.reports:pie-report");
        this.tester.assertTextPresent("Report: Pie Chart Report");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Please specify a project or filter");
        this.tester.setFormElement("projectOrFilterId", "project-10000");
        this.tester.selectOption("statistictype", "Issue Type");
        this.tester.submit("Next");
        WebPageLocator locator = new WebPageLocator(this.tester);
        this.text.assertTextSequence(locator, "Report:", "Pie Chart Report");
        this.text.assertTextSequence(locator, "Project:", "homosapien", "(Issue Type)");
        this.text.assertTextPresent(locator, "There are no matching issues to report on.");
        this.navigation.issue().createIssue("homosapien", "Bug", "My first bug");
        this.navigation.issue().createIssue("homosapien", "Improvement", "My first improvement");
        this.tester.gotoPage("/secure/ConfigureReport!default.jspa?selectedProjectId=10000&reportKey=com.atlassian.jira.plugin.system.reports:pie-report");
        this.tester.assertTextPresent("Report: Pie Chart Report");
        this.tester.setFormElement("projectOrFilterId", "project-10000");
        this.tester.selectOption("statistictype", "Issue Type");
        this.tester.submit("Next");
        locator = new WebPageLocator(this.tester);
        this.text.assertTextSequence(locator, "Report:", "Pie Chart Report");
        this.text.assertTextSequence(locator, "Project:", "homosapien", "(Issue Type)");
        this.tester.assertTextPresent("Data Table");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "singlefieldpie-report-datatable", 0, 1), "Issues");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "singlefieldpie-report-datatable", 0, 2), "%");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "singlefieldpie-report-datatable", 1, 0), "Improvement");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "singlefieldpie-report-datatable", 1, 1), "1");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "singlefieldpie-report-datatable", 1, 2), "50%");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "singlefieldpie-report-datatable", 2, 0), "Bug");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "singlefieldpie-report-datatable", 2, 1), "1");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "singlefieldpie-report-datatable", 2, 2), "50%");
    }

    public void testAverageAgeReport() {
        String name = "Average Age Report";
        this.assertReportValidation("/secure/ConfigureReport!default.jspa?selectedProjectId=10000&reportKey=com.atlassian.jira.plugin.system.reports:averageage-report", "Average Age Report", "There are no matching issues to report on.");
        WebPageLocator locator = new WebPageLocator(this.tester);
        this.text.assertTextSequence(locator, "Report:", "Average Age Report");
        this.text.assertTextSequence(locator, "Project:", "homosapien");
        this.tester.assertTextPresent("Data Table");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "averageage-report-datatable", 0, 0), "Period");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "averageage-report-datatable", 0, 1), "Issues Unresolved");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "averageage-report-datatable", 0, 2), "Total Age");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "averageage-report-datatable", 0, 3), "Avg. Age");
    }

    public void testRecentlyCreatedReport() {
        String name = "Recently Created Issues Report";
        this.assertReportValidation("/secure/ConfigureReport!default.jspa?selectedProjectId=10000&reportKey=com.atlassian.jira.plugin.system.reports:recentlycreated-report", "Recently Created Issues Report", null);
        WebPageLocator locator = new WebPageLocator(this.tester);
        this.text.assertTextSequence(locator, "Report:", "Recently Created Issues Report");
        this.text.assertTextSequence(locator, "Project:", "homosapien");
        this.tester.assertTextPresent("Data Table");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "recentlycreated-report-datatable", 0, 0), "Period");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "recentlycreated-report-datatable", 0, 1), "Created Issues (Unresolved)");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "recentlycreated-report-datatable", 0, 2), "Created Issues (Resolved)");
    }

    public void testTimeSinceReport() {
        String name = "Time Since Issues Report";
        this.assertReportValidation("/secure/ConfigureReport!default.jspa?selectedProjectId=10000&reportKey=com.atlassian.jira.plugin.system.reports:timesince-report", "Time Since Issues Report", null);
        WebPageLocator locator = new WebPageLocator(this.tester);
        this.text.assertTextSequence(locator, "Report:", "Time Since Issues Report");
        this.text.assertTextSequence(locator, "Project:", "homosapien");
        this.tester.assertTextPresent("Data Table");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "timesince-report-datatable", 0, 0), "Period");
        this.text.assertTextPresent(new TableCellLocator(this.tester, "timesince-report-datatable", 0, 1), "Created");
    }

    private void assertReportValidation(String url, String reportName, String noIssuesMsg) {
        this.tester.gotoPage(url);
        this.tester.assertTextPresent("Report: " + reportName);
        this.tester.submit("Next");
        this.tester.assertTextPresent("Please specify a project or filter");
        this.tester.setFormElement("daysprevious", "aaa");
        this.tester.submit("Next");
        this.tester.assertTextPresent("You must specify a whole number of days.");
        this.tester.setFormElement("projectOrFilterId", "project-10000");
        this.tester.setFormElement("daysprevious", "30");
        this.tester.submit("Next");
        WebPageLocator locator = new WebPageLocator(this.tester);
        this.text.assertTextSequence(locator, "Report:", reportName);
        this.text.assertTextSequence(locator, "Project:", "homosapien");
        if (noIssuesMsg != null) {
            this.text.assertTextPresent(locator, noIssuesMsg);
        }
        this.navigation.issue().createIssue("homosapien", "Bug", "My first bug");
        this.navigation.issue().createIssue("homosapien", "Improvement", "My first improvement");
        this.tester.gotoPage(url);
        this.tester.assertTextPresent("Report: " + reportName);
        this.tester.setFormElement("projectOrFilterId", "project-10000");
        this.tester.setFormElement("daysprevious", "30");
        this.tester.submit("Next");
    }

    public void testRedirect() {
        this.tester.gotoPage("/secure/RunPortlet.jspa?cumulative=true&portletKey=com.atlassian.jira.ext.charting:createdvsresolved&daysprevious=30&periodName=daily&projectOrFilterId=project-10000&showUnresolvedTrend=false&versionLabels=major");
        TestCharting.assertTrue((boolean)this.tester.getDialog().getResponse().getURL().toString().endsWith("/secure/RunPortlet.jspa?cumulative=true&portletKey=com.atlassian.jira.plugin.system.portlets:createdvsresolved&daysprevious=30&periodName=daily&projectOrFilterId=project-10000&showUnresolvedTrend=false&versionLabels=major"));
        this.text.assertTextSequence(new WebPageLocator(this.tester), "Created vs Resolved Issues", "homosapien", "There were no matching issues found. Please make sure that you have selected a valid project or filter.");
        this.tester.gotoPage("/secure/RunPortlet.jspa?daysprevious=30&portletKey=com.atlassian.jira.ext.charting:resolutiontime&projectOrFilterId=project-10000&periodName=daily");
        TestCharting.assertTrue((boolean)this.tester.getDialog().getResponse().getURL().toString().endsWith("/secure/RunPortlet.jspa?daysprevious=30&portletKey=com.atlassian.jira.plugin.system.portlets:resolutiontime&projectOrFilterId=project-10000&periodName=daily"));
        this.text.assertTextSequence(new WebPageLocator(this.tester), "Resolution Time:", "homosapien", "There were no matching issues found. Please make sure that you have selected a valid project or filter.");
        this.tester.gotoPage("/secure/RunPortlet.jspa?statistictype=issuetype&portletKey=com.atlassian.jira.ext.charting:singlefieldpie&projectOrFilterId=project-10000");
        TestCharting.assertTrue((boolean)this.tester.getDialog().getResponse().getURL().toString().endsWith("/secure/RunPortlet.jspa?statistictype=issuetype&portletKey=com.atlassian.jira.plugin.system.portlets:pie&projectOrFilterId=project-10000"));
        this.text.assertTextSequence(new WebPageLocator(this.tester), "Pie Chart:", "homosapien", "There were no matching issues found. Please make sure that you have selected a valid project or filter.");
        this.tester.gotoPage("/secure/RunPortlet.jspa?daysprevious=30&portletKey=com.atlassian.jira.ext.charting:averageage&projectOrFilterId=project-10000&periodName=daily");
        TestCharting.assertTrue((boolean)this.tester.getDialog().getResponse().getURL().toString().endsWith("/secure/RunPortlet.jspa?daysprevious=30&portletKey=com.atlassian.jira.plugin.system.portlets:averageage&projectOrFilterId=project-10000&periodName=daily"));
        this.text.assertTextSequence(new WebPageLocator(this.tester), "Average Age:", "homosapien", "There were no matching issues found. Please make sure that you have selected a valid project or filter.");
        this.tester.gotoPage("/secure/RunPortlet.jspa?daysprevious=30&portletKey=com.atlassian.jira.ext.charting:recentlycreated&projectOrFilterId=project-10000&periodName=daily");
        TestCharting.assertTrue((boolean)this.tester.getDialog().getResponse().getURL().toString().endsWith("/secure/RunPortlet.jspa?daysprevious=30&portletKey=com.atlassian.jira.plugin.system.portlets:recentlycreated&projectOrFilterId=project-10000&periodName=daily"));
        this.text.assertTextSequence(new WebPageLocator(this.tester), "Recently Created Issues:", "homosapien", "There were no matching issues found. Please make sure that you have selected a valid project or filter.");
        this.tester.gotoPage("/secure/RunPortlet.jspa?daysprevious=30&portletKey=com.atlassian.jira.ext.charting:timesince&projectOrFilterId=project-10000&periodName=daily&dateField=created&cumulative=true");
        TestCharting.assertTrue((boolean)this.tester.getDialog().getResponse().getURL().toString().endsWith("/secure/RunPortlet.jspa?daysprevious=30&portletKey=com.atlassian.jira.plugin.system.portlets:timesince&projectOrFilterId=project-10000&periodName=daily&dateField=created&cumulative=true"));
        this.text.assertTextSequence(new WebPageLocator(this.tester), "Time Since Issues:", "homosapien", "There were no matching issues found. Please make sure that you have selected a valid project or filter.");
        this.tester.gotoPage("/secure/RunPortlet.jspa?daysprevious=30&portletKey=blub&projectOrFilterId=project-10000&periodName=daily&dateField=created&cumulative=true");
        this.text.assertTextSequence(new WebPageLocator(this.tester), "A portlet with the key blub does not exist.", new String[0]);
    }
}

