/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.meterware.httpunit.WebResponse;

public class TestVersionResource
extends RestFuncTest {
    public void testViewVersion() throws Exception {
        JSONObject version = this.getJSON("rest/api/2.0.alpha1/version/10000", new String[0]);
        TestVersionResource.assertEquals((String)this.getBaseUrlPlus("rest/api/2.0.alpha1/version/10000"), (String)version.getString("self"));
        TestVersionResource.assertEquals((String)"Test Version Description 1", (String)version.getString("description"));
        TestVersionResource.assertEquals((String)"New Version 1", (String)version.getString("name"));
        TestVersionResource.assertFalse((boolean)version.getBoolean("archived"));
        TestVersionResource.assertFalse((boolean)version.getBoolean("released"));
    }

    public void testViewVersionNotFound() throws Exception {
        WebResponse resp = this.GET("rest/api/2.0.alpha1/version/1");
        TestVersionResource.assertEquals((int)404, (int)resp.getResponseCode());
        JSONObject json = new JSONObject(resp.getText());
        TestVersionResource.assertEquals((String)"Could not find version for id '1'", (String)json.getJSONArray("errorMessages").getString(0));
        resp = this.GET("rest/api/2.0.alpha1/version/zbing");
        TestVersionResource.assertEquals((int)404, (int)resp.getResponseCode());
        json = new JSONObject(resp.getText());
        TestVersionResource.assertEquals((String)"Could not find version for id 'zbing'", (String)json.getJSONArray("errorMessages").getString(0));
    }

    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreBlankInstance();
    }
}

