/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.HttpNotFoundException;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;

public class TestStatusResource
extends RestFuncTest {
    private static final String STATUS_ID = "10000";
    private String baseUrl;

    public void testStatusReturned() throws Exception {
        this.tester.gotoPage("/rest/api/2.0.alpha1/status/10000");
        JSONObject status = new JSONObject(this.tester.getDialog().getResponseText());
        TestStatusResource.assertEquals((String)(this.baseUrl + "/rest/api/2.0.alpha1/status/10000"), (String)status.getString("self"));
        TestStatusResource.assertEquals((String)"Custom status", (String)status.getString("description"));
        TestStatusResource.assertEquals((String)(this.baseUrl + "/images/icons/status_generic.gif"), (String)status.getString("iconUrl"));
        TestStatusResource.assertEquals((String)"Insane", (String)status.getString("name"));
    }

    public void testStatusFilteredByPermissions() throws Exception {
        this.navigation.login("fred");
        try {
            String url = this.getEnvironmentData().getBaseUrl() + "/rest/api/2.0.alpha1/status/" + STATUS_ID;
            this.tester.getDialog().getWebClient().sendRequest((WebRequest)new GetMethodWebRequest(url));
            TestStatusResource.fail((String)"Should return 404 not found");
        }
        catch (HttpNotFoundException httpNotFoundException) {
            // empty catch block
        }
    }

    public void testStatusDoesntExist() throws Exception {
        WebResponse resp123 = this.GET("rest/api/2.0.alpha1/status/123");
        TestStatusResource.assertEquals((int)404, (int)resp123.getResponseCode());
        JSONObject content = new JSONObject(resp123.getText());
        TestStatusResource.assertEquals((String)"The status with id '123' does not exist", (String)content.getJSONArray("errorMessages").getString(0));
        WebResponse respAbc = this.GET("rest/api/2.0.alpha1/status/abc");
        TestStatusResource.assertEquals((int)404, (int)respAbc.getResponseCode());
        content = new JSONObject(respAbc.getText());
        TestStatusResource.assertEquals((String)"The status with id 'abc' does not exist", (String)content.getJSONArray("errorMessages").getString(0));
    }

    protected void setUpTest() {
        super.setUpTest();
        this.baseUrl = this.getEnvironmentData().getBaseUrl().toExternalForm();
        this.administration.restoreData("TestStatusResource.xml");
    }
}

