/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.util.lang.JiraStringUtils;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.meterware.httpunit.WebResponse;
import java.util.Map;

public class TestRestEncoding
extends RestFuncTest {
    private static final String E_ACUTE = "\u00e9";
    private static final String A_CIRCUMFLEX = "\u00e2";
    private static final Map<Integer, String> STANDARD_ISSUE_TYPES_FR = MapBuilder.newBuilder().add(1, "Bogue").add(2, JiraStringUtils.asString("Nouvelle fonctionnalit", "\u00e9")).add(3, JiraStringUtils.asString("T", "\u00e2", "che")).add(4, JiraStringUtils.asString("Am", "\u00e9", "lioration")).toImmutableMap();

    static String issueTypeStringFor(int id) {
        return STANDARD_ISSUE_TYPES_FR.get(id);
    }

    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreBlankInstance();
        this.navigation.login("admin", "admin");
    }

    public void testIssueTypesSchemesResponseEncodingUTF() throws Exception {
        this.administration.generalConfiguration().setEncoding("UTF-8");
        this.navigation.userProfile().changeUserLanguage("French (France)");
        this.doEncodingTest();
    }

    public void testIssueTypesSchemesResponseEncodingISO() throws Exception {
        this.administration.generalConfiguration().setEncoding("ISO-8859-1");
        this.navigation.userProfile().changeUserLanguage("French (France)");
        this.doEncodingTest();
    }

    private void doEncodingTest() throws Exception {
        WebResponse response = this.GET("rest/api/1.0/admin/issuetypeschemes?includeRecent=true");
        TestRestEncoding.assertEquals((String)"application/json", (String)response.getContentType());
        TestRestEncoding.assertEquals((String)"UTF-8", (String)response.getCharacterSet());
        JSONObject contents = new JSONObject(response.getText());
        this.assertIssueTypesHaveCorrectlyEncoded(contents.getJSONArray("types"));
    }

    private void assertIssueTypesHaveCorrectlyEncoded(JSONArray issueTypesArray) throws Exception {
        for (int i = 0; i < issueTypesArray.length(); ++i) {
            JSONObject typeObject = issueTypesArray.getJSONObject(i);
            int typeId = typeObject.getInt("id");
            TestRestEncoding.assertEquals((Object)TestRestEncoding.issueTypeStringFor(typeId), (Object)typeObject.get("name"));
        }
    }
}

