/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.meterware.httpunit.WebResponse;

public class TestPriorityResource
extends RestFuncTest {
    public void testViewPriority() throws Exception {
        JSONObject priority = this.getJSON("rest/api/2.0.alpha1/priority/1", new String[0]);
        TestPriorityResource.assertEquals((String)this.getBaseUrlPlus("rest/api/2.0.alpha1/priority/1"), (String)priority.getString("self"));
        TestPriorityResource.assertEquals((String)"#cc0000", (String)priority.getString("statusColor"));
        TestPriorityResource.assertEquals((String)"Blocks development and/or testing work, production could not run.", (String)priority.getString("description"));
        TestPriorityResource.assertEquals((String)this.getBaseUrlPlus("images/icons/priority_blocker.gif"), (String)priority.getString("iconUrl"));
        TestPriorityResource.assertEquals((String)"Blocker", (String)priority.getString("name"));
    }

    public void testViewPriorityNotFound() throws Exception {
        WebResponse resp123 = this.GET("rest/api/2.0.alpha1/priority/123");
        TestPriorityResource.assertEquals((int)404, (int)resp123.getResponseCode());
        JSONObject json123 = new JSONObject(resp123.getText());
        TestPriorityResource.assertEquals((String)"The priority with id '123' does not exist", (String)json123.getJSONArray("errorMessages").getString(0));
        WebResponse respFoo = this.GET("rest/api/2.0.alpha1/priority/foo");
        TestPriorityResource.assertEquals((int)404, (int)respFoo.getResponseCode());
        JSONObject jsonFoo = new JSONObject(respFoo.getText());
        TestPriorityResource.assertEquals((String)"The priority with id 'foo' does not exist", (String)jsonFoo.getJSONArray("errorMessages").getString(0));
    }

    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreBlankInstance();
    }
}

