/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.meterware.httpunit.WebResponse;

public class TestLogin
extends RestFuncTest {
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreBlankInstance();
    }

    public void testCurrentUser() throws Exception {
        JSONObject json = this.getJSON("/rest/auth/latest/session", new String[0]);
        TestLogin.assertEquals((String)"admin", (String)json.getString("name"));
        TestLogin.assertTrue((boolean)json.has("loginInfo"));
    }

    public void testCurrentUserAnon() throws Exception {
        this.navigation.logout();
        WebResponse response = this.GET("/rest/auth/latest/session");
        TestLogin.assertEquals((int)401, (int)response.getResponseCode());
    }

    public void testLogin() throws Exception {
        this.navigation.logout();
        JSONObject json = new JSONObject();
        json.put("username", "admin");
        json.put("password", "BAD-PASSWORD");
        WebResponse response = this.POST("/rest/auth/latest/session", json);
        TestLogin.assertEquals((int)401, (int)response.getResponseCode());
        TestLogin.assertEquals((String)"JIRA REST POST", (String)response.getHeaderField("WWW-Authenticate"));
        JSONObject userThatDoesntExist = new JSONObject().put("username", "wtf").put("password", "kljasdfjkl;dfs");
        TestLogin.assertEquals((String)"should return 401 if user doesn't exist", (int)401, (int)this.POST("/rest/auth/latest/session", userThatDoesntExist).getResponseCode());
        json = new JSONObject();
        json.put("username", "admin");
        json.put("password", "admin");
        response = this.POST("/rest/auth/latest/session", json);
        TestLogin.assertEquals((int)200, (int)response.getResponseCode());
        JSONObject responseJson = new JSONObject(response.getText());
        JSONObject session = responseJson.getJSONObject("session");
        TestLogin.assertEquals((String)"JSESSIONID", (String)session.getString("name"));
        TestLogin.assertEquals((String)this.tester.getDialog().getWebClient().getCookieValue("JSESSIONID"), (String)session.getString("value"));
        JSONObject loginInfo = responseJson.getJSONObject("loginInfo");
        TestLogin.assertTrue((boolean)loginInfo.has("previousLoginTime"));
        TestLogin.assertTrue((boolean)loginInfo.has("lastFailedLoginTime"));
        TestLogin.assertEquals((long)2L, (long)loginInfo.getLong("loginCount"));
        TestLogin.assertEquals((long)1L, (long)loginInfo.getLong("failedLoginCount"));
    }

    public void testLoginWorks() throws Exception {
        String key = this.navigation.issue().createIssue("homosapien", "Bug", "this is a summary");
        this.navigation.logout();
        JSONObject json = new JSONObject();
        json.put("username", "admin");
        json.put("password", "admin");
        WebResponse response = this.POST("/rest/auth/latest/session", json);
        JSONObject responseJson = new JSONObject(response.getText());
        JSONObject session = responseJson.getJSONObject("session");
        String jsessionId = session.getString("value");
        this.tester.getDialog().getWebClient().clearCookies();
        response = this.GET("/rest/api/latest/issue/" + key, MapBuilder.newBuilder().add("Cookie", "JSESSIONID=" + jsessionId).toImmutableMap());
        JSONObject issue = new JSONObject(response.getText());
        TestLogin.assertTrue((boolean)issue.has("key"));
    }

    public void testLogout() throws Exception {
        this.navigation.login("admin");
        WebResponse response = this.DELETE("/rest/auth/latest/session");
        TestLogin.assertEquals((int)204, (int)response.getResponseCode());
        response = this.DELETE("/rest/auth/latest/session");
        TestLogin.assertEquals((int)401, (int)response.getResponseCode());
    }
}

