/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;

public class TestIssueResourceWorklog
extends RestFuncTest {
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestWorklogAndTimeTracking.xml");
    }

    public void testView() throws Exception {
        JSONObject json = this.getJSON("/rest/api/2.0.alpha1/issue/HSP-1", new String[0]);
        JSONArray worklogs = json.getJSONObject("fields").getJSONObject("worklog").getJSONArray("value");
        TestIssueResourceWorklog.assertEquals((int)1, (int)worklogs.length());
        JSONObject log = worklogs.getJSONObject(0);
        TestIssueResourceWorklog.assertTrue((boolean)log.has("self"));
        TestIssueResourceWorklog.assertEquals((String)"", (String)log.getString("comment"));
        TestIssueResourceWorklog.assertEquals((int)120, (int)log.getInt("minutesSpent"));
        this.assertEqualDateStrings("2010-05-24T09:52:41.092+1000", log.getString("created"));
        this.assertEqualDateStrings("2010-05-24T09:52:41.092+1000", log.getString("updated"));
        this.assertEqualDateStrings("2010-05-24T09:52:00.000+1000", log.getString("started"));
        TestIssueResourceWorklog.assertEquals((String)(this.getBaseUrl() + "/rest/api/2.0.alpha1/issue/HSP-1"), (String)log.getString("issue"));
        JSONObject author = log.getJSONObject("author");
        TestIssueResourceWorklog.assertTrue((boolean)author.has("self"));
        TestIssueResourceWorklog.assertEquals((String)"admin", (String)author.getString("name"));
        TestIssueResourceWorklog.assertEquals((String)"Administrator", (String)author.getString("displayName"));
        JSONObject updateAuthor = log.getJSONObject("updateAuthor");
        TestIssueResourceWorklog.assertTrue((boolean)updateAuthor.has("self"));
        TestIssueResourceWorklog.assertEquals((String)"admin", (String)updateAuthor.getString("name"));
        TestIssueResourceWorklog.assertEquals((String)"Administrator", (String)updateAuthor.getString("displayName"));
    }

    public void testViewLoggedByDeletedUser() throws Exception {
        JSONObject json = this.getJSON("/rest/api/2.0.alpha1/issue/HSP-3", new String[0]);
        JSONArray worklogs = json.getJSONObject("fields").getJSONObject("worklog").getJSONArray("value");
        TestIssueResourceWorklog.assertEquals((int)1, (int)worklogs.length());
        JSONObject log = worklogs.getJSONObject(0);
        TestIssueResourceWorklog.assertTrue((boolean)log.has("self"));
        TestIssueResourceWorklog.assertEquals((String)"spent a whole minute on this", (String)log.getString("comment"));
        TestIssueResourceWorklog.assertEquals((int)1, (int)log.getInt("minutesSpent"));
        this.assertEqualDateStrings("2010-07-12T12:47:39.198+1000", log.getString("created"));
        this.assertEqualDateStrings("2010-07-12T12:47:39.198+1000", log.getString("updated"));
        this.assertEqualDateStrings("2010-07-12T12:47:00.000+1000", log.getString("started"));
        TestIssueResourceWorklog.assertEquals((String)(this.getBaseUrl() + "/rest/api/2.0.alpha1/issue/HSP-3"), (String)log.getString("issue"));
        JSONObject author = log.getJSONObject("author");
        TestIssueResourceWorklog.assertEquals((String)"deleted", (String)author.getString("name"));
        JSONObject updateAuthor = log.getJSONObject("updateAuthor");
        TestIssueResourceWorklog.assertEquals((String)"deleted", (String)updateAuthor.getString("name"));
    }
}

