/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.meterware.httpunit.WebResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TestIssueResourceWatchers
extends RestFuncTest {
    private static final String TEST_XML = "TestIssueResourceWatchers.xml";
    private final String loginUser = "fred";
    private final String anotherUser = "luser";

    public void testWatchingDisabled() throws Exception {
        this.restoreData(false);
        JSONObject issue = this.getJSON("/rest/api/2.0.alpha1/issue/HSP-1", new String[0]);
        TestIssueResourceWatchers.assertNull((Object)issue.optJSONObject("watchers"));
    }

    public void testViewWatchersRequestExpanded() throws Exception {
        this.restoreData(true);
        JSONObject issue = this.getJSON("/rest/api/2.0.alpha1/issue/HSP-1", new String[0]);
        TestIssueResourceWatchers.assertEquals((String)"HSP-1", (String)issue.getString("key"));
        JSONObject watchers = issue.getJSONObject("fields").getJSONObject("watcher").getJSONObject("value");
        TestIssueResourceWatchers.assertEquals((String)(this.getBaseUrl() + "/rest/api/2.0.alpha1/issue/HSP-1/watchers"), (String)watchers.getString("self"));
    }

    public void testViewWatchersNoPermissionToViewButCanStillSeeCount() throws Exception {
        this.restoreData(true);
        this.navigation.login("luser");
        JSONObject issue = this.getJSON("/rest/api/2.0.alpha1/issue/HSP-1", new String[0]);
        TestIssueResourceWatchers.assertEquals((String)"HSP-1", (String)issue.getString("key"));
        JSONObject watchers = issue.getJSONObject("fields").getJSONObject("watcher").getJSONObject("value");
        TestIssueResourceWatchers.assertEquals((int)2, (int)watchers.getInt("watchCount"));
    }

    public void testViewWatchersNoPermissionToViewButCanStillSeeMyselfAndCount() throws Exception {
        this.restoreData(true);
        this.navigation.login("luser");
        JSONObject issue = this.getJSON("/rest/api/2.0.alpha1/issue/HSP-2", new String[0]);
        TestIssueResourceWatchers.assertEquals((String)"HSP-2", (String)issue.getString("key"));
        JSONObject watchers = issue.getJSONObject("fields").getJSONObject("watcher").getJSONObject("value");
        TestIssueResourceWatchers.assertEquals((String)(this.getBaseUrl() + "/rest/api/2.0.alpha1/issue/HSP-2/watchers"), (String)watchers.getString("self"));
        TestIssueResourceWatchers.assertEquals((long)2L, (long)watchers.getLong("watchCount"));
    }

    public void testViewWatchersIsWatching() throws Exception {
        this.restoreData(true);
        this.navigation.login("luser");
        JSONObject issue = this.getJSON("/rest/api/2.0.alpha1/issue/HSP-2", new String[0]);
        TestIssueResourceWatchers.assertEquals((String)"HSP-2", (String)issue.getString("key"));
        JSONObject watchers = issue.getJSONObject("fields").getJSONObject("watcher").getJSONObject("value");
        TestIssueResourceWatchers.assertEquals((String)(this.getBaseUrl() + "/rest/api/2.0.alpha1/issue/HSP-2/watchers"), (String)watchers.getString("self"));
        TestIssueResourceWatchers.assertTrue((boolean)watchers.getBoolean("isWatching"));
    }

    public void testViewWatchersIsNotWatching() throws Exception {
        this.restoreData(true);
        this.navigation.login("luser");
        JSONObject issue = this.getJSON("/rest/api/2.0.alpha1/issue/HSP-1", new String[0]);
        TestIssueResourceWatchers.assertEquals((String)"HSP-1", (String)issue.getString("key"));
        JSONObject watchers = issue.getJSONObject("fields").getJSONObject("watcher").getJSONObject("value");
        TestIssueResourceWatchers.assertEquals((String)(this.getBaseUrl() + "/rest/api/2.0.alpha1/issue/HSP-1/watchers"), (String)watchers.getString("self"));
        TestIssueResourceWatchers.assertFalse((boolean)watchers.getBoolean("isWatching"));
    }

    public void testWatchers_Anonymous() throws Exception {
        this.restoreData(true);
        this.administration.permissionSchemes().defaultScheme().grantPermissionToGroup(10, "");
        this.navigation.logout();
        JSONObject watchers = this.getJSON("/rest/api/2.0.alpha1/issue/HSP-1/watchers", new String[0]);
        TestIssueResourceWatchers.assertEquals((String)(this.getBaseUrl() + "/rest/api/2.0.alpha1/issue/HSP-1/watchers"), (String)watchers.getString("self"));
        TestIssueResourceWatchers.assertEquals((int)2, (int)watchers.getInt("watchCount"));
        TestIssueResourceWatchers.assertFalse((boolean)watchers.getBoolean("isWatching"));
        TestIssueResourceWatchers.assertEquals((int)0, (int)watchers.getJSONArray("watchers").length());
    }

    public void testViewWatchersSubresourceExpanded() throws Exception {
        this.restoreData(true);
        JSONObject watchers = this.getJSON("/rest/api/2.0.alpha1/issue/HSP-1/watchers", new String[0]);
        TestIssueResourceWatchers.assertEquals((String)(this.getBaseUrl() + "/rest/api/2.0.alpha1/issue/HSP-1/watchers"), (String)watchers.getString("self"));
        JSONArray watcherList = watchers.getJSONArray("watchers");
        TestIssueResourceWatchers.assertEquals((int)2, (int)watcherList.length());
        ArrayList<String> names = new ArrayList<String>();
        List<JSONObject> objects = TestIssueResourceWatchers.asList(watcherList);
        for (JSONObject watcher : objects) {
            names.add(watcher.getString("name"));
        }
        TestIssueResourceWatchers.assertTrue((boolean)names.contains("fred"));
        TestIssueResourceWatchers.assertTrue((boolean)names.contains("admin"));
    }

    public void testViewWatchersSubresourceExpandedIssueDoesNotExist() throws Exception {
        this.restoreData(true);
        WebResponse response = this.GET("/rest/api/2.0.alpha1/issue/HSP-999/watchers");
        TestIssueResourceWatchers.assertEquals((int)404, (int)response.getResponseCode());
    }

    public void testAddWatchWhenWatchingIsDisabled() throws Exception {
        this.restoreData(false);
        this.navigation.login("fred");
        WebResponse resp = this.POST("rest/api/2.0.alpha1/issue/HSP-2/watchers", "\"fred\"");
        TestIssueResourceWatchers.assertEquals((int)404, (int)resp.getResponseCode());
    }

    public void testAddWatchToIssueThatDoesNotExist() throws Exception {
        this.restoreData(true);
        this.navigation.login("fred");
        WebResponse resp = this.POST("rest/api/2.0.alpha1/issue/HSP-999/watchers", "\"fred\"");
        TestIssueResourceWatchers.assertEquals((int)404, (int)resp.getResponseCode());
    }

    public void testAddWatchToIssueThatIAmAlreadyWatching() throws Exception {
        this.restoreData(true);
        this.navigation.login("fred");
        WebResponse resp = this.POST("rest/api/2.0.alpha1/issue/HSP-1/watchers", "\"fred\"");
        TestIssueResourceWatchers.assertEquals((int)204, (int)resp.getResponseCode());
    }

    public void testAddWatchToIssue() throws Exception {
        this.restoreData(true);
        this.navigation.login("fred");
        WebResponse resp = this.POST("rest/api/2.0.alpha1/issue/HSP-2/watchers", "\"fred\"");
        TestIssueResourceWatchers.assertEquals((int)204, (int)resp.getResponseCode());
        TestIssueResourceWatchers.assertTrue((boolean)this.hasVote("HSP-2", "fred"));
    }

    public void testAddWatchToIssue_emptyPOST() throws Exception {
        this.restoreData(true);
        this.navigation.login("fred");
        WebResponse resp = this.POST("rest/api/2.0.alpha1/issue/HSP-2/watchers", "");
        TestIssueResourceWatchers.assertEquals((int)204, (int)resp.getResponseCode());
        TestIssueResourceWatchers.assertTrue((boolean)this.hasVote("HSP-2", "fred"));
    }

    public void testAddWatchForAnotherUser() throws Exception {
        this.restoreData(true);
        this.navigation.login("luser");
        WebResponse resp = this.POST("rest/api/2.0.alpha1/issue/HSP-2/watchers", "\"fred\"");
        TestIssueResourceWatchers.assertEquals((int)401, (int)resp.getResponseCode());
    }

    public void testRemoveWatchWhenWatchingIsDisabled() throws Exception {
        this.restoreData(false);
        this.navigation.login("fred");
        WebResponse resp = this.DELETE(String.format("rest/api/2.0.alpha1/issue/HSP-2/watchers/%s", "fred"));
        TestIssueResourceWatchers.assertEquals((int)404, (int)resp.getResponseCode());
    }

    public void testRemoveWatchToIssueThatDoesNotExist() throws Exception {
        this.restoreData(true);
        this.navigation.login("fred");
        WebResponse resp = this.DELETE(String.format("rest/api/2.0.alpha1/issue/HSP-999/watchers/%s", "fred"));
        TestIssueResourceWatchers.assertEquals((int)404, (int)resp.getResponseCode());
    }

    public void testRemoveWatchFromIssueThatIAmNotWatching() throws Exception {
        this.restoreData(true);
        this.navigation.login("fred");
        TestIssueResourceWatchers.assertFalse((boolean)this.hasVote("HSP-2", "fred"));
        WebResponse resp = this.DELETE(String.format("rest/api/2.0.alpha1/issue/HSP-2/watchers/%s", "fred"));
        TestIssueResourceWatchers.assertEquals((int)204, (int)resp.getResponseCode());
        TestIssueResourceWatchers.assertFalse((boolean)this.hasVote("HSP-2", "fred"));
    }

    public void testRemoveWatchForAnotherUser_Denied() throws Exception {
        this.restoreData(true);
        this.navigation.login("luser");
        WebResponse resp = this.DELETE(String.format("rest/api/2.0.alpha1/issue/HSP-2/watchers/%s", "fred"));
        TestIssueResourceWatchers.assertError(401, "User 'luser' is not allowed to remove watchers from issue 'HSP-2'", resp);
    }

    public void testRemoveWatchForAnotherUser_Allowed() throws Exception {
        this.restoreData(true);
        WebResponse resp = this.DELETE(String.format("rest/api/2.0.alpha1/issue/HSP-2/watchers/%s", "fred"));
        TestIssueResourceWatchers.assertEquals((int)204, (int)resp.getResponseCode());
        TestIssueResourceWatchers.assertFalse((boolean)this.hasVote("HSP-2", "fred"));
    }

    public void testRemoveWatch() throws Exception {
        this.restoreData(true);
        this.navigation.login("fred");
        TestIssueResourceWatchers.assertTrue((boolean)this.hasVote("HSP-1", "fred"));
        WebResponse resp = this.DELETE(String.format("rest/api/2.0.alpha1/issue/HSP-1/watchers/%s", "fred"));
        TestIssueResourceWatchers.assertEquals((int)204, (int)resp.getResponseCode());
        TestIssueResourceWatchers.assertFalse((boolean)this.hasVote("HSP-1", "fred"));
    }

    protected boolean hasVote(String issueKey, String username) {
        try {
            JSONObject watchers = this.getJSON(String.format("/rest/api/2.0.alpha1/issue/%s/watchers", issueKey), new String[0]);
            JSONArray watcherListUsers = watchers.getJSONArray("watchers");
            for (int i = 0; i < watcherListUsers.length(); ++i) {
                if (!username.equals(watcherListUsers.getJSONObject(i).getString("name"))) continue;
                return true;
            }
            return false;
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    protected void restoreData(boolean watchingEnabled) throws IOException {
        this.administration.restoreDataWithReplacedTokens(TEST_XML, Collections.singletonMap("@@WATCHING_ENABLED@@", watchingEnabled ? "1" : "0"));
    }
}

