/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.meterware.httpunit.HttpException;
import com.meterware.httpunit.PostMethodWebRequest;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.xml.sax.SAXException;

public class TestIssueResourceTransitions
extends RestFuncTest {
    public void testTransitionLink() throws Exception {
        this.administration.restoreData("TestWorkflowActions.xml");
        this.tester.gotoPage("/rest/api/2.0.alpha1/issue/HSP-1");
        JSONObject issue = new JSONObject(this.tester.getDialog().getResponseText());
        TestIssueResourceTransitions.assertEquals((String)(this.getEnvironmentData().getBaseUrl().toExternalForm() + "/rest/api/2.0.alpha1/issue/HSP-1/transitions"), (String)issue.getString("transitions"));
    }

    public void testCustomFieldInTransition() throws Exception {
        this.administration.restoreData("TestIssueResourceTransitions.xml");
        JSONObject json = this.getJSON("/rest/api/2.0.alpha1/issue/HSP-1/transitions", new String[0]);
        JSONArray fields = json.getJSONObject("2").getJSONArray("fields");
        for (int i = 0; i < fields.length(); ++i) {
            JSONObject field = fields.getJSONObject(i);
            if (!field.getString("id").equals("customfield_10000")) continue;
            TestIssueResourceTransitions.assertEquals((String)"com.atlassian.jira.plugin.system.customfieldtypes:float", (String)field.getString("type"));
        }
    }

    public void testNumberCustomFieldLocalized() throws Exception {
        this.administration.restoreData("TestIssueResourceTransitions.xml");
        this.navigation.userProfile().changeUserLanguage("French (France)");
        JSONObject json = new JSONObject();
        json.put("transition", 2);
        JSONObject fields = new JSONObject();
        fields.put("resolution", "Duplicate");
        fields.put("customfield_10000", 2.5);
        json.put("fields", fields);
        WebResponse response = this.POST("/rest/api/2.0.alpha1/issue/HSP-1/transitions", json);
        TestIssueResourceTransitions.assertEquals((int)204, (int)response.getResponseCode());
    }

    public void testTransitionGET() throws Exception {
        this.administration.restoreData("TestWorkflowActions.xml");
        this.tester.gotoPage("/rest/api/2.0.alpha1/issue/HSP-1/transitions");
        JSONObject transitions = new JSONObject(this.tester.getDialog().getResponseText());
        TestIssueResourceTransitions.assertEquals((int)3, (int)transitions.names().length());
        String fields = "[{\"id\":\"resolution\",\"type\":\"com.atlassian.jira.issue.resolution.Resolution\",\"required\":true},{\"id\":\"fixVersions\",\"type\":\"com.atlassian.jira.project.version.Version\",\"required\":false},{\"id\":\"assignee\",\"type\":\"com.opensymphony.user.User\",\"required\":false}]";
        JSONObject transition = transitions.getJSONObject("2");
        TestIssueResourceTransitions.assertEquals((String)"Close Issue", (String)transition.getString("name"));
        JSONArray closeIssue = transition.getJSONArray("fields");
        TestIssueResourceTransitions.assertEquals((int)3, (int)closeIssue.length());
        TestIssueResourceTransitions.assertEquals((Object)new JSONArray("[{\"id\":\"resolution\",\"type\":\"com.atlassian.jira.issue.resolution.Resolution\",\"required\":true},{\"id\":\"fixVersions\",\"type\":\"com.atlassian.jira.project.version.Version\",\"required\":false},{\"id\":\"assignee\",\"type\":\"com.opensymphony.user.User\",\"required\":false}]"), (Object)closeIssue);
        transition = transitions.getJSONObject("5");
        TestIssueResourceTransitions.assertEquals((String)"Resolve Issue", (String)transition.getString("name"));
        JSONArray resolveIssue = transition.getJSONArray("fields");
        TestIssueResourceTransitions.assertEquals((int)3, (int)resolveIssue.length());
        TestIssueResourceTransitions.assertEquals((Object)new JSONArray("[{\"id\":\"resolution\",\"type\":\"com.atlassian.jira.issue.resolution.Resolution\",\"required\":true},{\"id\":\"fixVersions\",\"type\":\"com.atlassian.jira.project.version.Version\",\"required\":false},{\"id\":\"assignee\",\"type\":\"com.opensymphony.user.User\",\"required\":false}]"), (Object)resolveIssue);
        transition = transitions.getJSONObject("4");
        TestIssueResourceTransitions.assertEquals((String)"Start Progress", (String)transition.getString("name"));
        JSONArray startProgress = transition.getJSONArray("fields");
        TestIssueResourceTransitions.assertEquals((int)0, (int)startProgress.length());
    }

    public void testTransitionPUT_noComment() throws Exception {
        this.administration.restoreData("TestWorkflowActions.xml");
        String transitionURL = this.getEnvironmentData().getBaseUrl().toExternalForm() + "/rest/api/2.0.alpha1/issue/HSP-1/transitions";
        JSONObject json = new JSONObject();
        json.put("transition", 2);
        JSONObject fields = new JSONObject();
        fields.put("resolution", "Won't Fix");
        fields.put("fixVersions", CollectionBuilder.newBuilder("New Version 4", "New Version 5").asCollection());
        json.put("fields", fields);
        String postBody = json.toString();
        PostMethodWebRequest request = new PostMethodWebRequest(transitionURL, (InputStream)new ByteArrayInputStream(postBody.getBytes()), "application/json");
        WebResponse response = this.tester.getDialog().getWebClient().sendRequest((WebRequest)request);
        TestIssueResourceTransitions.assertEquals((int)204, (int)response.getResponseCode());
        this.tester.gotoPage("/rest/api/2.0.alpha1/issue/HSP-1");
        JSONObject issue = new JSONObject(this.tester.getDialog().getResponseText());
        TestIssueResourceTransitions.assertEquals((String)"Closed", (String)issue.getJSONObject("fields").getJSONObject("status").getJSONObject("value").getString("name"));
        TestIssueResourceTransitions.assertEquals((String)"Won't Fix", (String)issue.getJSONObject("fields").getJSONObject("resolution").getJSONObject("value").getString("name"));
        TestIssueResourceTransitions.assertEquals((String)"New Version 4", (String)issue.getJSONObject("fields").getJSONObject("fixVersions").getJSONArray("value").getJSONObject(0).getString("name"));
        TestIssueResourceTransitions.assertEquals((String)"New Version 5", (String)issue.getJSONObject("fields").getJSONObject("fixVersions").getJSONArray("value").getJSONObject(1).getString("name"));
    }

    public void testTransitionPOST_invalidRole() throws JSONException, IOException, SAXException {
        this.administration.restoreData("TestWorkflowActions.xml");
        String transitionURL = this.getEnvironmentData().getBaseUrl().toExternalForm() + "/rest/api/2.0.alpha1/issue/" + "HSP-1/transitions";
        JSONObject json = new JSONObject();
        json.put("transition", 2);
        JSONObject fields = new JSONObject();
        fields.put("resolution", "Won't Fix");
        json.put("fields", fields);
        JSONObject comment = new JSONObject();
        comment.put("body", "My comment");
        comment.put("role", "some-non-existing-role");
        json.put("comment", comment);
        String postBody = json.toString();
        PostMethodWebRequest request = new PostMethodWebRequest(transitionURL, (InputStream)new ByteArrayInputStream(postBody.getBytes()), "application/json");
        try {
            this.tester.getDialog().getWebClient().sendRequest((WebRequest)request);
            TestIssueResourceTransitions.fail((String)(HttpException.class.getName() + " should have been thrown"));
        }
        catch (HttpException e) {
            TestIssueResourceTransitions.assertEquals((int)400, (int)e.getResponseCode());
        }
    }

    public void testBasicTimeTracking() throws Exception {
        this.administration.restoreData("TestRESTTransitionsSimple.xml");
        String key = "MKY-1";
        this.getJSON(String.format("/rest/api/2.0.alpha1/issue/%s/transitions", "MKY-1"), new String[0]);
    }
}

