/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;

public class TestIssueResourceFields
extends RestFuncTest {
    public void testExpandos() throws Exception {
        this.administration.restoreData("TestIssueResourceFields.xml");
        JSONObject json = this.getJSON("/rest/api/2.0.alpha1/issue/HSP-1", new String[0]);
        TestIssueResourceFields.assertTrue((boolean)json.getString("expand").contains("html"));
        TestIssueResourceFields.assertEquals((int)0, (int)json.getJSONObject("html").length());
        JSONObject expanded = this.getJSON("/rest/api/2.0.alpha1/issue/HSP-1?expand=html", new String[0]);
        JSONObject html = expanded.getJSONObject("html");
        TestIssueResourceFields.assertEquals((int)4, (int)html.length());
        TestIssueResourceFields.assertTrue((boolean)html.has("environment"));
        TestIssueResourceFields.assertTrue((boolean)html.has("description"));
        TestIssueResourceFields.assertEquals((int)1, (int)html.getJSONArray("comment").length());
        TestIssueResourceFields.assertEquals((int)1, (int)html.getJSONArray("worklog").length());
    }

    public void testSystemFields() throws Exception {
        this.administration.restoreData("TestIssueResourceFields.xml");
        JSONObject json = this.getJSON("/rest/api/2.0.alpha1/issue/HSP-1?expand=html", new String[0]);
        TestIssueResourceFields.assertEquals((String)"HSP-1", (String)json.getString("key"));
        TestIssueResourceFields.assertEquals((String)(this.getBaseUrl() + "/rest/api/2.0.alpha1/issue/HSP-1"), (String)json.getString("self"));
        TestIssueResourceFields.assertTrue((boolean)json.has("fields"));
        TestIssueResourceFields.assertTrue((boolean)json.has("transitions"));
        TestIssueResourceFields.assertTrue((boolean)json.has("html"));
        TestIssueResourceFields.assertEquals((String)(this.getBaseUrl() + "/rest/api/2.0.alpha1/issue/HSP-1/transitions"), (String)json.getString("transitions"));
        JSONObject fields = json.getJSONObject("fields");
        TestIssueResourceFields.assertTrue((boolean)fields.has("summary"));
        TestIssueResourceFields.assertEquals((String)"Donec posuere tellus nulla; vitae pellentesque.", (String)fields.getJSONObject("summary").getString("value"));
        JSONObject votes = fields.getJSONObject("votes").getJSONObject("value");
        TestIssueResourceFields.assertEquals((int)0, (int)votes.getInt("votes"));
        TestIssueResourceFields.assertEquals((boolean)false, (boolean)votes.getBoolean("hasVoted"));
        TestIssueResourceFields.assertEquals((String)(this.getBaseUrl() + "/rest/api/2.0.alpha1/issue/HSP-1/votes"), (String)votes.getString("self"));
        TestIssueResourceFields.assertTrue((boolean)fields.has("security"));
        TestIssueResourceFields.assertEquals((String)"Insecure", (String)fields.getJSONObject("security").getString("value"));
        TestIssueResourceFields.assertTrue((boolean)fields.has("resolutiondate"));
        this.assertEqualDateStrings("2010-06-11T12:19:10.488+1000", fields.getJSONObject("resolutiondate").getString("value"));
        TestIssueResourceFields.assertTrue((boolean)fields.has("environment"));
        TestIssueResourceFields.assertEquals((String)"Curabitur bibendum molestie eros vel pretium.<br/>\n", (String)json.getJSONObject("html").getString("environment"));
        TestIssueResourceFields.assertTrue((boolean)fields.has("updated"));
        this.assertEqualDateStrings("2010-06-11T12:25:16.265+1000", fields.getJSONObject("updated").getString("value"));
        TestIssueResourceFields.assertTrue((boolean)fields.has("created"));
        this.assertEqualDateStrings("2010-06-11T12:17:45.383+1000", fields.getJSONObject("created").getString("value"));
        TestIssueResourceFields.assertTrue((boolean)fields.has("description"));
        TestIssueResourceFields.assertEquals((String)"Suspendisse a mi augue. Donec quis.<br/>\n", (String)json.getJSONObject("html").getString("description"));
        TestIssueResourceFields.assertTrue((boolean)fields.has("duedate"));
        this.assertEqualDateStrings("2010-06-23T00:00:00.000+1000", fields.getJSONObject("duedate").getString("value"));
        this.checkLabels(fields);
        TestIssueResourceFields.assertTrue((boolean)fields.has("timetracking"));
        this.checkIssueType(fields);
        this.checkStatus(fields);
        this.checkUser(fields, "assignee");
        this.checkUser(fields, "reporter");
        this.checkResolution(fields);
        this.checkProject(fields);
        this.checkPriority(fields);
        this.checkComponents(fields);
        this.checkFixVersions(fields, "fixVersions");
        this.checkFixVersions(fields, "versions");
    }

    private void checkFixVersions(JSONObject fields, String key) throws JSONException {
        TestIssueResourceFields.assertTrue((boolean)fields.has(key));
        JSONArray versions = fields.getJSONObject(key).getJSONArray("value");
        TestIssueResourceFields.assertEquals((String)(this.getBaseUrl() + "/rest/api/2.0.alpha1/version/10000"), (String)versions.getJSONObject(0).getString("self"));
        TestIssueResourceFields.assertEquals((String)"Test Version Description 1", (String)versions.getJSONObject(0).getString("description"));
        TestIssueResourceFields.assertEquals((String)"New Version 1", (String)versions.getJSONObject(0).getString("name"));
        TestIssueResourceFields.assertFalse((boolean)versions.getJSONObject(0).getBoolean("archived"));
        TestIssueResourceFields.assertFalse((boolean)versions.getJSONObject(0).getBoolean("released"));
        TestIssueResourceFields.assertEquals((String)(this.getBaseUrl() + "/rest/api/2.0.alpha1/version/10002"), (String)versions.getJSONObject(1).getString("self"));
        TestIssueResourceFields.assertEquals((String)"Test Version Description 5", (String)versions.getJSONObject(1).getString("description"));
        TestIssueResourceFields.assertEquals((String)"New Version 5", (String)versions.getJSONObject(1).getString("name"));
        TestIssueResourceFields.assertFalse((boolean)versions.getJSONObject(1).getBoolean("archived"));
        TestIssueResourceFields.assertFalse((boolean)versions.getJSONObject(1).getBoolean("released"));
    }

    private void checkComponents(JSONObject fields) throws JSONException {
        TestIssueResourceFields.assertTrue((boolean)fields.has("components"));
        JSONArray components = fields.getJSONObject("components").getJSONArray("value");
        TestIssueResourceFields.assertEquals((String)(this.getBaseUrl() + "/rest/api/2.0.alpha1/component/10001"), (String)components.getJSONObject(0).getString("self"));
        TestIssueResourceFields.assertEquals((String)"New Component 2", (String)components.getJSONObject(0).getString("name"));
        TestIssueResourceFields.assertEquals((String)(this.getBaseUrl() + "/rest/api/2.0.alpha1/component/10002"), (String)components.getJSONObject(1).getString("self"));
        TestIssueResourceFields.assertEquals((String)"New Component 3", (String)components.getJSONObject(1).getString("name"));
    }

    private void checkPriority(JSONObject fields) throws JSONException {
        TestIssueResourceFields.assertTrue((boolean)fields.has("priority"));
        JSONObject priority = fields.getJSONObject("priority").getJSONObject("value");
        TestIssueResourceFields.assertEquals((String)(this.getBaseUrl() + "/rest/api/2.0.alpha1/priority/3"), (String)priority.getString("self"));
        TestIssueResourceFields.assertEquals((String)"Major", (String)priority.getString("name"));
    }

    private void checkProject(JSONObject fields) throws JSONException {
        TestIssueResourceFields.assertTrue((boolean)fields.has("project"));
        JSONObject project = fields.getJSONObject("project").getJSONObject("value");
        TestIssueResourceFields.assertEquals((String)(this.getBaseUrl() + "/rest/api/2.0.alpha1/project/HSP"), (String)project.getString("self"));
        TestIssueResourceFields.assertEquals((String)"HSP", (String)project.getString("key"));
    }

    private void checkResolution(JSONObject fields) throws JSONException {
        TestIssueResourceFields.assertTrue((boolean)fields.has("resolution"));
        JSONObject resolution = fields.getJSONObject("resolution").getJSONObject("value");
        TestIssueResourceFields.assertEquals((String)(this.getBaseUrl() + "/rest/api/2.0.alpha1/resolution/1"), (String)resolution.getString("self"));
        TestIssueResourceFields.assertEquals((String)"Fixed", (String)resolution.getString("name"));
    }

    private void checkUser(JSONObject fields, String key) throws JSONException {
        TestIssueResourceFields.assertTrue((boolean)fields.has(key));
        JSONObject user = fields.getJSONObject(key).getJSONObject("value");
        TestIssueResourceFields.assertEquals((String)(this.getBaseUrl() + "/rest/api/2.0.alpha1/user?username=admin"), (String)user.getString("self"));
        TestIssueResourceFields.assertEquals((String)"admin", (String)user.getString("name"));
        TestIssueResourceFields.assertEquals((String)"Administrator", (String)user.getString("displayName"));
    }

    private void checkStatus(JSONObject fields) throws JSONException {
        TestIssueResourceFields.assertTrue((boolean)fields.has("status"));
        JSONObject status = fields.getJSONObject("status").getJSONObject("value");
        TestIssueResourceFields.assertEquals((String)(this.getBaseUrl() + "/rest/api/2.0.alpha1/status/5"), (String)status.getString("self"));
        TestIssueResourceFields.assertEquals((String)"Resolved", (String)status.getString("name"));
    }

    private void checkIssueType(JSONObject fields) throws JSONException {
        TestIssueResourceFields.assertTrue((boolean)fields.has("issuetype"));
        JSONObject issueType = fields.getJSONObject("issuetype").getJSONObject("value");
        TestIssueResourceFields.assertEquals((String)(this.getBaseUrl() + "/rest/api/2.0.alpha1/issueType/1"), (String)issueType.getString("self"));
        TestIssueResourceFields.assertEquals((String)"Bug", (String)issueType.getString("name"));
        TestIssueResourceFields.assertFalse((boolean)issueType.getBoolean("subtask"));
    }

    private void checkLabels(JSONObject fields) throws JSONException {
        TestIssueResourceFields.assertTrue((boolean)fields.has("labels"));
        JSONArray labels = fields.getJSONObject("labels").getJSONArray("value");
        TestIssueResourceFields.assertEquals((int)3, (int)labels.length());
        TestIssueResourceFields.assertEquals((String)"bad", (String)labels.getString(0));
        TestIssueResourceFields.assertEquals((String)"big", (String)labels.getString(1));
        TestIssueResourceFields.assertEquals((String)"wolf", (String)labels.getString(2));
    }
}

