/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.admin.GeneralConfiguration;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONObject;

public class TestIssueResourceComments
extends FuncTestCase {
    public void testCommentRendering() throws Exception {
        this.administration.restoreData("TestEditComment.xml");
        this.tester.gotoPage("/rest/api/2.0.alpha1/issue/HSP-1");
        JSONObject json = new JSONObject(this.tester.getDialog().getResponseText());
        TestIssueResourceComments.assertEquals((String)"I'm a hero!", (String)json.getJSONObject("fields").getJSONObject("comment").getJSONArray("value").getJSONObject(0).getString("body"));
        this.tester.gotoPage("/rest/api/2.0.alpha1/issue/HSP-1?expand=html");
        json = new JSONObject(this.tester.getDialog().getResponseText());
        TestIssueResourceComments.assertEquals((String)"I'm a hero!", (String)json.getJSONObject("fields").getJSONObject("comment").getJSONArray("value").getJSONObject(0).getString("body"));
        TestIssueResourceComments.assertEquals((String)"I&#39;m a hero!", (String)json.getJSONObject("html").getJSONArray("comment").getString(0));
    }

    public void testSystemTextFieldRendering() throws Exception {
        this.administration.restoreData("TestEditComment.xml");
        this.navigation.issue().setDescription("HSP-1", "I'll have 5<10<15 things?");
        this.navigation.issue().setEnvironment("HSP-1", "I'll have 5<10<15 things?");
        this.tester.gotoPage("/rest/api/2.0.alpha1/issue/HSP-1");
        JSONObject json = new JSONObject(this.tester.getDialog().getResponseText());
        TestIssueResourceComments.assertEquals((String)"\r\nI'll have 5<10<15 things?", (String)json.getJSONObject("fields").getJSONObject("description").getString("value"));
        TestIssueResourceComments.assertEquals((String)"I'll have 5<10<15 things?", (String)json.getJSONObject("fields").getJSONObject("environment").getString("value"));
        this.tester.gotoPage("/rest/api/2.0.alpha1/issue/HSP-1?expand=html");
        json = new JSONObject(this.tester.getDialog().getResponseText());
        TestIssueResourceComments.assertEquals((String)"\r<br/>\nI&#39;ll have 5&lt;10&lt;15 things?", (String)json.getJSONObject("html").getString("description"));
        TestIssueResourceComments.assertEquals((String)"I&#39;ll have 5&lt;10&lt;15 things?", (String)json.getJSONObject("html").getString("environment"));
    }

    public void testComment() throws Exception {
        this.administration.restoreBlankInstance();
        this.administration.generalConfiguration().setCommentVisibility(GeneralConfiguration.CommentVisibility.PROJECT_ROLES);
        this.administration.roles().addProjectRoleForUser("Monkey", 10002, "admin");
        String key = this.navigation.issue().createIssue("monkey", "Bug", "First Test Issue");
        this.navigation.issue().addComment(key, "comment", "Administrators");
        this.tester.gotoPage("/rest/api/2.0.alpha1/issue/" + key);
        JSONObject json = new JSONObject(this.tester.getDialog().getResponseText());
        JSONArray comments = json.getJSONObject("fields").getJSONObject("comment").getJSONArray("value");
        TestIssueResourceComments.assertEquals((int)1, (int)comments.length());
        this.tester.gotoPage("/rest/api/2.0.alpha1/issue/" + key);
        json = new JSONObject(this.tester.getDialog().getResponseText()).getJSONObject("fields").getJSONObject("comment").getJSONArray("value").getJSONObject(0);
        TestIssueResourceComments.assertEquals((String)"comment", (String)json.getString("body"));
        TestIssueResourceComments.assertEquals((String)"Administrators", (String)json.getString("roleLevel"));
        TestIssueResourceComments.assertTrue((boolean)json.has("created"));
        TestIssueResourceComments.assertTrue((boolean)json.has("updated"));
        TestIssueResourceComments.assertEquals((String)(this.getEnvironmentData().getBaseUrl() + "/rest/api/2.0.alpha1/comment/10000"), (String)json.getString("self"));
        TestIssueResourceComments.assertEquals((String)"admin", (String)json.getJSONObject("author").getString("name"));
        TestIssueResourceComments.assertEquals((String)"Administrator", (String)json.getJSONObject("author").getString("displayName"));
        TestIssueResourceComments.assertEquals((String)(this.getEnvironmentData().getBaseUrl() + "/rest/api/2.0.alpha1/user?username=admin"), (String)json.getJSONObject("author").getString("self"));
        TestIssueResourceComments.assertEquals((String)"admin", (String)json.getJSONObject("updateAuthor").getString("name"));
        TestIssueResourceComments.assertEquals((String)"Administrator", (String)json.getJSONObject("updateAuthor").getString("displayName"));
        TestIssueResourceComments.assertEquals((String)(this.getEnvironmentData().getBaseUrl() + "/rest/api/2.0.alpha1/user?username=admin"), (String)json.getJSONObject("updateAuthor").getString("self"));
    }
}

