/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.functest.framework.admin.GeneralConfiguration;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.HttpNotFoundException;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;

public class TestCommentResource
extends RestFuncTest {
    public void testViewCommentNotFound() throws Exception {
        this.administration.restoreData("TestEditComment.xml");
        WebResponse response1 = this.GET("/rest/api/2.0.alpha1/comment/1");
        TestCommentResource.assertEquals((int)404, (int)response1.getResponseCode());
        JSONObject content1 = new JSONObject(response1.getText());
        TestCommentResource.assertEquals((int)1, (int)content1.getJSONArray("errorMessages").length());
        TestCommentResource.assertEquals((String)"Can not find a comment for the id: 1.", (String)content1.getJSONArray("errorMessages").getString(0));
        WebResponse responsePiolho = this.GET("/rest/api/2.0.alpha1/comment/piolho");
        TestCommentResource.assertEquals((int)404, (int)responsePiolho.getResponseCode());
        JSONObject contentPiolho = new JSONObject(responsePiolho.getText());
        TestCommentResource.assertEquals((int)1, (int)contentPiolho.getJSONArray("errorMessages").length());
        TestCommentResource.assertEquals((String)"Can not find a comment for the id: piolho.", (String)contentPiolho.getJSONArray("errorMessages").getString(0));
    }

    public void testAnonymous() throws Exception {
        this.administration.restoreBlankInstance();
        this.administration.generalConfiguration().setCommentVisibility(GeneralConfiguration.CommentVisibility.PROJECT_ROLES);
        this.administration.roles().addProjectRoleForUser("Monkey", 10002, "admin");
        String key = this.navigation.issue().createIssue("monkey", "Bug", "First Test Issue");
        this.navigation.issue().addComment(key, "comment", "Administrators");
        this.navigation.logout();
        try {
            String url = this.getEnvironmentData().getBaseUrl() + "/rest/api/2.0.alpha1/comment/10000";
            this.tester.getDialog().getWebClient().sendRequest((WebRequest)new GetMethodWebRequest(url));
            TestCommentResource.fail();
        }
        catch (HttpNotFoundException httpNotFoundException) {
            // empty catch block
        }
    }

    public void testCommentJson() throws Exception {
        this.administration.restoreBlankInstance();
        this.administration.generalConfiguration().setCommentVisibility(GeneralConfiguration.CommentVisibility.PROJECT_ROLES);
        this.administration.roles().addProjectRoleForUser("Monkey", 10002, "admin");
        String key = this.navigation.issue().createIssue("monkey", "Bug", "First Test Issue");
        this.navigation.issue().addComment(key, "comment", "Administrators");
        this.tester.gotoPage("/rest/api/2.0.alpha1/comment/10000");
        JSONObject json = new JSONObject(this.tester.getDialog().getResponseText());
        TestCommentResource.assertTrue((boolean)json.has("created"));
        TestCommentResource.assertTrue((boolean)json.has("updated"));
        TestCommentResource.assertEquals((String)(this.getEnvironmentData().getBaseUrl() + "/rest/api/2.0.alpha1/comment/10000"), (String)json.getString("self"));
        TestCommentResource.assertEquals((String)"comment", (String)json.getString("body"));
        TestCommentResource.assertEquals((String)"Administrators", (String)json.getString("roleLevel"));
        TestCommentResource.assertEquals((String)"admin", (String)json.getJSONObject("author").getString("name"));
        TestCommentResource.assertEquals((String)"Administrator", (String)json.getJSONObject("author").getString("displayName"));
        TestCommentResource.assertEquals((String)(this.getEnvironmentData().getBaseUrl() + "/rest/api/2.0.alpha1/user?username=admin"), (String)json.getJSONObject("author").getString("self"));
        TestCommentResource.assertEquals((String)"admin", (String)json.getJSONObject("updateAuthor").getString("name"));
        TestCommentResource.assertEquals((String)"Administrator", (String)json.getJSONObject("updateAuthor").getString("displayName"));
        TestCommentResource.assertEquals((String)(this.getEnvironmentData().getBaseUrl() + "/rest/api/2.0.alpha1/user?username=admin"), (String)json.getJSONObject("updateAuthor").getString("self"));
    }
}

