/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bundledplugins2.rest;

import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.meterware.httpunit.WebResponse;

public class TestAttachmentResource
extends RestFuncTest {
    public void testViewAttachment() throws Exception {
        WebResponse resp = this.GET("rest/api/2.0.alpha1/attachment/10000");
        JSONObject attachment1 = new JSONObject(resp.getText());
        TestAttachmentResource.assertEquals((String)(this.getBaseUrl() + "/rest/api/2.0.alpha1/attachment/10000"), (String)attachment1.getString("self"));
        TestAttachmentResource.assertEquals((String)"attachment.txt", (String)attachment1.getString("filename"));
        TestAttachmentResource.assertEquals((String)(this.getBaseUrl() + "/rest/api/2.0.alpha1/user?username=admin"), (String)attachment1.getJSONObject("author").getString("self"));
        TestAttachmentResource.assertEquals((String)"admin", (String)attachment1.getJSONObject("author").getString("name"));
        TestAttachmentResource.assertEquals((String)"Administrator", (String)attachment1.getJSONObject("author").getString("displayName"));
        this.assertEqualDateStrings("2010-06-09T15:59:34.602+1000", attachment1.getString("created"));
        TestAttachmentResource.assertEquals((long)19L, (long)attachment1.getLong("size"));
        TestAttachmentResource.assertEquals((String)"text/plain", (String)attachment1.getString("mimeType"));
        TestAttachmentResource.assertEquals((String)(this.getBaseUrl() + "/secure/attachment/10000/attachment.txt"), (String)attachment1.getString("content"));
    }

    public void testViewAttachmentNotFound() throws Exception {
        WebResponse resp123 = this.GET("rest/api/2.0.alpha1/attachment/123");
        TestAttachmentResource.assertEquals((int)404, (int)resp123.getResponseCode());
        JSONObject content123 = new JSONObject(resp123.getText());
        TestAttachmentResource.assertEquals((int)1, (int)content123.getJSONArray("errorMessages").length());
        TestAttachmentResource.assertEquals((String)"The attachment with id '123' does not exist", (String)content123.getJSONArray("errorMessages").getString(0));
        WebResponse respAbc = this.GET("rest/api/2.0.alpha1/attachment/abc");
        TestAttachmentResource.assertEquals((int)404, (int)respAbc.getResponseCode());
        JSONObject contentAbc = new JSONObject(respAbc.getText());
        TestAttachmentResource.assertEquals((int)1, (int)contentAbc.getJSONArray("errorMessages").length());
        TestAttachmentResource.assertEquals((String)"The attachment with id 'abc' does not exist", (String)contentAbc.getJSONArray("errorMessages").getString(0));
    }

    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestIssueResourceAttachments.xml");
    }
}

