/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bulk;

import com.atlassian.jira.webtests.JIRAWebTest;

public class TestBulkMoveWithMultiContexts
extends JIRAWebTest {
    public TestBulkMoveWithMultiContexts(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.restoreData("IssuesWithSubTasksWorkflowScheme.xml");
    }

    public void testBulkMoveWithMultiContexts() throws Exception {
        this.grantGlobalPermission(33, "jira-users");
        this.displayAllIssues();
        this.clickLink("bulkedit_all");
        this.bulkChangeChooseIssuesAll();
        this.clickOnNext();
        this.checkCheckbox("operation", "bulk.move.operation.name");
        this.clickOnNext();
        this.selectOption("10000_1_pid", "monkey");
        this.assertTextPresent("Select Projects and Issue Types");
        this.clickOnNext();
        this.assertTextPresent("Select Projects and Issue Types for Sub-Tasks");
        this.assertTextPresent("Super Sub Task");
        this.assertTextPresent("Mega Sub Task");
        this.selectOption("10000_6_10001_issuetype", "Sub-task");
        this.selectOption("10000_7_10001_issuetype", "Sub-task");
        this.clickOnNext();
        this.assertTextPresent("Map Status for Target Project 'monkey' - Issue Type 'Bug'");
        this.selectOption("10000", "Open");
        this.clickOnNext();
        this.assertTextPresent("All field values will be retained");
        this.clickOnNext();
        this.assertTextPresent("Map Status for Target Project 'monkey' - Issue Type 'Sub-task'");
        this.assertTextPresentBeforeText("Current Status", "Mega Open");
        this.assertTextPresentBeforeText("Current Status", "Super Open");
        this.clickOnNext();
        this.assertTextPresent("All field values will be retained");
        this.clickOnNext();
        this.assertTextPresent("Confirmation");
        this.clickOnNext();
        this.assertTextPresent("Issue Navigator");
        this.assertTextPresent("MKY-1");
        this.clickLinkWithText("MKY-1");
        this.assertTextPresentBeforeText("Status", "Open");
        this.clickLinkWithText("Super Sub Task Issue");
        this.assertTextPresentBeforeText("Type", "Sub-task");
        this.assertTextPresentBeforeText("Status", "Open");
        this.assertTextPresent("monkey");
        this.removeGlobalPermission(33, "jira-users");
    }

    public void testBulkMoveIssueWithoutVersionPermission() {
        this.restoreData("TestMoveIssueWithoutVersionPermission.xml");
        this.gotoIssue("HSP-1");
        this.tester.assertTextPresent("Test issue 1");
        this.tester.assertTextPresent("New Version 1");
        this.tester.assertTextPresent("New Version 4");
        this.displayAllIssues();
        this.tester.clickLink("bulkedit_all");
        this.tester.checkCheckbox("bulkedit_10000", "on");
        this.tester.submit("Next");
        this.tester.checkCheckbox("operation", "bulk.move.operation.name");
        this.tester.submit("Next");
        this.tester.selectOption("10000_1_pid", "monkey");
        this.tester.submit("Next");
        this.assertTextSequence(new String[]{"*Fix Version/s:", "The value of this field must be changed to be valid in the target project, but you are not able to update this field in the target project. It will be set to the field's default value for the affected issues."});
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.tester.clickLinkWithText("MKY-1");
        this.tester.assertTextPresent("Test issue 1");
        this.tester.assertTextNotPresent("New Version 1");
        this.tester.assertTextNotPresent("New Version 4");
    }
}

