/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bulk;

import com.atlassian.jira.webtests.JIRAWebTest;
import com.meterware.httpunit.HttpUnitOptions;

public class TestBulkEditUserGroups
extends JIRAWebTest {
    private int adminsCount = 1;
    private int developersCount = 4;
    private int usersCount = 7;
    private int group200Count = 200;
    private int group202Count = 202;
    private static final String PERSONAL_LICENSE_LIMIT_ERROR = "Adding the user to the groups you have selected will grant the &#39;JIRA Users&#39; permission to the user in JIRA. This will exceed the number of users allowed to use JIRA under your license. Please reduce the number of users with the &#39;JIRA Users&#39;, &#39;JIRA Administrators&#39; or &#39;JIRA System Administrators&#39; global permissions or consider upgrading your license.";
    private static final String PLEASE_REFRESH_MEMBERS_LIST = "Newly selected group(s) may have different members.";
    private static final String UNASSIGN = "unassign";
    private static final String ASSIGN = "assign";
    private static final String FIELD_USERS_TO_UNASSIGN = "usersToUnassign";
    private static final String FIELD_USERS_TO_ASSIGN = "usersToAssignStr";
    private static final String FIELD_SELECTED_GROUPS = "selectedGroupsStr";
    private static final String WARNING_TOO_MANY_USERS_TO_DISPLAY = "These group(s) have been limited to display the first 200 users only.";
    private static final String ERROR_SELECT_GROUPS = "Please select group(s) to edit";
    private static final String ERROR_SELECT_USERS_TO_REMOVE = "Please select users to remove from the selected group(s)";
    private static final String ERROR_SELECT_USERS_TO_ADD = "Please select users to add to all the selected group(s)";
    private static final String ERROR_CANNOT_ADD_USER_INVALID = "Cannot add user. &#39;invalid&#39; does not exist";
    private static final String ERROR_LEAVING_ALL_SYS_ADMIN_GROUPS = "You are trying to leave all of the system administration groups jira-administrators. You cannot delete your own system administration permission";
    private static final String ERROR_LEAVING_ALL_ADMIN_GROUPS = "You are trying to leave all of the administration groups jira-administrators. You cannot delete your own administration permission";
    private static final String ERROR_ADMIN_ALREADY_MEMBER_OF_ALL = "Cannot add user &#39;admin&#39;, user is already a member of all the selected group(s)";
    private static final String ERROR_ADMIN_ALREADY_MEMBER_OF_JIRA_ADMIN = "Cannot add user &#39;admin&#39;, user is already a member of &#39;jira-administrators&#39;";

    public void resetGroupCounters() {
        this.adminsCount = 1;
        this.developersCount = 4;
        this.usersCount = 7;
        this.group200Count = 200;
        this.group202Count = 202;
    }

    public TestBulkEditUserGroups(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.restoreData("TestBulkEditGroupMembers.xml");
        this.resetGroupCounters();
    }

    public void tearDown() {
        HttpUnitOptions.setScriptingEnabled((boolean)false);
        super.tearDown();
    }

    public void testBulkEditUserGroupsWithScriptingEnabled() {
        TestBulkEditUserGroups.log("Testing Bulk Edit User Groups with Javascript ENABLED");
        HttpUnitOptions.setScriptingEnabled((boolean)true);
        this.runAllBulkEditUserGroupTests();
    }

    public void testBulkEditUserGroupsWithScriptingDisabled() {
        TestBulkEditUserGroups.log("Testing Bulk Edit User Groups with Javascript DISABLED");
        HttpUnitOptions.setScriptingEnabled((boolean)false);
        this.runAllBulkEditUserGroupTests();
    }

    public void runAllBulkEditUserGroupTests() {
        this._testBulkUnassignUsersFromGroups();
        this._testBulkAssignUsersFromGroups();
        this._testBulkEditUserGroupsListSize();
        this._testBulkUnassignUsersFromGroupsValidation();
        this._testBulkAssignUsersFromGroupsValidation();
    }

    public void testBulkEditUserGroupsWithShortUsername() {
        this.addUser("1");
        this.gotoBulkEditGroupMembers();
        this.selectSingleGroupOnly("jira-users", 8);
        this.selectMultiOption(FIELD_USERS_TO_UNASSIGN, "1");
        this.submit(UNASSIGN);
        this.assertTextPresent("Selected 1 of 5 Groups");
        this.assertTextPresent("7 Group Member(s)");
        String[] options = this.getDialog().getOptionValuesFor(FIELD_USERS_TO_UNASSIGN);
        for (int i = 0; i < options.length; ++i) {
            String option = options[i];
            TestBulkEditUserGroups.assertFalse((boolean)option.equals("1______jira-users"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBulkEditUserGroupsWithNoSysAdminPermRemoveLastAdmin() {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            this.clickOnAdminPanel("admin.usersgroups", "group_browser");
            this.clickLink("edit_members_of_jira-administrators");
            this.selectOption(FIELD_USERS_TO_UNASSIGN, "admin");
            this.submit(UNASSIGN);
            this.assertTextPresent(ERROR_LEAVING_ALL_ADMIN_GROUPS);
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBulkEditUserGroupsWithNoSysAdminPermRemoveAdmin() {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            this.createGroup("admin-group2");
            this.grantGlobalPermission(0, "admin-group2");
            this.addUserToGroup("admin", "admin-group2");
            this.clickOnAdminPanel("admin.usersgroups", "group_browser");
            this.clickLink("edit_members_of_jira-administrators");
            this.selectOption(FIELD_USERS_TO_UNASSIGN, "admin");
            this.submit(UNASSIGN);
            this.clickLink("view_profile");
            this.assertTextNotPresent("jira-administrators");
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }

    public void testBulkEditUserGroupsInvalidGroups() {
        this.gotoPage(this.page.addXsrfToken("/secure/admin/user/BulkEditUserGroups.jspa?selectedGroupsStr=invalid&assign=true&usersToAssignStr=admin"));
        this.assertTextPresent("The group &#39;invalid&#39; is not a valid group.");
        this.gotoPage(this.page.addXsrfToken("/secure/admin/user/BulkEditUserGroups.jspa?selectedGroupsStr=invalid&unassign=true&usersToUnassign=admin"));
        this.assertTextPresent("The group &#39;invalid&#39; is not a valid group.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBulkEditUserGroupsWithNoSysAdmin() {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            this.clickOnAdminPanel("admin.usersgroups", "group_browser");
            this.clickLink("bulk_edit_groups");
            this.assertOptionNotPresent(FIELD_SELECTED_GROUPS, "jira-sys-admins");
            this.assertTextNotPresent("jira-sys-admins");
            this.gotoPage(this.page.addXsrfToken("/secure/admin/user/BulkEditUserGroups.jspa?selectedGroupsStr=jira-sys-admins&assign=true&usersToAssignStr=fred"));
            this.assertTextPresent("You cannot add users to groups which are not visible to you.");
            this.gotoPage(this.page.addXsrfToken("/secure/admin/user/BulkEditUserGroups.jspa?selectedGroupsStr=jira-sys-admins&unassign=true&usersToUnassign=root"));
            this.assertTextPresent("You can not remove a group from this user as it is not visible to you.");
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFredEditGroups() {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            this.login("fred", "fred");
            this.gotoPage(this.page.addXsrfToken("/secure/admin/user/BulkEditUserGroups.jspa?selectedGroupsStr=jira-sys-admins&assign=true&usersToAssignStr=fred"));
            this.assertTextPresent("my login on this computer");
            this.gotoPage(this.page.addXsrfToken("/secure/admin/user/BulkEditUserGroups.jspa?selectedGroupsStr=jira-sys-admins&unassign=true&usersToUnassign=root"));
            this.assertTextPresent("my login on this computer");
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBulkEditUserGroupsWithSysAdmin() {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            this.logout();
            this.login("root", "root");
            this.clickOnAdminPanel("admin.usersgroups", "group_browser");
            this.clickLink("edit_members_of_jira-sys-admins");
            this.assertOptionPresent(FIELD_SELECTED_GROUPS, "jira-sys-admins");
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBulkEditUserGroupsHappyPathSysAdmin() {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            this.logout();
            this.login("root", "root");
            this.createGroup("sys-admin-group2");
            this.grantGlobalPermission(44, "sys-admin-group2");
            this.addUserToGroup("root", "sys-admin-group2");
            this.clickOnAdminPanel("admin.usersgroups", "group_browser");
            this.clickLink("edit_members_of_jira-sys-admins");
            this.selectOption(FIELD_USERS_TO_UNASSIGN, "root");
            this.submit(UNASSIGN);
            this.clickLink("view_profile");
            this.assertTextNotPresent("jira-sys-admins");
            this.assertTextPresent("sys-admin-group2");
            this.clickOnAdminPanel("admin.usersgroups", "group_browser");
            this.clickLink("edit_members_of_jira-sys-admins");
            this.setFormElement(FIELD_USERS_TO_ASSIGN, "root");
            this.submit(ASSIGN);
            this.gotoAdmin();
            this.clickLink("user_browser");
            this.clickLinkWithText("root");
            this.assertTextPresent("jira-sys-admins");
            this.assertTextPresent("sys-admin-group2");
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBulkEditUserGroupsHappyPathAdmin() {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            this.createGroup("admin-group2");
            this.grantGlobalPermission(0, "admin-group2");
            this.addUserToGroup("admin", "admin-group2");
            this.clickOnAdminPanel("admin.usersgroups", "group_browser");
            this.clickLink("edit_members_of_jira-administrators");
            this.selectOption(FIELD_USERS_TO_UNASSIGN, "admin");
            this.submit(UNASSIGN);
            this.gotoAdmin();
            this.clickLink("user_browser");
            this.clickLink("editgroups_admin");
            this.assertOptionNotPresent("groupsToLeave", "jira-administrators");
            this.assertOptionPresent("groupsToLeave", "admin-group2");
            this.clickOnAdminPanel("admin.usersgroups", "group_browser");
            this.clickLink("edit_members_of_jira-administrators");
            this.setFormElement(FIELD_USERS_TO_ASSIGN, "admin");
            this.submit(ASSIGN);
            this.gotoAdmin();
            this.clickLink("user_browser");
            this.clickLink("editgroups_admin");
            this.assertOptionPresent("groupsToLeave", "jira-administrators");
            this.assertOptionPresent("groupsToLeave", "admin-group2");
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }

    public void testBulkEditGroupMembershipWithPersonalLicense() {
        this.switchToPersonalLicense();
        this.addUser("bob");
        this.tester.gotoPage("/secure/admin/user/ViewUser.jspa?name=bob");
        this.assertTextPresent("User: bob");
        this.assertTextNotPresent("jira-users");
        this.tester.clickLink("editgroups_link");
        this.tester.selectOption("groupsToJoin", "jira-administrators");
        this.tester.submit("join");
        this.assertTextPresent(PERSONAL_LICENSE_LIMIT_ERROR);
        this.tester.selectOption("groupsToJoin", "jira-users");
        this.tester.submit("join");
        this.assertTextPresent(PERSONAL_LICENSE_LIMIT_ERROR);
        this.tester.clickLink("group_browser");
        this.tester.clickLink("edit_members_of_jira-administrators");
        this.tester.setFormElement(FIELD_USERS_TO_ASSIGN, "bob");
        this.tester.submit(ASSIGN);
        this.assertTextPresent(PERSONAL_LICENSE_LIMIT_ERROR);
        this.tester.clickLink("group_browser");
        this.tester.clickLink("edit_members_of_jira-users");
        this.tester.setFormElement(FIELD_USERS_TO_ASSIGN, "bob");
        this.tester.submit(ASSIGN);
        this.assertTextPresent(PERSONAL_LICENSE_LIMIT_ERROR);
    }

    public void testBulkEditGroupMembershipWithPersonalLicenseAlreadyActive() {
        this.switchToPersonalLicense();
        this.tester.gotoPage("/secure/admin/user/ViewUser.jspa?name=dev");
        this.assertTextPresent("User: developer");
        this.assertTextPresent("jira-users");
        this.assertTextNotPresent("jira-administrators");
        this.tester.clickLink("editgroups_link");
        this.tester.selectOption("groupsToJoin", "jira-administrators");
        this.tester.submit("join");
        this.assertTextNotPresent(PERSONAL_LICENSE_LIMIT_ERROR);
        this.tester.gotoPage("/secure/admin/user/ViewUser.jspa?name=dev");
        this.assertTextPresent("User: developer");
        this.assertTextPresent("jira-users");
        this.assertTextPresent("jira-administrators");
        this.tester.gotoPage("/secure/admin/user/ViewUser.jspa?name=dev00");
        this.assertTextPresent("User: developer");
        this.assertTextPresent("jira-users");
        this.assertTextNotPresent("jira-administrators");
        this.tester.clickLink("group_browser");
        this.tester.clickLink("edit_members_of_jira-administrators");
        this.tester.setFormElement(FIELD_USERS_TO_ASSIGN, "dev00");
        this.tester.submit(ASSIGN);
        this.assertTextNotPresent(PERSONAL_LICENSE_LIMIT_ERROR);
        this.tester.gotoPage("/secure/admin/user/ViewUser.jspa?name=dev00");
        this.assertTextPresent("User: developer");
        this.assertTextPresent("jira-users");
        this.assertTextPresent("jira-administrators");
    }

    private void _testBulkUnassignUsersFromGroups() {
        String option;
        int i;
        this.gotoBulkEditGroupMembers();
        this.selectDeveloperGroupOnly();
        this.selectMultiOption(FIELD_USERS_TO_UNASSIGN, "dev00");
        this.submit(UNASSIGN);
        --this.developersCount;
        this.assertTextPresent("Selected 1 of 5 Groups");
        this.assertTextPresent(this.developersCount + " Group Member(s)");
        String[] options = this.getDialog().getOptionValuesFor(FIELD_USERS_TO_UNASSIGN);
        for (i = 0; i < options.length; ++i) {
            option = options[i];
            TestBulkEditUserGroups.assertFalse((boolean)option.equals("dev00______jira-developers"));
        }
        this.selectUsersAndDevelopersGroup();
        options = this.getDialog().getOptionValuesFor(FIELD_USERS_TO_UNASSIGN);
        TestBulkEditUserGroups.assertTrue((options.length == 7 ? 1 : 0) != 0);
        this.selectMultiOptionByValue(FIELD_USERS_TO_UNASSIGN, "dev01");
        this.selectMultiOptionByValue(FIELD_USERS_TO_UNASSIGN, "user01______jira-users");
        this.submit(UNASSIGN);
        --this.developersCount;
        --this.usersCount;
        --this.usersCount;
        this.assertTextPresent("Selected 2 of 5 Groups");
        options = this.getDialog().getOptionValuesFor(FIELD_USERS_TO_UNASSIGN);
        TestBulkEditUserGroups.assertTrue((options.length == 5 ? 1 : 0) != 0);
        for (i = 0; i < options.length; ++i) {
            option = options[i];
            TestBulkEditUserGroups.assertFalse((boolean)option.equals("user01______jira-users"));
            TestBulkEditUserGroups.assertFalse((boolean)option.equals("dev01"));
        }
    }

    private void _testBulkAssignUsersFromGroups() {
        this.gotoBulkEditGroupMembers();
        this.selectDeveloperGroupOnly();
        this.assertTextPresent(this.developersCount + " Group Member(s)");
        this.setFormElement(FIELD_USERS_TO_ASSIGN, "dev00");
        this.submit(ASSIGN);
        ++this.developersCount;
        this.assertTextPresent("Selected 1 of 5 Groups");
        this.assertTextPresent(this.developersCount + " Group Member(s)");
        String[] options = this.getDialog().getOptionValuesFor(FIELD_USERS_TO_UNASSIGN);
        boolean found = false;
        for (int i = 0; i < options.length; ++i) {
            String option = options[i];
            if (!option.equals("dev00______jira-developers")) continue;
            found = true;
        }
        TestBulkEditUserGroups.assertTrue((boolean)found);
        this.selectUsersAndDevelopersGroup();
        options = this.getDialog().getOptionValuesFor(FIELD_USERS_TO_UNASSIGN);
        TestBulkEditUserGroups.assertTrue((options.length == 5 ? 1 : 0) != 0);
        this.setFormElement(FIELD_USERS_TO_ASSIGN, "dev01, user00");
        this.submit(ASSIGN);
        ++this.developersCount;
        ++this.developersCount;
        ++this.usersCount;
        this.assertTextPresent("Selected 2 of 5 Groups");
        options = this.getDialog().getOptionValuesFor(FIELD_USERS_TO_UNASSIGN);
        TestBulkEditUserGroups.assertEquals((int)6, (int)options.length);
        boolean found2 = false;
        found = false;
        for (int i = 0; i < options.length; ++i) {
            String option = options[i];
            if (option.equals("user00")) {
                found = true;
            }
            if (!option.equals("dev01")) continue;
            found2 = true;
        }
        TestBulkEditUserGroups.assertTrue((found && found2 ? 1 : 0) != 0);
    }

    private void _testBulkEditUserGroupsListSize() {
        this.gotoBulkEditGroupMembers();
        this.selectGroup200();
        this.assertTextNotPresent(WARNING_TOO_MANY_USERS_TO_DISPLAY);
        this.selectGroup202();
        this.assertTextPresent("group202 have more than 200 users.");
        this.assertTextPresent(WARNING_TOO_MANY_USERS_TO_DISPLAY);
        this.selectGroup200And202();
        this.assertTextPresent("group202 have more than 200 users.");
        this.assertTextPresent(WARNING_TOO_MANY_USERS_TO_DISPLAY);
    }

    private void _testBulkUnassignUsersFromGroupsValidation() {
        this.gotoBulkEditGroupMembers();
        this.submit(UNASSIGN);
        this.assertTextPresent(ERROR_SELECT_GROUPS);
        this.selectUsersAndDevelopersGroup();
        this.submit(UNASSIGN);
        this.assertTextPresent(ERROR_SELECT_USERS_TO_REMOVE);
        this.selectUsersAndDevelopersGroup();
        this.selectMultiOptionByValue(FIELD_USERS_TO_UNASSIGN, "user00");
        this.selectMultiOption(FIELD_SELECTED_GROUPS, this.getAdminOption());
        this.assertTextPresent(PLEASE_REFRESH_MEMBERS_LIST);
        this.submit(UNASSIGN);
        this.assertTextPresent("Cannot remove user &#39;user00&#39; from group &#39;jira-administrators&#39; since user is not a member of &#39;jira-administrators&#39;");
        this.selectUsersAndDevelopersGroup();
        this.selectMultiOptionByValue(FIELD_USERS_TO_UNASSIGN, "user00");
        this.selectMultiOption(FIELD_SELECTED_GROUPS, this.getDeveloperOption());
        this.selectMultiOption(FIELD_SELECTED_GROUPS, this.getAdminOption());
        this.assertTextPresent(PLEASE_REFRESH_MEMBERS_LIST);
        this.submit(UNASSIGN);
        this.assertTextPresent("Cannot remove user &#39;user00&#39; from selected group(s) since user is not a member of all the selected group(s)");
        this.selectUsersAndDevelopersGroup();
        this.selectMultiOptionByValue(FIELD_USERS_TO_UNASSIGN, "user______jira-users");
        this.selectMultiOption(FIELD_SELECTED_GROUPS, this.getAdminOption());
        this.assertTextPresent(PLEASE_REFRESH_MEMBERS_LIST);
        this.submit(UNASSIGN);
        this.assertTextPresent("Cannot remove user &#39;user&#39; from group &#39;jira-users&#39; since the group was not selected. Please make sure to refresh after selecting new group(s)");
        this.selectAdminGroupOnly();
        this.selectMultiOption(FIELD_USERS_TO_UNASSIGN, "admin");
        this.submit(UNASSIGN);
        this.assertTextPresent(ERROR_LEAVING_ALL_SYS_ADMIN_GROUPS);
        this.selectAllGroups();
        this.selectMultiOption(FIELD_USERS_TO_UNASSIGN, "admin");
        this.submit(UNASSIGN);
        this.assertTextPresent(ERROR_LEAVING_ALL_SYS_ADMIN_GROUPS);
    }

    private void _testBulkAssignUsersFromGroupsValidation() {
        this.gotoBulkEditGroupMembers();
        this.setFormElement(FIELD_USERS_TO_ASSIGN, "");
        this.assertTextPresent("Selected 0 of 5 Groups");
        this.submit(ASSIGN);
        this.assertTextPresent(ERROR_SELECT_GROUPS);
        this.gotoBulkEditGroupMembers();
        this.setFormElement(FIELD_USERS_TO_ASSIGN, "dev, user");
        this.assertTextPresent("Selected 0 of 5 Groups");
        this.submit(ASSIGN);
        this.assertTextPresent(ERROR_SELECT_GROUPS);
        this.selectUsersAndDevelopersGroup();
        this.submit(ASSIGN);
        this.assertTextPresent(ERROR_SELECT_USERS_TO_ADD);
        this.selectUsersAndDevelopersGroup();
        this.setFormElement(FIELD_USERS_TO_ASSIGN, "invalid");
        this.submit(ASSIGN);
        this.assertTextPresent(ERROR_CANNOT_ADD_USER_INVALID);
        this.selectAdminGroupOnly();
        this.setFormElement(FIELD_USERS_TO_ASSIGN, "admin");
        this.submit(ASSIGN);
        this.assertTextPresent(ERROR_ADMIN_ALREADY_MEMBER_OF_JIRA_ADMIN);
        this.selectUsersAndDevelopersGroup();
        this.setFormElement(FIELD_USERS_TO_ASSIGN, "admin");
        this.submit(ASSIGN);
        this.assertTextPresent(ERROR_ADMIN_ALREADY_MEMBER_OF_ALL);
        this.selectAdminGroupOnly();
        this.setFormElement(FIELD_USERS_TO_ASSIGN, "admin, dev");
        this.submit(ASSIGN);
        this.assertTextPresent(ERROR_ADMIN_ALREADY_MEMBER_OF_JIRA_ADMIN);
        String[] options = this.getDialog().getOptionValuesFor(FIELD_USERS_TO_UNASSIGN);
        TestBulkEditUserGroups.assertTrue((options.length == this.adminsCount ? 1 : 0) != 0);
        for (int i = 0; i < options.length; ++i) {
            String option = options[i];
            TestBulkEditUserGroups.assertFalse((boolean)option.equals("dev"));
        }
        this.selectAllGroups();
        this.setFormElement(FIELD_USERS_TO_ASSIGN, "admin, dev");
        this.submit(ASSIGN);
        this.assertTextPresent(ERROR_ADMIN_ALREADY_MEMBER_OF_ALL);
        options = this.getDialog().getOptionValuesFor(FIELD_USERS_TO_UNASSIGN);
        boolean found = false;
        boolean found2 = false;
        for (int i = 0; i < options.length; ++i) {
            String option = options[i];
            TestBulkEditUserGroups.assertFalse((boolean)option.equals("dev"));
            if (option.equals("dev______jira-users")) {
                found = true;
            }
            if (!option.equals("dev______jira-developers")) continue;
            found2 = true;
        }
        TestBulkEditUserGroups.assertTrue((boolean)found);
        TestBulkEditUserGroups.assertTrue((boolean)found2);
        this.selectAdminGroupOnly();
        this.setFormElement(FIELD_USERS_TO_ASSIGN, "user, admin, duplicate, invalid, dev, duplicate, duplicate, error, user");
        this.submit(ASSIGN);
        this.assertTextPresent(ERROR_ADMIN_ALREADY_MEMBER_OF_JIRA_ADMIN);
        this.assertTextPresent("Cannot add user. &#39;duplicate&#39; does not exist");
        this.assertTextPresent(ERROR_CANNOT_ADD_USER_INVALID);
        this.assertTextPresent("Cannot add user. &#39;duplicate&#39; does not exist");
        this.assertTextPresent("Cannot add user. &#39;duplicate&#39; does not exist");
        this.assertTextPresent("Cannot add user. &#39;error&#39; does not exist");
    }

    private void gotoBulkEditGroupMembers() {
        this.clickOnAdminPanel("admin.usersgroups", "group_browser");
        this.clickLinkWithText("Bulk Edit Group Members");
        this.assertTextPresent("This page allows you to edit the user memberships for each group.");
        this.assertTextPresent("Selected 0 of 5 Groups");
        this.assertTextPresent("No users in selected group(s)");
    }

    private void selectGroup200() {
        this.selectSingleGroupOnly(this.getGroup200Option(), this.group200Count);
    }

    private void selectGroup202() {
        this.selectSingleGroupOnly(this.getGroup202Option(), this.group202Count);
    }

    private void selectUserGroupOnly() {
        this.selectSingleGroupOnly(this.getUserOption(), this.usersCount);
    }

    private void selectDeveloperGroupOnly() {
        this.selectSingleGroupOnly(this.getDeveloperOption(), this.developersCount);
    }

    private void selectAdminGroupOnly() {
        this.selectSingleGroupOnly(this.getAdminOption(), this.adminsCount);
    }

    private void selectUsersAndDevelopersGroup() {
        this.selectTwoGroups(this.getUserOption(), this.getDeveloperOption());
    }

    private void selectGroup200And202() {
        this.selectTwoGroups(this.getGroup200Option(), this.getGroup202Option());
    }

    private void selectSingleGroupOnly(String group, int groupCount) {
        this.selectMultiOption(FIELD_SELECTED_GROUPS, group);
        this.assertTextPresent(PLEASE_REFRESH_MEMBERS_LIST);
        this.refreshMembersList();
        this.assertTextPresent("Selected 1 of 5 Groups");
        this.assertTextPresent((groupCount <= 200 ? groupCount : 200) + " Group Member(s)");
    }

    private void selectTwoGroups(String group1, String group2) {
        this.selectMultiOption(FIELD_SELECTED_GROUPS, group1);
        this.selectMultiOption(FIELD_SELECTED_GROUPS, group2);
        this.assertTextPresent(PLEASE_REFRESH_MEMBERS_LIST);
        this.refreshMembersList();
        this.assertTextPresent("Selected 2 of 5 Groups");
    }

    private void selectAllGroups() {
        this.selectMultiOption(FIELD_SELECTED_GROUPS, this.getAdminOption());
        this.selectMultiOption(FIELD_SELECTED_GROUPS, this.getDeveloperOption());
        this.selectMultiOption(FIELD_SELECTED_GROUPS, this.getUserOption());
        this.assertTextPresent(PLEASE_REFRESH_MEMBERS_LIST);
        this.refreshMembersList();
        this.assertTextPresent("Selected 3 of 5 Groups");
    }

    private void refreshMembersList() {
        if (HttpUnitOptions.isScriptingEnabled()) {
            this.clickLink("refresh");
        } else {
            this.submit("refresh");
        }
    }

    private String getAdminOption() {
        return "jira-administrators";
    }

    private String getDeveloperOption() {
        return "jira-developers";
    }

    private String getUserOption() {
        return "jira-users";
    }

    private String getGroup200Option() {
        return "group200";
    }

    private String getGroup202Option() {
        return "group202";
    }
}

