/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.bulk;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.webtests.table.HtmlTable;
import com.meterware.httpunit.WebTable;

public class TestBulkEditEnvironment
extends FuncTestCase {
    protected void setUpTest() {
        this.administration.restoreData("TestBulkEditEnvironment.xml");
    }

    public void testHappyPath() throws Exception {
        this.navigation.issue().viewIssue("RAT-1");
        this.assertions.getViewIssueAssertions().assertEnvironmentEquals("DOS 4, 80286");
        this.navigation.issue().viewIssue("RAT-2");
        this.assertions.getViewIssueAssertions().assertEnvironmentEquals("");
        this.navigation.issue().viewIssue("COW-18");
        this.assertions.getViewIssueAssertions().assertEnvironmentEquals("");
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.assertTextPresent("Issue Navigator");
        this.tester.clickLinkWithText("Tools");
        this.tester.clickLink("bulkedit_all");
        this.tester.assertTextPresent("Bulk Operation: Choose Issues");
        this.tester.checkCheckbox("bulkedit_10000", "on");
        this.tester.checkCheckbox("bulkedit_10020", "on");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Bulk Operation: Choose Operation");
        this.tester.checkCheckbox("operation", "bulk.edit.operation.name");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Bulk Operation: Operation Details");
        this.tester.assertTextPresent("Change Environment:");
        this.tester.checkCheckbox("actions", "environment");
        this.tester.setFormElement("environment", "DOS 5, 80386");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Bulk Operation: Confirmation");
        WebTable updatedfields = this.tester.getDialog().getWebTableBySummaryOrId("updatedfields");
        TestBulkEditEnvironment.assertEquals((String)"Cell (0, 0) in table 'updatedfields' should be 'Updated Fields'.", (String)"Updated Fields", (String)updatedfields.getCellAsText(0, 0).trim());
        TestBulkEditEnvironment.assertEquals((String)"Cell (1, 0) in table 'updatedfields' should be 'Environment'.", (String)"Environment", (String)updatedfields.getCellAsText(1, 0).trim());
        TestBulkEditEnvironment.assertEquals((String)"Cell (1, 1) in table 'updatedfields' should be 'DOS 5, 80386'.", (String)"DOS 5, 80386", (String)updatedfields.getCellAsText(1, 1).trim());
        this.tester.submit("Confirm");
        this.navigation.issue().viewIssue("RAT-1");
        this.assertions.getViewIssueAssertions().assertEnvironmentEquals("DOS 5, 80386");
        this.navigation.issue().viewIssue("RAT-2");
        this.assertions.getViewIssueAssertions().assertEnvironmentEquals("");
        this.navigation.issue().viewIssue("COW-15");
        this.assertions.getViewIssueAssertions().assertEnvironmentEquals("DOS 5, 80386");
    }

    public void testHiddenInOneProject() throws Exception {
        this.navigation.gotoAdminSection("view_projects");
        this.tester.clickLinkWithText("Bovine");
        this.tester.clickLink("select_fieldlayoutscheme");
        this.tester.selectOption("schemeId", "Small Field Configuration Scheme");
        this.tester.submit("Associate");
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.assertTextPresent("Issue Navigator");
        this.tester.clickLinkWithText("Tools");
        this.tester.clickLink("bulkedit_all");
        this.tester.assertTextPresent("Bulk Operation: Choose Issues");
        this.tester.checkCheckbox("bulkedit_10000", "on");
        this.tester.checkCheckbox("bulkedit_10020", "on");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Bulk Operation: Choose Operation");
        this.tester.checkCheckbox("operation", "bulk.edit.operation.name");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Bulk Operation: Operation Details");
        HtmlTable htmlTable = this.page.getHtmlTable("unavailableActionsTable");
        HtmlTable.Row row = htmlTable.findRowWhereCellEquals(1, "Change Environment:");
        TestBulkEditEnvironment.assertEquals((String)"NOTE: This field is hidden for at least 1 issue in at least 1 project for the selected issues.", (String)row.getCellAsText(2));
    }

    public void testDifferentRenderers() throws Exception {
        this.navigation.gotoAdminSection("view_projects");
        this.tester.clickLinkWithText("Bovine");
        this.tester.clickLink("edit_fieldlayoutscheme");
        this.tester.clickLink("configure_fieldlayout");
        this.tester.clickLink("renderer_environment");
        this.tester.selectOption("selectedRendererType", "Wiki Style Renderer");
        this.tester.submit("Update");
        this.tester.assertTextPresent("Edit Field Renderer Confirmation: Environment");
        this.tester.submit("Update");
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.assertTextPresent("Issue Navigator");
        this.tester.clickLinkWithText("Tools");
        this.tester.clickLink("bulkedit_all");
        this.tester.assertTextPresent("Bulk Operation: Choose Issues");
        this.tester.checkCheckbox("bulkedit_10000", "on");
        this.tester.checkCheckbox("bulkedit_10020", "on");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Bulk Operation: Choose Operation");
        this.tester.checkCheckbox("operation", "bulk.edit.operation.name");
        this.tester.submit("Next");
        this.tester.assertTextPresent("Bulk Operation: Operation Details");
        HtmlTable htmlTable = this.page.getHtmlTable("unavailableActionsTable");
        HtmlTable.Row row = htmlTable.findRowWhereCellEquals(1, "Change Environment:");
        TestBulkEditEnvironment.assertEquals((String)"NOTE: This field cannot be edited as the renderer type differs in the associated field layout configurations.", (String)row.getCellAsText(2));
    }
}

