/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.webtests.table.HtmlTable;
import org.xml.sax.SAXException;

public class TestUpgradeTask1_2
extends FuncTestCase {
    public static final String DEFAULT_PERM_SCHEME = "Default Permission Scheme";

    public void testWorklogPermissionEmptyOnUpgrade() throws SAXException {
        this.log("Permission Schemes: Testing that worklog permissions remain empty on upgrade");
        this.administration.restoreData("BlankProjectsOldBuild.xml");
        this.navigation.gotoAdminSection("permission_schemes");
        this.tester.clickLinkWithText(DEFAULT_PERM_SCHEME);
        this.tester.assertTextPresent("Edit Permissions &mdash; Default Permission Scheme");
        HtmlTable timetrackingPermissionsTable = this.page.getHtmlTable("edit_timetracking_permissions");
        TestUpgradeTask1_2.assertEquals((int)6, (int)timetrackingPermissionsTable.getRowCount());
        TestUpgradeTask1_2.assertTrue((boolean)timetrackingPermissionsTable.doesCellHaveText(1, 0, "Work On Issues"));
        TestUpgradeTask1_2.assertTrue((boolean)timetrackingPermissionsTable.doesCellHaveText(2, 0, "Edit Own Worklogs"));
        this.assertNoRole(timetrackingPermissionsTable, 2);
        TestUpgradeTask1_2.assertTrue((boolean)timetrackingPermissionsTable.doesCellHaveText(3, 0, "Edit All Worklogs"));
        this.assertNoRole(timetrackingPermissionsTable, 3);
        TestUpgradeTask1_2.assertTrue((boolean)timetrackingPermissionsTable.doesCellHaveText(4, 0, "Delete Own Worklogs"));
        this.assertNoRole(timetrackingPermissionsTable, 4);
        TestUpgradeTask1_2.assertTrue((boolean)timetrackingPermissionsTable.doesCellHaveText(5, 0, "Delete All Worklogs"));
        this.assertNoRole(timetrackingPermissionsTable, 5);
    }

    private void assertNoRole(HtmlTable permissionsTable, int row) {
        TestUpgradeTask1_2.assertFalse((boolean)permissionsTable.doesCellHaveText(row, 1, "(Administrators)"));
        TestUpgradeTask1_2.assertFalse((boolean)permissionsTable.doesCellHaveText(row, 1, "(Developers)"));
        TestUpgradeTask1_2.assertFalse((boolean)permissionsTable.doesCellHaveText(row, 1, "(Users)"));
    }
}

