/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin;

import com.atlassian.jira.webtests.JIRAWebTest;
import com.atlassian.license.DefaultSIDManager;
import com.atlassian.license.SIDManager;
import com.meterware.httpunit.WebTable;
import org.xml.sax.SAXException;

public class TestServerId
extends JIRAWebTest {
    private SIDManager sidManager = new DefaultSIDManager();

    public TestServerId(String name) {
        super(name);
    }

    public void testServerIdIdenticalAfterRestore() throws SAXException {
        this.restoreData("TestServerId.xml");
        this.gotoAdmin();
        this.clickLink("license_details");
        this.assertTextPresent("Server ID");
        WebTable licenseTable = this.getDialog().getResponse().getTableWithID("license_table");
        String serverId = licenseTable.getCellAsText(3, 1);
        TestServerId.assertEquals((String)"Server ID same as stored", (String)"ALA0-Y7A3-TR93-KAHT", (String)serverId.trim());
    }

    public void testServerIdGeneratedFresh() throws SAXException {
        this.restoreBlankInstance();
        this.gotoAdmin();
        this.clickLink("license_details");
        this.assertTextPresent("Server ID");
        WebTable licenseTable = this.getDialog().getResponse().getTableWithID("license_table");
        String serverId = licenseTable.getCellAsText(3, 1);
        TestServerId.assertTrue((String)"Valid SID", (boolean)this.sidManager.isValidSID(serverId.trim()));
    }
}

