/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.admin;

import com.atlassian.jira.webtests.JIRAWebTest;

public class TestGlobalPermissions
extends JIRAWebTest {
    public TestGlobalPermissions(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.restoreBlankInstance();
    }

    public void testCanRemoveAnyoneFromJiraUsers() throws Exception {
        this.restoreData("TestGlobalPermssionsJRA13577.xml");
        this.gotoGlobalPermissions();
        this.clickLink("global_permissions");
        this.assertTextPresent("Global Permissions");
        this.assertTextPresent("JIRA Permissions");
        this.clickLink("del_1_");
        this.assertTextPresent("Delete Global Permission");
        this.assertTextSequence(new String[]{"Are you sure you want to delete", "Anyone", "group from the", "JIRA Users", "permission?"});
        this.submit("Delete");
        this.assertTextPresent("Global Permissions");
        this.assertTextPresent("JIRA Permissions");
        this.assertLinkNotPresent("del_1_");
    }

    public void testErrorOnSysAdminDelete() {
        this.gotoGlobalPermissions();
        this.assertTextPresent("JIRA System Administrators");
        this.assertTextPresent("jira-administrators");
        this.clickLink("del_44_jira-administrators");
        this.assertTextPresent("You cannot delete this permission. You are not a member of any of the other system administration permissions.");
    }

    public void testAddThenDeletePermission() {
        this.gotoGlobalPermissions();
        this.assertTextPresent("JIRA Administrators");
        this.assertTextPresent("jira-administrators");
        this.assertLinkPresent("del_0_jira-administrators");
        this.selectOption("permType", "JIRA Administrators");
        this.selectOption("groupName", "Anyone");
        this.submit("Add");
        this.assertLinkPresent("del_0_");
        this.clickLink("del_0_");
        this.assertTextPresent("Delete Global Permission");
        this.assertTextPresent("Are you sure you want to delete the");
        this.assertTextPresent("Anyone");
        this.assertTextPresent("group from the");
        this.assertTextPresent("JIRA Administrators");
        this.assertTextPresent("permission?");
        this.submit("Delete");
        this.assertLinkNotPresent("del_0_");
    }

    public void testAddNoPermission() {
        this.gotoGlobalPermissions();
        this.submit("Add");
        this.assertTextPresent("You must select a permission");
        this.clickOnAdminPanel("admin.globalsettings", "global_permissions");
        this.assertTextNotPresent("You must select a permission");
        this.selectOption("permType", "Please select a permission");
        this.submit("Add");
        this.assertTextPresent("You must select a permission");
    }

    public void testNotAllowedToAddAnyoneToJiraUsers() {
        this.gotoGlobalPermissions();
        this.assertTextPresent("JIRA Administrators");
        this.assertTextPresent("jira-administrators");
        this.assertCannotAddAnyoneToJiraUsers();
        this.assertCanAddAnyoneToJiraAdministrators();
    }

    private void assertCannotAddAnyoneToJiraUsers() {
        this.selectOption("permType", "JIRA Users");
        this.selectOption("groupName", "Anyone");
        this.submit("Add");
        this.assertions.getJiraFormAssertions().assertFieldErrMsg("The group 'Anyone' is not allowed to be added to the permission");
    }

    private void assertCanAddAnyoneToJiraAdministrators() {
        this.selectOption("permType", "JIRA Administrators");
        this.selectOption("groupName", "Anyone");
        this.submit("Add");
        this.assertions.getJiraFormAssertions().assertNoFieldErrMsg("The group 'Anyone' is not allowed to be added to the permission");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSystemAdminNotVisibleToNonAdmins() {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            this.gotoGlobalPermissions();
            this.gotoGlobalPermissions();
            this.assertTextNotPresent("JIRA System Administrators");
            String addUrl = this.page.addXsrfToken("/secure/admin/jira/GlobalPermissions.jspa?action=add&permType=44&groupName=jira-users");
            this.tester.gotoPage(addUrl);
            this.assertTextPresent("You can not add a group to a global permission you do not have permission to see.");
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAdminCannotDeleteSysAdminGroups() {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            String removeUrl = this.page.addXsrfToken("/secure/admin/jira/GlobalPermissions.jspa?permType=44&action=del&groupName=jira-sys-admins");
            this.tester.gotoPage(removeUrl);
            this.assertTextPresent("Only system administrators can delete groups from the system administrator permission.");
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }

    public void testFilterPermsHaveCorrectVisibility() {
        this.gotoGlobalPermissions();
        this.assertTextPresent("Create Shared Objects");
        this.assertTextPresent("Manage Group Filter Subscriptions");
    }

    public void testRemoveGroupDoesntExist() {
        this.restoreData("TestRemoveGroupDoesntExist.xml");
        this.gotoAdmin();
        this.tester.clickLink("group_browser");
        this.tester.assertTextNotPresent("Stuff");
        this.tester.clickLink("global_permissions");
        this.assertTextPresent("Stuff");
        this.tester.clickLink("del_1_Stuff");
        this.tester.assertTextPresent("Delete Global Permission");
        this.assertTextSequence(new String[]{"Are you sure you want to delete the", "Stuff", "group from the", "JIRA Users", "permission"});
        this.tester.submit("Delete");
        this.assertTextPresent("Global Permissions");
        this.assertTextNotPresent("Stuff");
        String removeUrl = this.page.addXsrfToken("secure/admin/jira/GlobalPermissions.jspa?groupName=bad&permType=44&action=confirm");
        this.tester.gotoPage(removeUrl);
        this.assertions.getJiraFormAssertions().assertFormErrMsg("Group 'bad' cannot be removed from permission 'JIRA System Administrators' since it is not a member of this permission.");
    }

    private void gotoGlobalPermissions() {
        this.clickOnAdminPanel("admin.globalsettings", "global_permissions");
        this.assertTextPresent("Global Permissions");
    }
}

